package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the Notif service. Represents a row in the &quot;CARET_NOTIFICATION&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.NotifModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.NotifImpl}.
 * </p>
 *
 * @author caret
 * @see Notif
 * @see gov.va.caret.model.impl.NotifImpl
 * @see gov.va.caret.model.impl.NotifModelImpl
 * @generated
 */
public interface NotifModel extends BaseModel<Notif> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a notif model instance should use the {@link Notif} interface instead.
     */

    /**
     * Returns the primary key of this notif.
     *
     * @return the primary key of this notif
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this notif.
     *
     * @param primaryKey the primary key of this notif
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the notif ID of this notif.
     *
     * @return the notif ID of this notif
     */
    public long getNotifId();

    /**
     * Sets the notif ID of this notif.
     *
     * @param notifId the notif ID of this notif
     */
    public void setNotifId(long notifId);

    /**
     * Returns the owner ID of this notif.
     *
     * @return the owner ID of this notif
     */
    public long getOwnerId();

    /**
     * Sets the owner ID of this notif.
     *
     * @param ownerId the owner ID of this notif
     */
    public void setOwnerId(long ownerId);

    /**
     * Returns the type of this notif.
     *
     * @return the type of this notif
     */
    @AutoEscape
    public String getType();

    /**
     * Sets the type of this notif.
     *
     * @param type the type of this notif
     */
    public void setType(String type);

    /**
     * Returns the discontinue date of this notif.
     *
     * @return the discontinue date of this notif
     */
    public Date getDiscontinueDate();

    /**
     * Sets the discontinue date of this notif.
     *
     * @param discontinueDate the discontinue date of this notif
     */
    public void setDiscontinueDate(Date discontinueDate);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.Notif notif);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.Notif> toCacheModel();

    @Override
    public gov.va.caret.model.Notif toEscapedModel();

    @Override
    public gov.va.caret.model.Notif toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
