package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the Facil service. Represents a row in the &quot;CARET_FACILITY&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.FacilModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.FacilImpl}.
 * </p>
 *
 * @author caret
 * @see Facil
 * @see gov.va.caret.model.impl.FacilImpl
 * @see gov.va.caret.model.impl.FacilModelImpl
 * @generated
 */
public interface FacilModel extends BaseModel<Facil> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a facil model instance should use the {@link Facil} interface instead.
     */

    /**
     * Returns the primary key of this facil.
     *
     * @return the primary key of this facil
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this facil.
     *
     * @param primaryKey the primary key of this facil
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the facil ID of this facil.
     *
     * @return the facil ID of this facil
     */
    public long getFacilId();

    /**
     * Sets the facil ID of this facil.
     *
     * @param facilId the facil ID of this facil
     */
    public void setFacilId(long facilId);

    /**
     * Returns the facility number of this facil.
     *
     * @return the facility number of this facil
     */
    @AutoEscape
    public String getFacilityNumber();

    /**
     * Sets the facility number of this facil.
     *
     * @param facilityNumber the facility number of this facil
     */
    public void setFacilityNumber(String facilityNumber);

    /**
     * Returns the location of this facil.
     *
     * @return the location of this facil
     */
    @AutoEscape
    public String getLocation();

    /**
     * Sets the location of this facil.
     *
     * @param location the location of this facil
     */
    public void setLocation(String location);

    /**
     * Returns the group ID of this facil.
     *
     * @return the group ID of this facil
     */
    public long getGroupId();

    /**
     * Sets the group ID of this facil.
     *
     * @param groupId the group ID of this facil
     */
    public void setGroupId(long groupId);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.Facil facil);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.Facil> toCacheModel();

    @Override
    public gov.va.caret.model.Facil toEscapedModel();

    @Override
    public gov.va.caret.model.Facil toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
