package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.EERatedDisabilityLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Map;


public class EERatedDisabilityClp extends BaseModelImpl<EERatedDisability>
    implements EERatedDisability {
    private long _eeRatedDisabId;
    private long _eeLgId;
    private long _percentage;
    private String _code;
    private String _description;
    private BaseModel<?> _eeRatedDisabilityRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public EERatedDisabilityClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return EERatedDisability.class;
    }

    @Override
    public String getModelClassName() {
        return EERatedDisability.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _eeRatedDisabId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setEeRatedDisabId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _eeRatedDisabId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("eeRatedDisabId", getEeRatedDisabId());
        attributes.put("eeLgId", getEeLgId());
        attributes.put("percentage", getPercentage());
        attributes.put("code", getCode());
        attributes.put("description", getDescription());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long eeRatedDisabId = (Long) attributes.get("eeRatedDisabId");

        if (eeRatedDisabId != null) {
            setEeRatedDisabId(eeRatedDisabId);
        }

        Long eeLgId = (Long) attributes.get("eeLgId");

        if (eeLgId != null) {
            setEeLgId(eeLgId);
        }

        Long percentage = (Long) attributes.get("percentage");

        if (percentage != null) {
            setPercentage(percentage);
        }

        String code = (String) attributes.get("code");

        if (code != null) {
            setCode(code);
        }

        String description = (String) attributes.get("description");

        if (description != null) {
            setDescription(description);
        }
    }

    @Override
    public long getEeRatedDisabId() {
        return _eeRatedDisabId;
    }

    @Override
    public void setEeRatedDisabId(long eeRatedDisabId) {
        _eeRatedDisabId = eeRatedDisabId;

        if (_eeRatedDisabilityRemoteModel != null) {
            try {
                Class<?> clazz = _eeRatedDisabilityRemoteModel.getClass();

                Method method = clazz.getMethod("setEeRatedDisabId", long.class);

                method.invoke(_eeRatedDisabilityRemoteModel, eeRatedDisabId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getEeLgId() {
        return _eeLgId;
    }

    @Override
    public void setEeLgId(long eeLgId) {
        _eeLgId = eeLgId;

        if (_eeRatedDisabilityRemoteModel != null) {
            try {
                Class<?> clazz = _eeRatedDisabilityRemoteModel.getClass();

                Method method = clazz.getMethod("setEeLgId", long.class);

                method.invoke(_eeRatedDisabilityRemoteModel, eeLgId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getPercentage() {
        return _percentage;
    }

    @Override
    public void setPercentage(long percentage) {
        _percentage = percentage;

        if (_eeRatedDisabilityRemoteModel != null) {
            try {
                Class<?> clazz = _eeRatedDisabilityRemoteModel.getClass();

                Method method = clazz.getMethod("setPercentage", long.class);

                method.invoke(_eeRatedDisabilityRemoteModel, percentage);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCode() {
        return _code;
    }

    @Override
    public void setCode(String code) {
        _code = code;

        if (_eeRatedDisabilityRemoteModel != null) {
            try {
                Class<?> clazz = _eeRatedDisabilityRemoteModel.getClass();

                Method method = clazz.getMethod("setCode", String.class);

                method.invoke(_eeRatedDisabilityRemoteModel, code);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getDescription() {
        return _description;
    }

    @Override
    public void setDescription(String description) {
        _description = description;

        if (_eeRatedDisabilityRemoteModel != null) {
            try {
                Class<?> clazz = _eeRatedDisabilityRemoteModel.getClass();

                Method method = clazz.getMethod("setDescription", String.class);

                method.invoke(_eeRatedDisabilityRemoteModel, description);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getEERatedDisabilityRemoteModel() {
        return _eeRatedDisabilityRemoteModel;
    }

    public void setEERatedDisabilityRemoteModel(
        BaseModel<?> eeRatedDisabilityRemoteModel) {
        _eeRatedDisabilityRemoteModel = eeRatedDisabilityRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _eeRatedDisabilityRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_eeRatedDisabilityRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            EERatedDisabilityLocalServiceUtil.addEERatedDisability(this);
        } else {
            EERatedDisabilityLocalServiceUtil.updateEERatedDisability(this);
        }
    }

    @Override
    public EERatedDisability toEscapedModel() {
        return (EERatedDisability) ProxyUtil.newProxyInstance(EERatedDisability.class.getClassLoader(),
            new Class[] { EERatedDisability.class },
            new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        EERatedDisabilityClp clone = new EERatedDisabilityClp();

        clone.setEeRatedDisabId(getEeRatedDisabId());
        clone.setEeLgId(getEeLgId());
        clone.setPercentage(getPercentage());
        clone.setCode(getCode());
        clone.setDescription(getDescription());

        return clone;
    }

    @Override
    public int compareTo(EERatedDisability eeRatedDisability) {
        long primaryKey = eeRatedDisability.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof EERatedDisabilityClp)) {
            return false;
        }

        EERatedDisabilityClp eeRatedDisability = (EERatedDisabilityClp) obj;

        long primaryKey = eeRatedDisability.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{eeRatedDisabId=");
        sb.append(getEeRatedDisabId());
        sb.append(", eeLgId=");
        sb.append(getEeLgId());
        sb.append(", percentage=");
        sb.append(getPercentage());
        sb.append(", code=");
        sb.append(getCode());
        sb.append(", description=");
        sb.append(getDescription());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(19);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.EERatedDisability");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>eeRatedDisabId</column-name><column-value><![CDATA[");
        sb.append(getEeRatedDisabId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>eeLgId</column-name><column-value><![CDATA[");
        sb.append(getEeLgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>percentage</column-name><column-value><![CDATA[");
        sb.append(getPercentage());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>code</column-name><column-value><![CDATA[");
        sb.append(getCode());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>description</column-name><column-value><![CDATA[");
        sb.append(getDescription());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
