package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the EEMonetaryBenefit service. Represents a row in the &quot;CARET_EE_MON_BENEFIT&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.EEMonetaryBenefitModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.EEMonetaryBenefitImpl}.
 * </p>
 *
 * @author caret
 * @see EEMonetaryBenefit
 * @see gov.va.caret.model.impl.EEMonetaryBenefitImpl
 * @see gov.va.caret.model.impl.EEMonetaryBenefitModelImpl
 * @generated
 */
public interface EEMonetaryBenefitModel extends BaseModel<EEMonetaryBenefit> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a e e monetary benefit model instance should use the {@link EEMonetaryBenefit} interface instead.
     */

    /**
     * Returns the primary key of this e e monetary benefit.
     *
     * @return the primary key of this e e monetary benefit
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this e e monetary benefit.
     *
     * @param primaryKey the primary key of this e e monetary benefit
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the ee mon benefit ID of this e e monetary benefit.
     *
     * @return the ee mon benefit ID of this e e monetary benefit
     */
    public long getEeMonBenefitId();

    /**
     * Sets the ee mon benefit ID of this e e monetary benefit.
     *
     * @param eeMonBenefitId the ee mon benefit ID of this e e monetary benefit
     */
    public void setEeMonBenefitId(long eeMonBenefitId);

    /**
     * Returns the ee lg ID of this e e monetary benefit.
     *
     * @return the ee lg ID of this e e monetary benefit
     */
    public long getEeLgId();

    /**
     * Sets the ee lg ID of this e e monetary benefit.
     *
     * @param eeLgId the ee lg ID of this e e monetary benefit
     */
    public void setEeLgId(long eeLgId);

    /**
     * Returns the monetary benefit of this e e monetary benefit.
     *
     * @return the monetary benefit of this e e monetary benefit
     */
    @AutoEscape
    public String getMonetaryBenefit();

    /**
     * Sets the monetary benefit of this e e monetary benefit.
     *
     * @param monetaryBenefit the monetary benefit of this e e monetary benefit
     */
    public void setMonetaryBenefit(String monetaryBenefit);

    /**
     * Returns the type of this e e monetary benefit.
     *
     * @return the type of this e e monetary benefit
     */
    @AutoEscape
    public String getType();

    /**
     * Sets the type of this e e monetary benefit.
     *
     * @param type the type of this e e monetary benefit
     */
    public void setType(String type);

    /**
     * Returns the report date of this e e monetary benefit.
     *
     * @return the report date of this e e monetary benefit
     */
    public Date getReportDate();

    /**
     * Sets the report date of this e e monetary benefit.
     *
     * @param reportDate the report date of this e e monetary benefit
     */
    public void setReportDate(Date reportDate);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.EEMonetaryBenefit eeMonetaryBenefit);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.EEMonetaryBenefit> toCacheModel();

    @Override
    public gov.va.caret.model.EEMonetaryBenefit toEscapedModel();

    @Override
    public gov.va.caret.model.EEMonetaryBenefit toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
