package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.EEMonetaryBenefitLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class EEMonetaryBenefitClp extends BaseModelImpl<EEMonetaryBenefit>
    implements EEMonetaryBenefit {
    private long _eeMonBenefitId;
    private long _eeLgId;
    private String _monetaryBenefit;
    private String _type;
    private Date _reportDate;
    private BaseModel<?> _eeMonetaryBenefitRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public EEMonetaryBenefitClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return EEMonetaryBenefit.class;
    }

    @Override
    public String getModelClassName() {
        return EEMonetaryBenefit.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _eeMonBenefitId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setEeMonBenefitId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _eeMonBenefitId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("eeMonBenefitId", getEeMonBenefitId());
        attributes.put("eeLgId", getEeLgId());
        attributes.put("monetaryBenefit", getMonetaryBenefit());
        attributes.put("type", getType());
        attributes.put("reportDate", getReportDate());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long eeMonBenefitId = (Long) attributes.get("eeMonBenefitId");

        if (eeMonBenefitId != null) {
            setEeMonBenefitId(eeMonBenefitId);
        }

        Long eeLgId = (Long) attributes.get("eeLgId");

        if (eeLgId != null) {
            setEeLgId(eeLgId);
        }

        String monetaryBenefit = (String) attributes.get("monetaryBenefit");

        if (monetaryBenefit != null) {
            setMonetaryBenefit(monetaryBenefit);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }

        Date reportDate = (Date) attributes.get("reportDate");

        if (reportDate != null) {
            setReportDate(reportDate);
        }
    }

    @Override
    public long getEeMonBenefitId() {
        return _eeMonBenefitId;
    }

    @Override
    public void setEeMonBenefitId(long eeMonBenefitId) {
        _eeMonBenefitId = eeMonBenefitId;

        if (_eeMonetaryBenefitRemoteModel != null) {
            try {
                Class<?> clazz = _eeMonetaryBenefitRemoteModel.getClass();

                Method method = clazz.getMethod("setEeMonBenefitId", long.class);

                method.invoke(_eeMonetaryBenefitRemoteModel, eeMonBenefitId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getEeLgId() {
        return _eeLgId;
    }

    @Override
    public void setEeLgId(long eeLgId) {
        _eeLgId = eeLgId;

        if (_eeMonetaryBenefitRemoteModel != null) {
            try {
                Class<?> clazz = _eeMonetaryBenefitRemoteModel.getClass();

                Method method = clazz.getMethod("setEeLgId", long.class);

                method.invoke(_eeMonetaryBenefitRemoteModel, eeLgId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getMonetaryBenefit() {
        return _monetaryBenefit;
    }

    @Override
    public void setMonetaryBenefit(String monetaryBenefit) {
        _monetaryBenefit = monetaryBenefit;

        if (_eeMonetaryBenefitRemoteModel != null) {
            try {
                Class<?> clazz = _eeMonetaryBenefitRemoteModel.getClass();

                Method method = clazz.getMethod("setMonetaryBenefit",
                        String.class);

                method.invoke(_eeMonetaryBenefitRemoteModel, monetaryBenefit);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getType() {
        return _type;
    }

    @Override
    public void setType(String type) {
        _type = type;

        if (_eeMonetaryBenefitRemoteModel != null) {
            try {
                Class<?> clazz = _eeMonetaryBenefitRemoteModel.getClass();

                Method method = clazz.getMethod("setType", String.class);

                method.invoke(_eeMonetaryBenefitRemoteModel, type);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getReportDate() {
        return _reportDate;
    }

    @Override
    public void setReportDate(Date reportDate) {
        _reportDate = reportDate;

        if (_eeMonetaryBenefitRemoteModel != null) {
            try {
                Class<?> clazz = _eeMonetaryBenefitRemoteModel.getClass();

                Method method = clazz.getMethod("setReportDate", Date.class);

                method.invoke(_eeMonetaryBenefitRemoteModel, reportDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getEEMonetaryBenefitRemoteModel() {
        return _eeMonetaryBenefitRemoteModel;
    }

    public void setEEMonetaryBenefitRemoteModel(
        BaseModel<?> eeMonetaryBenefitRemoteModel) {
        _eeMonetaryBenefitRemoteModel = eeMonetaryBenefitRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _eeMonetaryBenefitRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_eeMonetaryBenefitRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            EEMonetaryBenefitLocalServiceUtil.addEEMonetaryBenefit(this);
        } else {
            EEMonetaryBenefitLocalServiceUtil.updateEEMonetaryBenefit(this);
        }
    }

    @Override
    public EEMonetaryBenefit toEscapedModel() {
        return (EEMonetaryBenefit) ProxyUtil.newProxyInstance(EEMonetaryBenefit.class.getClassLoader(),
            new Class[] { EEMonetaryBenefit.class },
            new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        EEMonetaryBenefitClp clone = new EEMonetaryBenefitClp();

        clone.setEeMonBenefitId(getEeMonBenefitId());
        clone.setEeLgId(getEeLgId());
        clone.setMonetaryBenefit(getMonetaryBenefit());
        clone.setType(getType());
        clone.setReportDate(getReportDate());

        return clone;
    }

    @Override
    public int compareTo(EEMonetaryBenefit eeMonetaryBenefit) {
        long primaryKey = eeMonetaryBenefit.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof EEMonetaryBenefitClp)) {
            return false;
        }

        EEMonetaryBenefitClp eeMonetaryBenefit = (EEMonetaryBenefitClp) obj;

        long primaryKey = eeMonetaryBenefit.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(11);

        sb.append("{eeMonBenefitId=");
        sb.append(getEeMonBenefitId());
        sb.append(", eeLgId=");
        sb.append(getEeLgId());
        sb.append(", monetaryBenefit=");
        sb.append(getMonetaryBenefit());
        sb.append(", type=");
        sb.append(getType());
        sb.append(", reportDate=");
        sb.append(getReportDate());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(19);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.EEMonetaryBenefit");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>eeMonBenefitId</column-name><column-value><![CDATA[");
        sb.append(getEeMonBenefitId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>eeLgId</column-name><column-value><![CDATA[");
        sb.append(getEeLgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>monetaryBenefit</column-name><column-value><![CDATA[");
        sb.append(getMonetaryBenefit());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>type</column-name><column-value><![CDATA[");
        sb.append(getType());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>reportDate</column-name><column-value><![CDATA[");
        sb.append(getReportDate());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
