package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link EEMilitaryRecord}.
 * </p>
 *
 * @author caret
 * @see EEMilitaryRecord
 * @generated
 */
public class EEMilitaryRecordWrapper implements EEMilitaryRecord,
    ModelWrapper<EEMilitaryRecord> {
    private EEMilitaryRecord _eeMilitaryRecord;

    public EEMilitaryRecordWrapper(EEMilitaryRecord eeMilitaryRecord) {
        _eeMilitaryRecord = eeMilitaryRecord;
    }

    @Override
    public Class<?> getModelClass() {
        return EEMilitaryRecord.class;
    }

    @Override
    public String getModelClassName() {
        return EEMilitaryRecord.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("eeMilRecordId", getEeMilRecordId());
        attributes.put("eeLgId", getEeLgId());
        attributes.put("serviceBranch", getServiceBranch());
        attributes.put("serviceDate", getServiceDate());
        attributes.put("exitServiceDate", getExitServiceDate());
        attributes.put("dischargeType", getDischargeType());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long eeMilRecordId = (Long) attributes.get("eeMilRecordId");

        if (eeMilRecordId != null) {
            setEeMilRecordId(eeMilRecordId);
        }

        Long eeLgId = (Long) attributes.get("eeLgId");

        if (eeLgId != null) {
            setEeLgId(eeLgId);
        }

        String serviceBranch = (String) attributes.get("serviceBranch");

        if (serviceBranch != null) {
            setServiceBranch(serviceBranch);
        }

        Date serviceDate = (Date) attributes.get("serviceDate");

        if (serviceDate != null) {
            setServiceDate(serviceDate);
        }

        Date exitServiceDate = (Date) attributes.get("exitServiceDate");

        if (exitServiceDate != null) {
            setExitServiceDate(exitServiceDate);
        }

        String dischargeType = (String) attributes.get("dischargeType");

        if (dischargeType != null) {
            setDischargeType(dischargeType);
        }
    }

    /**
    * Returns the primary key of this e e military record.
    *
    * @return the primary key of this e e military record
    */
    @Override
    public long getPrimaryKey() {
        return _eeMilitaryRecord.getPrimaryKey();
    }

    /**
    * Sets the primary key of this e e military record.
    *
    * @param primaryKey the primary key of this e e military record
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _eeMilitaryRecord.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the ee mil record ID of this e e military record.
    *
    * @return the ee mil record ID of this e e military record
    */
    @Override
    public long getEeMilRecordId() {
        return _eeMilitaryRecord.getEeMilRecordId();
    }

    /**
    * Sets the ee mil record ID of this e e military record.
    *
    * @param eeMilRecordId the ee mil record ID of this e e military record
    */
    @Override
    public void setEeMilRecordId(long eeMilRecordId) {
        _eeMilitaryRecord.setEeMilRecordId(eeMilRecordId);
    }

    /**
    * Returns the ee lg ID of this e e military record.
    *
    * @return the ee lg ID of this e e military record
    */
    @Override
    public long getEeLgId() {
        return _eeMilitaryRecord.getEeLgId();
    }

    /**
    * Sets the ee lg ID of this e e military record.
    *
    * @param eeLgId the ee lg ID of this e e military record
    */
    @Override
    public void setEeLgId(long eeLgId) {
        _eeMilitaryRecord.setEeLgId(eeLgId);
    }

    /**
    * Returns the service branch of this e e military record.
    *
    * @return the service branch of this e e military record
    */
    @Override
    public java.lang.String getServiceBranch() {
        return _eeMilitaryRecord.getServiceBranch();
    }

    /**
    * Sets the service branch of this e e military record.
    *
    * @param serviceBranch the service branch of this e e military record
    */
    @Override
    public void setServiceBranch(java.lang.String serviceBranch) {
        _eeMilitaryRecord.setServiceBranch(serviceBranch);
    }

    /**
    * Returns the service date of this e e military record.
    *
    * @return the service date of this e e military record
    */
    @Override
    public java.util.Date getServiceDate() {
        return _eeMilitaryRecord.getServiceDate();
    }

    /**
    * Sets the service date of this e e military record.
    *
    * @param serviceDate the service date of this e e military record
    */
    @Override
    public void setServiceDate(java.util.Date serviceDate) {
        _eeMilitaryRecord.setServiceDate(serviceDate);
    }

    /**
    * Returns the exit service date of this e e military record.
    *
    * @return the exit service date of this e e military record
    */
    @Override
    public java.util.Date getExitServiceDate() {
        return _eeMilitaryRecord.getExitServiceDate();
    }

    /**
    * Sets the exit service date of this e e military record.
    *
    * @param exitServiceDate the exit service date of this e e military record
    */
    @Override
    public void setExitServiceDate(java.util.Date exitServiceDate) {
        _eeMilitaryRecord.setExitServiceDate(exitServiceDate);
    }

    /**
    * Returns the discharge type of this e e military record.
    *
    * @return the discharge type of this e e military record
    */
    @Override
    public java.lang.String getDischargeType() {
        return _eeMilitaryRecord.getDischargeType();
    }

    /**
    * Sets the discharge type of this e e military record.
    *
    * @param dischargeType the discharge type of this e e military record
    */
    @Override
    public void setDischargeType(java.lang.String dischargeType) {
        _eeMilitaryRecord.setDischargeType(dischargeType);
    }

    @Override
    public boolean isNew() {
        return _eeMilitaryRecord.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _eeMilitaryRecord.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _eeMilitaryRecord.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _eeMilitaryRecord.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _eeMilitaryRecord.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _eeMilitaryRecord.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _eeMilitaryRecord.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _eeMilitaryRecord.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _eeMilitaryRecord.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _eeMilitaryRecord.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _eeMilitaryRecord.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new EEMilitaryRecordWrapper((EEMilitaryRecord) _eeMilitaryRecord.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.EEMilitaryRecord eeMilitaryRecord) {
        return _eeMilitaryRecord.compareTo(eeMilitaryRecord);
    }

    @Override
    public int hashCode() {
        return _eeMilitaryRecord.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.EEMilitaryRecord> toCacheModel() {
        return _eeMilitaryRecord.toCacheModel();
    }

    @Override
    public gov.va.caret.model.EEMilitaryRecord toEscapedModel() {
        return new EEMilitaryRecordWrapper(_eeMilitaryRecord.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.EEMilitaryRecord toUnescapedModel() {
        return new EEMilitaryRecordWrapper(_eeMilitaryRecord.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _eeMilitaryRecord.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _eeMilitaryRecord.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _eeMilitaryRecord.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof EEMilitaryRecordWrapper)) {
            return false;
        }

        EEMilitaryRecordWrapper eeMilitaryRecordWrapper = (EEMilitaryRecordWrapper) obj;

        if (Validator.equals(_eeMilitaryRecord,
                    eeMilitaryRecordWrapper._eeMilitaryRecord)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public EEMilitaryRecord getWrappedEEMilitaryRecord() {
        return _eeMilitaryRecord;
    }

    @Override
    public EEMilitaryRecord getWrappedModel() {
        return _eeMilitaryRecord;
    }

    @Override
    public void resetOriginalValues() {
        _eeMilitaryRecord.resetOriginalValues();
    }
}
