package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the EEMilitaryRecord service. Represents a row in the &quot;CARET_EE_MIL_RECORD&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.EEMilitaryRecordModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.EEMilitaryRecordImpl}.
 * </p>
 *
 * @author caret
 * @see EEMilitaryRecord
 * @see gov.va.caret.model.impl.EEMilitaryRecordImpl
 * @see gov.va.caret.model.impl.EEMilitaryRecordModelImpl
 * @generated
 */
public interface EEMilitaryRecordModel extends BaseModel<EEMilitaryRecord> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a e e military record model instance should use the {@link EEMilitaryRecord} interface instead.
     */

    /**
     * Returns the primary key of this e e military record.
     *
     * @return the primary key of this e e military record
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this e e military record.
     *
     * @param primaryKey the primary key of this e e military record
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the ee mil record ID of this e e military record.
     *
     * @return the ee mil record ID of this e e military record
     */
    public long getEeMilRecordId();

    /**
     * Sets the ee mil record ID of this e e military record.
     *
     * @param eeMilRecordId the ee mil record ID of this e e military record
     */
    public void setEeMilRecordId(long eeMilRecordId);

    /**
     * Returns the ee lg ID of this e e military record.
     *
     * @return the ee lg ID of this e e military record
     */
    public long getEeLgId();

    /**
     * Sets the ee lg ID of this e e military record.
     *
     * @param eeLgId the ee lg ID of this e e military record
     */
    public void setEeLgId(long eeLgId);

    /**
     * Returns the service branch of this e e military record.
     *
     * @return the service branch of this e e military record
     */
    @AutoEscape
    public String getServiceBranch();

    /**
     * Sets the service branch of this e e military record.
     *
     * @param serviceBranch the service branch of this e e military record
     */
    public void setServiceBranch(String serviceBranch);

    /**
     * Returns the service date of this e e military record.
     *
     * @return the service date of this e e military record
     */
    public Date getServiceDate();

    /**
     * Sets the service date of this e e military record.
     *
     * @param serviceDate the service date of this e e military record
     */
    public void setServiceDate(Date serviceDate);

    /**
     * Returns the exit service date of this e e military record.
     *
     * @return the exit service date of this e e military record
     */
    public Date getExitServiceDate();

    /**
     * Sets the exit service date of this e e military record.
     *
     * @param exitServiceDate the exit service date of this e e military record
     */
    public void setExitServiceDate(Date exitServiceDate);

    /**
     * Returns the discharge type of this e e military record.
     *
     * @return the discharge type of this e e military record
     */
    @AutoEscape
    public String getDischargeType();

    /**
     * Sets the discharge type of this e e military record.
     *
     * @param dischargeType the discharge type of this e e military record
     */
    public void setDischargeType(String dischargeType);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.EEMilitaryRecord eeMilitaryRecord);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.EEMilitaryRecord> toCacheModel();

    @Override
    public gov.va.caret.model.EEMilitaryRecord toEscapedModel();

    @Override
    public gov.va.caret.model.EEMilitaryRecord toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
