package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.EEMilitaryRecordLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class EEMilitaryRecordClp extends BaseModelImpl<EEMilitaryRecord>
    implements EEMilitaryRecord {
    private long _eeMilRecordId;
    private long _eeLgId;
    private String _serviceBranch;
    private Date _serviceDate;
    private Date _exitServiceDate;
    private String _dischargeType;
    private BaseModel<?> _eeMilitaryRecordRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public EEMilitaryRecordClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return EEMilitaryRecord.class;
    }

    @Override
    public String getModelClassName() {
        return EEMilitaryRecord.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _eeMilRecordId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setEeMilRecordId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _eeMilRecordId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("eeMilRecordId", getEeMilRecordId());
        attributes.put("eeLgId", getEeLgId());
        attributes.put("serviceBranch", getServiceBranch());
        attributes.put("serviceDate", getServiceDate());
        attributes.put("exitServiceDate", getExitServiceDate());
        attributes.put("dischargeType", getDischargeType());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long eeMilRecordId = (Long) attributes.get("eeMilRecordId");

        if (eeMilRecordId != null) {
            setEeMilRecordId(eeMilRecordId);
        }

        Long eeLgId = (Long) attributes.get("eeLgId");

        if (eeLgId != null) {
            setEeLgId(eeLgId);
        }

        String serviceBranch = (String) attributes.get("serviceBranch");

        if (serviceBranch != null) {
            setServiceBranch(serviceBranch);
        }

        Date serviceDate = (Date) attributes.get("serviceDate");

        if (serviceDate != null) {
            setServiceDate(serviceDate);
        }

        Date exitServiceDate = (Date) attributes.get("exitServiceDate");

        if (exitServiceDate != null) {
            setExitServiceDate(exitServiceDate);
        }

        String dischargeType = (String) attributes.get("dischargeType");

        if (dischargeType != null) {
            setDischargeType(dischargeType);
        }
    }

    @Override
    public long getEeMilRecordId() {
        return _eeMilRecordId;
    }

    @Override
    public void setEeMilRecordId(long eeMilRecordId) {
        _eeMilRecordId = eeMilRecordId;

        if (_eeMilitaryRecordRemoteModel != null) {
            try {
                Class<?> clazz = _eeMilitaryRecordRemoteModel.getClass();

                Method method = clazz.getMethod("setEeMilRecordId", long.class);

                method.invoke(_eeMilitaryRecordRemoteModel, eeMilRecordId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getEeLgId() {
        return _eeLgId;
    }

    @Override
    public void setEeLgId(long eeLgId) {
        _eeLgId = eeLgId;

        if (_eeMilitaryRecordRemoteModel != null) {
            try {
                Class<?> clazz = _eeMilitaryRecordRemoteModel.getClass();

                Method method = clazz.getMethod("setEeLgId", long.class);

                method.invoke(_eeMilitaryRecordRemoteModel, eeLgId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getServiceBranch() {
        return _serviceBranch;
    }

    @Override
    public void setServiceBranch(String serviceBranch) {
        _serviceBranch = serviceBranch;

        if (_eeMilitaryRecordRemoteModel != null) {
            try {
                Class<?> clazz = _eeMilitaryRecordRemoteModel.getClass();

                Method method = clazz.getMethod("setServiceBranch", String.class);

                method.invoke(_eeMilitaryRecordRemoteModel, serviceBranch);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getServiceDate() {
        return _serviceDate;
    }

    @Override
    public void setServiceDate(Date serviceDate) {
        _serviceDate = serviceDate;

        if (_eeMilitaryRecordRemoteModel != null) {
            try {
                Class<?> clazz = _eeMilitaryRecordRemoteModel.getClass();

                Method method = clazz.getMethod("setServiceDate", Date.class);

                method.invoke(_eeMilitaryRecordRemoteModel, serviceDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getExitServiceDate() {
        return _exitServiceDate;
    }

    @Override
    public void setExitServiceDate(Date exitServiceDate) {
        _exitServiceDate = exitServiceDate;

        if (_eeMilitaryRecordRemoteModel != null) {
            try {
                Class<?> clazz = _eeMilitaryRecordRemoteModel.getClass();

                Method method = clazz.getMethod("setExitServiceDate", Date.class);

                method.invoke(_eeMilitaryRecordRemoteModel, exitServiceDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getDischargeType() {
        return _dischargeType;
    }

    @Override
    public void setDischargeType(String dischargeType) {
        _dischargeType = dischargeType;

        if (_eeMilitaryRecordRemoteModel != null) {
            try {
                Class<?> clazz = _eeMilitaryRecordRemoteModel.getClass();

                Method method = clazz.getMethod("setDischargeType", String.class);

                method.invoke(_eeMilitaryRecordRemoteModel, dischargeType);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getEEMilitaryRecordRemoteModel() {
        return _eeMilitaryRecordRemoteModel;
    }

    public void setEEMilitaryRecordRemoteModel(
        BaseModel<?> eeMilitaryRecordRemoteModel) {
        _eeMilitaryRecordRemoteModel = eeMilitaryRecordRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _eeMilitaryRecordRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_eeMilitaryRecordRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            EEMilitaryRecordLocalServiceUtil.addEEMilitaryRecord(this);
        } else {
            EEMilitaryRecordLocalServiceUtil.updateEEMilitaryRecord(this);
        }
    }

    @Override
    public EEMilitaryRecord toEscapedModel() {
        return (EEMilitaryRecord) ProxyUtil.newProxyInstance(EEMilitaryRecord.class.getClassLoader(),
            new Class[] { EEMilitaryRecord.class },
            new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        EEMilitaryRecordClp clone = new EEMilitaryRecordClp();

        clone.setEeMilRecordId(getEeMilRecordId());
        clone.setEeLgId(getEeLgId());
        clone.setServiceBranch(getServiceBranch());
        clone.setServiceDate(getServiceDate());
        clone.setExitServiceDate(getExitServiceDate());
        clone.setDischargeType(getDischargeType());

        return clone;
    }

    @Override
    public int compareTo(EEMilitaryRecord eeMilitaryRecord) {
        long primaryKey = eeMilitaryRecord.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof EEMilitaryRecordClp)) {
            return false;
        }

        EEMilitaryRecordClp eeMilitaryRecord = (EEMilitaryRecordClp) obj;

        long primaryKey = eeMilitaryRecord.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(13);

        sb.append("{eeMilRecordId=");
        sb.append(getEeMilRecordId());
        sb.append(", eeLgId=");
        sb.append(getEeLgId());
        sb.append(", serviceBranch=");
        sb.append(getServiceBranch());
        sb.append(", serviceDate=");
        sb.append(getServiceDate());
        sb.append(", exitServiceDate=");
        sb.append(getExitServiceDate());
        sb.append(", dischargeType=");
        sb.append(getDischargeType());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(22);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.EEMilitaryRecord");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>eeMilRecordId</column-name><column-value><![CDATA[");
        sb.append(getEeMilRecordId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>eeLgId</column-name><column-value><![CDATA[");
        sb.append(getEeLgId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>serviceBranch</column-name><column-value><![CDATA[");
        sb.append(getServiceBranch());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>serviceDate</column-name><column-value><![CDATA[");
        sb.append(getServiceDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>exitServiceDate</column-name><column-value><![CDATA[");
        sb.append(getExitServiceDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>dischargeType</column-name><column-value><![CDATA[");
        sb.append(getDischargeType());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
