package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the EELg service. Represents a row in the &quot;CARET_EE_LOGS&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.EELgModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.EELgImpl}.
 * </p>
 *
 * @author caret
 * @see EELg
 * @see gov.va.caret.model.impl.EELgImpl
 * @see gov.va.caret.model.impl.EELgModelImpl
 * @generated
 */
public interface EELgModel extends BaseModel<EELg> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a e e lg model instance should use the {@link EELg} interface instead.
     */

    /**
     * Returns the primary key of this e e lg.
     *
     * @return the primary key of this e e lg
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this e e lg.
     *
     * @param primaryKey the primary key of this e e lg
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the ee lg ID of this e e lg.
     *
     * @return the ee lg ID of this e e lg
     */
    public long getEeLgId();

    /**
     * Sets the ee lg ID of this e e lg.
     *
     * @param eeLgId the ee lg ID of this e e lg
     */
    public void setEeLgId(long eeLgId);

    /**
     * Returns the i c n of this e e lg.
     *
     * @return the i c n of this e e lg
     */
    @AutoEscape
    public String getICN();

    /**
     * Sets the i c n of this e e lg.
     *
     * @param ICN the i c n of this e e lg
     */
    public void setICN(String ICN);

    /**
     * Returns the date of death of this e e lg.
     *
     * @return the date of death of this e e lg
     */
    public Date getDateOfDeath();

    /**
     * Sets the date of death of this e e lg.
     *
     * @param dateOfDeath the date of death of this e e lg
     */
    public void setDateOfDeath(Date dateOfDeath);

    /**
     * Returns the priority group of this e e lg.
     *
     * @return the priority group of this e e lg
     */
    @AutoEscape
    public String getPriorityGroup();

    /**
     * Sets the priority group of this e e lg.
     *
     * @param priorityGroup the priority group of this e e lg
     */
    public void setPriorityGroup(String priorityGroup);

    /**
     * Returns the sc tot disab rating of this e e lg.
     *
     * @return the sc tot disab rating of this e e lg
     */
    public Long getScTotDisabRating();

    /**
     * Sets the sc tot disab rating of this e e lg.
     *
     * @param scTotDisabRating the sc tot disab rating of this e e lg
     */
    public void setScTotDisabRating(Long scTotDisabRating);

    /**
     * Returns the sc indicator of this e e lg.
     *
     * @return the sc indicator of this e e lg
     */
    public Boolean getScIndicator();

    /**
     * Sets the sc indicator of this e e lg.
     *
     * @param scIndicator the sc indicator of this e e lg
     */
    public void setScIndicator(Boolean scIndicator);

    /**
     * Returns the medicaid eligibility of this e e lg.
     *
     * @return the medicaid eligibility of this e e lg
     */
    public Boolean getMedicaidEligibility();

    /**
     * Sets the medicaid eligibility of this e e lg.
     *
     * @param medicaidEligibility the medicaid eligibility of this e e lg
     */
    public void setMedicaidEligibility(Boolean medicaidEligibility);

    /**
     * Returns the created date of this e e lg.
     *
     * @return the created date of this e e lg
     */
    public Date getCreatedDate();

    /**
     * Sets the created date of this e e lg.
     *
     * @param createdDate the created date of this e e lg
     */
    public void setCreatedDate(Date createdDate);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.EELg eeLg);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.EELg> toCacheModel();

    @Override
    public gov.va.caret.model.EELg toEscapedModel();

    @Override
    public gov.va.caret.model.EELg toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
