package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link ClSoc}.
 * </p>
 *
 * @author caret
 * @see ClSoc
 * @generated
 */
public class ClSocWrapper implements ClSoc, ModelWrapper<ClSoc> {
    private ClSoc _clSoc;

    public ClSocWrapper(ClSoc clSoc) {
        _clSoc = clSoc;
    }

    @Override
    public Class<?> getModelClass() {
        return ClSoc.class;
    }

    @Override
    public String getModelClassName() {
        return ClSoc.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("clSocId", getClSocId());
        attributes.put("callId", getCallId());
        attributes.put("persnId", getPersnId());
        attributes.put("surveyStatus", getSurveyStatus());
        attributes.put("surveyComment", getSurveyComment());
        attributes.put("creationDate", getCreationDate());
        attributes.put("attemptNum", getAttemptNum());
        attributes.put("callerAvailable", getCallerAvailable());
        attributes.put("requestedCallbackTime", getRequestedCallbackTime());
        attributes.put("willingToAnsQues", getWillingToAnsQues());
        attributes.put("calledCsl", getCalledCsl());
        attributes.put("cslKnowledgable", getCslKnowledgable());
        attributes.put("cslSupportive", getCslSupportive());
        attributes.put("localResSuggested", getLocalResSuggested());
        attributes.put("localResContacted", getLocalResContacted());
        attributes.put("rsnLocalResNotContacted", getRsnLocalResNotContacted());
        attributes.put("localResHelpful", getLocalResHelpful());
        attributes.put("concernsAnswered", getConcernsAnswered());
        attributes.put("understandNextSteps", getUnderstandNextSteps());
        attributes.put("callCslAgain", getCallCslAgain());
        attributes.put("recommendCsl", getRecommendCsl());
        attributes.put("suggestions", getSuggestions());
        attributes.put("followupCall", getFollowupCall());
        attributes.put("followupCallTime", getFollowupCallTime());
        attributes.put("tresholdMet", getTresholdMet());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long clSocId = (Long) attributes.get("clSocId");

        if (clSocId != null) {
            setClSocId(clSocId);
        }

        Long callId = (Long) attributes.get("callId");

        if (callId != null) {
            setCallId(callId);
        }

        Long persnId = (Long) attributes.get("persnId");

        if (persnId != null) {
            setPersnId(persnId);
        }

        String surveyStatus = (String) attributes.get("surveyStatus");

        if (surveyStatus != null) {
            setSurveyStatus(surveyStatus);
        }

        String surveyComment = (String) attributes.get("surveyComment");

        if (surveyComment != null) {
            setSurveyComment(surveyComment);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        String attemptNum = (String) attributes.get("attemptNum");

        if (attemptNum != null) {
            setAttemptNum(attemptNum);
        }

        String callerAvailable = (String) attributes.get("callerAvailable");

        if (callerAvailable != null) {
            setCallerAvailable(callerAvailable);
        }

        String requestedCallbackTime = (String) attributes.get(
                "requestedCallbackTime");

        if (requestedCallbackTime != null) {
            setRequestedCallbackTime(requestedCallbackTime);
        }

        String willingToAnsQues = (String) attributes.get("willingToAnsQues");

        if (willingToAnsQues != null) {
            setWillingToAnsQues(willingToAnsQues);
        }

        String calledCsl = (String) attributes.get("calledCsl");

        if (calledCsl != null) {
            setCalledCsl(calledCsl);
        }

        String cslKnowledgable = (String) attributes.get("cslKnowledgable");

        if (cslKnowledgable != null) {
            setCslKnowledgable(cslKnowledgable);
        }

        String cslSupportive = (String) attributes.get("cslSupportive");

        if (cslSupportive != null) {
            setCslSupportive(cslSupportive);
        }

        String localResSuggested = (String) attributes.get("localResSuggested");

        if (localResSuggested != null) {
            setLocalResSuggested(localResSuggested);
        }

        String localResContacted = (String) attributes.get("localResContacted");

        if (localResContacted != null) {
            setLocalResContacted(localResContacted);
        }

        String rsnLocalResNotContacted = (String) attributes.get(
                "rsnLocalResNotContacted");

        if (rsnLocalResNotContacted != null) {
            setRsnLocalResNotContacted(rsnLocalResNotContacted);
        }

        String localResHelpful = (String) attributes.get("localResHelpful");

        if (localResHelpful != null) {
            setLocalResHelpful(localResHelpful);
        }

        String concernsAnswered = (String) attributes.get("concernsAnswered");

        if (concernsAnswered != null) {
            setConcernsAnswered(concernsAnswered);
        }

        String understandNextSteps = (String) attributes.get(
                "understandNextSteps");

        if (understandNextSteps != null) {
            setUnderstandNextSteps(understandNextSteps);
        }

        String callCslAgain = (String) attributes.get("callCslAgain");

        if (callCslAgain != null) {
            setCallCslAgain(callCslAgain);
        }

        String recommendCsl = (String) attributes.get("recommendCsl");

        if (recommendCsl != null) {
            setRecommendCsl(recommendCsl);
        }

        String suggestions = (String) attributes.get("suggestions");

        if (suggestions != null) {
            setSuggestions(suggestions);
        }

        String followupCall = (String) attributes.get("followupCall");

        if (followupCall != null) {
            setFollowupCall(followupCall);
        }

        String followupCallTime = (String) attributes.get("followupCallTime");

        if (followupCallTime != null) {
            setFollowupCallTime(followupCallTime);
        }

        String tresholdMet = (String) attributes.get("tresholdMet");

        if (tresholdMet != null) {
            setTresholdMet(tresholdMet);
        }
    }

    /**
    * Returns the primary key of this cl soc.
    *
    * @return the primary key of this cl soc
    */
    @Override
    public long getPrimaryKey() {
        return _clSoc.getPrimaryKey();
    }

    /**
    * Sets the primary key of this cl soc.
    *
    * @param primaryKey the primary key of this cl soc
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _clSoc.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the cl soc ID of this cl soc.
    *
    * @return the cl soc ID of this cl soc
    */
    @Override
    public long getClSocId() {
        return _clSoc.getClSocId();
    }

    /**
    * Sets the cl soc ID of this cl soc.
    *
    * @param clSocId the cl soc ID of this cl soc
    */
    @Override
    public void setClSocId(long clSocId) {
        _clSoc.setClSocId(clSocId);
    }

    /**
    * Returns the call ID of this cl soc.
    *
    * @return the call ID of this cl soc
    */
    @Override
    public long getCallId() {
        return _clSoc.getCallId();
    }

    /**
    * Sets the call ID of this cl soc.
    *
    * @param callId the call ID of this cl soc
    */
    @Override
    public void setCallId(long callId) {
        _clSoc.setCallId(callId);
    }

    /**
    * Returns the persn ID of this cl soc.
    *
    * @return the persn ID of this cl soc
    */
    @Override
    public long getPersnId() {
        return _clSoc.getPersnId();
    }

    /**
    * Sets the persn ID of this cl soc.
    *
    * @param persnId the persn ID of this cl soc
    */
    @Override
    public void setPersnId(long persnId) {
        _clSoc.setPersnId(persnId);
    }

    /**
    * Returns the survey status of this cl soc.
    *
    * @return the survey status of this cl soc
    */
    @Override
    public java.lang.String getSurveyStatus() {
        return _clSoc.getSurveyStatus();
    }

    /**
    * Sets the survey status of this cl soc.
    *
    * @param surveyStatus the survey status of this cl soc
    */
    @Override
    public void setSurveyStatus(java.lang.String surveyStatus) {
        _clSoc.setSurveyStatus(surveyStatus);
    }

    /**
    * Returns the survey comment of this cl soc.
    *
    * @return the survey comment of this cl soc
    */
    @Override
    public java.lang.String getSurveyComment() {
        return _clSoc.getSurveyComment();
    }

    /**
    * Sets the survey comment of this cl soc.
    *
    * @param surveyComment the survey comment of this cl soc
    */
    @Override
    public void setSurveyComment(java.lang.String surveyComment) {
        _clSoc.setSurveyComment(surveyComment);
    }

    /**
    * Returns the creation date of this cl soc.
    *
    * @return the creation date of this cl soc
    */
    @Override
    public java.util.Date getCreationDate() {
        return _clSoc.getCreationDate();
    }

    /**
    * Sets the creation date of this cl soc.
    *
    * @param creationDate the creation date of this cl soc
    */
    @Override
    public void setCreationDate(java.util.Date creationDate) {
        _clSoc.setCreationDate(creationDate);
    }

    /**
    * Returns the attempt num of this cl soc.
    *
    * @return the attempt num of this cl soc
    */
    @Override
    public java.lang.String getAttemptNum() {
        return _clSoc.getAttemptNum();
    }

    /**
    * Sets the attempt num of this cl soc.
    *
    * @param attemptNum the attempt num of this cl soc
    */
    @Override
    public void setAttemptNum(java.lang.String attemptNum) {
        _clSoc.setAttemptNum(attemptNum);
    }

    /**
    * Returns the caller available of this cl soc.
    *
    * @return the caller available of this cl soc
    */
    @Override
    public java.lang.String getCallerAvailable() {
        return _clSoc.getCallerAvailable();
    }

    /**
    * Sets the caller available of this cl soc.
    *
    * @param callerAvailable the caller available of this cl soc
    */
    @Override
    public void setCallerAvailable(java.lang.String callerAvailable) {
        _clSoc.setCallerAvailable(callerAvailable);
    }

    /**
    * Returns the requested callback time of this cl soc.
    *
    * @return the requested callback time of this cl soc
    */
    @Override
    public java.lang.String getRequestedCallbackTime() {
        return _clSoc.getRequestedCallbackTime();
    }

    /**
    * Sets the requested callback time of this cl soc.
    *
    * @param requestedCallbackTime the requested callback time of this cl soc
    */
    @Override
    public void setRequestedCallbackTime(java.lang.String requestedCallbackTime) {
        _clSoc.setRequestedCallbackTime(requestedCallbackTime);
    }

    /**
    * Returns the willing to ans ques of this cl soc.
    *
    * @return the willing to ans ques of this cl soc
    */
    @Override
    public java.lang.String getWillingToAnsQues() {
        return _clSoc.getWillingToAnsQues();
    }

    /**
    * Sets the willing to ans ques of this cl soc.
    *
    * @param willingToAnsQues the willing to ans ques of this cl soc
    */
    @Override
    public void setWillingToAnsQues(java.lang.String willingToAnsQues) {
        _clSoc.setWillingToAnsQues(willingToAnsQues);
    }

    /**
    * Returns the called csl of this cl soc.
    *
    * @return the called csl of this cl soc
    */
    @Override
    public java.lang.String getCalledCsl() {
        return _clSoc.getCalledCsl();
    }

    /**
    * Sets the called csl of this cl soc.
    *
    * @param calledCsl the called csl of this cl soc
    */
    @Override
    public void setCalledCsl(java.lang.String calledCsl) {
        _clSoc.setCalledCsl(calledCsl);
    }

    /**
    * Returns the csl knowledgable of this cl soc.
    *
    * @return the csl knowledgable of this cl soc
    */
    @Override
    public java.lang.String getCslKnowledgable() {
        return _clSoc.getCslKnowledgable();
    }

    /**
    * Sets the csl knowledgable of this cl soc.
    *
    * @param cslKnowledgable the csl knowledgable of this cl soc
    */
    @Override
    public void setCslKnowledgable(java.lang.String cslKnowledgable) {
        _clSoc.setCslKnowledgable(cslKnowledgable);
    }

    /**
    * Returns the csl supportive of this cl soc.
    *
    * @return the csl supportive of this cl soc
    */
    @Override
    public java.lang.String getCslSupportive() {
        return _clSoc.getCslSupportive();
    }

    /**
    * Sets the csl supportive of this cl soc.
    *
    * @param cslSupportive the csl supportive of this cl soc
    */
    @Override
    public void setCslSupportive(java.lang.String cslSupportive) {
        _clSoc.setCslSupportive(cslSupportive);
    }

    /**
    * Returns the local res suggested of this cl soc.
    *
    * @return the local res suggested of this cl soc
    */
    @Override
    public java.lang.String getLocalResSuggested() {
        return _clSoc.getLocalResSuggested();
    }

    /**
    * Sets the local res suggested of this cl soc.
    *
    * @param localResSuggested the local res suggested of this cl soc
    */
    @Override
    public void setLocalResSuggested(java.lang.String localResSuggested) {
        _clSoc.setLocalResSuggested(localResSuggested);
    }

    /**
    * Returns the local res contacted of this cl soc.
    *
    * @return the local res contacted of this cl soc
    */
    @Override
    public java.lang.String getLocalResContacted() {
        return _clSoc.getLocalResContacted();
    }

    /**
    * Sets the local res contacted of this cl soc.
    *
    * @param localResContacted the local res contacted of this cl soc
    */
    @Override
    public void setLocalResContacted(java.lang.String localResContacted) {
        _clSoc.setLocalResContacted(localResContacted);
    }

    /**
    * Returns the rsn local res not contacted of this cl soc.
    *
    * @return the rsn local res not contacted of this cl soc
    */
    @Override
    public java.lang.String getRsnLocalResNotContacted() {
        return _clSoc.getRsnLocalResNotContacted();
    }

    /**
    * Sets the rsn local res not contacted of this cl soc.
    *
    * @param rsnLocalResNotContacted the rsn local res not contacted of this cl soc
    */
    @Override
    public void setRsnLocalResNotContacted(
        java.lang.String rsnLocalResNotContacted) {
        _clSoc.setRsnLocalResNotContacted(rsnLocalResNotContacted);
    }

    /**
    * Returns the local res helpful of this cl soc.
    *
    * @return the local res helpful of this cl soc
    */
    @Override
    public java.lang.String getLocalResHelpful() {
        return _clSoc.getLocalResHelpful();
    }

    /**
    * Sets the local res helpful of this cl soc.
    *
    * @param localResHelpful the local res helpful of this cl soc
    */
    @Override
    public void setLocalResHelpful(java.lang.String localResHelpful) {
        _clSoc.setLocalResHelpful(localResHelpful);
    }

    /**
    * Returns the concerns answered of this cl soc.
    *
    * @return the concerns answered of this cl soc
    */
    @Override
    public java.lang.String getConcernsAnswered() {
        return _clSoc.getConcernsAnswered();
    }

    /**
    * Sets the concerns answered of this cl soc.
    *
    * @param concernsAnswered the concerns answered of this cl soc
    */
    @Override
    public void setConcernsAnswered(java.lang.String concernsAnswered) {
        _clSoc.setConcernsAnswered(concernsAnswered);
    }

    /**
    * Returns the understand next steps of this cl soc.
    *
    * @return the understand next steps of this cl soc
    */
    @Override
    public java.lang.String getUnderstandNextSteps() {
        return _clSoc.getUnderstandNextSteps();
    }

    /**
    * Sets the understand next steps of this cl soc.
    *
    * @param understandNextSteps the understand next steps of this cl soc
    */
    @Override
    public void setUnderstandNextSteps(java.lang.String understandNextSteps) {
        _clSoc.setUnderstandNextSteps(understandNextSteps);
    }

    /**
    * Returns the call csl again of this cl soc.
    *
    * @return the call csl again of this cl soc
    */
    @Override
    public java.lang.String getCallCslAgain() {
        return _clSoc.getCallCslAgain();
    }

    /**
    * Sets the call csl again of this cl soc.
    *
    * @param callCslAgain the call csl again of this cl soc
    */
    @Override
    public void setCallCslAgain(java.lang.String callCslAgain) {
        _clSoc.setCallCslAgain(callCslAgain);
    }

    /**
    * Returns the recommend csl of this cl soc.
    *
    * @return the recommend csl of this cl soc
    */
    @Override
    public java.lang.String getRecommendCsl() {
        return _clSoc.getRecommendCsl();
    }

    /**
    * Sets the recommend csl of this cl soc.
    *
    * @param recommendCsl the recommend csl of this cl soc
    */
    @Override
    public void setRecommendCsl(java.lang.String recommendCsl) {
        _clSoc.setRecommendCsl(recommendCsl);
    }

    /**
    * Returns the suggestions of this cl soc.
    *
    * @return the suggestions of this cl soc
    */
    @Override
    public java.lang.String getSuggestions() {
        return _clSoc.getSuggestions();
    }

    /**
    * Sets the suggestions of this cl soc.
    *
    * @param suggestions the suggestions of this cl soc
    */
    @Override
    public void setSuggestions(java.lang.String suggestions) {
        _clSoc.setSuggestions(suggestions);
    }

    /**
    * Returns the followup call of this cl soc.
    *
    * @return the followup call of this cl soc
    */
    @Override
    public java.lang.String getFollowupCall() {
        return _clSoc.getFollowupCall();
    }

    /**
    * Sets the followup call of this cl soc.
    *
    * @param followupCall the followup call of this cl soc
    */
    @Override
    public void setFollowupCall(java.lang.String followupCall) {
        _clSoc.setFollowupCall(followupCall);
    }

    /**
    * Returns the followup call time of this cl soc.
    *
    * @return the followup call time of this cl soc
    */
    @Override
    public java.lang.String getFollowupCallTime() {
        return _clSoc.getFollowupCallTime();
    }

    /**
    * Sets the followup call time of this cl soc.
    *
    * @param followupCallTime the followup call time of this cl soc
    */
    @Override
    public void setFollowupCallTime(java.lang.String followupCallTime) {
        _clSoc.setFollowupCallTime(followupCallTime);
    }

    /**
    * Returns the treshold met of this cl soc.
    *
    * @return the treshold met of this cl soc
    */
    @Override
    public java.lang.String getTresholdMet() {
        return _clSoc.getTresholdMet();
    }

    /**
    * Sets the treshold met of this cl soc.
    *
    * @param tresholdMet the treshold met of this cl soc
    */
    @Override
    public void setTresholdMet(java.lang.String tresholdMet) {
        _clSoc.setTresholdMet(tresholdMet);
    }

    @Override
    public boolean isNew() {
        return _clSoc.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _clSoc.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _clSoc.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _clSoc.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _clSoc.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _clSoc.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _clSoc.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _clSoc.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _clSoc.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _clSoc.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _clSoc.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new ClSocWrapper((ClSoc) _clSoc.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.ClSoc clSoc) {
        return _clSoc.compareTo(clSoc);
    }

    @Override
    public int hashCode() {
        return _clSoc.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.ClSoc> toCacheModel() {
        return _clSoc.toCacheModel();
    }

    @Override
    public gov.va.caret.model.ClSoc toEscapedModel() {
        return new ClSocWrapper(_clSoc.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.ClSoc toUnescapedModel() {
        return new ClSocWrapper(_clSoc.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _clSoc.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _clSoc.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _clSoc.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof ClSocWrapper)) {
            return false;
        }

        ClSocWrapper clSocWrapper = (ClSocWrapper) obj;

        if (Validator.equals(_clSoc, clSocWrapper._clSoc)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public ClSoc getWrappedClSoc() {
        return _clSoc;
    }

    @Override
    public ClSoc getWrappedModel() {
        return _clSoc;
    }

    @Override
    public void resetOriginalValues() {
        _clSoc.resetOriginalValues();
    }
}
