package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class ClSocSoap implements Serializable {
    private long _clSocId;
    private long _callId;
    private long _persnId;
    private String _surveyStatus;
    private String _surveyComment;
    private Date _creationDate;
    private String _attemptNum;
    private String _callerAvailable;
    private String _requestedCallbackTime;
    private String _willingToAnsQues;
    private String _calledCsl;
    private String _cslKnowledgable;
    private String _cslSupportive;
    private String _localResSuggested;
    private String _localResContacted;
    private String _rsnLocalResNotContacted;
    private String _localResHelpful;
    private String _concernsAnswered;
    private String _understandNextSteps;
    private String _callCslAgain;
    private String _recommendCsl;
    private String _suggestions;
    private String _followupCall;
    private String _followupCallTime;
    private String _tresholdMet;

    public ClSocSoap() {
    }

    public static ClSocSoap toSoapModel(ClSoc model) {
        ClSocSoap soapModel = new ClSocSoap();

        soapModel.setClSocId(model.getClSocId());
        soapModel.setCallId(model.getCallId());
        soapModel.setPersnId(model.getPersnId());
        soapModel.setSurveyStatus(model.getSurveyStatus());
        soapModel.setSurveyComment(model.getSurveyComment());
        soapModel.setCreationDate(model.getCreationDate());
        soapModel.setAttemptNum(model.getAttemptNum());
        soapModel.setCallerAvailable(model.getCallerAvailable());
        soapModel.setRequestedCallbackTime(model.getRequestedCallbackTime());
        soapModel.setWillingToAnsQues(model.getWillingToAnsQues());
        soapModel.setCalledCsl(model.getCalledCsl());
        soapModel.setCslKnowledgable(model.getCslKnowledgable());
        soapModel.setCslSupportive(model.getCslSupportive());
        soapModel.setLocalResSuggested(model.getLocalResSuggested());
        soapModel.setLocalResContacted(model.getLocalResContacted());
        soapModel.setRsnLocalResNotContacted(model.getRsnLocalResNotContacted());
        soapModel.setLocalResHelpful(model.getLocalResHelpful());
        soapModel.setConcernsAnswered(model.getConcernsAnswered());
        soapModel.setUnderstandNextSteps(model.getUnderstandNextSteps());
        soapModel.setCallCslAgain(model.getCallCslAgain());
        soapModel.setRecommendCsl(model.getRecommendCsl());
        soapModel.setSuggestions(model.getSuggestions());
        soapModel.setFollowupCall(model.getFollowupCall());
        soapModel.setFollowupCallTime(model.getFollowupCallTime());
        soapModel.setTresholdMet(model.getTresholdMet());

        return soapModel;
    }

    public static ClSocSoap[] toSoapModels(ClSoc[] models) {
        ClSocSoap[] soapModels = new ClSocSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static ClSocSoap[][] toSoapModels(ClSoc[][] models) {
        ClSocSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new ClSocSoap[models.length][models[0].length];
        } else {
            soapModels = new ClSocSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static ClSocSoap[] toSoapModels(List<ClSoc> models) {
        List<ClSocSoap> soapModels = new ArrayList<ClSocSoap>(models.size());

        for (ClSoc model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new ClSocSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _clSocId;
    }

    public void setPrimaryKey(long pk) {
        setClSocId(pk);
    }

    public long getClSocId() {
        return _clSocId;
    }

    public void setClSocId(long clSocId) {
        _clSocId = clSocId;
    }

    public long getCallId() {
        return _callId;
    }

    public void setCallId(long callId) {
        _callId = callId;
    }

    public long getPersnId() {
        return _persnId;
    }

    public void setPersnId(long persnId) {
        _persnId = persnId;
    }

    public String getSurveyStatus() {
        return _surveyStatus;
    }

    public void setSurveyStatus(String surveyStatus) {
        _surveyStatus = surveyStatus;
    }

    public String getSurveyComment() {
        return _surveyComment;
    }

    public void setSurveyComment(String surveyComment) {
        _surveyComment = surveyComment;
    }

    public Date getCreationDate() {
        return _creationDate;
    }

    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    public String getAttemptNum() {
        return _attemptNum;
    }

    public void setAttemptNum(String attemptNum) {
        _attemptNum = attemptNum;
    }

    public String getCallerAvailable() {
        return _callerAvailable;
    }

    public void setCallerAvailable(String callerAvailable) {
        _callerAvailable = callerAvailable;
    }

    public String getRequestedCallbackTime() {
        return _requestedCallbackTime;
    }

    public void setRequestedCallbackTime(String requestedCallbackTime) {
        _requestedCallbackTime = requestedCallbackTime;
    }

    public String getWillingToAnsQues() {
        return _willingToAnsQues;
    }

    public void setWillingToAnsQues(String willingToAnsQues) {
        _willingToAnsQues = willingToAnsQues;
    }

    public String getCalledCsl() {
        return _calledCsl;
    }

    public void setCalledCsl(String calledCsl) {
        _calledCsl = calledCsl;
    }

    public String getCslKnowledgable() {
        return _cslKnowledgable;
    }

    public void setCslKnowledgable(String cslKnowledgable) {
        _cslKnowledgable = cslKnowledgable;
    }

    public String getCslSupportive() {
        return _cslSupportive;
    }

    public void setCslSupportive(String cslSupportive) {
        _cslSupportive = cslSupportive;
    }

    public String getLocalResSuggested() {
        return _localResSuggested;
    }

    public void setLocalResSuggested(String localResSuggested) {
        _localResSuggested = localResSuggested;
    }

    public String getLocalResContacted() {
        return _localResContacted;
    }

    public void setLocalResContacted(String localResContacted) {
        _localResContacted = localResContacted;
    }

    public String getRsnLocalResNotContacted() {
        return _rsnLocalResNotContacted;
    }

    public void setRsnLocalResNotContacted(String rsnLocalResNotContacted) {
        _rsnLocalResNotContacted = rsnLocalResNotContacted;
    }

    public String getLocalResHelpful() {
        return _localResHelpful;
    }

    public void setLocalResHelpful(String localResHelpful) {
        _localResHelpful = localResHelpful;
    }

    public String getConcernsAnswered() {
        return _concernsAnswered;
    }

    public void setConcernsAnswered(String concernsAnswered) {
        _concernsAnswered = concernsAnswered;
    }

    public String getUnderstandNextSteps() {
        return _understandNextSteps;
    }

    public void setUnderstandNextSteps(String understandNextSteps) {
        _understandNextSteps = understandNextSteps;
    }

    public String getCallCslAgain() {
        return _callCslAgain;
    }

    public void setCallCslAgain(String callCslAgain) {
        _callCslAgain = callCslAgain;
    }

    public String getRecommendCsl() {
        return _recommendCsl;
    }

    public void setRecommendCsl(String recommendCsl) {
        _recommendCsl = recommendCsl;
    }

    public String getSuggestions() {
        return _suggestions;
    }

    public void setSuggestions(String suggestions) {
        _suggestions = suggestions;
    }

    public String getFollowupCall() {
        return _followupCall;
    }

    public void setFollowupCall(String followupCall) {
        _followupCall = followupCall;
    }

    public String getFollowupCallTime() {
        return _followupCallTime;
    }

    public void setFollowupCallTime(String followupCallTime) {
        _followupCallTime = followupCallTime;
    }

    public String getTresholdMet() {
        return _tresholdMet;
    }

    public void setTresholdMet(String tresholdMet) {
        _tresholdMet = tresholdMet;
    }
}
