package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.CespLocalServiceUtil;
import gov.va.caret.service.ClpSerializer;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class CespClp extends BaseModelImpl<Cesp> implements Cesp {
    private long _cespId;
    private long _callId;
    private long _createdByPersnId;
    private Date _creationDate;
    private String _step;
    private String _status;
    private String _referredBy;
    private String _assignedCslPersnId;
    private String _goals;
    private String _planProgressBarrier;
    private String _cespClosed;
    private String _cespClosedReason;
    private String _goalsReached;
    private BaseModel<?> _cespRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public CespClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return Cesp.class;
    }

    @Override
    public String getModelClassName() {
        return Cesp.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _cespId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setCespId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _cespId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("cespId", getCespId());
        attributes.put("callId", getCallId());
        attributes.put("createdByPersnId", getCreatedByPersnId());
        attributes.put("creationDate", getCreationDate());
        attributes.put("step", getStep());
        attributes.put("status", getStatus());
        attributes.put("referredBy", getReferredBy());
        attributes.put("assignedCslPersnId", getAssignedCslPersnId());
        attributes.put("goals", getGoals());
        attributes.put("planProgressBarrier", getPlanProgressBarrier());
        attributes.put("cespClosed", getCespClosed());
        attributes.put("cespClosedReason", getCespClosedReason());
        attributes.put("goalsReached", getGoalsReached());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long cespId = (Long) attributes.get("cespId");

        if (cespId != null) {
            setCespId(cespId);
        }

        Long callId = (Long) attributes.get("callId");

        if (callId != null) {
            setCallId(callId);
        }

        Long createdByPersnId = (Long) attributes.get("createdByPersnId");

        if (createdByPersnId != null) {
            setCreatedByPersnId(createdByPersnId);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        String step = (String) attributes.get("step");

        if (step != null) {
            setStep(step);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        String referredBy = (String) attributes.get("referredBy");

        if (referredBy != null) {
            setReferredBy(referredBy);
        }

        String assignedCslPersnId = (String) attributes.get(
                "assignedCslPersnId");

        if (assignedCslPersnId != null) {
            setAssignedCslPersnId(assignedCslPersnId);
        }

        String goals = (String) attributes.get("goals");

        if (goals != null) {
            setGoals(goals);
        }

        String planProgressBarrier = (String) attributes.get(
                "planProgressBarrier");

        if (planProgressBarrier != null) {
            setPlanProgressBarrier(planProgressBarrier);
        }

        String cespClosed = (String) attributes.get("cespClosed");

        if (cespClosed != null) {
            setCespClosed(cespClosed);
        }

        String cespClosedReason = (String) attributes.get("cespClosedReason");

        if (cespClosedReason != null) {
            setCespClosedReason(cespClosedReason);
        }

        String goalsReached = (String) attributes.get("goalsReached");

        if (goalsReached != null) {
            setGoalsReached(goalsReached);
        }
    }

    @Override
    public long getCespId() {
        return _cespId;
    }

    @Override
    public void setCespId(long cespId) {
        _cespId = cespId;

        if (_cespRemoteModel != null) {
            try {
                Class<?> clazz = _cespRemoteModel.getClass();

                Method method = clazz.getMethod("setCespId", long.class);

                method.invoke(_cespRemoteModel, cespId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getCallId() {
        return _callId;
    }

    @Override
    public void setCallId(long callId) {
        _callId = callId;

        if (_cespRemoteModel != null) {
            try {
                Class<?> clazz = _cespRemoteModel.getClass();

                Method method = clazz.getMethod("setCallId", long.class);

                method.invoke(_cespRemoteModel, callId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getCreatedByPersnId() {
        return _createdByPersnId;
    }

    @Override
    public void setCreatedByPersnId(long createdByPersnId) {
        _createdByPersnId = createdByPersnId;

        if (_cespRemoteModel != null) {
            try {
                Class<?> clazz = _cespRemoteModel.getClass();

                Method method = clazz.getMethod("setCreatedByPersnId",
                        long.class);

                method.invoke(_cespRemoteModel, createdByPersnId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;

        if (_cespRemoteModel != null) {
            try {
                Class<?> clazz = _cespRemoteModel.getClass();

                Method method = clazz.getMethod("setCreationDate", Date.class);

                method.invoke(_cespRemoteModel, creationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getStep() {
        return _step;
    }

    @Override
    public void setStep(String step) {
        _step = step;

        if (_cespRemoteModel != null) {
            try {
                Class<?> clazz = _cespRemoteModel.getClass();

                Method method = clazz.getMethod("setStep", String.class);

                method.invoke(_cespRemoteModel, step);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getStatus() {
        return _status;
    }

    @Override
    public void setStatus(String status) {
        _status = status;

        if (_cespRemoteModel != null) {
            try {
                Class<?> clazz = _cespRemoteModel.getClass();

                Method method = clazz.getMethod("setStatus", String.class);

                method.invoke(_cespRemoteModel, status);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getReferredBy() {
        return _referredBy;
    }

    @Override
    public void setReferredBy(String referredBy) {
        _referredBy = referredBy;

        if (_cespRemoteModel != null) {
            try {
                Class<?> clazz = _cespRemoteModel.getClass();

                Method method = clazz.getMethod("setReferredBy", String.class);

                method.invoke(_cespRemoteModel, referredBy);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getAssignedCslPersnId() {
        return _assignedCslPersnId;
    }

    @Override
    public void setAssignedCslPersnId(String assignedCslPersnId) {
        _assignedCslPersnId = assignedCslPersnId;

        if (_cespRemoteModel != null) {
            try {
                Class<?> clazz = _cespRemoteModel.getClass();

                Method method = clazz.getMethod("setAssignedCslPersnId",
                        String.class);

                method.invoke(_cespRemoteModel, assignedCslPersnId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getGoals() {
        return _goals;
    }

    @Override
    public void setGoals(String goals) {
        _goals = goals;

        if (_cespRemoteModel != null) {
            try {
                Class<?> clazz = _cespRemoteModel.getClass();

                Method method = clazz.getMethod("setGoals", String.class);

                method.invoke(_cespRemoteModel, goals);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getPlanProgressBarrier() {
        return _planProgressBarrier;
    }

    @Override
    public void setPlanProgressBarrier(String planProgressBarrier) {
        _planProgressBarrier = planProgressBarrier;

        if (_cespRemoteModel != null) {
            try {
                Class<?> clazz = _cespRemoteModel.getClass();

                Method method = clazz.getMethod("setPlanProgressBarrier",
                        String.class);

                method.invoke(_cespRemoteModel, planProgressBarrier);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCespClosed() {
        return _cespClosed;
    }

    @Override
    public void setCespClosed(String cespClosed) {
        _cespClosed = cespClosed;

        if (_cespRemoteModel != null) {
            try {
                Class<?> clazz = _cespRemoteModel.getClass();

                Method method = clazz.getMethod("setCespClosed", String.class);

                method.invoke(_cespRemoteModel, cespClosed);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCespClosedReason() {
        return _cespClosedReason;
    }

    @Override
    public void setCespClosedReason(String cespClosedReason) {
        _cespClosedReason = cespClosedReason;

        if (_cespRemoteModel != null) {
            try {
                Class<?> clazz = _cespRemoteModel.getClass();

                Method method = clazz.getMethod("setCespClosedReason",
                        String.class);

                method.invoke(_cespRemoteModel, cespClosedReason);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getGoalsReached() {
        return _goalsReached;
    }

    @Override
    public void setGoalsReached(String goalsReached) {
        _goalsReached = goalsReached;

        if (_cespRemoteModel != null) {
            try {
                Class<?> clazz = _cespRemoteModel.getClass();

                Method method = clazz.getMethod("setGoalsReached", String.class);

                method.invoke(_cespRemoteModel, goalsReached);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getCespRemoteModel() {
        return _cespRemoteModel;
    }

    public void setCespRemoteModel(BaseModel<?> cespRemoteModel) {
        _cespRemoteModel = cespRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _cespRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_cespRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            CespLocalServiceUtil.addCesp(this);
        } else {
            CespLocalServiceUtil.updateCesp(this);
        }
    }

    @Override
    public Cesp toEscapedModel() {
        return (Cesp) ProxyUtil.newProxyInstance(Cesp.class.getClassLoader(),
            new Class[] { Cesp.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        CespClp clone = new CespClp();

        clone.setCespId(getCespId());
        clone.setCallId(getCallId());
        clone.setCreatedByPersnId(getCreatedByPersnId());
        clone.setCreationDate(getCreationDate());
        clone.setStep(getStep());
        clone.setStatus(getStatus());
        clone.setReferredBy(getReferredBy());
        clone.setAssignedCslPersnId(getAssignedCslPersnId());
        clone.setGoals(getGoals());
        clone.setPlanProgressBarrier(getPlanProgressBarrier());
        clone.setCespClosed(getCespClosed());
        clone.setCespClosedReason(getCespClosedReason());
        clone.setGoalsReached(getGoalsReached());

        return clone;
    }

    @Override
    public int compareTo(Cesp cesp) {
        long primaryKey = cesp.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof CespClp)) {
            return false;
        }

        CespClp cesp = (CespClp) obj;

        long primaryKey = cesp.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(27);

        sb.append("{cespId=");
        sb.append(getCespId());
        sb.append(", callId=");
        sb.append(getCallId());
        sb.append(", createdByPersnId=");
        sb.append(getCreatedByPersnId());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", step=");
        sb.append(getStep());
        sb.append(", status=");
        sb.append(getStatus());
        sb.append(", referredBy=");
        sb.append(getReferredBy());
        sb.append(", assignedCslPersnId=");
        sb.append(getAssignedCslPersnId());
        sb.append(", goals=");
        sb.append(getGoals());
        sb.append(", planProgressBarrier=");
        sb.append(getPlanProgressBarrier());
        sb.append(", cespClosed=");
        sb.append(getCespClosed());
        sb.append(", cespClosedReason=");
        sb.append(getCespClosedReason());
        sb.append(", goalsReached=");
        sb.append(getGoalsReached());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(43);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Cesp");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>cespId</column-name><column-value><![CDATA[");
        sb.append(getCespId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callId</column-name><column-value><![CDATA[");
        sb.append(getCallId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>createdByPersnId</column-name><column-value><![CDATA[");
        sb.append(getCreatedByPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>step</column-name><column-value><![CDATA[");
        sb.append(getStep());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>status</column-name><column-value><![CDATA[");
        sb.append(getStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>referredBy</column-name><column-value><![CDATA[");
        sb.append(getReferredBy());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>assignedCslPersnId</column-name><column-value><![CDATA[");
        sb.append(getAssignedCslPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>goals</column-name><column-value><![CDATA[");
        sb.append(getGoals());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>planProgressBarrier</column-name><column-value><![CDATA[");
        sb.append(getPlanProgressBarrier());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cespClosed</column-name><column-value><![CDATA[");
        sb.append(getCespClosed());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cespClosedReason</column-name><column-value><![CDATA[");
        sb.append(getCespClosedReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>goalsReached</column-name><column-value><![CDATA[");
        sb.append(getGoalsReached());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
