package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class CalEtSoap implements Serializable {
    private long _calEtId;
    private long _callId;
    private String _event;
    private String _comment;
    private Date _creationDate;
    private long _userId;

    public CalEtSoap() {
    }

    public static CalEtSoap toSoapModel(CalEt model) {
        CalEtSoap soapModel = new CalEtSoap();

        soapModel.setCalEtId(model.getCalEtId());
        soapModel.setCallId(model.getCallId());
        soapModel.setEvent(model.getEvent());
        soapModel.setComment(model.getComment());
        soapModel.setCreationDate(model.getCreationDate());
        soapModel.setUserId(model.getUserId());

        return soapModel;
    }

    public static CalEtSoap[] toSoapModels(CalEt[] models) {
        CalEtSoap[] soapModels = new CalEtSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static CalEtSoap[][] toSoapModels(CalEt[][] models) {
        CalEtSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new CalEtSoap[models.length][models[0].length];
        } else {
            soapModels = new CalEtSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static CalEtSoap[] toSoapModels(List<CalEt> models) {
        List<CalEtSoap> soapModels = new ArrayList<CalEtSoap>(models.size());

        for (CalEt model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new CalEtSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _calEtId;
    }

    public void setPrimaryKey(long pk) {
        setCalEtId(pk);
    }

    public long getCalEtId() {
        return _calEtId;
    }

    public void setCalEtId(long calEtId) {
        _calEtId = calEtId;
    }

    public long getCallId() {
        return _callId;
    }

    public void setCallId(long callId) {
        _callId = callId;
    }

    public String getEvent() {
        return _event;
    }

    public void setEvent(String event) {
        _event = event;
    }

    public String getComment() {
        return _comment;
    }

    public void setComment(String comment) {
        _comment = comment;
    }

    public Date getCreationDate() {
        return _creationDate;
    }

    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    public long getUserId() {
        return _userId;
    }

    public void setUserId(long userId) {
        _userId = userId;
    }
}
