package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.service.CalEtLocalServiceUtil;
import gov.va.caret.service.ClpSerializer;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class CalEtClp extends BaseModelImpl<CalEt> implements CalEt {
    private long _calEtId;
    private long _callId;
    private String _event;
    private String _comment;
    private Date _creationDate;
    private long _userId;
    private String _userUuid;
    private BaseModel<?> _calEtRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public CalEtClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return CalEt.class;
    }

    @Override
    public String getModelClassName() {
        return CalEt.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _calEtId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setCalEtId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _calEtId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("calEtId", getCalEtId());
        attributes.put("callId", getCallId());
        attributes.put("event", getEvent());
        attributes.put("comment", getComment());
        attributes.put("creationDate", getCreationDate());
        attributes.put("userId", getUserId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long calEtId = (Long) attributes.get("calEtId");

        if (calEtId != null) {
            setCalEtId(calEtId);
        }

        Long callId = (Long) attributes.get("callId");

        if (callId != null) {
            setCallId(callId);
        }

        String event = (String) attributes.get("event");

        if (event != null) {
            setEvent(event);
        }

        String comment = (String) attributes.get("comment");

        if (comment != null) {
            setComment(comment);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }
    }

    @Override
    public long getCalEtId() {
        return _calEtId;
    }

    @Override
    public void setCalEtId(long calEtId) {
        _calEtId = calEtId;

        if (_calEtRemoteModel != null) {
            try {
                Class<?> clazz = _calEtRemoteModel.getClass();

                Method method = clazz.getMethod("setCalEtId", long.class);

                method.invoke(_calEtRemoteModel, calEtId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getCallId() {
        return _callId;
    }

    @Override
    public void setCallId(long callId) {
        _callId = callId;

        if (_calEtRemoteModel != null) {
            try {
                Class<?> clazz = _calEtRemoteModel.getClass();

                Method method = clazz.getMethod("setCallId", long.class);

                method.invoke(_calEtRemoteModel, callId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getEvent() {
        return _event;
    }

    @Override
    public void setEvent(String event) {
        _event = event;

        if (_calEtRemoteModel != null) {
            try {
                Class<?> clazz = _calEtRemoteModel.getClass();

                Method method = clazz.getMethod("setEvent", String.class);

                method.invoke(_calEtRemoteModel, event);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getComment() {
        return _comment;
    }

    @Override
    public void setComment(String comment) {
        _comment = comment;

        if (_calEtRemoteModel != null) {
            try {
                Class<?> clazz = _calEtRemoteModel.getClass();

                Method method = clazz.getMethod("setComment", String.class);

                method.invoke(_calEtRemoteModel, comment);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;

        if (_calEtRemoteModel != null) {
            try {
                Class<?> clazz = _calEtRemoteModel.getClass();

                Method method = clazz.getMethod("setCreationDate", Date.class);

                method.invoke(_calEtRemoteModel, creationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;

        if (_calEtRemoteModel != null) {
            try {
                Class<?> clazz = _calEtRemoteModel.getClass();

                Method method = clazz.getMethod("setUserId", long.class);

                method.invoke(_calEtRemoteModel, userId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    public BaseModel<?> getCalEtRemoteModel() {
        return _calEtRemoteModel;
    }

    public void setCalEtRemoteModel(BaseModel<?> calEtRemoteModel) {
        _calEtRemoteModel = calEtRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _calEtRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_calEtRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            CalEtLocalServiceUtil.addCalEt(this);
        } else {
            CalEtLocalServiceUtil.updateCalEt(this);
        }
    }

    @Override
    public CalEt toEscapedModel() {
        return (CalEt) ProxyUtil.newProxyInstance(CalEt.class.getClassLoader(),
            new Class[] { CalEt.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        CalEtClp clone = new CalEtClp();

        clone.setCalEtId(getCalEtId());
        clone.setCallId(getCallId());
        clone.setEvent(getEvent());
        clone.setComment(getComment());
        clone.setCreationDate(getCreationDate());
        clone.setUserId(getUserId());

        return clone;
    }

    @Override
    public int compareTo(CalEt calEt) {
        long primaryKey = calEt.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof CalEtClp)) {
            return false;
        }

        CalEtClp calEt = (CalEtClp) obj;

        long primaryKey = calEt.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(13);

        sb.append("{calEtId=");
        sb.append(getCalEtId());
        sb.append(", callId=");
        sb.append(getCallId());
        sb.append(", event=");
        sb.append(getEvent());
        sb.append(", comment=");
        sb.append(getComment());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(22);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.CalEt");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>calEtId</column-name><column-value><![CDATA[");
        sb.append(getCalEtId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callId</column-name><column-value><![CDATA[");
        sb.append(getCallId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>event</column-name><column-value><![CDATA[");
        sb.append(getEvent());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>comment</column-name><column-value><![CDATA[");
        sb.append(getComment());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
