package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the BlsRe service. Represents a row in the &quot;CARET_BLS&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.BlsReModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.BlsReImpl}.
 * </p>
 *
 * @author caret
 * @see BlsRe
 * @see gov.va.caret.model.impl.BlsReImpl
 * @see gov.va.caret.model.impl.BlsReModelImpl
 * @generated
 */
public interface BlsReModel extends BaseModel<BlsRe> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a bls re model instance should use the {@link BlsRe} interface instead.
     */

    /**
     * Returns the primary key of this bls re.
     *
     * @return the primary key of this bls re
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this bls re.
     *
     * @param primaryKey the primary key of this bls re
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the bls re ID of this bls re.
     *
     * @return the bls re ID of this bls re
     */
    public long getBlsReId();

    /**
     * Sets the bls re ID of this bls re.
     *
     * @param blsReId the bls re ID of this bls re
     */
    public void setBlsReId(long blsReId);

    /**
     * Returns the bls ae ID of this bls re.
     *
     * @return the bls ae ID of this bls re
     */
    public long getBlsAeId();

    /**
     * Sets the bls ae ID of this bls re.
     *
     * @param blsAeId the bls ae ID of this bls re
     */
    public void setBlsAeId(long blsAeId);

    /**
     * Returns the year of this bls re.
     *
     * @return the year of this bls re
     */
    public int getYear();

    /**
     * Sets the year of this bls re.
     *
     * @param year the year of this bls re
     */
    public void setYear(int year);

    /**
     * Returns the h75 of this bls re.
     *
     * @return the h75 of this bls re
     */
    public Double getH75();

    /**
     * Sets the h75 of this bls re.
     *
     * @param h75 the h75 of this bls re
     */
    public void setH75(Double h75);

    /**
     * Returns the city of this bls re.
     *
     * @return the city of this bls re
     */
    @AutoEscape
    public String getCity();

    /**
     * Sets the city of this bls re.
     *
     * @param city the city of this bls re
     */
    public void setCity(String city);

    /**
     * Returns the zip of this bls re.
     *
     * @return the zip of this bls re
     */
    @AutoEscape
    public String getZip();

    /**
     * Sets the zip of this bls re.
     *
     * @param zip the zip of this bls re
     */
    public void setZip(String zip);

    /**
     * Returns the state of this bls re.
     *
     * @return the state of this bls re
     */
    @AutoEscape
    public String getState();

    /**
     * Sets the state of this bls re.
     *
     * @param state the state of this bls re
     */
    public void setState(String state);

    /**
     * Returns the county of this bls re.
     *
     * @return the county of this bls re
     */
    @AutoEscape
    public String getCounty();

    /**
     * Sets the county of this bls re.
     *
     * @param county the county of this bls re
     */
    public void setCounty(String county);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.BlsRe blsRe);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.BlsRe> toCacheModel();

    @Override
    public gov.va.caret.model.BlsRe toEscapedModel();

    @Override
    public gov.va.caret.model.BlsRe toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
