package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the AudLg service. Represents a row in the &quot;CARET_AUDIT_LOG&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.AudLgModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.AudLgImpl}.
 * </p>
 *
 * @author caret
 * @see AudLg
 * @see gov.va.caret.model.impl.AudLgImpl
 * @see gov.va.caret.model.impl.AudLgModelImpl
 * @generated
 */
public interface AudLgModel extends BaseModel<AudLg> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a aud lg model instance should use the {@link AudLg} interface instead.
     */

    /**
     * Returns the primary key of this aud lg.
     *
     * @return the primary key of this aud lg
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this aud lg.
     *
     * @param primaryKey the primary key of this aud lg
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the aud lg ID of this aud lg.
     *
     * @return the aud lg ID of this aud lg
     */
    public long getAudLgId();

    /**
     * Sets the aud lg ID of this aud lg.
     *
     * @param audLgId the aud lg ID of this aud lg
     */
    public void setAudLgId(long audLgId);

    /**
     * Returns the class pk of this aud lg.
     *
     * @return the class pk of this aud lg
     */
    public long getClassPk();

    /**
     * Sets the class pk of this aud lg.
     *
     * @param classPk the class pk of this aud lg
     */
    public void setClassPk(long classPk);

    /**
     * Returns the class ID of this aud lg.
     *
     * @return the class ID of this aud lg
     */
    public long getClassId();

    /**
     * Sets the class ID of this aud lg.
     *
     * @param classId the class ID of this aud lg
     */
    public void setClassId(long classId);

    /**
     * Returns the attribute of this aud lg.
     *
     * @return the attribute of this aud lg
     */
    @AutoEscape
    public String getAttribute();

    /**
     * Sets the attribute of this aud lg.
     *
     * @param attribute the attribute of this aud lg
     */
    public void setAttribute(String attribute);

    /**
     * Returns the old value of this aud lg.
     *
     * @return the old value of this aud lg
     */
    @AutoEscape
    public String getOldValue();

    /**
     * Sets the old value of this aud lg.
     *
     * @param oldValue the old value of this aud lg
     */
    public void setOldValue(String oldValue);

    /**
     * Returns the new value of this aud lg.
     *
     * @return the new value of this aud lg
     */
    @AutoEscape
    public String getNewValue();

    /**
     * Sets the new value of this aud lg.
     *
     * @param newValue the new value of this aud lg
     */
    public void setNewValue(String newValue);

    /**
     * Returns the cover user ID of this aud lg.
     *
     * @return the cover user ID of this aud lg
     */
    public long getCoverUserId();

    /**
     * Sets the cover user ID of this aud lg.
     *
     * @param coverUserId the cover user ID of this aud lg
     */
    public void setCoverUserId(long coverUserId);

    /**
     * Returns the cover user uuid of this aud lg.
     *
     * @return the cover user uuid of this aud lg
     * @throws SystemException if a system exception occurred
     */
    public String getCoverUserUuid() throws SystemException;

    /**
     * Sets the cover user uuid of this aud lg.
     *
     * @param coverUserUuid the cover user uuid of this aud lg
     */
    public void setCoverUserUuid(String coverUserUuid);

    /**
     * Returns the modified by ID of this aud lg.
     *
     * @return the modified by ID of this aud lg
     */
    public long getModifiedById();

    /**
     * Sets the modified by ID of this aud lg.
     *
     * @param modifiedById the modified by ID of this aud lg
     */
    public void setModifiedById(long modifiedById);

    /**
     * Returns the modified date of this aud lg.
     *
     * @return the modified date of this aud lg
     */
    public Date getModifiedDate();

    /**
     * Sets the modified date of this aud lg.
     *
     * @param modifiedDate the modified date of this aud lg
     */
    public void setModifiedDate(Date modifiedDate);

    /**
     * Returns the group ID of this aud lg.
     *
     * @return the group ID of this aud lg
     */
    public long getGroupId();

    /**
     * Sets the group ID of this aud lg.
     *
     * @param groupId the group ID of this aud lg
     */
    public void setGroupId(long groupId);

    /**
     * Returns the role name of this aud lg.
     *
     * @return the role name of this aud lg
     */
    @AutoEscape
    public String getRoleName();

    /**
     * Sets the role name of this aud lg.
     *
     * @param roleName the role name of this aud lg
     */
    public void setRoleName(String roleName);

    /**
     * Returns the sys date time of this aud lg.
     *
     * @return the sys date time of this aud lg
     */
    public long getSysDateTime();

    /**
     * Sets the sys date time of this aud lg.
     *
     * @param sysDateTime the sys date time of this aud lg
     */
    public void setSysDateTime(long sysDateTime);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.AudLg audLg);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.AudLg> toCacheModel();

    @Override
    public gov.va.caret.model.AudLg toEscapedModel();

    @Override
    public gov.va.caret.model.AudLg toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
