package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link Assmt}.
 * </p>
 *
 * @author caret
 * @see Assmt
 * @generated
 */
public class AssmtWrapper implements Assmt, ModelWrapper<Assmt> {
    private Assmt _assmt;

    public AssmtWrapper(Assmt assmt) {
        _assmt = assmt;
    }

    @Override
    public Class<?> getModelClass() {
        return Assmt.class;
    }

    @Override
    public String getModelClassName() {
        return Assmt.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("assmtId", getAssmtId());
        attributes.put("vcgId", getVcgId());
        attributes.put("noteId", getNoteId());
        attributes.put("completionDate", getCompletionDate());
        attributes.put("type", getType());
        attributes.put("scheduleDate", getScheduleDate());
        attributes.put("userId", getUserId());
        attributes.put("comment", getComment());
        attributes.put("active", getActive());
        attributes.put("caregiverId", getCaregiverId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long assmtId = (Long) attributes.get("assmtId");

        if (assmtId != null) {
            setAssmtId(assmtId);
        }

        Long vcgId = (Long) attributes.get("vcgId");

        if (vcgId != null) {
            setVcgId(vcgId);
        }

        Long noteId = (Long) attributes.get("noteId");

        if (noteId != null) {
            setNoteId(noteId);
        }

        Date completionDate = (Date) attributes.get("completionDate");

        if (completionDate != null) {
            setCompletionDate(completionDate);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }

        Date scheduleDate = (Date) attributes.get("scheduleDate");

        if (scheduleDate != null) {
            setScheduleDate(scheduleDate);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        String comment = (String) attributes.get("comment");

        if (comment != null) {
            setComment(comment);
        }

        Boolean active = (Boolean) attributes.get("active");

        if (active != null) {
            setActive(active);
        }

        Long caregiverId = (Long) attributes.get("caregiverId");

        if (caregiverId != null) {
            setCaregiverId(caregiverId);
        }
    }

    /**
    * Returns the primary key of this assmt.
    *
    * @return the primary key of this assmt
    */
    @Override
    public long getPrimaryKey() {
        return _assmt.getPrimaryKey();
    }

    /**
    * Sets the primary key of this assmt.
    *
    * @param primaryKey the primary key of this assmt
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _assmt.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the assmt ID of this assmt.
    *
    * @return the assmt ID of this assmt
    */
    @Override
    public long getAssmtId() {
        return _assmt.getAssmtId();
    }

    /**
    * Sets the assmt ID of this assmt.
    *
    * @param assmtId the assmt ID of this assmt
    */
    @Override
    public void setAssmtId(long assmtId) {
        _assmt.setAssmtId(assmtId);
    }

    /**
    * Returns the vcg ID of this assmt.
    *
    * @return the vcg ID of this assmt
    */
    @Override
    public long getVcgId() {
        return _assmt.getVcgId();
    }

    /**
    * Sets the vcg ID of this assmt.
    *
    * @param vcgId the vcg ID of this assmt
    */
    @Override
    public void setVcgId(long vcgId) {
        _assmt.setVcgId(vcgId);
    }

    /**
    * Returns the note ID of this assmt.
    *
    * @return the note ID of this assmt
    */
    @Override
    public long getNoteId() {
        return _assmt.getNoteId();
    }

    /**
    * Sets the note ID of this assmt.
    *
    * @param noteId the note ID of this assmt
    */
    @Override
    public void setNoteId(long noteId) {
        _assmt.setNoteId(noteId);
    }

    /**
    * Returns the completion date of this assmt.
    *
    * @return the completion date of this assmt
    */
    @Override
    public java.util.Date getCompletionDate() {
        return _assmt.getCompletionDate();
    }

    /**
    * Sets the completion date of this assmt.
    *
    * @param completionDate the completion date of this assmt
    */
    @Override
    public void setCompletionDate(java.util.Date completionDate) {
        _assmt.setCompletionDate(completionDate);
    }

    /**
    * Returns the type of this assmt.
    *
    * @return the type of this assmt
    */
    @Override
    public java.lang.String getType() {
        return _assmt.getType();
    }

    /**
    * Sets the type of this assmt.
    *
    * @param type the type of this assmt
    */
    @Override
    public void setType(java.lang.String type) {
        _assmt.setType(type);
    }

    /**
    * Returns the schedule date of this assmt.
    *
    * @return the schedule date of this assmt
    */
    @Override
    public java.util.Date getScheduleDate() {
        return _assmt.getScheduleDate();
    }

    /**
    * Sets the schedule date of this assmt.
    *
    * @param scheduleDate the schedule date of this assmt
    */
    @Override
    public void setScheduleDate(java.util.Date scheduleDate) {
        _assmt.setScheduleDate(scheduleDate);
    }

    /**
    * Returns the user ID of this assmt.
    *
    * @return the user ID of this assmt
    */
    @Override
    public long getUserId() {
        return _assmt.getUserId();
    }

    /**
    * Sets the user ID of this assmt.
    *
    * @param userId the user ID of this assmt
    */
    @Override
    public void setUserId(long userId) {
        _assmt.setUserId(userId);
    }

    /**
    * Returns the user uuid of this assmt.
    *
    * @return the user uuid of this assmt
    * @throws SystemException if a system exception occurred
    */
    @Override
    public java.lang.String getUserUuid()
        throws com.liferay.portal.kernel.exception.SystemException {
        return _assmt.getUserUuid();
    }

    /**
    * Sets the user uuid of this assmt.
    *
    * @param userUuid the user uuid of this assmt
    */
    @Override
    public void setUserUuid(java.lang.String userUuid) {
        _assmt.setUserUuid(userUuid);
    }

    /**
    * Returns the comment of this assmt.
    *
    * @return the comment of this assmt
    */
    @Override
    public java.lang.String getComment() {
        return _assmt.getComment();
    }

    /**
    * Sets the comment of this assmt.
    *
    * @param comment the comment of this assmt
    */
    @Override
    public void setComment(java.lang.String comment) {
        _assmt.setComment(comment);
    }

    /**
    * Returns the active of this assmt.
    *
    * @return the active of this assmt
    */
    @Override
    public boolean getActive() {
        return _assmt.getActive();
    }

    /**
    * Returns <code>true</code> if this assmt is active.
    *
    * @return <code>true</code> if this assmt is active; <code>false</code> otherwise
    */
    @Override
    public boolean isActive() {
        return _assmt.isActive();
    }

    /**
    * Sets whether this assmt is active.
    *
    * @param active the active of this assmt
    */
    @Override
    public void setActive(boolean active) {
        _assmt.setActive(active);
    }

    /**
    * Returns the caregiver ID of this assmt.
    *
    * @return the caregiver ID of this assmt
    */
    @Override
    public long getCaregiverId() {
        return _assmt.getCaregiverId();
    }

    /**
    * Sets the caregiver ID of this assmt.
    *
    * @param caregiverId the caregiver ID of this assmt
    */
    @Override
    public void setCaregiverId(long caregiverId) {
        _assmt.setCaregiverId(caregiverId);
    }

    @Override
    public boolean isNew() {
        return _assmt.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _assmt.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _assmt.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _assmt.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _assmt.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _assmt.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _assmt.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _assmt.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _assmt.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _assmt.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _assmt.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new AssmtWrapper((Assmt) _assmt.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.Assmt assmt) {
        return _assmt.compareTo(assmt);
    }

    @Override
    public int hashCode() {
        return _assmt.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.Assmt> toCacheModel() {
        return _assmt.toCacheModel();
    }

    @Override
    public gov.va.caret.model.Assmt toEscapedModel() {
        return new AssmtWrapper(_assmt.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.Assmt toUnescapedModel() {
        return new AssmtWrapper(_assmt.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _assmt.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _assmt.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _assmt.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof AssmtWrapper)) {
            return false;
        }

        AssmtWrapper assmtWrapper = (AssmtWrapper) obj;

        if (Validator.equals(_assmt, assmtWrapper._assmt)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public Assmt getWrappedAssmt() {
        return _assmt;
    }

    @Override
    public Assmt getWrappedModel() {
        return _assmt;
    }

    @Override
    public void resetOriginalValues() {
        _assmt.resetOriginalValues();
    }
}
