package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class AssmtSoap implements Serializable {
    private long _assmtId;
    private long _vcgId;
    private long _noteId;
    private Date _completionDate;
    private String _type;
    private Date _scheduleDate;
    private long _userId;
    private String _comment;
    private boolean _active;
    private long _caregiverId;

    public AssmtSoap() {
    }

    public static AssmtSoap toSoapModel(Assmt model) {
        AssmtSoap soapModel = new AssmtSoap();

        soapModel.setAssmtId(model.getAssmtId());
        soapModel.setVcgId(model.getVcgId());
        soapModel.setNoteId(model.getNoteId());
        soapModel.setCompletionDate(model.getCompletionDate());
        soapModel.setType(model.getType());
        soapModel.setScheduleDate(model.getScheduleDate());
        soapModel.setUserId(model.getUserId());
        soapModel.setComment(model.getComment());
        soapModel.setActive(model.getActive());
        soapModel.setCaregiverId(model.getCaregiverId());

        return soapModel;
    }

    public static AssmtSoap[] toSoapModels(Assmt[] models) {
        AssmtSoap[] soapModels = new AssmtSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static AssmtSoap[][] toSoapModels(Assmt[][] models) {
        AssmtSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new AssmtSoap[models.length][models[0].length];
        } else {
            soapModels = new AssmtSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static AssmtSoap[] toSoapModels(List<Assmt> models) {
        List<AssmtSoap> soapModels = new ArrayList<AssmtSoap>(models.size());

        for (Assmt model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new AssmtSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _assmtId;
    }

    public void setPrimaryKey(long pk) {
        setAssmtId(pk);
    }

    public long getAssmtId() {
        return _assmtId;
    }

    public void setAssmtId(long assmtId) {
        _assmtId = assmtId;
    }

    public long getVcgId() {
        return _vcgId;
    }

    public void setVcgId(long vcgId) {
        _vcgId = vcgId;
    }

    public long getNoteId() {
        return _noteId;
    }

    public void setNoteId(long noteId) {
        _noteId = noteId;
    }

    public Date getCompletionDate() {
        return _completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        _completionDate = completionDate;
    }

    public String getType() {
        return _type;
    }

    public void setType(String type) {
        _type = type;
    }

    public Date getScheduleDate() {
        return _scheduleDate;
    }

    public void setScheduleDate(Date scheduleDate) {
        _scheduleDate = scheduleDate;
    }

    public long getUserId() {
        return _userId;
    }

    public void setUserId(long userId) {
        _userId = userId;
    }

    public String getComment() {
        return _comment;
    }

    public void setComment(String comment) {
        _comment = comment;
    }

    public boolean getActive() {
        return _active;
    }

    public boolean isActive() {
        return _active;
    }

    public void setActive(boolean active) {
        _active = active;
    }

    public long getCaregiverId() {
        return _caregiverId;
    }

    public void setCaregiverId(long caregiverId) {
        _caregiverId = caregiverId;
    }
}
