package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the Assmt service. Represents a row in the &quot;CARET_ASSESSMENT&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.AssmtModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.AssmtImpl}.
 * </p>
 *
 * @author caret
 * @see Assmt
 * @see gov.va.caret.model.impl.AssmtImpl
 * @see gov.va.caret.model.impl.AssmtModelImpl
 * @generated
 */
public interface AssmtModel extends BaseModel<Assmt> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a assmt model instance should use the {@link Assmt} interface instead.
     */

    /**
     * Returns the primary key of this assmt.
     *
     * @return the primary key of this assmt
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this assmt.
     *
     * @param primaryKey the primary key of this assmt
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the assmt ID of this assmt.
     *
     * @return the assmt ID of this assmt
     */
    public long getAssmtId();

    /**
     * Sets the assmt ID of this assmt.
     *
     * @param assmtId the assmt ID of this assmt
     */
    public void setAssmtId(long assmtId);

    /**
     * Returns the vcg ID of this assmt.
     *
     * @return the vcg ID of this assmt
     */
    public long getVcgId();

    /**
     * Sets the vcg ID of this assmt.
     *
     * @param vcgId the vcg ID of this assmt
     */
    public void setVcgId(long vcgId);

    /**
     * Returns the note ID of this assmt.
     *
     * @return the note ID of this assmt
     */
    public long getNoteId();

    /**
     * Sets the note ID of this assmt.
     *
     * @param noteId the note ID of this assmt
     */
    public void setNoteId(long noteId);

    /**
     * Returns the completion date of this assmt.
     *
     * @return the completion date of this assmt
     */
    public Date getCompletionDate();

    /**
     * Sets the completion date of this assmt.
     *
     * @param completionDate the completion date of this assmt
     */
    public void setCompletionDate(Date completionDate);

    /**
     * Returns the type of this assmt.
     *
     * @return the type of this assmt
     */
    @AutoEscape
    public String getType();

    /**
     * Sets the type of this assmt.
     *
     * @param type the type of this assmt
     */
    public void setType(String type);

    /**
     * Returns the schedule date of this assmt.
     *
     * @return the schedule date of this assmt
     */
    public Date getScheduleDate();

    /**
     * Sets the schedule date of this assmt.
     *
     * @param scheduleDate the schedule date of this assmt
     */
    public void setScheduleDate(Date scheduleDate);

    /**
     * Returns the user ID of this assmt.
     *
     * @return the user ID of this assmt
     */
    public long getUserId();

    /**
     * Sets the user ID of this assmt.
     *
     * @param userId the user ID of this assmt
     */
    public void setUserId(long userId);

    /**
     * Returns the user uuid of this assmt.
     *
     * @return the user uuid of this assmt
     * @throws SystemException if a system exception occurred
     */
    public String getUserUuid() throws SystemException;

    /**
     * Sets the user uuid of this assmt.
     *
     * @param userUuid the user uuid of this assmt
     */
    public void setUserUuid(String userUuid);

    /**
     * Returns the comment of this assmt.
     *
     * @return the comment of this assmt
     */
    @AutoEscape
    public String getComment();

    /**
     * Sets the comment of this assmt.
     *
     * @param comment the comment of this assmt
     */
    public void setComment(String comment);

    /**
     * Returns the active of this assmt.
     *
     * @return the active of this assmt
     */
    public boolean getActive();

    /**
     * Returns <code>true</code> if this assmt is active.
     *
     * @return <code>true</code> if this assmt is active; <code>false</code> otherwise
     */
    public boolean isActive();

    /**
     * Sets whether this assmt is active.
     *
     * @param active the active of this assmt
     */
    public void setActive(boolean active);

    /**
     * Returns the caregiver ID of this assmt.
     *
     * @return the caregiver ID of this assmt
     */
    public long getCaregiverId();

    /**
     * Sets the caregiver ID of this assmt.
     *
     * @param caregiverId the caregiver ID of this assmt
     */
    public void setCaregiverId(long caregiverId);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.Assmt assmt);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.Assmt> toCacheModel();

    @Override
    public gov.va.caret.model.Assmt toEscapedModel();

    @Override
    public gov.va.caret.model.Assmt toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
