<%@include file="/jsp/init.jsp" %>

<c:set var="form_" value="${caretMap_['form_']}" />

<aui:a href="https://www.va.gov/vaforms/medical/pdf/vha-10-10CG.pdf" target="_blank" cssClass="icon-download-alt caret-menu-vet" style="margin-top: 7px;" label="download-1010cg" title="Download 10-10CG Form"></aui:a>


	<portlet:actionURL var="newRole">
		<portlet:param name="javax.portlet.action" value="doAction"/>
		<portlet:param name="action" value="undoSelectRole"/>
		<portlet:param name="TRACKER" value="${TRACKER}"/>
	</portlet:actionURL>
	<c:set var="reset"><liferay-ui:message key="reset-online-roles" /></c:set>
	<aui:nav cssClass="caret-nav">
       <aui:nav-item iconCssClass="icon-cancel" label='${reset}' href="${newRole}"  >
       </aui:nav-item>
    </aui:nav>
	
	
<div id="tabSrc">
	

  <ul class="nav nav-tabs">
	    <li class="active tab-click"><a href="#tab-1">Caregiver Dashboard</a></li>
    	<li class="tab-click" ><a href="#tab-2">Informational</a></li>
  </ul>

  <div class="tab-content">
	    <div id="tab-1" class="tab-pane">
	      	<div class="dashboard-top">
	      		<div class="online-split-pane">
	      			<fieldset>
				      	<legend><liferay-ui:message key="my-veterans" /></legend>
				      	<c:set var="ndx0" value="my-role" />
				      	<c:set var="ndx1" value="veteran-name" />
				      	<c:set var="emptyResultsMessage" value="no-veterans-found" />
						<%@include file="/jsp/online/myVcgStatus.jsp" %>
					</fieldset>
	      		</div>
	      		<div class="online-split-pane">
	      			<fieldset>
			      		<legend ><liferay-ui:message key="my-notes" /></legend>
		      			<%@include file="/jsp/online/myMessages.jsp" %>
	      			</fieldset>
	      		</div>
	      	</div>
	      	<div class="clear-both"></div>
	      	<div id="dashboard-bottom">
	      		
	      		<div id="bottomTabSrc">
		      		<ul class="nav nav-tabs">
					    <li class="tab-click active"><a href="#tab-apps"><liferay-ui:message key="my-apps" /></a></li>
				    	<li class="tab-click" ><a href="#tab-stip"><liferay-ui:message key="my-stipends" /></a></li>
				  	</ul>
				  	
				  	<div class="tab-content">
	    				<div id="tab-apps" class="tab-pane">
					  		<%@include file="/jsp/online/myApplications.jsp" %>
	    				</div>
				  		<div id="tab-stip" class="tab-pane">
				  			<%@include file="/jsp/online/myStipends.jsp" %>
	    				</div>
	    			</div>
			  	</div>
			</div>
	    </div>
    
    <div id="tab-2" class="tab-pane">
		<%@include file="/jsp/online/information.jsp" %>
	</div>
	
  </div>
</div>


<c:if test="${true eq form_['showConfirmation']}">
	<%@include file="/jsp/online/applicationSubmitted.jsp" %>
</c:if>

<aui:script use="aui-tabview">

  window.careTmainTab = new A.TabView({
      srcNode: '#tabSrc',
      type: 'pills'
    }
  );
  window.careTmainTab.render();
  
  window.careTmainTab = new A.TabView({
      srcNode: '#bottomTabSrc',
      type: 'pills'
    }
  );
  window.careTmainTab.render();
  A.all('.tab-click').attr('tabindex',0);
	
</aui:script>


<div id="chatVaMsg" >
	<a tabindex="0" class="tab-click btn-link search-vcg-action" onclick="window.open('https://www.ebenefits.va.gov/chat/chatstart.aspx?domain=1010cg','10-10 CG', 'width:700,height=900');" >
		Chat online &nbsp; with <i class="icon-comment">&nbsp; VA</i> representative </a>
</div>


