<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>
<%@ include file="/jsp/init.jsp" %>

<%@ taglib uri="http://liferay.com/tld/ui" prefix="liferay-ui" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ page import="gov.va.caret.model.Letter"%>
<%@ page import="java.util.List"%>
<%@page import="java.util.ArrayList"%>
<%@ page import="java.util.Map"%>
<%@ page import="java.util.HashMap"%>

<script src="<%=request.getContextPath()%>/js/jquery/jquery-latest.js" type="text/javascript"></script>
<script src="<%=request.getContextPath()%>/js/jquery/jquery.tablesorter.min.js" type="text/javascript"></script>

<style>
	.letter-title{
		color:blue;
		font-weight:bold;
		font-size:20px;
	}
	.aui p {
		margin-bottom: 20px;
		margin-left: 10px;
	}
	
	.centerHeading {
		text-align: center;
		font-weight:bold;
		font-size:15px;
	}
	
	.subHeading {
		font-weight:bold;
		font-size:15px;
	}
	
	.alertHeading {
		color: red;
		font-weight:bold;
		font-size:15px;
	}
	
	.alertText {
		color: red;
	}
	
	.sectionHeading{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.section{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	
	.summaryTable select {
		width: 300px;
	}
	.summaryTable table, th, td{
	    //border: thin solid #d9d9d9;
	    border-collapse: collapse;
	    margin: 12px;
	    padding: 5px;
	    text-align: left;
		padding-left:40px;
		
	}
	
	.aui .control-group{
		margin-bottom: 0px !important;
	}
	.summaryTable tr:hover {
		background-color: #f5f5f5;
	}
	.summaryTable th {
	    background-color: #f0efef;
	}
	.manage-layout-td text{
		/* width: 840px; */
		width: 67px;
		padding-left: 10px;
	}
	.manage-layout-td textarea{
		/* width: 840px; */
		width: 767px;
		padding-left: 10px;
	}

	.messageicon{
	margin-left:50px;font-size: 15px; font-weight:100; float:center;
	}

	.assessment-history-all{
		float:right;
		margin:10px;
	}
	.section-link{
		float:right;
		margin:10px;
	}

</style>

<c:set var="caretCss" value="${form_['required']}" />

<div id="mainTab">

<div class="tab-content">
<div class="yui3-skin-sam">
	<div id="modalEditLetterContent0"></div>
</div>

<div id="deleteDocDiv" class="yui3-skin-sam" >	
Do you want to proceed and delete the document?
</div>
<div class="yui3-skin-sam">
	<div id="deleteDocModal"></div>
</div>

<div class="supporting-docs">

<div class="content toggler-content-expanded">	

<legend class="header">Preview & Send</legend>
	<div id="letterContentTable">
	<div id="letterContent" class="letterContent" contenteditable = "true">
	</div>
	</div>
	
		<portlet:resourceURL var="loadEditLetterContent">
			<portlet:param name="action" value="loadEditLetterContent"/>
			<portlet:param name="vcgId" value="${vcgId}"/>
		</portlet:resourceURL>
		<portlet:resourceURL var="previewLetter">
			<portlet:param name="action" value="previewLetter"/>
			<portlet:param name="vcgId" value="${vcgId}"/>
		</portlet:resourceURL>
		
		<portlet:actionURL var="sendLetter">
			<portlet:param name="javax.portlet.action" value="doAction" />
			<portlet:param name="action" value="sendLetter"/>
			<portlet:param name="vcgId" value="${vcgId}"/>
		</portlet:actionURL>

	<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <th width="30%">Letter Name</th> 
			  <th width="45%">Recipients</th> 
			  <th width="25%">Action</th>			  
			</tr>
		
			<tr id="">
			    <td>
				    <aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" >
					<aui:select label="" name="selectedLetterName" id="selectedLetterName" >
						<aui:option value="" label="select-letter" selected="true" />
						<c:forEach var="letterName" items="${cscLetterNames}">
							<aui:option value="${letterName}" label="${letterName}"/>
						</c:forEach>
					</aui:select>
					</aui:field-wrapper>
			    </td>
			    
			    <td>
				    <aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" >
						<c:forEach var="recipient" items="${recipients}">
							<aui:input label="${recipient.value}" name="${recipient.key}" type="checkbox" /><br/>
						</c:forEach>
					</aui:field-wrapper>
			    </td>
				
			    <td>
					<aui:form  style="margin:0px;" action="#" name="editLetter" method="post" enctype="multipart/form-data">
					</aui:form>
					<aui:form  style="margin:0px;" action="${previewLetter}" name="previewLetterForm" method="post" enctype="multipart/form-data">
						<input type="hidden" id="previewLetterName" name="previewLetterName" value=""/>
						<input type="hidden" id="previewLetterContent" name="previewLetterContent" value=""/>
					</aui:form>
					<aui:form style="margin:0px;" action="${sendLetter}" name="sendLetterForm" method="post" enctype="multipart/form-data">
						<input type="hidden" id="sendLetterName" name="sendLetterName" value=""/>
						<input type="hidden" id="editedLetterContent" name="editedLetterContent" value=""/>
						<input type="hidden" id="veteranRecipient" name="veteranRecipient" value=""/>
						<input type="hidden" id="primaryCGRecipient" name="primaryCGRecipient" value=""/>
						<input type="hidden" id="secondaryCGRecipient" name="secondaryCGRecipient" value=""/>
						<input type="hidden" id="secondaryTwoCGRecipient" name="secondaryTwoCGRecipient" value=""/>
					</aui:form>
					<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="true" >
						<a href="javascript:previewLetter();"><i class="close-window btn btn-primary" >&nbsp; Preview </i></a>
						<a href="javascript:editLetterContent();"><i class="close-window btn btn-primary" >&nbsp; Edit </i></a>
						<a href="javascript:sendLetter();"><i class="close-window btn btn-primary" >&nbsp; Create</i></a>		
					</aui:field-wrapper>
					<input type="hidden" id="<portlet:namespace/>editLetterName" name="<portlet:namespace/>editLetterName" value=""/>
				</td>
			</tr>
		</table>
		</div>

		<div id="letterValidationDiv" class="yui3-skin-sam">
		    <div id="letterValidationResult"></div>
		</div>
		
	</div>
</div>	

<%
List<Letter> allLetters = (List<Letter>) request.getAttribute("allLetters");
Map<Long, Docum> allLetterDocums = (HashMap<Long, Docum>) request.getAttribute("allLetterDocums");
%>

<legend class="header">Previous Letters </legend>
	<portlet:resourceURL var="deleteLetter">
	<portlet:param name="action" value="deleteLetter"/>
	<portlet:param name="documId" value="${doc.documId}"/>
	</portlet:resourceURL>
	
	<aui:form style="margin:0px;" action="${deleteLetter}" name="deleteLetter" method="post" enctype="multipart/form-data">
	</aui:form>
	<div class="summaryTable">
	
	<c:choose>
	<c:when test="${not empty allLetters}">
		<table id="previousLetters" class="table-hover table-striped tablesorter" style="width:98%">
		 <thead class="table-columns">	
		 	<tr>
				<th><div class="table-sort-liner">File Name<span class="table-sort-indicator"></span></div></th> 
				<th><div class="table-sort-liner">Recipients<span class="table-sort-indicator"></span></div></th> 
				<th><div class="table-sort-liner">Created Date<span class="table-sort-indicator"></span></div></th> 
				<th></th>		  
			</tr>
		 </thead>
		 <tbody>
			<c:forEach var="letter" items="${allLetters}">	
				<tr id="row_${letter.letterId}">
					<td>${letter.name}</td>
					<td>${letter.recepients}</td>
					<td>
						<fmt:formatDate value="${letter.getSentDate()}" var="sentDate" type="date" pattern="MM/dd/yy hh:mm:ss a"/>
						${sentDate}
    	 			</td>
					<td>
					<portlet:resourceURL var="viewLetter">
					<portlet:param name="action" value="getDocum"/>
						<portlet:param name="letterId" value="${letter.letterId}"/>
						<portlet:param name="documId" value="${allLetterDocums[letter.letterId].documId}"/>
					</portlet:resourceURL>
					<a href="${viewLetter}" target="_blank" ><i class="close-window btn btn-primary" >&nbsp; View</i></a>
					
					<a href="javascript:showDeleteModal(${letter.letterId},${allLetterDocums[letter.letterId].documId});" class="btn-primary delete-document" id="${doc.documId}"><i class="close-window btn btn-primary" >&nbsp; Delete</i></a>
					</td>
				</tr>
			</c:forEach>
		  <tbody>
		</table>
	</c:when>
	<c:otherwise>
		<div class="messageicon">No letters available</div>
	</c:otherwise>
</c:choose>
</div>
	
</div>	
</div>
</div>

<script type="text/javascript">
	$(document).ready(function ($) {
		$("#previousLetters").tablesorter(); 
		 var sorting = [[2,1]]; 
	        // sort on date column
	        $("table").trigger("sorton",[sorting]); 
	});
</script>
<aui:script use="aui-base, aui-io-request,aui-parse-content,aui-modal">

 var modalEditLetterContent = new A.Modal({
		headerContent: '<h4><liferay-ui:message key="edit-letter-content" /></h4>',
	     bodyContent: A.one('#letterContentTable'),//'<div id="editContentDiv" class="editContentDiv" contenteditable = "true">'+data+'</div>',
	     centered: true,
	     destroyOnHide: false,
	     modal: true,
	     render: '#modalEditLetterContent0', 
	     resizable: {
	       handles: 'b, r'
	     },
	     visible: false,
	     width: 950
		});
 
	modalEditLetterContent.addToolbar([
	        {
	          label: 'Cancel',
	          on: {
	            click: function() {
	            	modalEditLetterContent.hide();
	            }
	          }
	        },{
	          label: 'Save Changes',
	          on: {
	            click: function() {
	        	var editedContent = A.one('#letterContent').innerHTML;
	        	modalEditLetterContent.hide();
	            }
	          }
	        }
	   ]);
	
	window.previewLetter = function() {
		var selectedLetterName = A.one("#<portlet:namespace/>selectedLetterName").val();
		var editLetterName = A.one('#<portlet:namespace/>editLetterName').val();
		if (selectedLetterName == "") {
    		A.one("#<portlet:namespace/>selectedLetterName").addClass( 'missing-required-input' );
    		var msg = "<div class='portlet-msg-alert'>Letter name is required</div>";
    		A.one ('#letterValidationResult').html(msg);

		} else {
			if (selectedLetterName != editLetterName) {
				A.io.request('<%=loadEditLetterContent %>',{
	              method: 'POST',
	              form: { id: '<portlet:namespace />editLetter' },
	              data: {
	            	  editLetterName: A.one('#<portlet:namespace/>selectedLetterName').val(),
				  },
	              on: {
	                  success: function(){
	            	  		var data = this.get('responseData');
	            	  		A.all('#letterContent').html(data);
	            	  		A.one('#<portlet:namespace/>editLetterName').val(selectedLetterName);
	        				A.all('#previewLetterContent').val(data);	
	        				A.one('#previewLetterName').val(selectedLetterName);
	        				setTimeout(function(){}, 100);
	        				A.one("#<portlet:namespace/>previewLetterForm").submit();
	                   }
	             }
				});
			} else {
				var content = A.one('#letterContent').html();
				A.all('#previewLetterContent').val(content);	
				A.one('#previewLetterName').val(selectedLetterName);
				setTimeout(function(){}, 10);
				A.one("#<portlet:namespace/>previewLetterForm").submit();
			}
			
			
		}
	}
	
	window.deleteLetter = function() {
		A.one("#<portlet:namespace/>deleteLetter").submit();
	}
	
	window.showDeleteModal = function (letterId, documId) {
		window.deleteLetterId = letterId;	 	   
		window.deleteDocumId = documId;
		console.log("document id to delete : "+ window.deleteDocumId);
		modalDeleteDocument.render();
		modalDeleteDocument.show();		
	}

	window.sendLetter = function() {
		var selectedLetterName = A.one("#<portlet:namespace/>selectedLetterName").val();
		var editLetterName = A.one('#<portlet:namespace/>editLetterName');
		if (selectedLetterName == "") {
    		A.one("#<portlet:namespace/>selectedLetterName").addClass( 'missing-required-input' );
    		var msg = "<div class='portlet-msg-alert'>Letter name is required</div>";
    		A.one ('#letterValidationResult').html(msg);

		} else {
			if (selectedLetterName != editLetterName) {
				A.io.request('<%=loadEditLetterContent %>',{
	              method: 'POST',
	              form: { id: '<portlet:namespace />editLetter' },
	              data: {
	            	  editLetterName: A.one('#<portlet:namespace/>selectedLetterName').val(),
				  },
	              on: {
	                  success: function(){
	            	  		var data = this.get('responseData');
	            	  		A.all('#letterContent').html(data);
	            	  		A.one('#<portlet:namespace/>editLetterName').val(selectedLetterName);
	        				A.all('#editedLetterContent').val(data);	
	        				A.one('#sendLetterName').val(selectedLetterName);
	        				setTimeout(function(){}, 100);
	        				A.one('#veteranRecipient').val( A.one("#<portlet:namespace/>veteran").val());	
	        				A.one('#primaryCGRecipient').val( A.one("#<portlet:namespace/>primary").val());	
	        				if (A.one("#<portlet:namespace/>secondary") != null) {
	        					A.one('#secondaryCGRecipient').val(A.one("#<portlet:namespace/>secondary").val());	
	        				}
	        				if (A.one("#<portlet:namespace/>secondaryTwo") != null) {
	        	    			A.one('#secondaryTwoCGRecipient').val( A.one("#<portlet:namespace/>secondaryTwo").val());	
	        				}
	        				
	        				A.one("#<portlet:namespace/>sendLetterForm").submit();
	                   }
	             }
				});
			} else {
				var content = document.getElementById("letterContent").innerHTML;
				A.all('#editedLetterContent').val(content);	
				A.one('#sendLetterName').val(selectedLetterName);	

				A.one('#veteranRecipient').val( A.one("#<portlet:namespace/>veteran").val());	
				A.one('#primaryCGRecipient').val( A.one("#<portlet:namespace/>primary").val());	
				if (A.one("#<portlet:namespace/>secondary") != null) {
					A.one('#secondaryCGRecipient').val(A.one("#<portlet:namespace/>secondary").val());	
				}
				if (A.one("#<portlet:namespace/>secondaryTwo") != null) {
	    			A.one('#secondaryTwoCGRecipient').val( A.one("#<portlet:namespace/>secondaryTwo").val());	
				}
				A.one("#<portlet:namespace/>sendLetterForm").submit();
			}
	  		
		 }
	}
		
	
	window.editLetterContent = function() {
				var selectedLetterName = A.one("#<portlet:namespace/>selectedLetterName").val();
				if (selectedLetterName == "") {
		    		A.one("#<portlet:namespace/>selectedLetterName").addClass( 'missing-required-input' );
		    		var msg = "<div class='portlet-msg-alert'>Letter name is required</div>";
		    		A.one ('#letterValidationResult').html(msg);

				} else {
				A.io.request('<%=loadEditLetterContent %>',{
	              method: 'POST',
	              form: { id: '<portlet:namespace />editLetter' },
	              data: {
	            	  editLetterName: selectedLetterName,
				  },
	              on: {
	                  success: function() {
	            	  		var data = this.get('responseData');
	            	  		A.one('#<portlet:namespace/>editLetterName').val(selectedLetterName);
	            	  		A.one('#letterContent').html(data);
	            	  		modalEditLetterContent.render();
	            			modalEditLetterContent.show();
	                   }
	             }
				});
				}
	}
	
	var deleteLetterId = '';
	var deleteDocumId = '';
	window.modalDeleteDocument = new A.Modal({
	    headerContent: '<h4><liferay-ui:message key="delete-document" /> </h4>',
	    bodyContent: A.one("#deleteDocDiv"),
	    centered: true,
	    destroyOnHide: false,
	    modal: true,
	    render: '#deleteDocModal',
	    resizable: {
	      handles: 'b, r'
	    },
	    visible: false,
	    width: 800
	});
	 
	 modalDeleteDocument.addToolbar([
	   {
         label: 'Cancel',
         on: {
	            click: function() {
	            	window.letterDocId = '';
	            	modalDeleteDocument.hide();
              	}
          }
	   },
	   {
          label: 'Delete',
          id: 'modalDelete',
          on: {
              click: function() {
            	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="deleteLetter"/></portlet:resourceURL>', 'json', 
				{ 
			   		letterId: window.deleteLetterId,
			   		documId: window.deleteDocumId,
			   	  	deleteComment: "letters document deleted"
			 	},
				function( data )
				{
					document.getElementById('row_'+window.deleteLetterId).style.display = 'none';
					window.deleteLetterId = '';
					window.deleteDocumId = '';
					modalDeleteDocument.hide();
				} );
              }
          }
       }
	 ]);    
	
   </aui:script>