<%@ include file="/jsp/init.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<c:set var="queueName" value="${SEARCH_CONTAINER_RESULT_ROW.object['queueName']}" />
<c:set var="type" value="${SEARCH_CONTAINER_RESULT_ROW.object['type']}" />
<c:set var="worImId" value="${SEARCH_CONTAINER_RESULT_ROW.object['worImId']}" />
<c:set var="ownerId" value="${SEARCH_CONTAINER_RESULT_ROW.object['userId'] eq 0 }" />
<c:set var="mine" value="${SEARCH_CONTAINER_RESULT_ROW.object['userId'] eq user.userId}" />
<c:set var="complete" value="${SEARCH_CONTAINER_RESULT_ROW.object['complete'] }" />
<c:set var="workItem" value="${SEARCH_CONTAINER_RESULT_ROW.object['this'] }" />
<c:set var="context" value="${caretMap_['context'] }" />

<liferay-ui:icon-menu>
	<liferay-ui:icon image="time" message="work-audit" url="javascript:auditLog(${worImId});" />
<c:if test="${!complete && workItem.canAssign(resourceRequest) }" >
<c:if test="${!mine}" >
  <portlet:actionURL var="takeOwnership">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="takeOwnership"/>
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="type" value="${type}"/>
	<portlet:param name="context" value="${context}"/>
  </portlet:actionURL>
	<liferay-ui:icon image="edit" message="take-ownership" url="javascript: window.escapePrevent(); window.location.assign('${takeOwnership}');"  />
</c:if>
	<liferay-ui:icon image="assign" message="assign-ownership" url="javascript:assignTo(${worImId},'${context}');" />
<c:if test="${!ownerId}" >
  <portlet:actionURL var="unassignTo">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="unassignTo"/>
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="context" value="${caretMap_['context']}"/>
  </portlet:actionURL>
	<liferay-ui:icon image="unassign_user" message="unassign-ownership" url="javascript: window.escapePrevent(); window.location.assign('${unassignTo}','${context}');" />
</c:if>
</c:if>
	<c:if test="${workItem.canReview(resourceRequest,permissionChecker,scopeGroupId)}" >
		<liferay-ui:icon image="reply" message="review-work"  url="javascript:manageOccWork(${worImId}, \"${type}\", \"${SEARCH_CONTAINER_RESULT_ROW.object['personName']}\", \"${SEARCH_CONTAINER_RESULT_ROW.object['caregiverName']}\", \"${context}\");"  />
	</c:if>
	<c:if test="${workItem.canReviewDelay(resourceRequest,permissionChecker,scopeGroupId)}">
		<liferay-ui:icon image="manage_task" message="review-app-delay" url="javascript:reviewAppDelay(${worImId},'${context}');" />
	</c:if>
	<c:if test="${workItem.canTransfer(permissionChecker,scopeGroupId)}" >
		<liferay-ui:icon image="post" message="transfer-to-facility" url="javascript:transfer(${worImId},'${context}');"  />
	</c:if>
	<c:if test="${workItem.canCscCorrect(permissionChecker,scopeGroupId)}" >
		<liferay-ui:icon image="checked" message="corrective-action-completed" url="javascript:markCorrected(${worImId},'${context}');" />
	</c:if>
	<c:if test="${SEARCH_CONTAINER_RESULT_ROW.object['vcgId'] gt 0 && 'manageVcg' ne caretMap_['context'] }" >
		<portlet:actionURL var="loadVcgManagement">
			<portlet:param name="javax.portlet.action" value="doAction" />
			<portlet:param name="action" value="loadEntry"/>
			<portlet:param name="entry" value="MANAGE_VCG"/>
			<portlet:param name="vcgId" value="${SEARCH_CONTAINER_RESULT_ROW.object['vcgId']}"/>
		</portlet:actionURL>
		<liferay-ui:icon image="group" message="manage-vcg" url="${loadVcgManagement}"  />
	</c:if>
	<c:if test="${SEARCH_CONTAINER_RESULT_ROW.object['docLoaded']}" >
		<portlet:resourceURL var="getDocum">
			<portlet:param name="action" value="getDocum"/>
			<portlet:param name="classPk" value="${SEARCH_CONTAINER_RESULT_ROW.object['classPk']}"/>
		</portlet:resourceURL>
		<liferay-ui:icon image="page" useDialog="false" target="_blank"  message="view-document" url="${getDocum}" />
	</c:if>

	<liferay-ui:icon image="add" message="new-note" url="javascript:newWorkNote(${worImId},'${context}' );" />

</liferay-ui:icon-menu>





