<%@ include file="/jsp/init.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<c:set var="type" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx2']}" />
<c:set var="isReferral" value="${fn:contains(type, 'REFERRAL')}" />

<c:set var="worImId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx1']}" />
<c:set var="primaryKey" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx10']}" />
<c:set var="vcgId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx11']}" />
<c:set var="documId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx12']}" />

<portlet:actionURL var="editEntry">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="takeOwnership"/>
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="type" value="${type}"/>
</portlet:actionURL>
<c:set var="isDelayReviewed" value="${fn:contains(type, 'DELAY_REVIEWED')}" />



<liferay-ui:icon-menu>
	<liferay-ui:icon image="edit" message="take-ownership" url="${editEntry}" />
	<liferay-ui:icon image="assign" message="assign-ownership" url="javascript:assignTo(${worImId});" />
	<liferay-ui:icon image="post" message="transfer-to-facility" url="javascript:transfer(${worImId});"  />
	<liferay-ui:icon image="time" message="work-audit" url="javascript:auditLog(${worImId});" />
	<c:if test="${documId gt 0}" >
		<portlet:resourceURL var="getDocum">
			<portlet:param name="action" value="getDocum"/>
			<portlet:param name="documId" value="${documId}"/>
		</portlet:resourceURL>
		<liferay-ui:icon image="page" useDialog="false" target="_blank"  message="view-document" url="${getDocum}" />
	</c:if>
	<c:choose>
		<c:when test="${isReferral}">
			<portlet:actionURL var="openReferral">
				<portlet:param name="javax.portlet.action" value="doAction" />
				<portlet:param name="action" value="openReferral" />
				<portlet:param name="worImId" value="${worImId}"/>
				<portlet:param name="callId" value="${primaryKey}"/>
				<portlet:param name="type" value="${type}"/>
			</portlet:actionURL>
			<liferay-ui:icon image="preview" message="view-referral" url="${openReferral}" />
		</c:when>
		<c:when test="${fn:endsWith(type, '_APP')}">
				<liferay-ui:icon image="add" message="application-note" url="javascript:newWorkNote(${worImId},'', '${vcgId}' );" />
		</c:when>
	</c:choose>
	<c:if test="${isDelayReviewed}" >
		<liferay-ui:icon image="checked" message="mark-closed-completed" url="javascript:markClosed(${worImId});" />
	</c:if>	
	
</liferay-ui:icon-menu>