<%@ include file="/jsp/init.jsp" %>


<c:set var="vcgId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx11']}" />
<c:set var="type" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx2']}" />
<c:set var="worImId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx1']}" />
<c:set var="caregiver" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx9']}, ${SEARCH_CONTAINER_RESULT_ROW.object['ndx8']}" />
<c:set var="veteran" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx7']}, ${SEARCH_CONTAINER_RESULT_ROW.object['ndx6']}" />
<c:set var="ownerId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx13'] eq null || empty SEARCH_CONTAINER_RESULT_ROW.object['ndx13'] }" />
<c:set var="mine" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx13'] eq user.screenName}" />

<liferay-ui:icon-menu>
		<portlet:actionURL var="loadVcgManagement">
			<portlet:param name="javax.portlet.action" value="doAction" />
			<portlet:param name="action" value="loadEntry"/>
			<portlet:param name="entry" value="MANAGE_VCG"/>
			<portlet:param name="vcgId" value="${vcgId}"/>
		</portlet:actionURL>
		<liferay-ui:icon image="group" message="manage-vcg" url="${loadVcgManagement}" />
		<liferay-ui:icon image="time" message="work-audit" url="javascript:auditLog(${worImId});" />
	
	
<portlet:actionURL var="editEntry">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="takeOwnership"/>
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="type" value="${type}"/>
</portlet:actionURL>
		<liferay-ui:icon image="edit" message="take-ownership" url="${editEntry}" />
		
<liferay-ui:icon image="reply" message="new-note"  url="javascript:newWorkNote(${worImId});"  />
<liferay-ui:icon image="reply" message="review-work"  url="javascript:manageOccWork(${worImId}, '${type}', '${veteran}', '${caregiver}');"  />
<c:if test="${!mine}" >
  <portlet:actionURL var="takeOwnership">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="takeOwnership"/>
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="type" value="${type}"/>
  </portlet:actionURL>
	<liferay-ui:icon image="edit" message="take-ownership" url="${takeOwnership}" />
</c:if>
	<liferay-ui:icon image="assign" message="assign-ownership" url="javascript:assignTo(${worImId});" />
<c:if test="${!ownerId}" >
  <portlet:actionURL var="unassignTo">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="unassignTo"/>
	<portlet:param name="worImId" value="${worImId}"/>
  </portlet:actionURL>
	<liferay-ui:icon image="unassign_user" message="unassign-ownership" url="${unassignTo}" />
</c:if>
	
</liferay-ui:icon-menu>

<aui:script use="aui-io-request,aui-parse-content,aui-modal">
	
	window.manageOccWork = function( worImId, type, veteran, caregiver ) {
				    	modalOccWork.render();
							        	modalOccWork.show();
							        	window.enforceFormats();
				    };
	
	var modalOccWork = new A.Modal({
				headerContent: A.one("#work_header"),
		        bodyContent: A.one("#review_work_entry"),
		        destroyOnHide: false,
		        modal: true,
		        render: '#modalUpdateVcg',
		        visible: false,
				xy: [225, document.body.parentElement.scrollTop+25],
		        zIndex: 1100,
		        width: 920
		    });
					    
		    modalOccWork.addToolbar([
			                         {
			                           label: 'Cancel',
			                           on: {
			                             click: function() {
			                            	 modalOccWork.hide();
			                             }
			                           }
			                         },{
			                           label: 'Update',
			                           id:'modalOccWorkSubmitId',
			                           on: {
			                             click: function() {
                            		    	validateFields( function ( message ) {
                            		    		var validationNotice = A.one ('#_validationResult');
                           			    		if ( message.length > 0 ){
                           		    				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
                           		    				validationNotice.html(msg);
                           		    				modalOccWork.footerNode.insert(validationNotice);
                           				    		return false;	
                           			    		}
				                            	A.one("#<portlet:namespace/>reviewMyWork_fm").submit();
                            		    	}, '#review_work_entry' );

			                             }
			                           }
			                         }
			                    ]);
	var validateFields = function ( anotherCallback, parentNode ){
		  
		  var count = 0;
		  parentNode = parentNode || '';
		  var inputNodes = A.all( parentNode + ' .required-input input, ' 
				  				+ parentNode + ' .required-input radio, ' 
				  				+ parentNode + ' .required-input textarea, ' 
				  				+ parentNode + ' .required-input select');
		  var fields = "";
		  for ( var i = 0; i < inputNodes.size() ; i++ ){
			  var node = A.one(inputNodes._nodes[i]);
			  if (node == undefined  || node.attr('disabled') == true ) continue;
				if ( 'select-one' == node.attr('type') ){
	    			if ( node.val() == "" || node.val() == "0" ){
	    				 node.addClass( 'missing-required-input' );
	    				 fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
	    				 count++;
	    			} else {
	    				if ( node.hasClass('missing-required-input') ){
	    					node.removeClass( 'missing-required-input' );
	    				}
	    			}
	    		} 
				if ( 'text' == node.attr('type') || 'textarea' == node.attr('type') ){
					if ( node.val() == ""   
						|| ( node.hasClass('date-field') && node.val() == 'MM/DD/YYYY' )
						|| ( node.hasClass('ssn-field') && node.val() == '###-##-####' )
						|| ( node.hasClass('email-field') && node.val() == '[USERNAME]@[DOMAIN]' )
						|| ( node.hasClass('phone-field') && node.val() == '(###) ###-####' ) ){
	   					node.addClass( 'missing-required-input' );
	   					fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
	   					count++;
		   			} else {
		   				if ( node.hasClass('missing-required-input') ){
		   					node.removeClass( 'missing-required-input' );
		   				}
					}
		    	}  
	    		if ( 'radio' == node.attr('type') ){
	    			var radios = document.getElementsByName( node.attr('name') );
	    		    var checked = false;
	    		    var i;
	    		    var labels = '';
	    		    for (i = 0; i < radios.length; i++) {
	    		        if ( radios[i].checked ) {
	    		            checked = true;
	    		        }
	    		        labels = labels + radios[i].nextSibling.data.trim() + '/' ;
	    		    }
	    		    if ( !checked ){
	    		    	fields = fields + "<li>" + labels.substring(0,labels.length-1) +" selection required</li>";
	   					count++;
	    		    }
	    		}
		    }
		  anotherCallback( fields );
	  }
</aui:script>

		<portlet:actionURL var="reviewMyWork">
			<portlet:param name="javax.portlet.action" value="doAction"/>
			<portlet:param name="action" value="reviewMyWork"/>
		</portlet:actionURL>
	<aui:form name="reviewMyWork_fm" method="post"  action="${reviewMyWork}"  >
				
    	<div id="modalUpdateVcg">
    	</div>
    </aui:form>
	<div id="review_work_entry">
	</div>
	<div id="work_header" >
	</div>
	
<div class="hidden-element">
<div id="_validationResult" ></div>

</div>

