
<%@ include file="/jsp/init.jsp" %>	

<c:set var="form_" value="${caretMap_['form_']}" />

<c:set var="calcInfo" value="${workItem.calcInfo}" /> 

<div id="workTab">
  <ul class="nav nav-tabs">
    <li class="tab-click" ><a href="#tab-11"><div class="icon-bullhorn"></div> Summary </a></li>
    <li class="tab-click" ><a href="#tab-12"><div class="icon-user"></div> Additional Information </a></li>
	<li class="tab-click" ><a href="#tab-13"><div class="icon-credit"></div>
    <c:choose>
    	<c:when test="${calcInfo.calculationWork}" >Auto Calculation</c:when>
    	<c:otherwise>Information Change</c:otherwise>
    </c:choose>
	 </a></li>
    <li class="tab-click" ><a href="#tab-14"><div class="icon-edit"></div><liferay-ui:message key="review-work-notes" /></a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-11" class="tab-pane">
		
		
		<div id="reviewOccWork2">
			<input type="hidden" value="${form_['statusDate']}" id="statusDate" />
			<input type="hidden" value="${form_['maxDate']}" id="maxDate" />
		
			<div class='portlet-msg-info' style="width:80%"]>(TBD) Top things to Highlight here...
				<div class="ten-ten-links" >
					<portlet:resourceURL var="getDocum">
						<portlet:param name="action" value="getDocum"/>
						<portlet:param name="classPk" value="${workItem.classPk}"/>
					</portlet:resourceURL>
			  		<a href="${getDocum}" tabindex="0"  target="_blank" class="tab-click btn icon-file stipend-row float-right" title='<liferay-ui:message key="pdf-10-10cg" />' >&nbsp;<liferay-ui:message key="pdf-10-10cg-review-message" /></a>
		  		</div>
		  	
		  
		  <ul>
			<fmt:formatDate value="${workItem.vcgSupport.primaryVcgAn.receivedDate}" var="appReceivedDate" type="date" pattern="MM/dd/yyyy"/>
			<fmt:formatDate value="${workItem.vcgSupport.primaryRevocationDate}" var="revocationDate" type="date" pattern="MM/dd/yyyy"/>
			<fmt:formatDate value="${workItem.vcgSupport.primaryDispositionDate}" var="dispositionDate" type="date" pattern="MM/dd/yyyy"/>
			
			<li> Application Received Date: ${appReceivedDate}</li>
			
					<c:if test="${workItem.vendor.vendrId eq 0}">
						<span class="icon-bell" title="<liferay-ui:message key='usps-validated'/>" >&nbsp;</span>New Vendor Record &nbsp;
					</c:if>
					<li><liferay-ui:message key='cg-vendor' /> Name: ${workItem.caregiver.lastName}, ${workItem.caregiver.firstName} ${workItem.caregiver.middleName} &nbsp;</li>
					<li>SSN: ${workItem.caregiver.ssn} </li>
					<li><liferay-ui:message key='cg-vendor' /> Address:${workItem.caregiver.address}
					  <div style="margin-left:100px;" >
						<c:choose>
							<c:when test="${workItem.caregiver.validUspsAddress}">
								<span class="icon-ok" title="<liferay-ui:message key='usps-validated'/>" >&nbsp;</span>
							</c:when>
							<c:otherwise>
								<span class="icon-flag" title="<liferay-ui:message key='non-usps-validated'/>" >&nbsp;</span>
							</c:otherwise>
						</c:choose>
							${workItem.caregiver.city}, ${workItem.caregiver.state} ${workItem.caregiver.zip}
					  </div>
					 </li>
				</ul>
			</div><!-- end Top things to Highlight here... -->
			

		
		<div id="reviewMyWork">
			
				<input type="hidden" name="<portlet:namespace/>worImId" id="<portlet:namespace/>worImId16" value="${workItem.worImId}">
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="required-input">
					<aui:select label="app-review-status" name="worIm_status" id="worIm_status" cssClass="srch-caret search-category"  >
							<aui:option value="0" label="please-select-review-condition" />
						<c:forEach var="reviewAction" items="${workItem.reviewActions}">
							<aui:option value="${reviewAction}" label="${reviewAction}" />
						</c:forEach>
					</aui:select>
				</aui:field-wrapper>
				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="required-input">
					<aui:select label="correction-type" name="worIm_correction" id="worIm_correction" cssClass="srch-caret search-category"  >
						<c:forEach var="correctionType" items="${caretMap_['correctionTypes']}">
							<aui:option value="${correctionType}" label="${correctionType}"  />
						</c:forEach>
					</aui:select>
				</aui:field-wrapper>
					
				<div id="validationResult" ></div>
				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-vcg-medium-input"  >
					<aui:input label="comments" name="worIm_comments" size="50" type="textarea"  />
				</aui:field-wrapper>
				
				<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" >
					<a class="btn btn-primary" style="float:right; margin-left:30px" href="javascript:submitReview();" >&nbsp;<liferay-ui:message key="submit-review" /></a>      			
				</aui:field-wrapper>
			</div>
		</div><!-- end reviewOccWork2 -->
    </div> <!-- end tab-11 -->

    <div id="tab-12" class="tab-pane">
    	<%@include file="/jsp/internal/appInfo.jsp" %>
	</div>
	
	
	<div id="tab-13" class="tab-pane">
	  <c:choose>
    	<c:when test="${calcInfo.calculationWork}" >
    		<%@include file="/jsp/internal/autoCalc.jsp" %>
		</c:when>
    	<c:otherwise>
    		<%@include file="/jsp/internal/autoVcgChange.jsp" %>
    	</c:otherwise>
      </c:choose>
	</div>
	
	<div id="tab-14" class="tab-pane">
	  <div class="content" id="workNotes" >
		<div class="portlet-msg-info">
			<liferay-ui:message key="no-work-notes-found" />
		</div>
	  </div>
    	<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="manage-layout-medium-input ${cssClass}" >
 			<aui:input label="new-occ-work-note" name="addNode_comments2" id="addNode_comments2" size="50" type="textarea"  />
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" >
			<a class="btn btn-primary" style="float:right;" href="javascript:loadWorkNotes();" >&nbsp;<liferay-ui:message key="Submit Note" /></a>      			
		</aui:field-wrapper>
    	
	</div><!-- end tab-14 -->
	
  </div><!-- end tab-context -->
</div><!-- workTab -->

	
<aui:script use="aui-tabview">

	window.loadWorkNotes = function (  ) {
		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadWorkNotes" /><portlet:param name="page" value="workNotes" /><portlet:param name="classPk" value="${workItem.worImId}" /><portlet:param name="fromParameter" value="true" /></portlet:resourceURL>', 'html', 
			{ note: A.one('#<portlet:namespace/>addNode_comments2').val() },
			function( data ){ 
				overwrite( A.one( "#workNotes" ), data );
				A.one('#<portlet:namespace/>addNode_comments2').val("");
			} 
		);
	}
	
	A.on('domready', loadWorkNotes );

  window.careTworkTab = new A.TabView({
      srcNode: '#workTab',
      type: 'pills',
      on: {
	            click: function() {
	            	//console.log('changed...' + this._getAttr('selection').get('index') );
	            	//console.log ( A.one('#modalOccWorkSubmitId') );
	            	//if ( this._getAttr('selection').get('index') == 0 ){
	            		//button says save Review
	            		//A.one('#modalOccWorkSubmitId').attr('childNodes').get(0)[0].attr('nodeValue', 'Submit Review');
	            	//} else if ( this._getAttr('selection').get('index') == 3 ){
	            		//button says save Note
	            		//A.one('#modalOccWorkSubmitId').attr('childNodes').get(0)[0].attr('nodeValue', 'Add Note');
	            	//} else {
	            		//A.one('#modalOccWorkSubmitId').attr('disabled', true);
	            	//}
	            	//console.log(A.one('#modalOccWorkSubmitId').attr('parentNode'));
              	}
          }
    }
  ).render();

	window.submitReview = function (){
		if ( A.one('#<portlet:namespace/>worIm_status').val() == "0" ) {
			var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' />&nbsp;<liferay-ui:message key='app-review-status' /></div>";
			A.one('#<portlet:namespace/>worIm_status').addClass( 'missing-required-input' );
			A.one("#validationResult").html(msg);
			return;
		}
		try{
			window.removeEventListener('beforeunload',preventUser);
		} catch(e){}
		overwrite( A.one( "#reviewMyWorkNode" ), A.one("#reviewMyWork") );
		A.one("#<portlet:namespace/>reviewMyWork_fm").submit();
	}
	
	var requireField = function( field ){
		if (field) {
			if ( !field.hasClass('required-input') ){
             	field.addClass( 'required-input' );
             }
	        field.show();
    	    field.attr('disabled', '');
        }
	}
	
	var unrequireField = function( field ){
		if (field ) {
			if ( field.hasClass('required-input') ){
             	field.removeClass( 'required-input' );
             }
	        field.hide();
    	    field.attr('disabled', 'true');
        }
	}
	try {
		unrequireField( A.one('#<portlet:namespace/>worIm_correction').ancestor('.field-wrapper') );
	} catch(e){
		console.log( 'cannot unrequire worIm_correction' );
	}
	
	A.one('#<portlet:namespace/>worIm_status').on('change',
  		function(e) {
  			var selection = A.one('#<portlet:namespace/>worIm_status').val();
  			var correctionType = A.one('#<portlet:namespace/>worIm_correction').ancestor('.field-wrapper');
  			if ( selection.indexOf('CORRECTION_REQUEST') > 0 ){
  				requireField( correctionType );
  			} else {
  				unrequireField( correctionType );
  			}
    	}
	);
	
</aui:script>

		