<%@ include file="/jsp/init.jsp" %>




<legend class="header">New VCG Record</legend>

<portlet:actionURL var="saveEntry">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="saveEntry"/>
	<portlet:param name="entry" value="vcg"/>
</portlet:actionURL>



<form name="saveEntry" method="post" action="${saveEntry}" >
	<input type="hidden" name="TRACKER" value="${TRACKER}" >
	<c:set var="form_" value="${caretMap_['form_']}" />
	<c:set var="workItem" value="${form_['workItem']}" />
	<input type="hidden" name="associate" value="${workItem.worImId}" >
	<c:set var="worImId" value="${workItem.worImId}" />
	<c:set var="cssClass" value="${form_['required']}" />
	
	
	<div id="veteranTab">
	   	<ul class="nav nav-tabs">
		    <li><a href="#tab-4-1">Veteran</a></li>
		</ul>	
	
		<div class="tab-content">
			<div id="tab-4-1" class="tab-pane">				
				<c:set var="title" value="Veteran" />
				
				<div class='portlet-msg-info' id="verifiedPii" style="width:334px; float:left; margin-right: 53px;" >
					<liferay-ui:message key='baselines-for-verified-record' /> <span class="icon-star" title="baselines-for-verified-record-tooltip" >&nbsp;</span> <ul>
					<li class="pii-info-li" id="<portlet:namespace/>piiInfo1" ></li>
					<li class="pii-info-li" id="<portlet:namespace/>piiInfo2" ></li>
					<li class="pii-info-li" id="<portlet:namespace/>piiInfo3" ></li>
					<li class="pii-info-li" id="<portlet:namespace/>piiInfo4" ></li>
					<li class="pii-info-li" id="<portlet:namespace/>piiInfo5" ></li>
					<li class="pii-info-li" id="<portlet:namespace/>piiInfo6" ></li>

					<input type="hidden" id="<portlet:namespace/>icn" value="" />
					
					<c:if test="${! empty workItem}" >
						<li class="associate" >Associate ${workItem.type} for ${workItem.personName} </li>
					</c:if>
				</ul></div>
	
	
				<div class='portlet-msg-alert' id="unverifiedPii" style="width:334px; float:left; margin-right:53px;" >
					<liferay-ui:message key='baselines-for-unverified-record' /> <span class="search-person-action icon-search" title="baselines-for-unverified-record-tooltip" >&nbsp;</span>
				</div>
				
		    	<%@include file="/jsp/internal/cscVcgInfo.jsp" %>
		    </div>
		    
	
		</div>
	</div>

	
	<div class="clear-both">
		
		<a class="btn btn-primary" id="submitVcg" >
			<liferay-ui:message key="Save" />
		</a>
		
		<a href="<portlet:actionURL/>" class="btn btn-primary btn-cancel" >
			<liferay-ui:message key="cancel" />
		</a>
	</div>

</form>


<div class="yui3-skin-sam">
	<div id="modalEligibility">
	</div>
</div>
<div id="eligibility_entry">
<a style="display:none;" class="eligibility-frommodal btn-primary" title='<liferay-ui:message key="load-eligibility-tooltip" />'  >&nbsp;Retrieve E&E</a>
</div>


<aui:script use="aui-tabview,aui-modal">

		window.preventUser = function() {
			return "<liferay-ui:message key='back-button-lose-form-data' />";
		}
		window.addEventListener('beforeunload', preventUser);
		
		A.all('.btn-cancel, #breadcrumbs a, .collapse.nav-collapse a').on('click', function ( event ) {
		  	window.removeEventListener('beforeunload',preventUser);
		});
	

	var veteranTab = new A.TabView({
	    srcNode: '#veteranTab',
	    type: 'pills'
	  }
	);
	veteranTab.render();
	
	new A.TooltipDelegate( { trigger: '.search-person-action' } );
    
	A.one('#submitVcg').on('click', function(event){
		if ( validateFields() ){
			window.removeEventListener('beforeunload',preventUser);
			document.forms['saveEntry'].submit();
		}
	});
	
</aui:script>



<input type="hidden" id="<portlet:namespace/>prefix" value="veteranPerson_" />

<div class="yui3-skin-sam">
    <div id="modalSelectCg"></div>
</div>

 <div id="search_persn">
 	<c:set var="ssnType" value="text" />
 	<c:set var="ndx" value="searchPersn" />
 	
 	<c:set var="person" value="${form_['lastName']}" />
	<c:set var="cssClass" value="can-clear" />
	<c:set var="searchCss" value="" />
 	
 	<c:set var="caretCss" value="${null}" />
 	
	<%@include file="/jsp/internal/person.jsp" %>
	
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
		<aui:input label="address" name="${ndx}_address" id="${ndx}_address" type="text" size="25"  />
	</aui:field-wrapper>
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
		<aui:input label="zip" name="${ndx}_zip" id="${ndx}_zip" type="text" size="25"  />
	</aui:field-wrapper>
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
		<aui:input label="city" name="${ndx}_city" id="${ndx}_city" type="text" size="25"  />
	</aui:field-wrapper>
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
		<aui:input label="email" name="${ndx}_email" cssClass="email-field" id="${ndx}_email" type="text" size="25"  />
	</aui:field-wrapper>
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
		<aui:input label="phone" name="${ndx}_phone" cssClass="phone-field" id="${ndx}_phone" type="text" size="25"  />
	</aui:field-wrapper>
	<!--
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
		<aui:input label="phone2" name="${ndx}_phone2" cssClass="phone-field" id="${ndx}_phone2" type="text" size="25"  />
	</aui:field-wrapper>	
	-->
   	<br class="clear-both" />
   	<div class="submit-person-search">
		<button id="closeSearch" class="btn btn-primary" type="button" ><liferay-ui:message key="cancel" /></button>		
		<button id="searchPerson" class="btn btn-primary" type="button" ><liferay-ui:message key="search-person" /></button>
	</div>
	
	<input type="hidden" id="<portlet:namespace/>placeHolder" />
   	<div id="myAlert" class="portlet-msg-alert hidden-msg" ><liferay-ui:message key="no-persons-found" /></div>
   	<div id="myError" class="portlet-msg-error hidden-msg" ><liferay-ui:message key="service-error" /></div>
   	<div id="<portlet:namespace/>personResults" class="person-results" ></div>
   	
</div>

<c:choose>
	<c:when test="${! empty workItem}" >
		<c:set var="searchPersonHeader" >Associate ${workItem.type} to VCG for ${workItem.personName}</c:set>
	</c:when>
	<c:otherwise>
		<c:set var="searchPersonHeader" >search-person-header</c:set>
	</c:otherwise>
</c:choose>


<aui:script use="aui-modal,node-event-simulate">



var modal = new A.Modal({
		headerContent: '<h4><liferay-ui:message key="${searchPersonHeader}" /></h4>',
        bodyContent: A.one("#search_persn"),
        centered: true,
        destroyOnHide: false,
        modal: true,
        render: '#modalSelectCg',
        resizable: {
          handles: 'b, r'
        },
        visible: false,
        width: 1000
    });
    

	A.one('#closeSearch').on('click', function(event){
		modal.hide();
	});

     <portlet:actionURL var="loadVcgManagement">
		<portlet:param name="javax.portlet.action" value="doAction" />
		<portlet:param name="action" value="loadEntry"/>
		<portlet:param name="entry" value="MANAGE_VCG"/>
		<portlet:param name="vcgId" value="${vcgId}"/>
	</portlet:actionURL>
    
    <c:if test="${! empty person}">
    A.on('domready', function( event ) {
   	try {
   		modal.render();
	    modal.show();
   		A.one('#searchPerson').simulate('click');
   	} catch (e){}
   });
    </c:if>
    
	A.one('#searchPerson').on('click',
		 function( event ) {
				A.one ( '#<portlet:namespace/>personResults' ).html('');
				if ( !A.one("#myAlert").hasClass('hidden-msg') ){
					A.one("#myAlert").addClass('hidden-msg');
				}
				if ( !A.one("#myError").hasClass('hidden-msg') ){
					A.one("#myError").addClass('hidden-msg');
				}
				
				window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="searchVcg" /></portlet:resourceURL>', 'json',
					  {
					  includeMulti : 'true',
					  withIndx: '${ndx}' ,
					  lastName: A.one('#<portlet:namespace/>${ndx}_lastName' ).val(),
					  firstName: A.one('#<portlet:namespace/>${ndx}_firstName' ).val(),
					  middleName: A.one('#<portlet:namespace/>${ndx}_middleName' ).val(),
					  ssn:   A.one('#<portlet:namespace/>${ndx}_ssn').val(),
					  phone: A.one('#<portlet:namespace/>${ndx}_phone' ).val(),
					 // phone2: A.one('#<portlet:namespace/>${ndx}_phone2' ).val(),
					  address: A.one('#<portlet:namespace/>${ndx}_address' ).val(),
					  zip: A.one('#<portlet:namespace/>${ndx}_zip' ).val(),
					  city: A.one('#<portlet:namespace/>${ndx}_city' ).val(),
					  email: A.one('#<portlet:namespace/>${ndx}_email' ).val(),
					  birthDate: A.one('#<portlet:namespace/>${ndx}_birthDate' ).val(),
					  gender: A.one('#<portlet:namespace/>${ndx}_gender' ).val(),
					  searchType : 'ACTIVE_VCG'
				  }, function( data ) {
					  if ( data.size > 0 ){
						  var tooltip = '<liferay-ui:message key="delete-caregiver-selection" />';
						  var insertHtml = '<hr/>';
						  var end = "' ><i class='cg-entry' >";
						  var anode = A.one ( '#<portlet:namespace/>personResults' );
						  for ( var i = 0; i < data.vcgs.length; i++ ){
							  var person = data.vcgs[i];
							  var stringify = JSON.stringify(person);
						       insertHtml = insertHtml + "<div class='veteran-name tab-click' tabindex='0' " +
						       (person.linked ? "" : " onclick='selectPerson(this);' ") + 
						       "json='" + stringify + end + 
						       (person.linked ? ('<a href="${loadVcgManagement}&associate=${worImId}&vcgId=' + person.vcgId + '" class="icon-group href-css" ></a>  <a class="href-css"  href="${loadVcgManagement}&associate=${worImId}&vcgId=' + person.vcgId + '">') :'' ) +
						       person.fullName + '&nbsp;</i>&nbsp;<i class="cg-entry" >';
						       insertHtml = insertHtml + 
						       (person.ssn ? person.ssn : '') + '</i><i class="cg-entry" >' + 
						       (person.birthDate? person.birthDate  : '') + '</i><i class="cg-entry" >' + 
						       (person.address? person.address  : '') + '</i><i class="cg-entry">' + 
						       (person.city ? person.city : '') + ', ' + 
						       (person.state ? person.state : '') + ' ' + 
						       (person.zip ? person.zip : '') + '</i><i class="cg-entry">' +  
						       (person.phone ? person.phone : '') + ' ' +  
						       (person.phone2 ? person.phone2 : '') + '</i><i class="cg-entry">' + 
						       (person.email ? person.email: '') + ' ' +  
						       (person.email2 ? person.email2 : '') + '</i>' + 
						        (person.linked ? '</a>' :'') +
						       '<input type="hidden" class="iCN" value="'+ person.iCN +'" ></div><hr/>';
						       anode.html( insertHtml );
						  }
						  enforceFormats();
						  A.all('.href-css').on('click', function ( event ) {
								window.removeEventListener('beforeunload',preventUser);
							});
					  	} else if ( data.size == -1 ) {
					  		if ( A.one("#myError").hasClass('hidden-msg') ){
		   						A.one("#myError").removeClass('hidden-msg');
		   					}
					  	} else {
					  		if ( A.one("#myAlert").hasClass('hidden-msg') ){
		   						A.one("#myAlert").removeClass('hidden-msg');
		   					}
					  	}
					}
				);
	      }
	 );
	
	var temp = '';
	    A.all('.search-person-action').on(
	      'click',
	      function(e) {
	    	  
	        	//A.one ('#<portlet:namespace/>prefix').val( e.currentTarget.attr('id') );
	        	A.one ( '#<portlet:namespace/>personResults' ).html('');
	        	if ( !A.one("#myAlert").hasClass('hidden-msg') ){
					A.one("#myAlert").addClass('hidden-msg');
				}
				if ( !A.one("#myError").hasClass('hidden-msg') ){
					A.one("#myError").addClass('hidden-msg');
				}
				
	        	 A.one('#<portlet:namespace/>${ndx}_lastName' ).val('');
				  A.one('#<portlet:namespace/>${ndx}_firstName' ).val('');
				  A.one('#<portlet:namespace/>${ndx}_middleName' ).val('');
				  A.one('#<portlet:namespace/>${ndx}_middleName' ).val('');
				  A.one('#<portlet:namespace/>${ndx}_ssn').val('###-##-####');
				  A.one('#<portlet:namespace/>${ndx}_phone' ).val();
				  //A.one('#<portlet:namespace/>${ndx}_phone2' ).val('(###) ###-####');
				  A.one('#<portlet:namespace/>${ndx}_address' ).val('');
				  A.one('#<portlet:namespace/>${ndx}_zip' ).val('');
				  A.one('#<portlet:namespace/>${ndx}_city' ).val('');
				  A.one('#<portlet:namespace/>${ndx}_email' ).val('[USERNAME]@[DOMAIN]');
				  A.one('#<portlet:namespace/>${ndx}_birthDate' ).val('MM/DD/YYYY');
				  A.one('#<portlet:namespace/>${ndx}_gender' ).val('');
				  
				modal.render();
	        	modal.show();
	      }
	    );
	    
	    	
		window.selectPerson = function( src ) {
			var prefix = '#<portlet:namespace/>' + A.one ('#<portlet:namespace/>prefix').val();
			 
			usePerson ( src, prefix );
			var length = prefix.length;
			var addrUsaPrefix = prefix.substr(0, length-1) + 'u_';
			usePerson ( src, addrUsaPrefix );
			modal.hide();
		};
	
		A.one("#verifiedPii").hide();
		A.one("#<portlet:namespace/>veteranPerson_lastName").attr("disabled", "disabled");
		window.usePerson = function( src, prefix ) {
			
			AUI().use('node', function(A){
			
				var jsonObj = JSON.parse( src.getAttribute('json') );
				var icn = jsonObj.iCN;
			
			 A.one('#<portlet:namespace/>piiInfo1').html( 'Name:&nbsp;' + jsonObj['fullName'] );
			 A.one('#<portlet:namespace/>piiInfo2').html( 'SSN:&nbsp;' + jsonObj['ssn'] );
			 A.one('#<portlet:namespace/>piiInfo3').html( 'DOB:&nbsp;' + jsonObj['birthDate'] );
			 var gender = jsonObj['gender'];
			 A.one('#<portlet:namespace/>piiInfo4').html( 'Gender:&nbsp;' + gender.charAt(0).toUpperCase() + gender.slice(1) );
			 A.one('#<portlet:namespace/>piiInfo5').html( 'Address:&nbsp;' + jsonObj['address'] 
			 					+ '<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' 
			 					+ jsonObj['city'] + ', ' + jsonObj['state'] + ' ' + jsonObj['zip'] );
			 A.one('#<portlet:namespace/>piiInfo6').html( '<a href="javascript:loadEligibilityFromCaret();" class="view-eligibility icon-info-sign btn-link btn-primary" title="<liferay-ui:message key="view-eligibility-tooltip" />"  >&nbsp;E&amp;E</a>' );
			 A.one('#<portlet:namespace/>icn').val(icn);
			 A.one("#unverifiedPii").hide();	 
			 A.one("#verifiedPii").show();
			  	
			 if ( jsonObj['validUspsAddress'] ){
	         	A.one ('#veteranPersonu_validUsps').show();
	            A.one ('#veteranPersonu_invalidUsps').hide();
	         } else {
	         	A.one ('#veteranPersonu_invalidUsps').show();
	        	A.one ('#veteranPersonu_validUsps').hide();
	         }
			 var phone2 = A.one(prefix + 'phone2' );
			 	if ( phone2 && phone2 != undefined ){
			 		phone2.val('');
			 	}
			    for ( var key in jsonObj ){
			    	var attrName = key;
			    	var node = A.one(prefix + attrName );
			    	if ( node && jsonObj[key] != undefined ){
						if ( 'select-one' == node.attr('type')  ){
							if ( attrName == 'groupId' ){
								if ( jsonObj[key] > 0 ){
									node.val( jsonObj[key] );
								}
							} else {
							//	if ( jsonObj[key] != "" || ( jsonObj[key] == "" && 'state' != attrName && 'gender' != attrName ) ){
								if ( 'state' == attrName || 'gender' == attrName ){
									node.val( jsonObj[key] );
								} else if ( jsonObj[key] != "" ) {
				    				node.html( '<option value="' + jsonObj[key] + '">'+ jsonObj[key] + '</option>' );
								}
							}
			    		} else {
			    			node.val( jsonObj[key] );
			    		}
						if ( 'hidden' == node.attr('type') ){
							try {
								A.one(prefix + attrName + 'Checkbox').attr('checked', 'on'==jsonObj[key] );
							} catch(e){}
						}
			    	}
			    }
			});
		};
		

var modalEligibility = new A.Modal({
	headerContent: '<h4><liferay-ui:message key="eligibility-header" /></h4>',
    bodyContent: A.one("#eligibility_entry"),
    centered: true,
    destroyOnHide: false,
    modal: true,
    render: '#modalEligibility',
    resizable: {
      handles: 'b, r'
    },
    visible: false,
    width: 750
});

window.loadEligibilityFromCaret = function( ) {
	var icn = A.one('#<portlet:namespace/>icn').val();
	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadEligibilityFromCaret" /><portlet:param name="page" value="eeHistory"/></portlet:resourceURL>', 'html', 
			{ icn : icn },
			function( data ){
				overwrite( A.one( '#eligibility_entry' ), data );
				modalEligibility.show();
			} 
	);
}

window.loadEligibilityFromEE = function( icn ){
	setTimeout(function(){modalEligibility.modal('hide')}, 10)
	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="getEligibilityFromEandE" /><portlet:param name="page" value="eeHistory"/></portlet:resourceURL>', 'html', 
                 { icn : icn
                 },
                 function( data ){
                	 overwrite( A.one( '#eligibility_entry' ), data );
                 	setTimeout(function(){modalEligibility.modal('show')}, 900)
                 } 
          );     
}
</aui:script>


	

<%@include file="/jsp/version.jsp" %>

	