
<%@ include file="/jsp/init.jsp" %>


<portlet:actionURL var="createVcg">
       <portlet:param name="javax.portlet.action" value="doAction"/>
       <portlet:param name="action" value="createVcg"/>
</portlet:actionURL>

<div class="caret-form clear-both" >
<form name="createVcg" method="post" action="${createVcg}" >
       <c:set var="form_" value="${caretMap_['form_']}" />
       <c:set var="vcgAn" value="${form_['vcgAn']}" />
       <c:set var="worImId" value="${form_['worImId']}" />
      <c:set var="veteran" value="${form_['veteranPersn']}" />
      <c:set var="primary" value="${form_['primaryPersn']}" />
      <c:set var="secondary" value="${form_['secondaryPersn']}" />
      <c:set var="secondaryTwo" value="${form_['secondaryTwoPersn']}" />
      <c:set var="cssClass" value="${form_['required']}" />
      <c:set var="registeredOnly" value="${true eq form_['REGISTERED_ONLY']}" />

      <c:set var="ndx" value="veteranPersn" />
       
     <fieldset>
       	<legend class="header"><liferay-ui:message key="process-application-${form_['workType']}" /> </legend>
      	<input type="hidden" name="TRACKER" value="${TRACKER}" >
       	<input type="hidden" name="<portlet:namespace/>vcgAnId" value="${vcgAn.vcgAnId}">
       
       <input type="hidden" name="worImId" id="<portlet:namespace/>worImId" value="${worImId}">
       
       <input type="hidden" name="vcg_veteranId" id="<portlet:namespace/>use_found_0" >
       <input type="hidden" name="ndx0" id="<portlet:namespace/>ndx_found_0" value="${veteran.primaryKey}"  >
       <input type="hidden" id="<portlet:namespace/>vcgs" value="" >
       <input type="hidden" id="<portlet:namespace/>icn" value="" />
		
       

       <div class="vcg-box" >
       
          <div class="vcg-header column-float" >
                     VA Form 10 10CG
          </div>
          <div class="vcg-header column-float" >
          	System Profile
		  </div>
          <div class="vcg-header column-last" >
          	&nbsp;
          </div>
          <hr/>
              
          <c:set var="registered" value="${veteran.registeredIdentity}" />
          <c:if test="${ !registeredOnly || registered }">
              <c:set var="iconLink" value="icon-link" />
              <c:set var="vcgButton" value="vcg-button tab-click" />
              <c:set var="headerLink" value="-verified-${veteran.registeredIdentity}" />
          </c:if>
          
          <c:choose>
                     		<c:when test="${veteran.activeVcg}">
                     			<c:set var="icon" value="icon-ok" />
      							<c:set var="vcgSave" value="(Update VCG)" />
      						</c:when>
      						<c:otherwise>
      							<c:set var="icon" value="icon-pushpin" />
      							<c:set var="vcgSave" value="(New VCG)" />
      						</c:otherwise>
      					</c:choose>
              
              <div class="vcg-row column-float ${vcgButton}" tabindex="0" id="ndx0" >
              		<div class="next-line process-app-header btn-link btn-primary ${iconLink}"> &nbsp;<liferay-ui:message key="process-app-veteran${headerLink}" />
              		</div>
                     <div class="next-line">${veteran.fullName}</div>
                     <div class="next-line">DOB:${veteran.birthDateStr}</div>               
                     <div class="next-line">SSN:${veteran.ssn}</div>
                     <div class="next-line">VA Health Enrolled: <liferay-ui:message key="${veteran.vaHealthEnrolled}-yes" /></div>
                     <div class="next-line">${veteran.address}</div>
                     <div class="next-line">${veteran.city} ${veteran.state} ${veteran.zip}</div>
                     <div class="next-line">${veteran.phone}</div>
                     <div class="next-line">${veteran.email}</div>
                     <div class="next-line">${veteran.facilityName}</div>
              </div>
              <div class="vcg-row column-float user-selection veteran-process" id="sys_profile_0" person="Veteran" >
                     <a class="btn-link search-vcg-action btn-primary icon-search tab-click" tabindex="0" searchType="VCG_CREATION" useLast="${veteran.lastName}" id="found_0">&nbsp;<liferay-ui:message key="veteran-registered-search" /></a>
                     	<c:choose>
                     		<c:when test="${veteran.activeVcg}">
                     			<c:set var="icon" value="icon-ok" />
      							<c:set var="vcgSave" value="(Update VCG)" />
      						</c:when>
      						<c:otherwise>
      							<c:set var="icon" value="icon-pushpin" />
      							<c:set var="vcgSave" value="(New VCG)" />
      						</c:otherwise>
      					</c:choose>	
                     	<div class="control-group hide" style="display: none;" hidden="true" id="cancel_found_0" >
	                        <div class="${icon}" >&nbsp; Use App's Veteran ${vcgSave}</div>
	                        <div class="next-line">${veteran.fullName}</div>
                            <div class="next-line">${veteran.birthDateStr}</div>
                            <div class="next-line">${veteran.ssn}</div>
                            <div class="next-line">${veteran.address}</div>
                            <div class="next-line">VA Health Enrolled: <liferay-ui:message key="${veteran.vaHealthEnrolled}-yes" /></div>
                            <div class="next-line">${veteran.otherHealthInsurance}</div>
                            <div class="next-line">${veteran.city} ${veteran.state} ${veteran.zip}</div>
                           	<div class="next-line">${veteran.phone}</div>
                     		<div class="next-line">${veteran.email}</div>
                     		<div class="next-line">${veteran.facilityName}</div>
						 </div>
                     <div class="person-information" id="search_found_0" >
                     </div>
              </div>
              <div class="vcg-row column-last" >
                                  <aui:field-wrapper inlineField="false" cssClass=" wider-label ${cssClass['applicationStatus']} required-input"   >
                                   <aui:select disabled="${isDisabled}" label="application-status" name="applicationStatus" id="applicationStatus" >
                                          <aui:option value="" label="select-application-status" />
                                          <aui:option value="IN_PROCESS" label="processing-application" selected="${form_['applicationStatus'] eq \"IN_PROCESS\" }"  />
                                          <aui:option value="DUPLICATE" label="duplicate" selected="${form_['applicationStatus'] eq \"DUPLICATE\"}" />
                                          <aui:option value="INVALID" label="invalid" selected="${form_['applicationStatus'] eq \"INVALID\"}" />
                                         </aui:select>
                                  </aui:field-wrapper>
                     <aui:field-wrapper inlineField="false" cssClass="required-input veteran-process" >
                           <aui:input label="process-application-note" name="dispositionNote" size="35" type="textarea" id="applicationTextarea" />
                     </aui:field-wrapper>
                     
              </div>
              
              
              <hr/>
              
              
              <c:if test="${! empty primary}">
       
       <input type="hidden" name="vcg_primaryId" id="<portlet:namespace/>use_found_1" >
       <input type="hidden" name="ndx1" id="<portlet:namespace/>ndx_found_1" value="${primary.primaryKey}" >
       
                     <div class="vcg-row column-float vcg-button tab-click" tabindex="0" id="ndx1" >
                     	<div class="next-line process-app-header btn-link btn-primary icon-link">&nbsp;<liferay-ui:message key="process-app-primary-verified-${primary.registeredIdentity}" /></div>
                           <div class="next-line">${primary.fullName}</div>
                           <div class="next-line">DOB:${primary.birthDateStr}</div>                                     
                           <div class="next-line">SSN:${primary.ssn}</div>
                           <div class="next-line">Other Ins:${primary.otherHealthInsurance}</div>
                           <div class="next-line">Enrolled in Medicare/Medicaid: <liferay-ui:message key="${primary.mediEnrolled}-yes" /></div>
                           <div class="next-line">${primary.address}</div>
                           <div class="next-line">${primary.city} ${primary.state} ${primary.zip}</div>
                           <div class="next-line">${primary.phone}</div>
                     	   <div class="next-line">${primary.email}</div>
                     </div>
                     <div class="vcg-row column-float user-selection primary-process" controlNode=".primary" id="sys_profile_1" person="Primary" >
                           <a class="btn-link search-vcg-action btn-primary icon-search tab-click" tabindex="0" id="found_1" useLast="${primary.lastName}" >&nbsp; <liferay-ui:message key="primary-registered-search" /></a>
                           <div class="control-group hide" style="display: none;" hidden="true" id="lock_found_1" >
	                           <div class="icon-lock" >&nbsp; VCG slot taken! </div>
						   </div>
						   <div class="control-group hide" style="display: none;" hidden="true" id="dupe_found_1" >
	                           <div class="icon-exclamation-sign" >&nbsp; Person already used! </div>
						   </div>
                           			<div class="control-group hide" style="display: none;" hidden="true" id="cancel_found_1" >
	                        			<div class="icon-pushpin" >&nbsp; Use App's Primary</div>
	                        			<div class="next-line">${primary.fullName}</div>
                                        <div class="next-line">${primary.birthDateStr}</div>                                     
                           				<div class="next-line">${primary.ssn}</div>
                           				<div class="next-line">${primary.otherHealthInsurance}</div>
                           				<div class="next-line">Enrolled in Medicare/Medicaid: <liferay-ui:message key="${primary.mediEnrolled}-yes" /></div>
                           				<div class="next-line">${primary.address}</div>
                           				<div class="next-line">${primary.city} ${primary.state} ${primary.zip}</div>
                           				<div class="next-line">${primary.phone}</div>
                     					<div class="next-line">${primary.email}</div>
						 			</div>
                           <div class="person-information" id="search_found_1" >
                           </div>
                     </div>
                     <div class="vcg-row column-last caregiver-inputs" controlNode=".primary" >
                                  <aui:field-wrapper inlineField="false" cssClass=" wider-label ${cssClass['primaryStatus']} required-input process-select"   >
                                   <aui:select disabled="${isDisabled}" label="primary-status" name="primaryStatus" id="primaryStatus"  >
                                                <aui:option value="" label="select-caregiver-status" />
                                          <aui:option value="IN_PROCESS" label="processing-applicant" selected="${form_['primaryStatus'] eq \"IN_PROCESS\" }"  />
                                          <aui:option value="INVALID" label="invalid" selected="${form_['primaryStatus'] eq \"INVALID\"}" />
                                         </aui:select>
                                  </aui:field-wrapper>
                           <aui:field-wrapper inlineField="false" cssClass="required-input primary-process"  >
                                 <aui:input label="primary-note" name="primaryNote" size="35" type="textarea"  />
                           </aui:field-wrapper>
                     
                     </div>
                     
                     
                     <hr/>
              </c:if>
              
              
              
              <c:if test="${! empty secondary}">  

       <input type="hidden" name="vcg_secondaryId" id="<portlet:namespace/>use_found_2" >
       <input type="hidden" name="ndx2" id="<portlet:namespace/>ndx_found_2" value="${secondary.primaryKey}" >

                     <div class="vcg-row column-float vcg-button tab-click" tabindex="0" id="ndx2" >
			              <div class="next-line process-app-header btn-link btn-primary  icon-link">&nbsp;<liferay-ui:message key="process-app-secondary-verified-${secondary.registeredIdentity}" /></div>
                           <div class="next-line">${secondary.fullName}</div>
                           <div class="next-line">DOB:${secondary.birthDateStr}</div>       
                           <div class="next-line">SSN:${secondary.ssn}</div>
                           <div class="next-line">${secondary.address}</div>
                           <div class="next-line">${secondary.city} ${secondary.state} ${secondary.zip}</div>
                          	<div class="next-line">${secondary.phone}</div>    
                     		<div class="next-line">${secondary.email}</div>                 
                     </div>
                     <div class="vcg-row column-float  user-selection secondary-process" id="sys_profile_2" controlNode=".secondary" person="Secondary" >
                           <a class="btn-link search-vcg-action btn-primary icon-search tab-click" tabindex="0"  useLast="${secondary.lastName}" id="found_2">&nbsp;<liferay-ui:message key="secondary-registered-search" /></a>
                           <div class="control-group hide" style="display: none;" hidden="true" id="lock_found_2" >
	                           <div class="icon-lock" >&nbsp; VCG slot taken! </div>
						   </div>
						   <div class="control-group hide" style="display: none;" hidden="true" id="dupe_found_2" >
	                           <div class="icon-exclamation-sign" >&nbsp; Person already used! </div>
						   </div>
                           			<div class="control-group hide" style="display: none;" hidden="true" id="cancel_found_2" >
	                        			 <div class="icon-pushpin" >&nbsp; Use App's Secondary</div>
	                        			 <div class="next-line">${secondary.fullName}</div>
                                         <div class="next-line">${secondary.birthDateStr}</div>
                                         <div class="next-line">${secondary.ssn}</div>
                                         <div class="next-line">${secondary.address}</div>
                           				<div class="next-line">${secondary.city} ${secondary.state} ${secondary.zip}</div>
                           				<div class="next-line">${secondary.phone}</div>
                     					<div class="next-line">${secondary.email}</div>
						 			</div>
                           
                           <div class="person-information" id="search_found_2" >
                           </div>
                     </div>
                     <div class="vcg-row column-last caregiver-inputs" controlNode=".secondary" >
                                  <aui:field-wrapper inlineField="false" cssClass=" wider-label ${cssClass['secondaryStatus']} required-input process-select"   >
                                   <aui:select disabled="${isDisabled}" label="secondary-status" name="secondaryStatus" id="secondaryStatus" >
                                                <aui:option value="" label="select-caregiver-status" />
                                          <aui:option value="IN_PROCESS" label="processing-applicant" selected="${form_['secondaryStatus'] eq \"IN_PROCESS\" }"  />
                                          <aui:option value="INVALID" label="invalid" selected="${form_['secondaryStatus'] eq \"INVALID\"}" />
                                         </aui:select>
                                  </aui:field-wrapper>
                                  <aui:field-wrapper inlineField="false" cssClass="required-input secondary-process"  >
                                         <aui:input label="secondary-note" name="secondaryNote" size="35" type="textarea"  />
                                  </aui:field-wrapper>
                     </div>
                     
                     
                     <hr/>
              </c:if>
              
              
             
              
              <c:if test="${! empty secondaryTwo}">

       <input type="hidden" name="vcg_secondaryTwoId" id="<portlet:namespace/>use_found_3" >
       <input type="hidden" name="ndx3" id="<portlet:namespace/>ndx_found_3" value="${secondaryTwo.primaryKey}" >
              
                     <div class="vcg-row column-float vcg-button tab-click" tabindex="0" id="ndx3" >
                     	 <div class="next-line process-app-header btn-link btn-primary icon-link">&nbsp;<liferay-ui:message key="process-app-secondaryTwo-verified-${secondaryTwo.registeredIdentity}" /></div>
                           <div class="next-line">${secondaryTwo.fullName}</div>
                           <div class="next-line">DOB:${secondaryTwo.birthDateStr}</div>                                       
                           <div class="next-line">SSN:${secondaryTwo.ssn}</div>
                           <div class="next-line">${secondaryTwo.address}</div>
                           <div class="next-line">${secondaryTwo.city} ${secondaryTwo.state} ${secondaryTwo.zip}</div>
                           <div class="next-line">${secondaryTwo.phone}</div>
                     		<div class="next-line">${secondaryTwo.email}</div>
                     </div>
                     <div class="vcg-row column-float user-selection secondaryTwo-process" id="sys_profile_3" controlNode=".secondaryTwo" person="Secondary II" >
                           <a class="btn-link search-vcg-action btn-primary icon-search tab-click" tabindex="0"  useLast="${secondaryTwo.lastName}" id="found_3">&nbsp;<liferay-ui:message key="secondaryTwo-registered-search" /></a>
                           <div class="control-group hide" style="display: none;" hidden="true" id="lock_found_3" >
	                           <div class="icon-lock" >&nbsp; VCG slot taken! </div>
						   </div>
						   <div class="control-group hide" style="display: none;" hidden="true" id="dupe_found_3" >
	                           <div class="icon-exclamation-sign" >&nbsp; Person already used! </div>
						   </div>
                           		<div class="control-group hide" style="display: none;" hidden="true" id="cancel_found_3" >
	                           		<div class="icon-pushpin" >&nbsp; Use App's Secondary II </div>
	                           		<div class="next-line">${secondaryTwo.fullName}</div>
                                         <div class="next-line">${secondaryTwo.birthDateStr}</div>                                       
                           				<div class="next-line">${secondaryTwo.ssn}</div>
                           				<div class="next-line">${secondaryTwo.address}</div>
                           				<div class="next-line">${secondaryTwo.city} ${secondaryTwo.state} ${secondaryTwo.zip}</div>
                           				<div class="next-line">${secondaryTwo.phone}</div>
                     					<div class="next-line">${secondaryTwo.email}</div>
						   		</div>
                           <div class="person-information" id="search_found_3" >
                           </div>
                     </div>
                     <div class="vcg-row column-last caregiver-inputs" controlNode=".secondaryTwo" >
                           <aui:field-wrapper inlineField="false" cssClass=" wider-label ${cssClass['secondaryTwoStatus']} required-input process-select" >
                                   <aui:select disabled="${isDisabled}" label="secondaryTwo-status" name="secondaryTwoStatus" id="secondaryTwoStatus" >
                                                <aui:option value="" label="select-caregiver-status" />
                                          <aui:option value="IN_PROCESS" label="processing-applicant" selected="${form_['secondaryTwoStatus'] eq \"IN_PROCESS\" }"  />
                                          <aui:option value="INVALID" label="invalid" selected="${form_['secondaryTwoStatus'] eq \"INVALID\"}" />
                                   </aui:select>
                           </aui:field-wrapper>
                                  <aui:field-wrapper inlineField="false" cssClass="required-input secondaryTwo-process"  >
                                         <aui:input label="secondaryTwo-note" name="secondaryTwoNote" size="35" type="textarea"  />
                                  </aui:field-wrapper>
                     </div>
              </c:if>
       </div>
       </fieldset>
       
       <fieldset>
       <legend class="header">Supporting Documents</legend>
       <div class="clear-both" id="<portlet:namespace/>supportDocs" >
              <c:forEach var="doc" items="${form_['supportDocs']}">
                     <portlet:resourceURL var="getDocum">
                           <portlet:param name="action" value="getDocum"/>
                           <portlet:param name="documId" value="${doc.documId}"/>
                     </portlet:resourceURL>
                     
                     <div class="poa-docum manage-layout" >
                           <a href="${getDocum}" target="_blank" ><i class="close-window btn btn-primary icon-download" >&nbsp; ${doc.name}</i></a>
                     </div>
              
              </c:forEach>
       </div>
       </fieldset>
              
       


</form>
       <input type="hidden" id="<portlet:namespace/>placeHolder" />
       <input type="hidden" id="<portlet:namespace/>searchType" />
       
       <div class="manage-layout manage-layout-shim">
              <c:if test="${! empty form_['documId'] and form_['documId'] gt 0}">
                     <portlet:resourceURL var="getDocum">
                           <portlet:param name="action" value="getDocum"/>
                           <portlet:param name="documId" value="${form_['documId']}"/>
                     </portlet:resourceURL>
                     
                     <div class="poa-docum manage-layout" >
                           <a href="${getDocum}" target="_blank" ><i class="icon-download" >&nbsp; ${form_['documName']}</i></a>
                     </div>
              </c:if>
       </div>
       
       

<div class="yui3-skin-sam">
    <div id="modalSelectCg"></div>
</div>

       <div id="search_vcg">

             <c:set var="person" value="${defaultUser}" />
             <c:set var="ndx" value="srch" />
             <c:set var="caretCss" value="${cssClass}" />
              
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="manage-layout ${caretCss['lastName']}"  >
			<aui:input label="last-name" name="${ndx}_lastName" type="text" size="25" id="${ndx}_lastName"  />
		</aui:field-wrapper>
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="manage-layout ${caretCss['firstName']}"  >
			<aui:input label="first-name" name="${ndx}_firstName" type="text" size="25" id="${ndx}_firstName"  />
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="manage-layout ${caretCss['middleName']}"  >
		<aui:input label="middle-name" name="${ndx}_middleName" type="text" size="25" id="${ndx}_middleName" />
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="manage-layout ${caretCss['ssn']}"  >
			<aui:input label="ssn" name="${ndx}_ssn" cssClass="ssn-field" type="text" size="25" id="${ndx}_ssn"  />
		</aui:field-wrapper>
		<div class="control-group-inline form-inline field-wrapper manage-layout ${caretCss['birthDate']}" >
			<fmt:formatDate var="bday" pattern="MM/dd/yyyy" value="${person.birthDate}"/>
			<aui:input label="dob" name="${ndx}_birthDate" cssClass="date-field" type="text" size="25" id="${ndx}_birthDate" />
		</div>
		<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="manage-layout ${caretCss['gender']}"  >
			<aui:select inlineField="true" label="gender" name="${ndx}_gender" id="${ndx}_gender" >
				<aui:option value="" label="select-gender" />
				<c:forEach var="gender" items="${caretMap_['genderTypes']}">
					<aui:option value="${gender}" label="${gender}" selected="${gender eq person.gender}" />
				</c:forEach>
			</aui:select>
		</aui:field-wrapper>


              
                <aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="manage-layout ${cssClass['address']}"  >
					<aui:input label="address" name="${ndx}_address" id="${ndx}_address" type="text" size="25"  />
				</aui:field-wrapper>
		
				<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="manage-layout float-left ${cssClass['zip']}"  >
					<aui:input label="zip" name="${ndx}_zip" id="${ndx}_zip" type="text" size="25"  />
				</aui:field-wrapper>
		
				<aui:field-wrapper inlineField="true" inlineLabel="left" cssClass="manage-layout ${cssClass['city']}"  >
					<aui:input label="city" name="${ndx}_city" id="${ndx}_city" type="text" size="25"  />
				</aui:field-wrapper>
				
              
              <br class="clear-both" />
              <div class="submit-vcg-search">
                     <button id="searchVcg" class="btn btn-primary" type="button" >Search</button>
              </div>
              
              <div id="cgSearchResults"></div>
       </div>
       
       <div class="caret-submit-form">
              <a href="<portlet:actionURL/>" id="cancelSearch" class="btn btn-primary" >
                           <liferay-ui:message key="cancel" />
              </a>
              <a onclick="saveType();" id="dispoForm" class="btn btn-primary" >
                     <liferay-ui:message key="submit" />
              </a>
              
       </div>

<div class="clear-both my-shim"></div>
</div>


<div class="yui3-skin-sam">
   	<div id="modalEligibility">
   	</div>
</div>
<div id="eligibility_entry">
	<a style="display:none;" class="eligibility-frommodal btn-primary" title='<liferay-ui:message key="load-eligibility-tooltip" />'  >&nbsp;Retrieve E&E</a>
</div>



<div class="yui3-skin-sam">
       <div id="modalResponse">
       </div>
</div>

<div class="yui3-skin-sam">
       <div id="_validationResult" ></div>
</div>



<aui:script use="aui-modal">

var modalEligibility = new A.Modal({
	headerContent: '<h4><liferay-ui:message key="eligibility-header" /></h4>',
    bodyContent: A.one("#eligibility_entry"),
    centered: true,
    destroyOnHide: false,
    modal: true,
    render: '#modalEligibility',
    resizable: {
      handles: 'b, r'
    },
    visible: false,
    width: 750
});

window.loadEligibilityFromCaret = function( icn ){
	var icn = A.one ('#<portlet:namespace/>icn').val();
	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadEligibilityFromCaret" /><portlet:param name="page" value="eeHistory"/></portlet:resourceURL>', 'html', 
			{ icn : icn },
			function( data ){
				overwrite( A.one( '#eligibility_entry' ), data );
				modalEligibility.show();
			} 
	);
}

window.loadEligibilityFromEE = function( icn ){
	setTimeout(function(){modalEligibility.modal('hide')}, 10)
	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="getEligibilityFromEandE" /><portlet:param name="page" value="eeHistory"/></portlet:resourceURL>', 'html', 
                 { icn : icn
                 },
                 function( data ){
                	 overwrite( A.one( '#eligibility_entry' ), data );
                 	setTimeout(function(){modalEligibility.modal('show')}, 900)
                 } 
          );     
}


var modalVcg = new A.Modal({
       headerContent: "<h4><liferay-ui:message key='search-verified-identity' /></h4>",
    bodyContent: A.one("#search_vcg"),
    centered: true,
    destroyOnHide: false,
    modal: true,
    render: '#modalSelectCg',
    resizable: {
      handles: 'b, r'
    },
    visible: false,
    width: 870
});
A.one('#searchVcg').on('click',
             function( event ) {
             		var searchType = A.one ('#<portlet:namespace/>searchType').val();
                     window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="searchVcg" /></portlet:resourceURL>', 'json', 
                                  { mviInclusion : 'true',
                           firstName: A.one('#<portlet:namespace/>srch_firstName' ).val(),
                           lastName: A.one('#<portlet:namespace/>srch_lastName').val(),
                                   ssn:   A.one('#<portlet:namespace/>srch_ssn').val(),
                                   middleName: A.one('#<portlet:namespace/>srch_middleName').val(), 
                                   gender: A.one('#<portlet:namespace/>srch_gender' ).val(),
									address: A.one('#<portlet:namespace/>${ndx}_address' ).val(),
									city: A.one('#<portlet:namespace/>${ndx}_city' ).val(),
									zip: A.one('#<portlet:namespace/>${ndx}_zip' ).val(),
									birthdate: A.one('#<portlet:namespace/>${ndx}_birthDate' ).val(),					  
                                   searchType:  searchType
                                  },
                                  function( data ){
                                    var anode = A.one ( '#cgSearchResults' );
                                    if ( data.size == -1 ) {
					  					anode.html('<div id="myAlert" class="portlet-msg-error" ><liferay-ui:message key="service-error" /></div>');
					  				} else if ( data.size > 0 ){
                                           var insertHtml = '<hr/>';
                                           var start = "<div tabindex='0' class='person-information tab-click' onclick='useVcg(this);' json='";
                                           var end = "' ><div class='cg-entry' >";
                                           for ( var i = 0; i < data.vcgs.length; i++ ){
                                                  var person = data.vcgs[i];
                                                  var stringify = JSON.stringify(person);
                                                insertHtml = insertHtml + start + stringify + end + person.fullName + '</div><div class="cg-entry" >';
                                                insertHtml = insertHtml + 
                                                (person.birthDate? person.birthDate  : '') + '</div><div class="cg-entry" >' + 
                                                (person.ssn ? person.ssn : '') + '</div><div class="cg-entry" >' + 
                                                (person.otherHealthInsurance ? person.otherHealthInsurance : '') + '</div><div class="cg-entry" >' + 
                                                (person.address? person.address  : '') + '</div><div class="cg-entry">' + 
                                                (person.city ? person.city : '') + ', ' + 
                                                (person.state ? person.state : '') + ' ' + 
                                                (person.zip ? person.zip : '') + '</div><div class="cg-entry">' +  
                                                (person.phone ? person.phone : '') + ' ' +  
                                                (person.phone2 ? person.phone2 : '') + '</div><div class="cg-entry">' + 
                                                (person.email ? person.email: '') + ' ' +  
                                                (person.email2 ? person.email2 : '') + '</div>' +
                                                (searchType == 'VCG_CREATION' ? (person.facilityName? ('<div class="cg-entry">' + person.facilityName + '</div>'): ''): '')
                                                 + '<input type="hidden" class="ACTIVE_VCG" value="'+ person.ACTIVE_VCG +'" ></div><hr/>'
                                                  + '<input type="hidden" class="iCN" value="'+ person.iCN +'" ></div>';
                                                anode.html( insertHtml );
                                           }
                                    } else {
                                           anode.html('<div id="myAlert" class="portlet-msg-alert hidden-msg" ><liferay-ui:message key="no-persons-found" /></div>');
                                    }
                                  } 
                           );     
             }
       );
              
       
       A.all('.vcg-button').on(
              'click',
             function(e) {
             	var prefix = A.one(e.currentTarget).attr('id').substring(3);
             	A.one ( '#search_found_' + prefix ).hide();
             	A.one ( '#cancel_found_' + prefix ).show();
             	A.one ( '#<portlet:namespace/>use_found_' + prefix ).val( A.one( "#<portlet:namespace/>ndx_found_" + prefix ).val() );
            	if ( prefix == '0' ){
	            	A.one('#<portlet:namespace/>vcgs').val('${form_['ACTIVE_VCG']}');
            		enforceActiveCaregivers( enforceActiveVeteran(), 'found_0');
            		enforceActiveCaregivers( enforceActiveVeteran(), 'found_1');
            		enforceActiveCaregivers( enforceActiveVeteran(), 'found_2');
            		enforceActiveCaregivers( enforceActiveVeteran(), 'found_3');
            	} else {
	           		enforceActiveCaregivers( enforceActiveVeteran(), 'found_' + prefix );
            	}
             });
              
              
       A.one('#<portlet:namespace/>applicationStatus').on(
             'change',
             function(e) {
	            checkCaregivers ();
	            var disapproved =( e.currentTarget.val() == 'INVALID' || e.currentTarget.val() == 'DUPLICATE');
	            var invalid = e.currentTarget.val() == 'INVALID';
              	A.all('.process-select select').each( function( ii ){
                   	var node = document.getElementById( ii.attr('id') );
                   	if ( disapproved ){
                   		node.disabled = true;
						A.one( document.getElementById( ii.attr('id') ).parentNode ).hide();                  	
                    } else {
                    	node.disabled = false;
                    	A.one( document.getElementById( ii.attr('id') ).parentNode ).show();
                    }
                   });
                   if ( disapproved ){
                   		A.one( document.getElementById( '<portlet:namespace/>applicationTextarea').parentNode).show();                     	
                    } else {
                    	A.one( document.getElementById( '<portlet:namespace/>applicationTextarea').parentNode).hide();
                    }
                    if ( invalid ){
                    	document.getElementById( 'found_0' ).disabled = true;
                    } else {
                    	document.getElementById( 'found_0' ).disabled = false;
                    }
             });
             
           A.all('.process-select select').on(
             'change',
             function(e) {
              	var prefix = A.one(e.currentTarget.ancestorsByClassName('vcg-row')._nodes[0]).attr('controlNode');
              	applyDisplayLogic( prefix );
             });
             
       var applyDisplayLogic = function( prefix ){
             var node =  A.one( '#<portlet:namespace/>' + prefix.substring(1) + 'Status' );
             if ( node == null ) return;
             
             var localInvalid = node.val() == 'INVALID';
             // var localDuplicate = node.val() == 'DUPLICATE';
       		 var applicationInvalid = A.one('#<portlet:namespace/>applicationStatus').val() == 'INVALID';
       		 var applicationDuplicate = A.one('#<portlet:namespace/>applicationStatus').val() == 'DUPLICATE';
			
             A.all(prefix + '-process select, ' + prefix + '-process textarea, '
             	+ prefix + '-process input, ' + prefix + '-process a'  ).each( function( ii ){
             		
             	node = document.getElementById( ii.attr('id') );
             	if ( node != null ){
             		if ( applicationInvalid || applicationDuplicate ){
                     	if ( localInvalid && node.tagName.toLowerCase() === 'a' ){
                            node.disabled = true;
                            //if ( node.hasClass('missing-required-input') ){
                            //    node.removeClass( 'missing-required-input' );
                            //}
                     	} else if ( prefix == '.application' ) {
                            A.one(node.parentNode).show();
                            node.disabled = false;
                     	} else {
                     		A.one(node.parentNode).hide();
                     		node.disabled = true;
                     	}
             		} else if ( localInvalid ) {
             			if ( node.tagName.toLowerCase() === 'a' ){
                            node.disabled = true;
                            A.one(node.parentNode).hide();
                     	} else {
                     		A.one(node.parentNode).show();
                     		node.disabled = false;
                     	}
                     	var clear = A.one ( '#<portlet:namespace/>use_' + ii.attr('id') );
                     	if ( clear ) {
                     		console.log ('old clear=' + clear.val() );
                     		clear.val(0);
                     		console.log ('new clear=' + clear.val() );
                     	}
             		} else {
             			if ( node.tagName.toLowerCase() === 'a' ){
                            node.disabled = false;
                            A.one(node.parentNode).show();
                     	} else {
                     		A.one(node.parentNode).hide();
                     		node.disabled = true;
                     	}
             		}
          		}
          	}
          	
          	);
       	}
       
       var checkCaregivers = function (  ){
              applyDisplayLogic ( '.primary' );
              applyDisplayLogic ( '.secondary' );
              applyDisplayLogic ( '.secondaryTwo' );
		      applyDisplayLogic ( '.application' );
		       
		      var appStatusVal = A.one( '#<portlet:namespace/>applicationStatus').val();
		      var disapproved =(appStatusVal == 'INVALID' || appStatusVal == 'DUPLICATE');
		    if ( disapproved ){
                   		A.one( document.getElementById( '<portlet:namespace/>applicationTextarea').parentNode).show();
                   		document.getElementById( '<portlet:namespace/>applicationTextarea').disabled = false;                  	
                    } else {
                    	A.one( document.getElementById( '<portlet:namespace/>applicationTextarea').parentNode).hide();
                    	document.getElementById( '<portlet:namespace/>applicationTextarea').disabled = true;
                    }
       };
       checkCaregivers();
 		
 		
              A.all('.search-vcg-action').on(
             'click',
             function(e) {  
                     A.one ( '#cgSearchResults' ).html('');
                      A.one ('#<portlet:namespace/>placeHolder').val( e.currentTarget.attr('id') );
                      A.one ('#<portlet:namespace/>searchType').val( e.currentTarget.attr('searchType') );
                     A.one('#<portlet:namespace/>srch_lastName' ).val(e.currentTarget.attr('useLast'));
						  A.one('#<portlet:namespace/>srch_firstName' ).val('');
						  A.one('#<portlet:namespace/>srch_middleName' ).val('');
						  A.one('#<portlet:namespace/>srch_ssn').val('');
						  A.one('#<portlet:namespace/>srch_birthDate' ).val('');
						  A.one('#<portlet:namespace/>srch_gender' ).val('');                           
						  A.one('#<portlet:namespace/>srch_address' ).val('');
						  A.one('#<portlet:namespace/>srch_zip' ).val('');
                           modalVcg.render();
                     modalVcg.show();
             }
           );
              
              window.useVcg = function( src ) {
                  var someVal = A.one ('#<portlet:namespace/>placeHolder').val();
                  var anode = A.one ( '#search_' + someVal ); 
             	  A.one ( '#cancel_' + someVal ).hide();

                  var jsonObj = JSON.parse( src.getAttribute('json') );
                  var icn = jsonObj.iCN;
                  A.one( "#<portlet:namespace/>use_" + someVal ).val( jsonObj.primaryKey );
                  A.one( '#<portlet:namespace/>vcgs').val(jsonObj.ACTIVE_VCG);
                  if ( someVal == 'found_0' ){
                  	enforceActiveCaregivers(enforceActiveVeteran(), someVal);
            		enforceActiveCaregivers( enforceActiveVeteran(), 'found_1');
            		enforceActiveCaregivers( enforceActiveVeteran(), 'found_2');
            		enforceActiveCaregivers( enforceActiveVeteran(), 'found_3');
            	  } else {
	//           		enforceActiveCaregivers( enforceActiveVeteran(), 'found_' + prefix );
	   	           	  enforceActiveCaregivers(enforceActiveVeteran(), someVal);
            	  }
                  var insertHtml = src.innerHTML;
                  var jsonObj = JSON.parse( src.getAttribute('json') );
                if ( someVal == 'found_0' ){
                  	insertHtml = insertHtml + '<div class="cg-entry"><a href="javascript:loadEligibilityFromCaret(${icn});" class="view-eligibility icon-info-sign btn-link btn-primary" title="<liferay-ui:message key="view-eligibility-tooltip" />"  >&nbsp;E&amp;E</a></div><hr/>'
                  }
                A.one('#<portlet:namespace/>icn').val(icn);
   			 
                  anode.html( insertHtml );
	              anode.show();
                  modalVcg.hide();
              }
           window.removeUser = function (e, someVal){
                     e.previousSibling.remove();
                     e.remove();
                     A.one( "#<portlet:namespace/>use_" + someVal.id ).val("");
              };
        
       var enforceActiveVeteran = function (  ){
		    var ACTIVE_VCG = A.one( '#<portlet:namespace/>vcgs').val();
       		if ( ACTIVE_VCG ) {
                  	var activeVcg = ACTIVE_VCG.split(","); 
       				var retVal = true;
                  	for ( var i = 1; i < 4; i++ ){
           				var foundNode = document.getElementById( 'found_' + i ); 
               			if ( foundNode ){
           					var prefix = A.one(A.one(foundNode).ancestorsByClassName('vcg-row')._nodes[0]).attr('controlNode');
              				var cgPick = A.one ( '#search_found_' + i );
              				var cgPick2 = A.one ( '#cancel_found_' + i );
                  			if ( parseInt ( activeVcg[i+1], 10 ) > 0 ){
                  					A.one('#lock_found_' + i).show();
                  					A.one(foundNode).hide();
                  					foundNode.disabled = true;
		           					var status =  A.one( '#<portlet:namespace/>' + prefix.substring(1) + 'Status' );
                  					if ( status.val() == 'IN_PROCESS'){
                  						status.val('');
                  					}
	               					A.one(document.getElementById( '_caret_WAR_caretportlet_' + prefix.substring(1) + 'Status' )[1]).attr('disabled', 'true');
                  					addStrikethru(cgPick);
                  					addStrikethru(cgPick2);
                                retVal = false;
                  			} else {
                  					A.one('#lock_found_' + i).hide();
                  					A.one(foundNode).show();
                  					foundNode.disabled = false;
              						A.one(document.getElementById( '_caret_WAR_caretportlet_' + prefix.substring(1) + 'Status' )[1]).attr('disabled', '');
              						removeStrikethru(cgPick);
                  					removeStrikethru(cgPick2);
              						applyDisplayLogic( prefix );
                  			} 
                  		}
                  	}
                  	return retVal;
           }
     }
     
	var enforceActiveCaregivers = function ( retVal, suffix ){ //"found_3"
   		var cgPick = A.one ( '#search_' + suffix );
   		if ( cgPick == null ) return;
		var cgPick2 = A.one ( '#cancel_' + suffix );
     	var veteran = 'found_0'== suffix;
   		var vcg = A.one('#<portlet:namespace/>vcgs');
   		if ( vcg && vcg.val() ){
            var activeVcg = vcg.val().split(",");
			if ( activeVcg.length == 5 ){
           		var usei = parseInt( A.one('#<portlet:namespace/>use_' + suffix ).val() );
   				var prefix = A.one( A.one( document.getElementById( suffix ) ).ancestorsByClassName('vcg-row')._nodes[0]).attr('controlNode');
               	var status =  A.one( '#<portlet:namespace/>' + prefix.substring(1) + 'Status' );
           		if ( parseInt ( activeVcg[1], 10 ) == usei ) { // Veteran
           			if ( !veteran ){
           				//console.log('you cannot choose veteran as own caregiver!');
           				addStrikethru(cgPick);
                  		addStrikethru(cgPick2);
                  		A.one ( '#dupe_' + suffix ).show();
                  		if ( status.val() == 'IN_PROCESS'){
   							status.val('');
	   					}
	 					A.one(document.getElementById( '_caret_WAR_caretportlet_' + prefix.substring(1) + 'Status' )[1]).attr('disabled', 'true');
           			} 
           		} else if ( parseInt ( activeVcg[2], 10 ) == usei ||  parseInt ( activeVcg[3], 10 ) == usei || parseInt ( activeVcg[4], 10 ) == usei ) {
           			//console.log('you already used this selection');
           			addStrikethru(cgPick);
                  	addStrikethru(cgPick2);
                  	A.one ( '#dupe_' + suffix ).show();
   					if ( status.val() == 'IN_PROCESS'){
   						status.val('');
   					}
 					A.one(document.getElementById( '_caret_WAR_caretportlet_' + prefix.substring(1) + 'Status' )[1]).attr('disabled', 'true');
           		} else {
           			// console.log(retVal +':clear to use this cg... ' );
           			if ( retVal ){
           				removeStrikethru(cgPick);
                  		removeStrikethru(cgPick2);
                  		A.one ( '#dupe_' + suffix ).hide();
                  		A.one(document.getElementById( '_caret_WAR_caretportlet_' + prefix.substring(1) + 'Status' )[1]).attr('disabled', '');
           			}
           		}
   			}
   		}
	}

	var addStrikethru = function(cgPick){
		if (cgPick && !cgPick.hasClass('strikethrough') ){
             cgPick.addClass( 'strikethrough' );
        }
	}
	
	var removeStrikethru = function(cgPick){
		if (cgPick && cgPick.hasClass('strikethrough') ){
            cgPick.removeClass( 'strikethrough' );
     	}
	}
       
       var getValidCg = function ( ndx ){
       		var node = A.one ( '#search_found_' + ndx );
       		
       		if (  !node || node.hasClass('strikethrough')   ) {
       			return 0;
       		}
       		return A.one('#<portlet:namespace/>use_found_' + ndx ).val();
       }
       var validateFields = function ( anotherCallback ){            
              var count = 0;
              var inputNodes = A.all('.required-input input, .required-input select, .required-input textarea');
              var fields = "";
              for ( var i = 1; i < inputNodes.size() ; i++ ){
                     var node = A.one(inputNodes._nodes[i]);
                     if (node == undefined || node.attr('disabled') == true ) continue;
                     if ( 'select-one' == node.attr('type') ){
                           if ( node.val() == "" || node.val() == "0" ){
                                  node.addClass( 'missing-required-input' );
                                  fields = fields + "<li>" + 
                                         node.ancestorsByClassName('required-input').one('.control-label').text().trim()+
                                         " is required</li>";
                                  count++;
                           } else {
                                   if ( node.hasClass('missing-required-input') ){
                                          node.removeClass( 'missing-required-input' );
                                   }
                             }
                       }
                     if ( 'text' == node.attr('type') || 'textarea' == node.attr('type') ){
                           var ok = true;
                           if ( node.val() == "" || ( node.hasClass('date-field') && node.val() == 'MM/DD/YYYY' ) ){
                                 node.addClass( 'missing-required-input' );
                                 ok = false;
                                 fields = fields + "<li>" + 
                                         node.ancestorsByClassName('required-input').one('.control-label').text().trim()+
                                         " is required</li>";
                                 count++;
                           } else {
                                  if ( node.hasClass ('not-future') && false ) { //fails future test
                                         ok = false;
                                  }
                                  if ( node.hasClass ('after-app-recieve-date') && false ) { //fails before app recd date
                                         ok = false;
                                  }
                                  
                           }
                           if ( ok && node.hasClass('missing-required-input') ){
                                         node.removeClass( 'missing-required-input' );
                           }
                     }
              }
              if ( A.one('#<portlet:namespace/>applicationStatus').val() != 'INVALID' ) {
              	for ( var i = 0; i < 4; i++ ){
                     var searchFound = A.one('#search_found_' + i);
                     if ( searchFound ) {
                           var personId = A.one('#<portlet:namespace/>use_found_' + i).val();
                           var personNode = A.one('#sys_profile_'+i);
                           if ( A.one('#sys_profile_'+i+ ' a').attr('disabled') == true ) continue;
                           if ( ( A.one ( '#search_found_' + i ) ).hasClass('strikethrough') ) continue;
                           if ( personId == '' || personId == 0 ){
                                  fields = fields + "<li>System Profile pick for " + personNode.attr("person") + " is required</li>";
                                  if ( !personNode.hasClass('missing-required-input') ){
                                         personNode.addClass( 'missing-required-input' );
                                  }
                           } else if ( personNode.hasClass('missing-required-input') ){
                                  personNode.removeClass( 'missing-required-input' );
                           }
                     }
             	 }
              }
              anotherCallback( fields );
       }
         
       var modal = new A.Modal({
              headerContent: '<h4><liferay-ui:message key="validation" /></h4>',
              bodyContent: A.one('#_validationResult'),
              centered: true,
       destroyOnHide: false,
       modal: true,
              render: '#modalResponse',
              visible: false,
              resizable: {
                     handles: 'b, r'
              },
              width: 500 });
              
         modal.addToolbar([{
			               label: 'Cancel',
			               on: {
			               		click: function() {
			                		modal.hide();
			                	}
			                }},{	
			                label: 'Submit',
			                id: 'modalSubmit',
			                on: {
			                    click: function() {
			                    	window.removeEventListener('beforeunload',preventUser);
			                    	document.forms["createVcg"].submit();
								}
			                 }
							}]);     
                             
          
          window.saveType = function(src){
                     validateFields( function ( message ) {
                         var validationNotice = A.one ('#_validationResult');
              			 if ( message.length > 0 ){
                         	var msg = "<div style='width:90%; padding-bottom:20px;' ></div><div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
                           	validationNotice.html(msg);
                           	document.getElementById( 'modalSubmit' ).disabled = true;
                           	//A.one("#modalSubmit").attr('disabled', 'true');
                           	modal.render();
                           	modal.show();
                            return false; 
                         }
                         if ( A.one('#<portlet:namespace/>applicationStatus').val() == 'INVALID' ){
                         	submitForm();
                         	return false;
                         }
                           window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="validateCreateVcg" /></portlet:resourceURL>', 'json', 
                                    { 
                                         worImId: ${worImId},
                                         vcgAnId:"${vcgAn.vcgAnId}",
                                         vcg_veteranId: A.one('#<portlet:namespace/>use_found_0').val(),
                                         vcg_primaryId: getValidCg(1),
                                         vcg_secondaryId: getValidCg(2),
                                         vcg_secondaryTwoId: getValidCg(3)
                                   },
                                    function( data ){
                                               if ( data && data.form_ ){
                                                       var msg = "";
                                                       if ( data.errors || data.warnings ){
                                                              msg = "<div style='width:90%; padding-bottom:20px;' ></div>";                                      
                                                              if ( data.warnings ){
                                                                   msg = msg + "<div class='portlet-msg-info'><liferay-ui:message key='note-updates-result' /><ul>" + data.warnings +"</ul></div>";
                                                             }
                                                             if ( data.errors ){
                                                             		// A.one("#modalSubmit").attr('disabled', 'true');
                                                             		document.getElementById( 'modalSubmit' ).disabled = true;
                                                                   msg = msg + "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + data.errors +"</ul></div>";
                                                             } else {
                                                             	   //A.one("#modalSubmit").attr('disabled', 'false');
                                                             	   document.getElementById( 'modalSubmit' ).disabled = false;
                                                                   // msg = msg + '<a href="javascript:submitForm();" class="btn btn-primary icon-flag">&nbsp; <liferay-ui:message key="process-application" /></a>'
                                                             }
                                                           validationNotice.html( msg );
                                                           modal.render();
                                                       		modal.show();
                                                      } else {
                                                      		window.removeEventListener('beforeunload',preventUser);
                                                              document.forms['createVcg'].submit();    
                                                      }
                                               } else {
                                                       alert('error');
                                               }
                                         } 
                                  );
            			});
              	}
              
        window.preventUser = function() {
			return "<liferay-ui:message key='back-button-lose-form-data' />";
		}
		window.addEventListener('beforeunload', preventUser);
		
		A.all("#breadcrumbs a, .collapse nav-collapse, #cancelSearch").on('click', function(){
			window.removeEventListener('beforeunload',preventUser);
		});
              
              
              window.submitForm = function(){ 
	              window.removeEventListener('beforeunload',preventUser);
	              document.forms["createVcg"].submit(); 
              }
</aui:script>


<%@include file="/jsp/version.jsp" %>
