<%@ include file="init.jsp"%>
<style>
.messageCol {
width:70%;
}
</style>
<%
	List<PMMessage> messages = (List<PMMessage>) request.getAttribute(PMConstants.MESSAGES_LIST);
%>
	<portlet:actionURL var="messageActions">
		<portlet:param name="javax.portlet.action" value="doAction"/>
		<portlet:param name="action" value="messageActions"/>
		<portlet:param name="messageAction" value="inbox"/>
	</portlet:actionURL>

		
	<aui:script use="node" >
		A.all('.message-action').on(
	      'click',
	      function(e) {	
	    	    var messageAction = e.currentTarget.attr('id');
	    	    var messageId = e.currentTarget.attr('href');
	    	    if ( e.currentTarget.attr('name') == "Subject") {
	    	    	messageAction = "view-message";
	    	    	 A.one ('#<portlet:namespace/>messageId').val(messageId);
	    	    }
	    	    A.one ('#<portlet:namespace/>entry').val("INTERNAL_MESSAGE");
	       		A.one ('#<portlet:namespace/>messageAction').val(messageAction);
	       		document.forms["messageActions"].submit();
	      }
	    );
	</aui:script>

<div class="yui3-skin-sam">
    <div id="modal"></div>
</div>

<div id="mainTab">
 
<legend>
<div image="message" class="message"></div> View Responses

<span class="messageicon">
<liferay-ui:icon-menu>
		<liferay-ui:icon image="recent_changes" message="My Messages" url="${messageActions}"  />
		</liferay-ui:icon-menu>
</span>

<span class="messageicon">
<liferay-ui:icon-menu>
		<liferay-ui:icon image="message" message="compose" url="javascript:composeMessage();"  />
		</liferay-ui:icon-menu>
</span>
</legend>
</div>
	
<div>
	<div class="pageContent">
		<div style="width:100%;">
			<%
				String errorMessage = (String) request.getAttribute(PMConstants.ERROR_MESSAGE);
				if(errorMessage != null) {
			%>
				<div class="portlet-msg-error" style="width:95%;"><%=errorMessage%></div><br/>
			<%
					request.removeAttribute(PMConstants.ERROR_MESSAGE);
				}
			%>
			<%
				String infoMessage = (String) request.getAttribute(PMConstants.INFO_MESSAGE);
				if(infoMessage != null) {
			%>			
				<div class="portlet-msg-info" style="width:95%;"><%=infoMessage%></div><br/>
			<%
					request.removeAttribute(PMConstants.INFO_MESSAGE);
				}
			%>
		</div>	
		<div id="mailbox">
				<script type="text/javascript">
					var messageIds = new Array();
					var userIds = new Array();
				</script>
				
				<fieldset id="sectionCollapse1">
					<input type="hidden" id="type" name="type" value="delete" />
					<input type="hidden" id="ids" name="ids" value="" />
					<liferay-ui:search-container id="parentMessages"  curParam="parentMessages"  emptyResultsMessage="no-sub-messages">
					
					<liferay-ui:search-container-results results="<%=messages%>"  />
		
					<liferay-ui:search-container-row className="gov.va.caret.model.PMMessage" escapedModel="true" modelVar="message" >
					
					<% 
						String messageId = Long.toString(message.getMessageId());
						String ownerId = Long.toString(message.getOwnerId());
						String sentTo = message.getRecepients();
						SimpleDateFormat formatter=new SimpleDateFormat("MM/dd/yy HH:mm:ss a");
						String messageDate=formatter.format(message.getPostedDate());
						String embeddedUrl = message.getUrl().replace("amp;", "");
					%>
	
						<liferay-ui:search-container-column-text name="From" value="<%= message.getOwnerName()%>"/><!-- orderable="true" orderableProperty="type_" -->
						<liferay-ui:search-container-column-text name="Sent" cssClass="date" value="<%=messageDate%>" />
						<liferay-ui:search-container-column-text cssClass="messageCol" name="Message" value="<%=message.getBody()%>"/>
						<liferay-ui:search-container-column-jsp name="Action" cssClass="messageActionMenu" path="/jsp/im/viewMessageActions.jsp"></liferay-ui:search-container-column-jsp>
						</liferay-ui:search-container-row>
					
					<liferay-ui:search-iterator />
					</liferay-ui:search-container>
					
					</fieldset>
			</div>
		</div>
	</div>

<script>


</script>

<aui:script use="aui-tabview,aui-modal,aui-dropdown,aui-toggler,node-event-simulate">
  
	window.showMessage = function(messageId) {
		//A.one('.body'+messageId).setAttribute("colspan", 3);
		//A.one('.body'+messageId).toggleView();
		//A.one('.content'+messageId).toggleView();
		
		var $this = A.one('.showMessage'+messageId); 
	    var $content = A.one('.body'+messageId);
	    var linkText = $this.text().toUpperCase();    
	    
	    if(linkText === "SHOW MORE"){
	        linkText = "Show less";
	        $content.switchClass("minContent", "fullContent", 100);
	    } else {
	        linkText = "Show more";
	        $content.switchClass("fullContent", "minContent", 100);
	    };

	    $this.text(linkText);
  }
</aui:script>

