<%@ include file="/jsp/init.jsp" %>

<%@ page import="java.util.List"%>
<%@ page import="java.util.Set"%>
<%@ page import="java.util.Map"%>
<%@ page import="java.util.HashMap"%>

<%@ page import="java.util.Date"%>
<%@ page import="gov.va.caret.pm.util.PMConstants"%>
<%@ page import="gov.va.caret.pm.util.PMUtil"%>
<%@ page import="gov.va.caret.model.PMMessage"%>
<%@ page import="gov.va.caret.model.PMDeletedMessage"%>
<%@ page import="gov.va.caret.model.PMReadMessage"%>
<%@ page import="gov.va.caret.service.PMMessageLocalServiceUtil"%>
<%@ page import="gov.va.caret.service.PMDeletedMessageLocalServiceUtil"%>
<%@ page import="gov.va.caret.service.PMReadMessageLocalServiceUtil"%>
<%@ page import="java.text.DateFormat"%>
<%@ page import="java.text.SimpleDateFormat"%>
<%@ page import="com.liferay.portal.service.UserLocalServiceUtil"%>
<%@ page import="com.liferay.portal.model.User"%>
<%@ page import="com.liferay.portal.NoSuchUserException"%>
<%@ page import="com.liferay.portal.model.Group"%>
<%@ page import="com.liferay.portal.kernel.util.ParamUtil"%>
<%@ page import="com.liferay.portal.kernel.util.HtmlUtil"%>
<%@ page import="com.liferay.portal.kernel.dao.search.RowChecker" %>
<%@ page import="com.liferay.util.*" %>

<portlet:defineObjects />
<liferay-theme:defineObjects />

<%
	//long userId = themeDisplay.getUserId();
	String url = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/" + request.getContextPath();
	String cssURL = url + "/css";
	String jsURL = url + "/js";
	DateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm");
	List<User> allUsers = PMUtil.getAllUsers(renderRequest);
	List<Group> allCommunities = PMUtil.getAllCommunities(renderRequest);
%>

<portlet:renderURL var="inboxUrl">
	<portlet:param name="<%= PMConstants.ACTION %>" value="<%= PMConstants.INBOX_ACTION %>"/>
</portlet:renderURL>
<portlet:renderURL var="outboxUrl">
	<portlet:param name="<%= PMConstants.ACTION %>" value="<%= PMConstants.OUTBOX_ACTION %>"/>
</portlet:renderURL>
<portlet:renderURL var="trashUrl">
	<portlet:param name="<%= PMConstants.ACTION %>" value="<%= PMConstants.TRASH_ACTION %>"/>
</portlet:renderURL>
<portlet:renderURL var="composeUrl">
	<portlet:param name="<%= PMConstants.ACTION %>" value="<%= PMConstants.COMPOSE_ACTION %>"/>
</portlet:renderURL>
<portlet:renderURL var="addUrl">
	<portlet:param name="<%= PMConstants.ACTION %>" value="<%= PMConstants.ADD_ACTION %>"/>
</portlet:renderURL>
<portlet:renderURL var="replyUrl">
	<portlet:param name="<%= PMConstants.ACTION %>" value="<%= PMConstants.REPLY_ACTION %>"/>
</portlet:renderURL>
<portlet:renderURL var="deleteUrl">
	<portlet:param name="<%= PMConstants.ACTION %>" value="<%= PMConstants.DELETE_ACTION %>"/>
</portlet:renderURL>
<portlet:renderURL var="settingsUrl">
	<portlet:param name="<%= PMConstants.ACTION %>" value="<%= PMConstants.SETTINGS_ACTION %>"/>
</portlet:renderURL>

<script src="<%=request.getContextPath()%>/js/im/AutoComplete.js" type="text/javascript"></script>
<script src="<%=request.getContextPath()%>/js/im/util.js" type="text/javascript"></script>

<script type="text/javascript">

	var allSelected = 0;
	var replyToAllStr = "";
	var composeURL = "<%=composeUrl%>";
	var allUsers = "<%=PMConstants.ALL_USERS%>";

	function loadAllUsers(exclude) {
		var from = document.getElementById("select_from");
		from.options.length = 0;
		<%
		for(Group community : allCommunities) {
		%>
		var nextCommunity = '<%=community.getName().replaceAll("'", "\\\\'")%>';
		var newElem = document.createElement("option");
		newElem.text = nextCommunity;
		newElem.value =  "<%=PMConstants.ALL_MEMBERS + community.getGroupId()%>";
		from.options.add(newElem);
		<%
		}
		%>

		<%
			for(User u : allUsers) {
				if(!u.isDefaultUser()) {
					String userName	 = u.getFullName();
		%>
			var nextUsername = '<%=userName.replaceAll("'", "\\\\'")%>';
			if((nextUsername != exclude) && !alreadySelected(nextUsername)) {
				addUserToList(nextUsername, '<%=u.getUserId()%>');
			}
		<%
				}
			}
		%>
		
		sortListbox("select_from");
	}
	function selectAll() {
		for (var i = 0; i < messageIds.length; i++) {
			document.getElementById("message_" + messageIds[i]).checked = !allSelected;
		}
		allSelected = !allSelected;
	}

	function selectAllBlockedUsers() {
		for (var i = 0; i < blockedUserIds.length; i++) {
			document.getElementById("blocked_user_" + blockedUserIds[i]).checked = !allSelected;
		}
		allSelected = !allSelected;
	}
	
	function getSelectedMessages() {
		var entries = "";
		for (var i = 0; i < messageIds.length; i++) {
			var obj = document.getElementById("message_" + messageIds[i]);
			if (obj.checked) {
				entries += messageIds[i] + ";";
			}
		}
		if(entries == "") {
			alert("Please select messages");
			return false;
		}
		document.getElementById('ids').value = entries;
		return true;
	}
	
	function eraseSelectedMessages() {
		var entries = "";
		for (var i = 0; i < messageIds.length; i++) {
			var obj = document.getElementById("message_" + messageIds[i]);
			if (obj.checked) {
				entries += messageIds[i] + ";";
			}
		}
		if(entries == "") {
			alert("Please select messages");
			return false;
		}
		document.getElementById('type').value = 'erase';
		document.getElementById('ids').value = entries;
		return true;
	}

	function getSelectedUsers() {
		var entries = "";
		for (var i = 0; i < messageIds.length; i++) {
			var obj = document.getElementById("message_" + messageIds[i]);
			if (obj.checked) {
				entries += userIds[i] + ";";
			}
		}
		if(entries == "") {
			alert("Please select users");
			return false;
		}
		document.getElementById('type').value = 'block';
		document.getElementById('ids').value = entries;
		return true;
	}
	
	function getSelectedBlockedUsers() {
		var entries = "";
		for (var i = 0; i < blockedUserIds.length; i++) {
			var obj = document.getElementById("blocked_user_" + blockedUserIds[i]);
			if (obj.checked) {
				entries += blockedUserIds[i] + ";";
			}
		}
		if(entries == "") {
			alert("Please select users");
			return false;
		}
		document.getElementById('ids').value = entries;
		return true;
	}	
	
	function openCompose() {
		location.href = composeURL;
	}

	function addUser() {
		var from = document.getElementById("select_from");
		from.enabled = true;
		
		//if(from.disabled) {
			//alert("dis");
			//return;
		//}
		var to = document.getElementById("select_to");
		var toRemove = new Array();

		//	if All Users Selected then disable other options
		for(var i=0; i<from.options.length; i++) {
			if(from.options[i].selected && from.options[i].value == allUsers) {
				to.options.length = 0;
				var newElem = document.createElement("option");
				newElem.text = from.options[i].text;
				newElem.value = from.options[i].value;
				to.options.add(newElem);
				
				loadAllUsers();

				//from.disabled = true;

				removeOption("select_from", newElem.value);

				return;
			}
		}

		for(var i=0; i<from.options.length; i++) {
			if(from.options[i].selected) {
				var newElem = document.createElement("option");
				newElem.text = from.options[i].text;
				newElem.value = from.options[i].value;
				to.options.add(newElem);

				toRemove.push(newElem.value);
			}
		}

		for(var i=0; i<toRemove.length; i++) {
			removeOption("select_from", toRemove[i]);
		}
		
		sortListbox("select_from");
		sortListbox("select_to");
	}
	
	function removeUser() {
		var to = document.getElementById("select_from");
		var from = document.getElementById("select_to");
		var toRemove = new Array();

		for(var i=0; i<from.options.length; i++) {
			if(from.options[i].selected) {
				var newElem = document.createElement("option");
				newElem.text = from.options[i].text;
				newElem.value = from.options[i].value;
				to.options.add(newElem);

				toRemove.push(newElem.value);
				
				to.disabled = false;
			}
		}
		for(var i=0; i<toRemove.length; i++) {
			removeOption("select_to", toRemove[i]);
		}
		
		sortListbox("select_from");
		sortListbox("select_to");
	}

	function dh_onSubmit() {
		cleanErrors();

		var str = "";
		if(document.getElementById("subject").value == "") {
			showError("Please choose a category");
			return false;
		}
		var to = document.getElementById("select_to");
		if(to) {
			for(var i=0; i<to.options.length; i++) {
				str += to.options[i].value;
				if (i<to.options.length-1) {
					str += ",";
				}
			}
			if(str == "") {
				showError("Recepients not selected");
				return false;
			}
			document.getElementById("<portlet:namespace/>recepients").value = str;
			
			if(document.getElementById("body").value == "") {
				showError("Message body cannot be empty");
				return false;
			}
			
		}

		return true;
	}
	
	function removeRecepient(id) {
		document.getElementById("recepient_" + id).style.display = "none";
		var str = document.getElementById("recepients").value;
		str = str.replace(id, "");
		document.getElementById("recepients").value = str;
		return false;
	}

	function cleanErrors() {
		document.getElementById("_validationResult").innerHTML = "";
		//document.getElementById("error_div").style.display = "none";
	}
	
	function showError(message) {
		var msg = "<div class='portlet-msg-alert'><ul>" + message +"</ul></div>";
		document.getElementById("_validationResult").innerHTML = msg;
		//document.getElementById("error_div").style.display = "block";
		window.scroll(0, 0);
	}

	function removeOption(objId, str) {
		var obj = document.getElementById(objId);
		for(var i=0; i<obj.options.length; i++) {
			if(obj.options[i].value == str) {
				obj.remove(i);
				return;
			}
		}
	}
	
	function dh_replyTo(messageId) {
		document.getElementById("replyId").value = messageId;
		document.getElementById("reply_form").submit();
		return false;
	}
	
	function dh_delete(messageId) {
		if(confirm('Delete this message ?')) {
			document.getElementById("ids").value = messageId + ";";
			document.getElementById("delete_form").submit();
		}
		return false;
	}
	
	function showLeftSymbols() {
		var maxCount = 250;
		var enteredValue = document.getElementById('body').value;
		var enteredCount = enteredValue.length;
		var count = maxCount - enteredCount;
		if (enteredCount > maxCount-1) {
			document.getElementById('body').value = enteredValue.substring(0, maxCount);
			document.getElementById('chars_left').innerHTML = "Max character limit reached";
			
			document.getElementById('chars_left').style.color = "red";
		} else {
			document.getElementById('chars_left').innerHTML = count + " characters left";
			document.getElementById('chars_left').style.color = "blue";
		}
		return true;
	}

	function updateUsersBox() {
		loadAllUsers();

		var str = document.getElementById("find").value.toLowerCase();
		if(str != "") {
			var from = document.getElementById("select_from");
			var toRemove = new Array();
			for(var i=0; i<from.options.length; i++) {
				if(from.options[i].text.toLowerCase().indexOf(str) == -1) {
					toRemove.push(from.options[i].value);
				}
			}
			for(var i=0; i<toRemove.length; i++) {
				from = document.getElementById("select_from");
				removeOption("select_from", toRemove[i]);
			}
		}
	}
	
	function isAllUsersSelected() {
		var obj = document.getElementById("select_to");
		for(var i=0; i<obj.options.length; i++) {
			if(obj.options[i].value == allUsers) {
				return true;
			}
		}
		return false;
	}

	function alreadySelected(str) {
		var obj = document.getElementById("select_to");
		for(var i=0; i<obj.options.length; i++) {
			if(obj.options[i].text == str) {
				return true;
			}
		}
		return false;
	}

	function addUserToList(name, id) {
		var to = document.getElementById("select_to");
		for(var i=0; i<to.options.length; i++) {
			if(to.options[i].text == name) {
				return;
			}
		}
		var from = document.getElementById("select_from");
		var newElem = document.createElement("option");
		newElem.text = name;
		newElem.value = id;
		from.options.add(newElem);
	}

	function replyToAll() {
		document.getElementById("select_to").options.length = 0;
		loadAllUsers();
		var names = replyToAllStr.split(", ");
		var from = document.getElementById("select_from");
		for(var i=0; i<from.options.length; i++) {
			for(var j=0; j<from.options.length; j++) {
				if(from.options[j].text == names[i]) {
					from.options[j].selected = true;
					break;
				}
			}
		}
		addUser();
		return true;
	}

	function sortListbox(id) {
		var lb = document.getElementById(id);
		var arrTexts = new Array();
		var arrValues = new Array();
		var arrOldTexts = new Array();

		for(i=0; i<lb.length; i++) {
			arrTexts[i] = lb.options[i].text;
			arrValues[i] = lb.options[i].value;	
			arrOldTexts[i] = lb.options[i].text;
		}

		arrTexts.sort();

		for(i=0; i<lb.length; i++) {
			lb.options[i].text = arrTexts[i];
			for(j=0; j<lb.length; j++) {
				if (arrTexts[i] == arrOldTexts[j]) {
					lb.options[i].value = arrValues[j];
					j = lb.length;
				}
			}
		}
	}


</script>


<link rel="stylesheet"  media="screen" type="text/css" href="<%=request.getContextPath()%>/css/im/AutoComplete.css"/>
<link rel="stylesheet"  media="screen" type="text/css" href="<%=request.getContextPath()%>/css/im/style.css"/>

<form id="reply_form" action="<%=replyUrl%>" method="post">
	<input type="hidden" id="replyId" name="replyId" value = "" />
</form>