<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>

<%@include file="/jsp/init.jsp" %>


<div class="yui3-skin-sam">
    <div id="modal"></div>
</div>

<div class="yui3-skin-sam">
    <div id="modal0"></div>
</div>


<%@include file="/jsp/internal/menu.jsp" %>    

<%@include file="/jsp/internal/actionsSupport.jsp" %>  

<div id="mainTab">
  <ul class="nav nav-tabs">
    <li class="tab-click" ><a href="#tab-1"><div class="icon-icon-cogs"></div> ${role} Dashboard</a></li>
    <li class="tab-click" ><a href="#tab-2"><div class="icon-search"></div> Search</a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-1" class="tab-pane">
      	<div class="dashboard-top">
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse1">
			      	<legend class="header toggler-header-expanded"><div class="icon-bookmark"></div> <liferay-ui:message key="my-work-header" /></legend>
						<div class="content toggler-header-expanded" id="myWork" >
						</div>
				</fieldset>
      		
      		</div>
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse2">
		      		<legend class="header toggler-header-expanded window-overwrite"><div class="icon-comment"></div> Notifications</legend>
		      		<div class="content toggler-header-expanded" id="myNotes" >
	      			</div>
      			</fieldset>
      		</div>
      	</div>
    	
    	<fieldset id="sectionCollapse3" class="clear-both">
			<legend class="header toggler-header-expanded"><div class="icon-medkit"></div> <liferay-ui:message key="other-queues-header" /></legend>
			   <div id="midTabs" class="content toggler-header-expanded" >
					<ul class="nav nav-tabs">
			  			<li class="tab-click" ><a href="#failedTiuNote">Failed TIU Notes (${total_['failedTiuNote']})</a></li>
				  	</ul>
					<div class="tab-content">
    					<div id="failedTiuNote" class="window-overwrite tab-pane"></div>
					</div>
					
				</div>
		  </fieldset>
    	
    </div>

    <div id="tab-2" class="tab-pane">
    	<%@include file="/jsp/dashboard/techSearch.jsp" %>
	</div>
  </div>
</div>




<aui:script use="aui-tabview,aui-toggler">
  
	
	for ( i = 1 ; i < 4; i++ ){
	    new A.TogglerDelegate(
	      {
	        animated: true,
	        closeAllOnExpand: true,
	        container: '#sectionCollapse' + i ,
	        content: '.content',
	        expanded: (i < 3),
	        header: '.header',
	        transition: {
	          duration: 0.2,
	          easing: 'cubic-bezier(0, 0.1, 0, 1)'
	        }
	      }
	    );
	}
	 

var loadList = function(e, page) {
	  	if (!page){
	   		var href = e.currentTarget.getActiveTab().one('a').attr('href');
	  	   	page = href.substring(href.indexOf('#'));
		}
		var node = A.one( page );
	    if (node.hasClass('loaded-pane')){
	    	return false;
	    }
	
		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /></portlet:resourceURL>', 'html', 
			{ page: page },
			function( data ){
				overwrite( node, data );
			} 
		);
}

  window.careTmainTab = new A.TabView({
      srcNode: '#mainTab',
      type: 'pills'
    }
  );
  window.careTmainTab.render();
 
  window.midTabs = new A.TabView({
      srcNode: '#midTabs',
      type: 'pills',
        on: {
            click: function(e){ loadList(e); }
          }
     
    }
  );
  window.midTabs.render();
  
	A.on('domready', function( event ) {
   	try {
   		loadList(event,'#myWork');
   		loadList(event,'#myNotes');
   		A.one('#failedTiuNote').simulate('click');
   		A.all('.tab-click').attr('tabindex',0);
   	} catch (e){}
   });
  
</aui:script>

