<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>

<%@include file="/jsp/init.jsp" %>


<div class="yui3-skin-sam">
	<div id="modalCloseItem"></div>
</div>



<%@include file="/jsp/internal/menu.jsp" %>

<portlet:actionURL var="approvePaymentMonth">
	<portlet:param name="<%=ActionRequest.ACTION_NAME%>" value="doAction"/>
	<portlet:param name="action" value="approvePaymentMonth"/>
</portlet:actionURL>

<div id="mainTab">
  <ul class="nav nav-tabs">
    <li class="tab-click" ><a href="#tab-1"><div class="icon-briefcase"></div> ${role} Dashboard</a></li>
    <li class="tab-click" ><a href="#tab-2"><div class="icon-search"></div> Search</a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-1" class="tab-pane">
      	<div class="dashboard-top">
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapseCbopc1">
			      	<legend class="header"><div class="icon-bookmark"></div> Payments</legend>
			      	<div class="content" id="cbopcStipend" >
					</div>
				</fieldset>
      		</div>
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapseCbopc2">
		      		<legend class="header"><div class="icon-comment"></div> My Comments/Notes </legend>
		      		<div class="content" id="myNotes" >
	      			</div>
      			</fieldset>
      		</div>
      	</div>
    </div>

    <div id="tab-2" class="tab-pane">
		<%@include file="/jsp/internal/filter.jsp" %>
	</div>
	
	
  </div>

</div>



<portlet:actionURL var="saveFunds">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="saveFunds"/>
</portlet:actionURL>

<div id="saveFunds">
	<aui:form action="${saveFunds}" method="post" name="close_fm"  >
	
	
	<aui:field-wrapper inlineField="false" cssClass="disposition-process "  >
         <aui:input label="Add New Funds" name="funds" type="text"  />
    </aui:field-wrapper>
		
	</aui:form>
</div>

<aui:script use="aui-tabview,aui-modal,aui-dropdown,aui-toggler,node-event-simulate,anim">
	
	for ( i = 1 ; i < 3; i++ ){
	    new A.TogglerDelegate(
	      {
	        animated: true,
	        container: '#sectionCollapseCbopc' + i ,
	        content: '.content',
	        expanded: true,
	        header: '.header',
	        transition: {
	          duration: 0.2,
	          easing: 'cubic-bezier(0, 0.1, 0, 1)'
	        }
	      }
	    );
	}
    
    var loadList = function(e, page) {
	  	if (!page){
	   		var href = e.currentTarget.getActiveTab().one('a').attr('href');
	  	   	page = href.substring(href.indexOf('#'));
		}
		var node = A.one( page );
	    if (!node || node.hasClass('loaded-pane')){
	    	return false;
	    }
	
		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /></portlet:resourceURL>', 'html', 
			{ page: page },
			function( data ){
				overwrite( node, data );
			} 
		);
	}
    

  window.careTmainTab = new A.TabView({
      srcNode: '#mainTab',
      type: 'pills'
    }
  );
  window.careTmainTab.render();
  
  A.on('domready', function( event ) {
   	try {
   		loadList(event,'#cbopcStipend');
   		loadList(event,'#myNotes');
   		A.all('.tab-click').attr('tabindex',0);
   		if ("search" == "${caretMap_['tabContext']}" ){
   			window.careTmainTab.selectChild(1);
   			window.setTimeout(function(e){ A.one('#<portlet:namespace/>searchPerson').simulate('click'); }, 500);
			new A.Anim({
				duration: 0.5,
				easing: 'easeBoth',
				node: 'win',
				to: {
					scroll: [0, A.one("#searchContextPane").get('offsetTop')]
				}
			}).run();			
   		}
   	} catch (e){}
   });
   
   
   
   /////--------------------------------------
	
	
	window.markClosed = function(src,context) {
		modalMarkClosed.render();
		modalMarkClosed.show();
		A.one('#<portlet:namespace/>worImId3').val(src);
		A.one('#<portlet:namespace/>context3').val(context);
	}

	var modalMarkClosed = new A.Modal(
			{
				headerContent : '<h4><liferay-ui:message key="Add New OCC Funds" /></h4>',
				bodyContent : A.one("#saveFunds"),
				centered : true,
				destroyOnHide : false,
				modal : true,
				render : '#modalCloseItem',
				resizable : {
					handles : 'b, r'
				},
				visible : false,
				width : 650
			});

	modalMarkClosed.addToolbar([ {
		label : 'Cancel',
		on : {
			click : function() {
				modalMarkClosed.hide();
			}
		}
	}, {
		label : 'Update',
		on : {
			click : function() {
				validateFields( function ( message ) {
		    		var validationNotice = A.one ('#_validationResult');
			    		if ( message.length > 0 ){
		    				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
		    				validationNotice.html(msg);
		    				modalMarkClosed.footerNode.insert(validationNotice);
				    		return false;	
			    		}
			    		window.escapePrevent();
			    		A.one("#<portlet:namespace/>close_fm").submit();
		    	}, '#saveFunds');
			}
		}
	} ]);

	/////--------------------------------------
  
</aui:script>


