
window.loadUpload = function ( allowedFileTypes, container, maxFileSize, 
		namespace, uploadFileUrl, multipleFiles, callback ){
}

window.caretIo = function ( url, dataType, data, callBack, onFail, hidden ){
	// start wait popup 
	AUI().use('aui-io-request', function(A){
		var loading = A.one('#_caret_WAR_caretportlet_loadingIndicator');
		A.io.request( url,
				{
		  			  method: 'POST',
		  			  dataType: dataType,
		  			  data: data,
		  	  		  on: {
		  	  			  start: function (){
		  	  				  if ( loading ){
		  	  					  if ( !hidden ){
		  	  						  loading.html('<div class="bound-animation"><div class="loading-animation"></div></div>');
		  	  						  loading.show();
		  	  					  }
		  	  				  }
		  	  			  },
		  				  success: function() {
		  					  if ( loading ){
	  	  						 loading.hide();
		  	  				  } 
		  					  callBack( this.get('responseData') );
		  				  },
						  fail: function (){
							  if ( loading ){
	  	  						 loading.hide();
		  	  				  } 
							  onFail ( this.get('responseData') );
						  }
		  			  }
		  		}
		  	);
	} );
}

window.enforceFormats = function (){
  
  
  AUI().use('aui-datatype-date-parse,node-event-simulate', function(A){
	  
	  
	A.all('.date-field').on('focus', function(e){
		var node = e.currentTarget;
		if (node.val() == 'MM/DD/YYYY') {
			node.val('');
		}
	});
	  
    A.all('.date-field').on('blur', function(e){
    	var node = e.currentTarget;
    	if (node.val() == '') {
    		node.val('MM/DD/YYYY');
    	}
	});
    
    A.all('.date-field').each(function(e){
    	if (this.val() == '') {
    		this.val('MM/DD/YYYY');
    	}
	});
	
    var minYear = 1900;
    var maxYear = new Date().getFullYear() + 1;
	A.all('.date-field').on('change', function(e){
		var node = e.currentTarget;
		  var val = '';
		  var val0 = '';
		  var str = node.val();
		  var arr = str.split("/");
		  if ( arr.length == 3 ){
			  for ( var i = 0; i < arr.length; i++ ){
				  if ( arr[i].length == 1 ){
					  arr[i] = '0' + arr[i];
				  }
			  }
			  str = arr[0] + arr[1] + arr[2];
		  }
		  
		  var stripped = (""+str ).replace(/\W/g, '');
		  var day, month, year;
		  var hundred = 0;
		  
		  var parts = stripped.match(/^(\d{2})(\d{2})(\d{4})$/);
		  if (!parts){
			  parts = stripped.match(/^(\d{2})(\d{2})(\d{2})$/);
			  if ( parts ){
				  var d = new Date();
				  var n = d.getFullYear();
				  if ( n < ( 1998 + parseInt ( parts[3], 10 ) ) ){
					  hundred = 1900;
				  } else {
					  hundred = 2000;
				  }
			  }
		  }

		  if ( parts ){
			  month = parts[1];
			  day = parts[2];
			  year = hundred + parseInt ( parts[3], 10 );
			  var d = new Date ( year, (parseInt ( month, 10 ) -1), day );
			  if ( year > maxYear || minYear > year || year != d.getFullYear() || parseInt( month, 10) != d.getMonth()+1 || parseInt ( day, 10 ) != d.getDate() ){
				  val = '';
			  } else {
				  val = month + '/' + day + '/' + year;
			  }

		  } else {
			  val = '';
		  }
		 
		  node.val(val);
	});
	
		A.all('.tab-click').on('keydown',function(e){
			if ( e.keyCode == 13 ){
				A.one(e.currentTarget).simulate('click');
			}
		});
		
		A.all('.tab-click').on('focus',function(e){
			A.one(e.currentTarget).simulate('mouseover');
		});
		
		A.all('.tab-click').on('blur',function(e){
			A.one(e.currentTarget).simulate('mouseout');
		});
		
		A.all('.yui3-uploader-focused').on('keydown', function(e){
     		if ( e.keyCode == 13 ){
				A.one(e.currentTarget).simulate('click');
			}
     	});

  });
  


  AUI().use('aui-node', function(A){
	  
	  A.all('.phone-field').on('focus', function(e){
			var node = e.currentTarget;
			if (node.val() == '(###) ###-####') {
				node.val('');
			}
		});
		  
	    A.all('.phone-field').on('blur', function(e){
	    	var node = e.currentTarget;
	    	if (node.val() == '') {
	    		node.val('(###) ###-####');
	    	}
		});
	    
	    A.all('.phone-field').each(function(e){
	    	if (this.val() == '') {
	    		this.val('(###) ###-####');
	    	}
		});
	  
	A.all('.phone-field').on('change', function(e){
		  var node = e.currentTarget;
		  var val = '';
		  try {
			  var stripped = (""+node.val()).replace(/\D/g, '');
			  var parts = stripped.match(/^(\d{3})(\d{3})(\d{4})$/);
			  if (parts){
				  val = "(" + parts[1] + ") " + parts[2] + "-" + parts[3];
			  }
			  
		  }catch(i){};
		  node.val(val);
	});
	
	 A.all('.ssn-field').on('focus', function(e){
			var node = e.currentTarget;
			if (node.val() == '###-##-####') {
				node.val('');
			}
		});
		
	    A.all('.ssn-field').on('blur', function(e){
	    	var node = e.currentTarget;
	    	if (node.val() == '') {
	    		node.val('###-##-####');
	    	}
		});
	    
	    A.all('.ssn-field').each(function(e){
	    	if (this.val() == '') {
	    		this.val('###-##-####');
	    	}
		});
  
	A.all('.ssn-field').on('change', function(e){
		  var node = e.currentTarget;
		  var val = '';
		  try {
			  var stripped = (""+node.val()).replace(/\D/g, '');
			  var parts = stripped.match(/^(\d{3})(\d{2})(\d{4})$/);
			  if (parts){
				  val = parts[1] + "-" + parts[2] + "-" + parts[3];
			  }
		  }catch(i){};
		  node.val(val);
	});
	
	
	 A.all('.email-field').on('focus', function(e){
			var node = e.currentTarget;
			if (node.val() == '[USERNAME]@[DOMAIN]') {
				node.val('');
			}
		});
		
	    A.all('.email-field').on('blur', function(e){
	    	var node = e.currentTarget;
	    	if (node.val() == '') {
	    		node.val('[USERNAME]@[DOMAIN]');
	    	}
		});
	    
	    A.all('.email-field').each(function(e){
	    	if (this.val() == '') {
	    		this.val('[USERNAME]@[DOMAIN]');
	    	}
		});
	
	A.all('.email-field').on('change', function(e){
		  var node = e.currentTarget;
		  var val = '';
		  try {
			  /** regex source - http://stackoverflow.com/questions/46155/validate-email-address-in-javascript  **/
			  var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
			  val = node.val().trim(); //.replace(/\s/g, "");
			  if (! re.test( val ) ){
			  	  val = '[USERNAME]@[DOMAIN]';
			  }
		  }catch(i){};
		  node.val(val);
	});
  });
}


window.escapePrevent = function(){
	if ( window.preventUser ){ 
		window.removeEventListener('beforeunload', preventUser); 
	}
}



window.enforceFormats();


window.overwrite = function( node, data ){
	AUI().use('aui-parse-content', function(A){
		if ( data ){
			node.plug( A.Plugin.ParseContent );
			node.setContent( data );
		}
		if ( !node.hasClass('loaded-pane') ){
	    	node.addClass('loaded-pane');
		}
		node.all('.table-sort-liner a, .lfr-menu-list a, .lfr-pagination-buttons a').on('click', function(e){
			if ( e.currentTarget.ancestorsByClassName('direction-left').size() > 0 ){ 
				return;
			}
			e.preventDefault();
			var href = e.currentTarget.attr('href');
			window.caretIo( href, 'html', {}, function( data2 ){ overwrite( node, data2 ); });
			return false;
		});
	});
}

window.openUspsPopup = function( pAddress, pState, pCity, pZip ){
	if ( pAddress.length == 0 || pState.indexOf ('Select') >= 0 || pCity.indexOf ('Select') >= 0 || pZip.length <= 1 ){
		return false;
	}

	window.open('https://tools.usps.com/go/ZipLookupResultsAction!input.action?resultMode=1&companyName=&address1='+pAddress+
			'&address2=&city='+pCity+'&state='+pState+'&urbanCode=&postalCode=&zip='+pZip,
			'newwindow', 'location=0, status=0, resizable=1, scrollbars=1, width=600, height=600'); 
	return true;
}


/*


AUI().use('node', function(A){
	A.getWin().on('beforeunload', function (event, data) {
	  var direction = data.state.direction;
	  console.log(direction);
	  if (direction == 'back') {
	    console.log('going back');
	    alert('back');
	  }
	  if (direction == 'forward') {
		  console.log('going forward');
		  alert('forward');
	  }
	});
});
*/

