package gov.va.caret.util.test;

import java.text.ParseException;
import java.util.Date;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import gov.va.caret.model.support.Person;
import gov.va.caret.util.Toolbox;
import junit.framework.TestResult;

public class CaretUtilTest extends org.junit.Assert implements junit.framework.Test  {

	@Test
	public void testDecode() {
		assertTrue ( "130 Metairie Rd".equals( Toolbox.decode("130%20METAIRIE%20RD", true) ) );
		assertTrue ( "TX".equals( Toolbox.decode("TX", false) ) );
		assertTrue ( "USA".equals( Toolbox.decode("USA", false) ) );
		assertTrue ( "Aiden".equals( Toolbox.decode("AIDEN", true) ) );
		assertTrue ( "Los Angeles".equals( Toolbox.decode("LOS%20ANGELES", true) ) );
		assertTrue ( "".equals( Toolbox.decode("NOT_FOUND", true) ) );
	}
	@Test
	public void testFormatDatePdf() {
		assertTrue( birthday instanceof java.util.Date );
		assertTrue ( "03-03-1988".equals( Toolbox.formatDatePdf( birthday ) ) );
	}
	@Test
	public void testParseHeaderDate() throws ParseException {
		assertTrue( birthday instanceof java.util.Date );
		assertTrue ( "03/03/88".equals( Toolbox.formatDate( birthday ) ) );
	}
	@Test
	public void testFormatDateOrient() {
		assertTrue( birthday instanceof java.util.Date );
		assertTrue ( "19680730".equals( Toolbox.formatDateOrient( birthday2 ) ) );
	}
	@Test
	public void testFormatDateCprs() {
		assertTrue( birthday instanceof java.util.Date );
		assertTrue ( "07/30/1968".equals( Toolbox.formatDateCprs( birthday2 ) ) );
	}
	@Test
	public void testFormatZip() {
		String zip = Toolbox.formatBigZip( "392" );
		assertTrue("00392".equals(zip));
	}
	@Test
	public void testFormatBigZip() {
		String zip = Toolbox.formatBigZip( "77743-0092" );
		assertTrue("77743".equals(zip));
		zip = Toolbox.formatBigZip( "6674392" );
		assertTrue("66743".equals(zip));
	}
	@Test
	public void testFormatSsn() {
		String ssn = "999887766";
		assertTrue ( "999-88-7766".equals( Toolbox.formatSsn(ssn) ) );
	}
	@Test
	public void testIsEmpty() {
		assertTrue( Toolbox.isEmpty( ( Toolbox.decode("NOT_FOUND", true) ) ) );
		assertTrue( Toolbox.isEmpty( ( Toolbox.decode("NOT_FOUND_EMAIL", true) ) ) );
		assertTrue( Toolbox.isEmpty( ( Toolbox.decode("NAME_NOT_FOUND", true) ) ) );
		assertTrue( Toolbox.isEmpty( Toolbox.parseEmail( Person.EMAIL_FORMAT ) ) );
		assertTrue( Toolbox.isEmpty( Toolbox.parsePhone( Person.PHONE_FORMAT ) ) );
	}
	@Test
	public void testParsePhone() {
		assertTrue( Toolbox.isEmpty( Toolbox.parsePhone( Person.PHONE_FORMAT ) ) );
		assertTrue( "(666) 777-9900".equals( Toolbox.parsePhone( "6667779900" ) ) );
	}
	@Test
	public void testParseEmail() {
		assertTrue( Toolbox.parseEmail( Person.EMAIL_FORMAT ).equals( "" ) );
		assertTrue( Toolbox.parseEmail( "first.last@a.gov" ).equals( "first.last@a.gov" ) );
	}
//-----------------------------------------------------------------------------------------------------------	
	@Before
	public void setUp() {
		try{
			System.out.println(">>>Toolbox Test SET UP");
			
			birthday = (Date)Toolbox.getDateFormatVaafi().parseObject( birthdayHeader1 );
			birthday2 = (Date)Toolbox.getDateFormatVaafi().parseObject( birthdayHeader2 );
			
		}catch(Exception ex){
			ex.printStackTrace();
			fail("Init failed...");
		}
	}

	String birthdayHeader1 = "1988-03-3T00:00:00-00:00";
	String birthdayHeader2 = "1968-07-30T00:00:00-00:00";
	Date birthday;
	Date birthday2;
	
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}
	public int countTestCases() {
		return 11;
	}
	public void run(TestResult result) {
	}
// TODO: more functions to test...
//	@Test
//	public void testGetUrlQuery() {
//		assertTrue(true);
//	}
//	@Test
//	public void testAdjustDate() {
//		assertTrue(true);
//	}
//
//	@Test
//	public void testAdjustBusinessDate() {
//		assertTrue(true);
//	}
	
//
}
