package gov.va.oit.oed.vaww;

import static java.nio.charset.StandardCharsets.ISO_8859_1;
import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.caret.util.TemplateHandler;
import gov.va.caret.util.Toolbox;


public class UnattendedService extends AttendedService {
	
	private static Log _log = LogFactoryUtil.getLog( UnattendedService.class );

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public void testMvi () throws IOException, ParserConfigurationException, SAXException, TransformerException {
		Map props = new Properties();
		((Properties)props).load(UnattendedService.class.getClassLoader().getResourceAsStream("form.properties"));
		_log.info("using form.properties params");
		searchUnattended( props );
	}
	
	public Map<String,Object> searchUnattended ( Map<String,Object> map ) throws IOException, ParserConfigurationException, SAXException, TransformerException {
		
		_log.info("callMVI()");
		String loadedTemplate = null;
		
		_log.info("using map params");
		loadedTemplate = new TemplateHandler().loadTemplate( optimizeSearchParams(map), "/gov/va/oit/oed/vaww/templates", "unattended.ftl" );
		_log.info("template loaded");
		
		Map<String,Object> person = null;
		if ( loadedTemplate != null ){
			_log.info("calling mvi");
			Object obj = new VAIdM().getVAIdMPort().prpaIN201305UV02( new String(loadedTemplate.getBytes(ISO_8859_1), UTF_8) );
			_log.info("finished mvi");
			
			person = translateMap( obj );
			_log.info("finished parsing");
			if ( person != null && Toolbox.nullSafe( person.get("lastName") ).isEmpty() ){
				return Collections.emptyMap();
			}
		}
		return person;
	}
	
	public Document getDocument ( Node node ) throws TransformerException, SAXException, IOException, ParserConfigurationException {
		StringWriter writer = new StringWriter();
		Transformer transformer = TransformerFactory.newInstance().newTransformer();
		transformer.transform(new DOMSource(node), new StreamResult(writer));

		InputSource inputSource = new InputSource(new StringReader(writer.toString()));
		DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
		documentBuilderFactory.setNamespaceAware(true);
		return documentBuilderFactory.newDocumentBuilder().parse(inputSource);
	}
	

	private Map<String,Object> translateMap ( Object obj ) throws ParserConfigurationException, SAXException, IOException, TransformerException{
		Document doc = null;
		if ( obj instanceof Node ){
			doc = getDocument ( (Node) obj );
		} else {
			_log.error("unable to parse response...");
			return null;
		}
		Map<String,Object> personMap = new HashMap<String,Object>();
        try {
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            xpath.setNamespaceContext(new UnattendedNameSpaceContext());
            	
            Properties props = new Properties();
			props.load(UnattendedService.class.getClassLoader().getResourceAsStream("unattended.properties"));
			
			String acknowledgement = getValue( doc, xpath, String.valueOf( props.get("acknowledgement") ) );
			_log.info("acknowledgement is " + acknowledgement);
			if ( "AE".equals(acknowledgement) || "AR".equals(acknowledgement) ){
				_log.warn("MVI Service ERROR");
				return null;
			}
			
			java.util.Map<String,String> nodeListMap = new java.util.HashMap<String,String>();
			String nodeListExpr = null;
			for ( Object key: props.keySet() ){
				if ( key.toString().startsWith("NodeList_") ){
					if ( "NodeList_".equals(key) ){
						nodeListExpr = props.get(key).toString();
					} else {
						nodeListMap.put( key.toString(), props.get(key).toString() );
					}
					continue;
				}
				String value = getValue( doc, xpath, String.valueOf( props.get(key) ) );
				personMap.put( String.valueOf(key), normalize( (String)key, value)  );
				_log.info( "Person "+ key + " Value: " + value );
			}
			if ( !Toolbox.isEmpty( nodeListExpr ) && !nodeListMap.isEmpty() ){
				setIdValues( doc, xpath, nodeListExpr, nodeListMap, personMap );
			}
			return personMap; 
        } catch ( IOException e ) {
            e.printStackTrace();
        }
		return null;
    }
}
