package gov.va.ee.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

import javax.xml.ws.BindingProvider;

import gov.va.caret.soap.util.HeaderHandlerResolver;
import gov.va.caret.util.CaretUtil;
import gov.va.ee.EeSummaryPort;
import gov.va.ee.EeSummaryPortService;
import gov.va.ee.GetEESummaryRequest;
import gov.va.ee.GetEESummaryResponse;
import gov.va.iam.esig.dss.Exception_Exception;

public class EeService {

	public final static String appId = "200CARE";
	final static String reason = "Approve";
	final static String fileName = "10-10CG.pdf";
	
	private EeService(){}
	
	private static EeSummaryPort getEeSummaryPort(){
		
		EeSummaryPortService eeSummaryPortService = null;
		try {
			eeSummaryPortService = new EeSummaryPortService(new URL(CaretUtil.getEEWsdlocation()));
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		HeaderHandlerResolver handlerResolver = new HeaderHandlerResolver();
		//eeSummaryPortService.addPort("eeSummaryPortSoap11", "eeSummaryPortSoap11", "http://DNS.URL:PORT/esr-ws/spring-ws/getEESummary/");
		eeSummaryPortService.setHandlerResolver(handlerResolver);
		EeSummaryPort eeSummaryPort = eeSummaryPortService.getEeSummaryPortSoap11();
		return eeSummaryPort;
	}
	
	public static GetEESummaryResponse getEESummary(GetEESummaryRequest getEESummaryRequest) throws Exception_Exception{
		return getEeSummaryPort().getEESummary(getEESummaryRequest);
	}
}
