package gov.va.caret.service.vetscanner;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.service.PersnLocalServiceUtil;

public class VetScanner implements MessageListener {

	final long COMPANY_ID = PortalUtil.getDefaultCompanyId();
	public static Log log = LogFactoryUtil.getLog( VetScanner.class );
	
	@Override
	public void receive(Message arg0) throws MessageListenerException {

		log.info("VetScanner--->VETERAN SCANNER BEGIN " + new Date().toString());
		try {
			//get all verteran users that are NOT deceased.
			ExecutorService exec = Executors.newFixedThreadPool(15);
			long veteranRoleId = getRoleIdByName("Veteran");
			List<User> veterans = UserLocalServiceUtil.getRoleUsers(veteranRoleId);
			for (Iterator<User> users = veterans.iterator(); users.hasNext();)
			{
				User user = users.next();
				Veteran caret_person = new Veteran (PersnLocalServiceUtil.getByUser(user.getUserId()) );
				if (caret_person.getICN() != null && caret_person.getDeceasedDate() == null ) { 
					if (caret_person.isPrimaryAvailable()) {
						log.info("VetScanner--->Veteran (persnid:" + caret_person.getPersnId() + ",userid:" + caret_person.getUserId() + ") queued for processing");
						VetScanWorker vsw = new VetScanWorker(caret_person);
						exec.submit(vsw);
					}
					
				}
				
			}
			exec.shutdown();
			try {
				exec.awaitTermination(120, TimeUnit.MINUTES);//give it two hours to finish doing what it is doing
			} catch (InterruptedException e) {
			  
			}
			
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}

		log.info("VETERAN SCANNER END " + new Date().toString());

		
	}

	public long getRoleIdByName(String roleName) throws Exception {
	    if (roleName != null && !roleName.isEmpty()) {
	        for (Role role : RoleLocalServiceUtil.getRoles(0, RoleLocalServiceUtil.getRolesCount())) {
	            if (role.getName().equals(roleName)) {
	                return role.getRoleId();
	            }
	        }
	    }
	    return -1;
	}
	
}
