package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchWorImException;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.WorImImpl;
import gov.va.caret.model.impl.WorImModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * The persistence implementation for the wor im service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see WorImPersistence
 * @see WorImUtil
 * @generated
 */
public class WorImPersistenceImpl extends BasePersistenceImpl<WorIm>
    implements WorImPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link WorImUtil} to access the wor im persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = WorImImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, WorImImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, WorImImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_TYPE = new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, WorImImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByType",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TYPE = new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, WorImImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByType",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName()
            },
            WorImModelImpl.CLASSPK_COLUMN_BITMASK |
            WorImModelImpl.CLASSID_COLUMN_BITMASK |
            WorImModelImpl.TYPE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_TYPE = new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByType",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName()
            });
    private static final String _FINDER_COLUMN_TYPE_CLASSPK_2 = "worIm.classPk = ? AND ";
    private static final String _FINDER_COLUMN_TYPE_CLASSID_2 = "worIm.classId = ? AND ";
    private static final String _FINDER_COLUMN_TYPE_TYPE_1 = "worIm.type IS NULL";
    private static final String _FINDER_COLUMN_TYPE_TYPE_2 = "worIm.type = ?";
    private static final String _FINDER_COLUMN_TYPE_TYPE_3 = "(worIm.type IS NULL OR worIm.type = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPTYPES =
        new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, WorImImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupTypes",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName(), Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPTYPES =
        new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, WorImImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupTypes",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName(), Long.class.getName()
            },
            WorImModelImpl.CLASSPK_COLUMN_BITMASK |
            WorImModelImpl.CLASSID_COLUMN_BITMASK |
            WorImModelImpl.TYPE_COLUMN_BITMASK |
            WorImModelImpl.GROUPID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPTYPES = new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupTypes",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName(), Long.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_COUNT_BY_GROUPTYPES =
        new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByGroupTypes",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName(), Long.class.getName()
            });
    private static final String _FINDER_COLUMN_GROUPTYPES_CLASSPK_2 = "worIm.classPk = ? AND ";
    private static final String _FINDER_COLUMN_GROUPTYPES_CLASSPK_5 = "(" +
        removeConjunction(_FINDER_COLUMN_GROUPTYPES_CLASSPK_2) + ")";
    private static final String _FINDER_COLUMN_GROUPTYPES_CLASSID_2 = "worIm.classId = ? AND ";
    private static final String _FINDER_COLUMN_GROUPTYPES_CLASSID_5 = "(" +
        removeConjunction(_FINDER_COLUMN_GROUPTYPES_CLASSID_2) + ")";
    private static final String _FINDER_COLUMN_GROUPTYPES_TYPE_1 = "worIm.type IS NULL AND ";
    private static final String _FINDER_COLUMN_GROUPTYPES_TYPE_2 = "worIm.type = ? AND ";
    private static final String _FINDER_COLUMN_GROUPTYPES_TYPE_3 = "(worIm.type IS NULL OR worIm.type = '') AND ";
    private static final String _FINDER_COLUMN_GROUPTYPES_TYPE_4 = "(" +
        removeConjunction(_FINDER_COLUMN_GROUPTYPES_TYPE_1) + ")";
    private static final String _FINDER_COLUMN_GROUPTYPES_TYPE_5 = "(" +
        removeConjunction(_FINDER_COLUMN_GROUPTYPES_TYPE_2) + ")";
    private static final String _FINDER_COLUMN_GROUPTYPES_TYPE_6 = "(" +
        removeConjunction(_FINDER_COLUMN_GROUPTYPES_TYPE_3) + ")";
    private static final String _FINDER_COLUMN_GROUPTYPES_GROUPID_2 = "worIm.groupId = ?";
    private static final String _FINDER_COLUMN_GROUPTYPES_GROUPID_5 = "(" +
        removeConjunction(_FINDER_COLUMN_GROUPTYPES_GROUPID_2) + ")";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_USERTYPE = new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, WorImImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserType",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName(), Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERTYPE =
        new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, WorImImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserType",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName(), Long.class.getName()
            },
            WorImModelImpl.CLASSPK_COLUMN_BITMASK |
            WorImModelImpl.CLASSID_COLUMN_BITMASK |
            WorImModelImpl.TYPE_COLUMN_BITMASK |
            WorImModelImpl.USERID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_USERTYPE = new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserType",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName(), Long.class.getName()
            });
    private static final String _FINDER_COLUMN_USERTYPE_CLASSPK_2 = "worIm.classPk = ? AND ";
    private static final String _FINDER_COLUMN_USERTYPE_CLASSID_2 = "worIm.classId = ? AND ";
    private static final String _FINDER_COLUMN_USERTYPE_TYPE_1 = "worIm.type IS NULL AND ";
    private static final String _FINDER_COLUMN_USERTYPE_TYPE_2 = "worIm.type = ? AND ";
    private static final String _FINDER_COLUMN_USERTYPE_TYPE_3 = "(worIm.type IS NULL OR worIm.type = '') AND ";
    private static final String _FINDER_COLUMN_USERTYPE_USERID_2 = "worIm.userId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_VCGID = new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, WorImImpl.class,
            FINDER_CLASS_NAME_ENTITY, "fetchByVcgId",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName()
            },
            WorImModelImpl.VCGID_COLUMN_BITMASK |
            WorImModelImpl.CAREGIVERID_COLUMN_BITMASK |
            WorImModelImpl.STATUS_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_VCGID = new FinderPath(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByVcgId",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                String.class.getName()
            });
    private static final String _FINDER_COLUMN_VCGID_VCGID_2 = "worIm.vcgId = ? AND ";
    private static final String _FINDER_COLUMN_VCGID_CAREGIVERID_2 = "worIm.caregiverId = ? AND ";
    private static final String _FINDER_COLUMN_VCGID_STATUS_1 = "worIm.status IS NULL";
    private static final String _FINDER_COLUMN_VCGID_STATUS_2 = "worIm.status = ?";
    private static final String _FINDER_COLUMN_VCGID_STATUS_3 = "(worIm.status IS NULL OR worIm.status = '')";
    private static final String _SQL_SELECT_WORIM = "SELECT worIm FROM WorIm worIm";
    private static final String _SQL_SELECT_WORIM_WHERE = "SELECT worIm FROM WorIm worIm WHERE ";
    private static final String _SQL_COUNT_WORIM = "SELECT COUNT(worIm) FROM WorIm worIm";
    private static final String _SQL_COUNT_WORIM_WHERE = "SELECT COUNT(worIm) FROM WorIm worIm WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "worIm.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No WorIm exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No WorIm exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(WorImPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray(new String[] {
                "type"
            });
    private static WorIm _nullWorIm = new WorImImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<WorIm> toCacheModel() {
                return _nullWorImCacheModel;
            }
        };

    private static CacheModel<WorIm> _nullWorImCacheModel = new CacheModel<WorIm>() {
            @Override
            public WorIm toEntityModel() {
                return _nullWorIm;
            }
        };

    public WorImPersistenceImpl() {
        setModelClass(WorIm.class);
    }

    /**
     * Returns all the wor ims where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @return the matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findByType(long classPk, long classId, String type)
        throws SystemException {
        return findByType(classPk, classId, type, QueryUtil.ALL_POS,
            QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the wor ims where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param start the lower bound of the range of wor ims
     * @param end the upper bound of the range of wor ims (not inclusive)
     * @return the range of matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findByType(long classPk, long classId, String type,
        int start, int end) throws SystemException {
        return findByType(classPk, classId, type, start, end, null);
    }

    /**
     * Returns an ordered range of all the wor ims where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param start the lower bound of the range of wor ims
     * @param end the upper bound of the range of wor ims (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findByType(long classPk, long classId, String type,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TYPE;
            finderArgs = new Object[] { classPk, classId, type };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_TYPE;
            finderArgs = new Object[] {
                    classPk, classId, type,
                    
                    start, end, orderByComparator
                };
        }

        List<WorIm> list = (List<WorIm>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (WorIm worIm : list) {
                if ((classPk != worIm.getClassPk()) ||
                        (classId != worIm.getClassId()) ||
                        !Validator.equals(type, worIm.getType())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(5 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(5);
            }

            query.append(_SQL_SELECT_WORIM_WHERE);

            query.append(_FINDER_COLUMN_TYPE_CLASSPK_2);

            query.append(_FINDER_COLUMN_TYPE_CLASSID_2);

            boolean bindType = false;

            if (type == null) {
                query.append(_FINDER_COLUMN_TYPE_TYPE_1);
            } else if (type.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_TYPE_TYPE_3);
            } else {
                bindType = true;

                query.append(_FINDER_COLUMN_TYPE_TYPE_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(WorImModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classPk);

                qPos.add(classId);

                if (bindType) {
                    qPos.add(type);
                }

                if (!pagination) {
                    list = (List<WorIm>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<WorIm>(list);
                } else {
                    list = (List<WorIm>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching wor im
     * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm findByType_First(long classPk, long classId, String type,
        OrderByComparator orderByComparator)
        throws NoSuchWorImException, SystemException {
        WorIm worIm = fetchByType_First(classPk, classId, type,
                orderByComparator);

        if (worIm != null) {
            return worIm;
        }

        StringBundler msg = new StringBundler(8);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("classPk=");
        msg.append(classPk);

        msg.append(", classId=");
        msg.append(classId);

        msg.append(", type=");
        msg.append(type);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchWorImException(msg.toString());
    }

    /**
     * Returns the first wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching wor im, or <code>null</code> if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm fetchByType_First(long classPk, long classId, String type,
        OrderByComparator orderByComparator) throws SystemException {
        List<WorIm> list = findByType(classPk, classId, type, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching wor im
     * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm findByType_Last(long classPk, long classId, String type,
        OrderByComparator orderByComparator)
        throws NoSuchWorImException, SystemException {
        WorIm worIm = fetchByType_Last(classPk, classId, type, orderByComparator);

        if (worIm != null) {
            return worIm;
        }

        StringBundler msg = new StringBundler(8);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("classPk=");
        msg.append(classPk);

        msg.append(", classId=");
        msg.append(classId);

        msg.append(", type=");
        msg.append(type);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchWorImException(msg.toString());
    }

    /**
     * Returns the last wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching wor im, or <code>null</code> if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm fetchByType_Last(long classPk, long classId, String type,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByType(classPk, classId, type);

        if (count == 0) {
            return null;
        }

        List<WorIm> list = findByType(classPk, classId, type, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the wor ims before and after the current wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param worImId the primary key of the current wor im
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next wor im
     * @throws gov.va.caret.NoSuchWorImException if a wor im with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm[] findByType_PrevAndNext(long worImId, long classPk,
        long classId, String type, OrderByComparator orderByComparator)
        throws NoSuchWorImException, SystemException {
        WorIm worIm = findByPrimaryKey(worImId);

        Session session = null;

        try {
            session = openSession();

            WorIm[] array = new WorImImpl[3];

            array[0] = getByType_PrevAndNext(session, worIm, classPk, classId,
                    type, orderByComparator, true);

            array[1] = worIm;

            array[2] = getByType_PrevAndNext(session, worIm, classPk, classId,
                    type, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected WorIm getByType_PrevAndNext(Session session, WorIm worIm,
        long classPk, long classId, String type,
        OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_WORIM_WHERE);

        query.append(_FINDER_COLUMN_TYPE_CLASSPK_2);

        query.append(_FINDER_COLUMN_TYPE_CLASSID_2);

        boolean bindType = false;

        if (type == null) {
            query.append(_FINDER_COLUMN_TYPE_TYPE_1);
        } else if (type.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_TYPE_TYPE_3);
        } else {
            bindType = true;

            query.append(_FINDER_COLUMN_TYPE_TYPE_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(WorImModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(classPk);

        qPos.add(classId);

        if (bindType) {
            qPos.add(type);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(worIm);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<WorIm> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; from the database.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByType(long classPk, long classId, String type)
        throws SystemException {
        for (WorIm worIm : findByType(classPk, classId, type,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(worIm);
        }
    }

    /**
     * Returns the number of wor ims where classPk = &#63; and classId = &#63; and type = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @return the number of matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByType(long classPk, long classId, String type)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_TYPE;

        Object[] finderArgs = new Object[] { classPk, classId, type };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(4);

            query.append(_SQL_COUNT_WORIM_WHERE);

            query.append(_FINDER_COLUMN_TYPE_CLASSPK_2);

            query.append(_FINDER_COLUMN_TYPE_CLASSID_2);

            boolean bindType = false;

            if (type == null) {
                query.append(_FINDER_COLUMN_TYPE_TYPE_1);
            } else if (type.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_TYPE_TYPE_3);
            } else {
                bindType = true;

                query.append(_FINDER_COLUMN_TYPE_TYPE_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classPk);

                qPos.add(classId);

                if (bindType) {
                    qPos.add(type);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param groupId the group ID
     * @return the matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findByGroupTypes(long classPk, long classId,
        String type, long groupId) throws SystemException {
        return findByGroupTypes(classPk, classId, type, groupId,
            QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param groupId the group ID
     * @param start the lower bound of the range of wor ims
     * @param end the upper bound of the range of wor ims (not inclusive)
     * @return the range of matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findByGroupTypes(long classPk, long classId,
        String type, long groupId, int start, int end)
        throws SystemException {
        return findByGroupTypes(classPk, classId, type, groupId, start, end,
            null);
    }

    /**
     * Returns an ordered range of all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param groupId the group ID
     * @param start the lower bound of the range of wor ims
     * @param end the upper bound of the range of wor ims (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findByGroupTypes(long classPk, long classId,
        String type, long groupId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPTYPES;
            finderArgs = new Object[] { classPk, classId, type, groupId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPTYPES;
            finderArgs = new Object[] {
                    classPk, classId, type, groupId,
                    
                    start, end, orderByComparator
                };
        }

        List<WorIm> list = (List<WorIm>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (WorIm worIm : list) {
                if ((classPk != worIm.getClassPk()) ||
                        (classId != worIm.getClassId()) ||
                        !Validator.equals(type, worIm.getType()) ||
                        (groupId != worIm.getGroupId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(6 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(6);
            }

            query.append(_SQL_SELECT_WORIM_WHERE);

            query.append(_FINDER_COLUMN_GROUPTYPES_CLASSPK_2);

            query.append(_FINDER_COLUMN_GROUPTYPES_CLASSID_2);

            boolean bindType = false;

            if (type == null) {
                query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_1);
            } else if (type.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_3);
            } else {
                bindType = true;

                query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_2);
            }

            query.append(_FINDER_COLUMN_GROUPTYPES_GROUPID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(WorImModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classPk);

                qPos.add(classId);

                if (bindType) {
                    qPos.add(type);
                }

                qPos.add(groupId);

                if (!pagination) {
                    list = (List<WorIm>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<WorIm>(list);
                } else {
                    list = (List<WorIm>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param groupId the group ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching wor im
     * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm findByGroupTypes_First(long classPk, long classId,
        String type, long groupId, OrderByComparator orderByComparator)
        throws NoSuchWorImException, SystemException {
        WorIm worIm = fetchByGroupTypes_First(classPk, classId, type, groupId,
                orderByComparator);

        if (worIm != null) {
            return worIm;
        }

        StringBundler msg = new StringBundler(10);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("classPk=");
        msg.append(classPk);

        msg.append(", classId=");
        msg.append(classId);

        msg.append(", type=");
        msg.append(type);

        msg.append(", groupId=");
        msg.append(groupId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchWorImException(msg.toString());
    }

    /**
     * Returns the first wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param groupId the group ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching wor im, or <code>null</code> if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm fetchByGroupTypes_First(long classPk, long classId,
        String type, long groupId, OrderByComparator orderByComparator)
        throws SystemException {
        List<WorIm> list = findByGroupTypes(classPk, classId, type, groupId, 0,
                1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param groupId the group ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching wor im
     * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm findByGroupTypes_Last(long classPk, long classId, String type,
        long groupId, OrderByComparator orderByComparator)
        throws NoSuchWorImException, SystemException {
        WorIm worIm = fetchByGroupTypes_Last(classPk, classId, type, groupId,
                orderByComparator);

        if (worIm != null) {
            return worIm;
        }

        StringBundler msg = new StringBundler(10);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("classPk=");
        msg.append(classPk);

        msg.append(", classId=");
        msg.append(classId);

        msg.append(", type=");
        msg.append(type);

        msg.append(", groupId=");
        msg.append(groupId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchWorImException(msg.toString());
    }

    /**
     * Returns the last wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param groupId the group ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching wor im, or <code>null</code> if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm fetchByGroupTypes_Last(long classPk, long classId,
        String type, long groupId, OrderByComparator orderByComparator)
        throws SystemException {
        int count = countByGroupTypes(classPk, classId, type, groupId);

        if (count == 0) {
            return null;
        }

        List<WorIm> list = findByGroupTypes(classPk, classId, type, groupId,
                count - 1, count, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the wor ims before and after the current wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
     *
     * @param worImId the primary key of the current wor im
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param groupId the group ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next wor im
     * @throws gov.va.caret.NoSuchWorImException if a wor im with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm[] findByGroupTypes_PrevAndNext(long worImId, long classPk,
        long classId, String type, long groupId,
        OrderByComparator orderByComparator)
        throws NoSuchWorImException, SystemException {
        WorIm worIm = findByPrimaryKey(worImId);

        Session session = null;

        try {
            session = openSession();

            WorIm[] array = new WorImImpl[3];

            array[0] = getByGroupTypes_PrevAndNext(session, worIm, classPk,
                    classId, type, groupId, orderByComparator, true);

            array[1] = worIm;

            array[2] = getByGroupTypes_PrevAndNext(session, worIm, classPk,
                    classId, type, groupId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected WorIm getByGroupTypes_PrevAndNext(Session session, WorIm worIm,
        long classPk, long classId, String type, long groupId,
        OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_WORIM_WHERE);

        query.append(_FINDER_COLUMN_GROUPTYPES_CLASSPK_2);

        query.append(_FINDER_COLUMN_GROUPTYPES_CLASSID_2);

        boolean bindType = false;

        if (type == null) {
            query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_1);
        } else if (type.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_3);
        } else {
            bindType = true;

            query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_2);
        }

        query.append(_FINDER_COLUMN_GROUPTYPES_GROUPID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(WorImModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(classPk);

        qPos.add(classId);

        if (bindType) {
            qPos.add(type);
        }

        qPos.add(groupId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(worIm);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<WorIm> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Returns all the wor ims where classPk = &#63; and classId = &#63; and type = any &#63; and groupId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param types the types
     * @param groupId the group ID
     * @return the matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findByGroupTypes(long classPk, long classId,
        String[] types, long groupId) throws SystemException {
        return findByGroupTypes(classPk, classId, types, groupId,
            QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the wor ims where classPk = &#63; and classId = &#63; and type = any &#63; and groupId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param types the types
     * @param groupId the group ID
     * @param start the lower bound of the range of wor ims
     * @param end the upper bound of the range of wor ims (not inclusive)
     * @return the range of matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findByGroupTypes(long classPk, long classId,
        String[] types, long groupId, int start, int end)
        throws SystemException {
        return findByGroupTypes(classPk, classId, types, groupId, start, end,
            null);
    }

    /**
     * Returns an ordered range of all the wor ims where classPk = &#63; and classId = &#63; and type = any &#63; and groupId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param types the types
     * @param groupId the group ID
     * @param start the lower bound of the range of wor ims
     * @param end the upper bound of the range of wor ims (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findByGroupTypes(long classPk, long classId,
        String[] types, long groupId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        if ((types != null) && (types.length == 1)) {
            return findByGroupTypes(classPk, classId, types[0], groupId, start,
                end, orderByComparator);
        }

        boolean pagination = true;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderArgs = new Object[] {
                    classPk, classId, StringUtil.merge(types), groupId
                };
        } else {
            finderArgs = new Object[] {
                    classPk, classId, StringUtil.merge(types), groupId,
                    
                    start, end, orderByComparator
                };
        }

        List<WorIm> list = (List<WorIm>) FinderCacheUtil.getResult(FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPTYPES,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (WorIm worIm : list) {
                if ((classPk != worIm.getClassPk()) ||
                        (classId != worIm.getClassId()) ||
                        !ArrayUtil.contains(types, worIm.getType()) ||
                        (groupId != worIm.getGroupId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = new StringBundler();

            query.append(_SQL_SELECT_WORIM_WHERE);

            boolean conjunctionable = false;

            if (conjunctionable) {
                query.append(WHERE_AND);
            }

            query.append(_FINDER_COLUMN_GROUPTYPES_CLASSPK_5);

            conjunctionable = true;

            if (conjunctionable) {
                query.append(WHERE_AND);
            }

            query.append(_FINDER_COLUMN_GROUPTYPES_CLASSID_5);

            conjunctionable = true;

            if ((types == null) || (types.length > 0)) {
                if (conjunctionable) {
                    query.append(WHERE_AND);
                }

                query.append(StringPool.OPEN_PARENTHESIS);

                for (int i = 0; i < types.length; i++) {
                    String type = types[i];

                    if (type == null) {
                        query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_4);
                    } else if (type.equals(StringPool.BLANK)) {
                        query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_6);
                    } else {
                        query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_5);
                    }

                    if ((i + 1) < types.length) {
                        query.append(WHERE_OR);
                    }
                }

                query.append(StringPool.CLOSE_PARENTHESIS);

                conjunctionable = true;
            }

            if (conjunctionable) {
                query.append(WHERE_AND);
            }

            query.append(_FINDER_COLUMN_GROUPTYPES_GROUPID_5);

            conjunctionable = true;

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(WorImModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classPk);

                qPos.add(classId);

                if (types != null) {
                    qPos.add(types);
                }

                qPos.add(groupId);

                if (!pagination) {
                    list = (List<WorIm>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<WorIm>(list);
                } else {
                    list = (List<WorIm>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPTYPES,
                    finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPTYPES,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63; from the database.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param groupId the group ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByGroupTypes(long classPk, long classId, String type,
        long groupId) throws SystemException {
        for (WorIm worIm : findByGroupTypes(classPk, classId, type, groupId,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(worIm);
        }
    }

    /**
     * Returns the number of wor ims where classPk = &#63; and classId = &#63; and type = &#63; and groupId = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param groupId the group ID
     * @return the number of matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByGroupTypes(long classPk, long classId, String type,
        long groupId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_GROUPTYPES;

        Object[] finderArgs = new Object[] { classPk, classId, type, groupId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(5);

            query.append(_SQL_COUNT_WORIM_WHERE);

            query.append(_FINDER_COLUMN_GROUPTYPES_CLASSPK_2);

            query.append(_FINDER_COLUMN_GROUPTYPES_CLASSID_2);

            boolean bindType = false;

            if (type == null) {
                query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_1);
            } else if (type.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_3);
            } else {
                bindType = true;

                query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_2);
            }

            query.append(_FINDER_COLUMN_GROUPTYPES_GROUPID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classPk);

                qPos.add(classId);

                if (bindType) {
                    qPos.add(type);
                }

                qPos.add(groupId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns the number of wor ims where classPk = &#63; and classId = &#63; and type = any &#63; and groupId = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param types the types
     * @param groupId the group ID
     * @return the number of matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByGroupTypes(long classPk, long classId, String[] types,
        long groupId) throws SystemException {
        Object[] finderArgs = new Object[] {
                classPk, classId, StringUtil.merge(types), groupId
            };

        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_WITH_PAGINATION_COUNT_BY_GROUPTYPES,
                finderArgs, this);

        if (count == null) {
            StringBundler query = new StringBundler();

            query.append(_SQL_COUNT_WORIM_WHERE);

            boolean conjunctionable = false;

            if (conjunctionable) {
                query.append(WHERE_AND);
            }

            query.append(_FINDER_COLUMN_GROUPTYPES_CLASSPK_5);

            conjunctionable = true;

            if (conjunctionable) {
                query.append(WHERE_AND);
            }

            query.append(_FINDER_COLUMN_GROUPTYPES_CLASSID_5);

            conjunctionable = true;

            if ((types == null) || (types.length > 0)) {
                if (conjunctionable) {
                    query.append(WHERE_AND);
                }

                query.append(StringPool.OPEN_PARENTHESIS);

                for (int i = 0; i < types.length; i++) {
                    String type = types[i];

                    if (type == null) {
                        query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_4);
                    } else if (type.equals(StringPool.BLANK)) {
                        query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_6);
                    } else {
                        query.append(_FINDER_COLUMN_GROUPTYPES_TYPE_5);
                    }

                    if ((i + 1) < types.length) {
                        query.append(WHERE_OR);
                    }
                }

                query.append(StringPool.CLOSE_PARENTHESIS);

                conjunctionable = true;
            }

            if (conjunctionable) {
                query.append(WHERE_AND);
            }

            query.append(_FINDER_COLUMN_GROUPTYPES_GROUPID_5);

            conjunctionable = true;

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classPk);

                qPos.add(classId);

                if (types != null) {
                    qPos.add(types);
                }

                qPos.add(groupId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_WITH_PAGINATION_COUNT_BY_GROUPTYPES,
                    finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_WITH_PAGINATION_COUNT_BY_GROUPTYPES,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param userId the user ID
     * @return the matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findByUserType(long classPk, long classId, String type,
        long userId) throws SystemException {
        return findByUserType(classPk, classId, type, userId,
            QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param userId the user ID
     * @param start the lower bound of the range of wor ims
     * @param end the upper bound of the range of wor ims (not inclusive)
     * @return the range of matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findByUserType(long classPk, long classId, String type,
        long userId, int start, int end) throws SystemException {
        return findByUserType(classPk, classId, type, userId, start, end, null);
    }

    /**
     * Returns an ordered range of all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param userId the user ID
     * @param start the lower bound of the range of wor ims
     * @param end the upper bound of the range of wor ims (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findByUserType(long classPk, long classId, String type,
        long userId, int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERTYPE;
            finderArgs = new Object[] { classPk, classId, type, userId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_USERTYPE;
            finderArgs = new Object[] {
                    classPk, classId, type, userId,
                    
                    start, end, orderByComparator
                };
        }

        List<WorIm> list = (List<WorIm>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (WorIm worIm : list) {
                if ((classPk != worIm.getClassPk()) ||
                        (classId != worIm.getClassId()) ||
                        !Validator.equals(type, worIm.getType()) ||
                        (userId != worIm.getUserId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(6 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(6);
            }

            query.append(_SQL_SELECT_WORIM_WHERE);

            query.append(_FINDER_COLUMN_USERTYPE_CLASSPK_2);

            query.append(_FINDER_COLUMN_USERTYPE_CLASSID_2);

            boolean bindType = false;

            if (type == null) {
                query.append(_FINDER_COLUMN_USERTYPE_TYPE_1);
            } else if (type.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_USERTYPE_TYPE_3);
            } else {
                bindType = true;

                query.append(_FINDER_COLUMN_USERTYPE_TYPE_2);
            }

            query.append(_FINDER_COLUMN_USERTYPE_USERID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(WorImModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classPk);

                qPos.add(classId);

                if (bindType) {
                    qPos.add(type);
                }

                qPos.add(userId);

                if (!pagination) {
                    list = (List<WorIm>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<WorIm>(list);
                } else {
                    list = (List<WorIm>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param userId the user ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching wor im
     * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm findByUserType_First(long classPk, long classId, String type,
        long userId, OrderByComparator orderByComparator)
        throws NoSuchWorImException, SystemException {
        WorIm worIm = fetchByUserType_First(classPk, classId, type, userId,
                orderByComparator);

        if (worIm != null) {
            return worIm;
        }

        StringBundler msg = new StringBundler(10);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("classPk=");
        msg.append(classPk);

        msg.append(", classId=");
        msg.append(classId);

        msg.append(", type=");
        msg.append(type);

        msg.append(", userId=");
        msg.append(userId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchWorImException(msg.toString());
    }

    /**
     * Returns the first wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param userId the user ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching wor im, or <code>null</code> if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm fetchByUserType_First(long classPk, long classId, String type,
        long userId, OrderByComparator orderByComparator)
        throws SystemException {
        List<WorIm> list = findByUserType(classPk, classId, type, userId, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param userId the user ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching wor im
     * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm findByUserType_Last(long classPk, long classId, String type,
        long userId, OrderByComparator orderByComparator)
        throws NoSuchWorImException, SystemException {
        WorIm worIm = fetchByUserType_Last(classPk, classId, type, userId,
                orderByComparator);

        if (worIm != null) {
            return worIm;
        }

        StringBundler msg = new StringBundler(10);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("classPk=");
        msg.append(classPk);

        msg.append(", classId=");
        msg.append(classId);

        msg.append(", type=");
        msg.append(type);

        msg.append(", userId=");
        msg.append(userId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchWorImException(msg.toString());
    }

    /**
     * Returns the last wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param userId the user ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching wor im, or <code>null</code> if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm fetchByUserType_Last(long classPk, long classId, String type,
        long userId, OrderByComparator orderByComparator)
        throws SystemException {
        int count = countByUserType(classPk, classId, type, userId);

        if (count == 0) {
            return null;
        }

        List<WorIm> list = findByUserType(classPk, classId, type, userId,
                count - 1, count, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the wor ims before and after the current wor im in the ordered set where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
     *
     * @param worImId the primary key of the current wor im
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param userId the user ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next wor im
     * @throws gov.va.caret.NoSuchWorImException if a wor im with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm[] findByUserType_PrevAndNext(long worImId, long classPk,
        long classId, String type, long userId,
        OrderByComparator orderByComparator)
        throws NoSuchWorImException, SystemException {
        WorIm worIm = findByPrimaryKey(worImId);

        Session session = null;

        try {
            session = openSession();

            WorIm[] array = new WorImImpl[3];

            array[0] = getByUserType_PrevAndNext(session, worIm, classPk,
                    classId, type, userId, orderByComparator, true);

            array[1] = worIm;

            array[2] = getByUserType_PrevAndNext(session, worIm, classPk,
                    classId, type, userId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected WorIm getByUserType_PrevAndNext(Session session, WorIm worIm,
        long classPk, long classId, String type, long userId,
        OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_WORIM_WHERE);

        query.append(_FINDER_COLUMN_USERTYPE_CLASSPK_2);

        query.append(_FINDER_COLUMN_USERTYPE_CLASSID_2);

        boolean bindType = false;

        if (type == null) {
            query.append(_FINDER_COLUMN_USERTYPE_TYPE_1);
        } else if (type.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_USERTYPE_TYPE_3);
        } else {
            bindType = true;

            query.append(_FINDER_COLUMN_USERTYPE_TYPE_2);
        }

        query.append(_FINDER_COLUMN_USERTYPE_USERID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(WorImModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(classPk);

        qPos.add(classId);

        if (bindType) {
            qPos.add(type);
        }

        qPos.add(userId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(worIm);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<WorIm> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the wor ims where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63; from the database.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param userId the user ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByUserType(long classPk, long classId, String type,
        long userId) throws SystemException {
        for (WorIm worIm : findByUserType(classPk, classId, type, userId,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(worIm);
        }
    }

    /**
     * Returns the number of wor ims where classPk = &#63; and classId = &#63; and type = &#63; and userId = &#63;.
     *
     * @param classPk the class pk
     * @param classId the class ID
     * @param type the type
     * @param userId the user ID
     * @return the number of matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByUserType(long classPk, long classId, String type,
        long userId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_USERTYPE;

        Object[] finderArgs = new Object[] { classPk, classId, type, userId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(5);

            query.append(_SQL_COUNT_WORIM_WHERE);

            query.append(_FINDER_COLUMN_USERTYPE_CLASSPK_2);

            query.append(_FINDER_COLUMN_USERTYPE_CLASSID_2);

            boolean bindType = false;

            if (type == null) {
                query.append(_FINDER_COLUMN_USERTYPE_TYPE_1);
            } else if (type.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_USERTYPE_TYPE_3);
            } else {
                bindType = true;

                query.append(_FINDER_COLUMN_USERTYPE_TYPE_2);
            }

            query.append(_FINDER_COLUMN_USERTYPE_USERID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(classPk);

                qPos.add(classId);

                if (bindType) {
                    qPos.add(type);
                }

                qPos.add(userId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns the wor im where vcgId = &#63; and caregiverId = &#63; and status = &#63; or throws a {@link gov.va.caret.NoSuchWorImException} if it could not be found.
     *
     * @param vcgId the vcg ID
     * @param caregiverId the caregiver ID
     * @param status the status
     * @return the matching wor im
     * @throws gov.va.caret.NoSuchWorImException if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm findByVcgId(long vcgId, long caregiverId, String status)
        throws NoSuchWorImException, SystemException {
        WorIm worIm = fetchByVcgId(vcgId, caregiverId, status);

        if (worIm == null) {
            StringBundler msg = new StringBundler(8);

            msg.append(_NO_SUCH_ENTITY_WITH_KEY);

            msg.append("vcgId=");
            msg.append(vcgId);

            msg.append(", caregiverId=");
            msg.append(caregiverId);

            msg.append(", status=");
            msg.append(status);

            msg.append(StringPool.CLOSE_CURLY_BRACE);

            if (_log.isWarnEnabled()) {
                _log.warn(msg.toString());
            }

            throw new NoSuchWorImException(msg.toString());
        }

        return worIm;
    }

    /**
     * Returns the wor im where vcgId = &#63; and caregiverId = &#63; and status = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
     *
     * @param vcgId the vcg ID
     * @param caregiverId the caregiver ID
     * @param status the status
     * @return the matching wor im, or <code>null</code> if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm fetchByVcgId(long vcgId, long caregiverId, String status)
        throws SystemException {
        return fetchByVcgId(vcgId, caregiverId, status, true);
    }

    /**
     * Returns the wor im where vcgId = &#63; and caregiverId = &#63; and status = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
     *
     * @param vcgId the vcg ID
     * @param caregiverId the caregiver ID
     * @param status the status
     * @param retrieveFromCache whether to use the finder cache
     * @return the matching wor im, or <code>null</code> if a matching wor im could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm fetchByVcgId(long vcgId, long caregiverId, String status,
        boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[] { vcgId, caregiverId, status };

        Object result = null;

        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(FINDER_PATH_FETCH_BY_VCGID,
                    finderArgs, this);
        }

        if (result instanceof WorIm) {
            WorIm worIm = (WorIm) result;

            if ((vcgId != worIm.getVcgId()) ||
                    (caregiverId != worIm.getCaregiverId()) ||
                    !Validator.equals(status, worIm.getStatus())) {
                result = null;
            }
        }

        if (result == null) {
            StringBundler query = new StringBundler(5);

            query.append(_SQL_SELECT_WORIM_WHERE);

            query.append(_FINDER_COLUMN_VCGID_VCGID_2);

            query.append(_FINDER_COLUMN_VCGID_CAREGIVERID_2);

            boolean bindStatus = false;

            if (status == null) {
                query.append(_FINDER_COLUMN_VCGID_STATUS_1);
            } else if (status.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_VCGID_STATUS_3);
            } else {
                bindStatus = true;

                query.append(_FINDER_COLUMN_VCGID_STATUS_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(vcgId);

                qPos.add(caregiverId);

                if (bindStatus) {
                    qPos.add(status);
                }

                List<WorIm> list = q.list();

                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_VCGID,
                        finderArgs, list);
                } else {
                    if ((list.size() > 1) && _log.isWarnEnabled()) {
                        _log.warn(
                            "WorImPersistenceImpl.fetchByVcgId(long, long, String, boolean) with parameters (" +
                            StringUtil.merge(finderArgs) +
                            ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                    }

                    WorIm worIm = list.get(0);

                    result = worIm;

                    cacheResult(worIm);

                    if ((worIm.getVcgId() != vcgId) ||
                            (worIm.getCaregiverId() != caregiverId) ||
                            (worIm.getStatus() == null) ||
                            !worIm.getStatus().equals(status)) {
                        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_VCGID,
                            finderArgs, worIm);
                    }
                }
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_VCGID,
                    finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        if (result instanceof List<?>) {
            return null;
        } else {
            return (WorIm) result;
        }
    }

    /**
     * Removes the wor im where vcgId = &#63; and caregiverId = &#63; and status = &#63; from the database.
     *
     * @param vcgId the vcg ID
     * @param caregiverId the caregiver ID
     * @param status the status
     * @return the wor im that was removed
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm removeByVcgId(long vcgId, long caregiverId, String status)
        throws NoSuchWorImException, SystemException {
        WorIm worIm = findByVcgId(vcgId, caregiverId, status);

        return remove(worIm);
    }

    /**
     * Returns the number of wor ims where vcgId = &#63; and caregiverId = &#63; and status = &#63;.
     *
     * @param vcgId the vcg ID
     * @param caregiverId the caregiver ID
     * @param status the status
     * @return the number of matching wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByVcgId(long vcgId, long caregiverId, String status)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_VCGID;

        Object[] finderArgs = new Object[] { vcgId, caregiverId, status };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(4);

            query.append(_SQL_COUNT_WORIM_WHERE);

            query.append(_FINDER_COLUMN_VCGID_VCGID_2);

            query.append(_FINDER_COLUMN_VCGID_CAREGIVERID_2);

            boolean bindStatus = false;

            if (status == null) {
                query.append(_FINDER_COLUMN_VCGID_STATUS_1);
            } else if (status.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_VCGID_STATUS_3);
            } else {
                bindStatus = true;

                query.append(_FINDER_COLUMN_VCGID_STATUS_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(vcgId);

                qPos.add(caregiverId);

                if (bindStatus) {
                    qPos.add(status);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the wor im in the entity cache if it is enabled.
     *
     * @param worIm the wor im
     */
    @Override
    public void cacheResult(WorIm worIm) {
        EntityCacheUtil.putResult(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImImpl.class, worIm.getPrimaryKey(), worIm);

        FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_VCGID,
            new Object[] {
                worIm.getVcgId(), worIm.getCaregiverId(), worIm.getStatus()
            }, worIm);

        worIm.resetOriginalValues();
    }

    /**
     * Caches the wor ims in the entity cache if it is enabled.
     *
     * @param worIms the wor ims
     */
    @Override
    public void cacheResult(List<WorIm> worIms) {
        for (WorIm worIm : worIms) {
            if (EntityCacheUtil.getResult(WorImModelImpl.ENTITY_CACHE_ENABLED,
                        WorImImpl.class, worIm.getPrimaryKey()) == null) {
                cacheResult(worIm);
            } else {
                worIm.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all wor ims.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(WorImImpl.class.getName());
        }

        EntityCacheUtil.clearCache(WorImImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the wor im.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(WorIm worIm) {
        EntityCacheUtil.removeResult(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImImpl.class, worIm.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        clearUniqueFindersCache(worIm);
    }

    @Override
    public void clearCache(List<WorIm> worIms) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (WorIm worIm : worIms) {
            EntityCacheUtil.removeResult(WorImModelImpl.ENTITY_CACHE_ENABLED,
                WorImImpl.class, worIm.getPrimaryKey());

            clearUniqueFindersCache(worIm);
        }
    }

    protected void cacheUniqueFindersCache(WorIm worIm) {
        if (worIm.isNew()) {
            Object[] args = new Object[] {
                    worIm.getVcgId(), worIm.getCaregiverId(), worIm.getStatus()
                };

            FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_VCGID, args,
                Long.valueOf(1));
            FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_VCGID, args, worIm);
        } else {
            WorImModelImpl worImModelImpl = (WorImModelImpl) worIm;

            if ((worImModelImpl.getColumnBitmask() &
                    FINDER_PATH_FETCH_BY_VCGID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        worIm.getVcgId(), worIm.getCaregiverId(),
                        worIm.getStatus()
                    };

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_BY_VCGID, args,
                    Long.valueOf(1));
                FinderCacheUtil.putResult(FINDER_PATH_FETCH_BY_VCGID, args,
                    worIm);
            }
        }
    }

    protected void clearUniqueFindersCache(WorIm worIm) {
        WorImModelImpl worImModelImpl = (WorImModelImpl) worIm;

        Object[] args = new Object[] {
                worIm.getVcgId(), worIm.getCaregiverId(), worIm.getStatus()
            };

        FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VCGID, args);
        FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_VCGID, args);

        if ((worImModelImpl.getColumnBitmask() &
                FINDER_PATH_FETCH_BY_VCGID.getColumnBitmask()) != 0) {
            args = new Object[] {
                    worImModelImpl.getOriginalVcgId(),
                    worImModelImpl.getOriginalCaregiverId(),
                    worImModelImpl.getOriginalStatus()
                };

            FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VCGID, args);
            FinderCacheUtil.removeResult(FINDER_PATH_FETCH_BY_VCGID, args);
        }
    }

    /**
     * Creates a new wor im with the primary key. Does not add the wor im to the database.
     *
     * @param worImId the primary key for the new wor im
     * @return the new wor im
     */
    @Override
    public WorIm create(long worImId) {
        WorIm worIm = new WorImImpl();

        worIm.setNew(true);
        worIm.setPrimaryKey(worImId);

        return worIm;
    }

    /**
     * Removes the wor im with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param worImId the primary key of the wor im
     * @return the wor im that was removed
     * @throws gov.va.caret.NoSuchWorImException if a wor im with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm remove(long worImId)
        throws NoSuchWorImException, SystemException {
        return remove((Serializable) worImId);
    }

    /**
     * Removes the wor im with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the wor im
     * @return the wor im that was removed
     * @throws gov.va.caret.NoSuchWorImException if a wor im with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm remove(Serializable primaryKey)
        throws NoSuchWorImException, SystemException {
        Session session = null;

        try {
            session = openSession();

            WorIm worIm = (WorIm) session.get(WorImImpl.class, primaryKey);

            if (worIm == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchWorImException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(worIm);
        } catch (NoSuchWorImException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected WorIm removeImpl(WorIm worIm) throws SystemException {
        worIm = toUnwrappedModel(worIm);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(worIm)) {
                worIm = (WorIm) session.get(WorImImpl.class,
                        worIm.getPrimaryKeyObj());
            }

            if (worIm != null) {
                session.delete(worIm);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (worIm != null) {
            clearCache(worIm);
        }

        return worIm;
    }

    @Override
    public WorIm updateImpl(gov.va.caret.model.WorIm worIm)
        throws SystemException {
        worIm = toUnwrappedModel(worIm);

        boolean isNew = worIm.isNew();

        WorImModelImpl worImModelImpl = (WorImModelImpl) worIm;

        Session session = null;

        try {
            session = openSession();

            if (worIm.isNew()) {
                session.save(worIm);

                worIm.setNew(false);
            } else {
                session.merge(worIm);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !WorImModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((worImModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TYPE.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        worImModelImpl.getOriginalClassPk(),
                        worImModelImpl.getOriginalClassId(),
                        worImModelImpl.getOriginalType()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_TYPE, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TYPE,
                    args);

                args = new Object[] {
                        worImModelImpl.getClassPk(), worImModelImpl.getClassId(),
                        worImModelImpl.getType()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_TYPE, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_TYPE,
                    args);
            }

            if ((worImModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPTYPES.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        worImModelImpl.getOriginalClassPk(),
                        worImModelImpl.getOriginalClassId(),
                        worImModelImpl.getOriginalType(),
                        worImModelImpl.getOriginalGroupId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_GROUPTYPES,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPTYPES,
                    args);

                args = new Object[] {
                        worImModelImpl.getClassPk(), worImModelImpl.getClassId(),
                        worImModelImpl.getType(), worImModelImpl.getGroupId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_GROUPTYPES,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPTYPES,
                    args);
            }

            if ((worImModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERTYPE.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        worImModelImpl.getOriginalClassPk(),
                        worImModelImpl.getOriginalClassId(),
                        worImModelImpl.getOriginalType(),
                        worImModelImpl.getOriginalUserId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_USERTYPE, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERTYPE,
                    args);

                args = new Object[] {
                        worImModelImpl.getClassPk(), worImModelImpl.getClassId(),
                        worImModelImpl.getType(), worImModelImpl.getUserId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_USERTYPE, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERTYPE,
                    args);
            }
        }

        EntityCacheUtil.putResult(WorImModelImpl.ENTITY_CACHE_ENABLED,
            WorImImpl.class, worIm.getPrimaryKey(), worIm);

        clearUniqueFindersCache(worIm);
        cacheUniqueFindersCache(worIm);

        return worIm;
    }

    protected WorIm toUnwrappedModel(WorIm worIm) {
        if (worIm instanceof WorImImpl) {
            return worIm;
        }

        WorImImpl worImImpl = new WorImImpl();

        worImImpl.setNew(worIm.isNew());
        worImImpl.setPrimaryKey(worIm.getPrimaryKey());

        worImImpl.setWorImId(worIm.getWorImId());
        worImImpl.setType(worIm.getType());
        worImImpl.setClassId(worIm.getClassId());
        worImImpl.setClassPk(worIm.getClassPk());
        worImImpl.setStatus(worIm.getStatus());
        worImImpl.setCreationDate(worIm.getCreationDate());
        worImImpl.setDueDate(worIm.getDueDate());
        worImImpl.setCompletionDate(worIm.getCompletionDate());
        worImImpl.setCompletionBy(worIm.getCompletionBy());
        worImImpl.setGroupId(worIm.getGroupId());
        worImImpl.setUserId(worIm.getUserId());
        worImImpl.setCaregiverId(worIm.getCaregiverId());
        worImImpl.setPersnId(worIm.getPersnId());
        worImImpl.setQueId(worIm.getQueId());
        worImImpl.setVcgId(worIm.getVcgId());

        return worImImpl;
    }

    /**
     * Returns the wor im with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the wor im
     * @return the wor im
     * @throws gov.va.caret.NoSuchWorImException if a wor im with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm findByPrimaryKey(Serializable primaryKey)
        throws NoSuchWorImException, SystemException {
        WorIm worIm = fetchByPrimaryKey(primaryKey);

        if (worIm == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchWorImException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return worIm;
    }

    /**
     * Returns the wor im with the primary key or throws a {@link gov.va.caret.NoSuchWorImException} if it could not be found.
     *
     * @param worImId the primary key of the wor im
     * @return the wor im
     * @throws gov.va.caret.NoSuchWorImException if a wor im with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm findByPrimaryKey(long worImId)
        throws NoSuchWorImException, SystemException {
        return findByPrimaryKey((Serializable) worImId);
    }

    /**
     * Returns the wor im with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the wor im
     * @return the wor im, or <code>null</code> if a wor im with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        WorIm worIm = (WorIm) EntityCacheUtil.getResult(WorImModelImpl.ENTITY_CACHE_ENABLED,
                WorImImpl.class, primaryKey);

        if (worIm == _nullWorIm) {
            return null;
        }

        if (worIm == null) {
            Session session = null;

            try {
                session = openSession();

                worIm = (WorIm) session.get(WorImImpl.class, primaryKey);

                if (worIm != null) {
                    cacheResult(worIm);
                } else {
                    EntityCacheUtil.putResult(WorImModelImpl.ENTITY_CACHE_ENABLED,
                        WorImImpl.class, primaryKey, _nullWorIm);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(WorImModelImpl.ENTITY_CACHE_ENABLED,
                    WorImImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return worIm;
    }

    /**
     * Returns the wor im with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param worImId the primary key of the wor im
     * @return the wor im, or <code>null</code> if a wor im with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public WorIm fetchByPrimaryKey(long worImId) throws SystemException {
        return fetchByPrimaryKey((Serializable) worImId);
    }

    /**
     * Returns all the wor ims.
     *
     * @return the wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the wor ims.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of wor ims
     * @param end the upper bound of the range of wor ims (not inclusive)
     * @return the range of wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the wor ims.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.WorImModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of wor ims
     * @param end the upper bound of the range of wor ims (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<WorIm> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<WorIm> list = (List<WorIm>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_WORIM);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_WORIM;

                if (pagination) {
                    sql = sql.concat(WorImModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<WorIm>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<WorIm>(list);
                } else {
                    list = (List<WorIm>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the wor ims from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (WorIm worIm : findAll()) {
            remove(worIm);
        }
    }

    /**
     * Returns the number of wor ims.
     *
     * @return the number of wor ims
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_WORIM);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    @Override
    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    /**
     * Initializes the wor im persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.WorIm")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<WorIm>> listenersList = new ArrayList<ModelListener<WorIm>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<WorIm>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(WorImImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
