package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchVcgAnException;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.impl.VcgAnImpl;
import gov.va.caret.model.impl.VcgAnModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the vcg an service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see VcgAnPersistence
 * @see VcgAnUtil
 * @generated
 */
public class VcgAnPersistenceImpl extends BasePersistenceImpl<VcgAn>
    implements VcgAnPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link VcgAnUtil} to access the vcg an persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = VcgAnImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, VcgAnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, VcgAnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_VCGID = new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, VcgAnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByVcgId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGID = new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, VcgAnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByVcgId",
            new String[] { Long.class.getName() },
            VcgAnModelImpl.VCGID_COLUMN_BITMASK |
            VcgAnModelImpl.CREATIONDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_VCGID = new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByVcgId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_VCGID_VCGID_2 = "vcgAn.vcgId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_VETERANID =
        new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, VcgAnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByVeteranId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VETERANID =
        new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, VcgAnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByVeteranId",
            new String[] { Long.class.getName() },
            VcgAnModelImpl.VETERANID_COLUMN_BITMASK |
            VcgAnModelImpl.CREATIONDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_VETERANID = new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByVeteranId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_VETERANID_VETERANID_2 = "vcgAn.veteranId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_PRIMARYID =
        new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, VcgAnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByPrimaryId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PRIMARYID =
        new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, VcgAnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByPrimaryId",
            new String[] { Long.class.getName() },
            VcgAnModelImpl.PRIMARYID_COLUMN_BITMASK |
            VcgAnModelImpl.CREATIONDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_PRIMARYID = new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByPrimaryId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_PRIMARYID_PRIMARYID_2 = "vcgAn.primaryId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_SECONDARYID =
        new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, VcgAnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findBySecondaryId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SECONDARYID =
        new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, VcgAnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findBySecondaryId",
            new String[] { Long.class.getName() },
            VcgAnModelImpl.SECONDARYID_COLUMN_BITMASK |
            VcgAnModelImpl.CREATIONDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_SECONDARYID = new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countBySecondaryId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_SECONDARYID_SECONDARYID_2 = "vcgAn.secondaryId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_SECONDARYTWOID =
        new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, VcgAnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findBySecondaryTwoId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SECONDARYTWOID =
        new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, VcgAnImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findBySecondaryTwoId",
            new String[] { Long.class.getName() },
            VcgAnModelImpl.SECONDARYTWOID_COLUMN_BITMASK |
            VcgAnModelImpl.CREATIONDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_SECONDARYTWOID = new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countBySecondaryTwoId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_SECONDARYTWOID_SECONDARYTWOID_2 = "vcgAn.secondaryTwoId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_PRIMARYAPP =
        new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, VcgAnImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByPrimaryApp",
            new String[] {
                Long.class.getName(), Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_COUNT_BY_PRIMARYAPP =
        new FinderPath(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByPrimaryApp",
            new String[] { Long.class.getName(), Long.class.getName() });
    private static final String _FINDER_COLUMN_PRIMARYAPP_PRIMARYID_2 = "vcgAn.primaryId > ? AND ";
    private static final String _FINDER_COLUMN_PRIMARYAPP_VETERANID_2 = "vcgAn.veteranId = ?";
    private static final String _SQL_SELECT_VCGAN = "SELECT vcgAn FROM VcgAn vcgAn";
    private static final String _SQL_SELECT_VCGAN_WHERE = "SELECT vcgAn FROM VcgAn vcgAn WHERE ";
    private static final String _SQL_COUNT_VCGAN = "SELECT COUNT(vcgAn) FROM VcgAn vcgAn";
    private static final String _SQL_COUNT_VCGAN_WHERE = "SELECT COUNT(vcgAn) FROM VcgAn vcgAn WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "vcgAn.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No VcgAn exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No VcgAn exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(VcgAnPersistenceImpl.class);
    private static VcgAn _nullVcgAn = new VcgAnImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<VcgAn> toCacheModel() {
                return _nullVcgAnCacheModel;
            }
        };

    private static CacheModel<VcgAn> _nullVcgAnCacheModel = new CacheModel<VcgAn>() {
            @Override
            public VcgAn toEntityModel() {
                return _nullVcgAn;
            }
        };

    public VcgAnPersistenceImpl() {
        setModelClass(VcgAn.class);
    }

    /**
     * Returns all the vcg ans where vcgId = &#63;.
     *
     * @param vcgId the vcg ID
     * @return the matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findByVcgId(long vcgId) throws SystemException {
        return findByVcgId(vcgId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the vcg ans where vcgId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param vcgId the vcg ID
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @return the range of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findByVcgId(long vcgId, int start, int end)
        throws SystemException {
        return findByVcgId(vcgId, start, end, null);
    }

    /**
     * Returns an ordered range of all the vcg ans where vcgId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param vcgId the vcg ID
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findByVcgId(long vcgId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGID;
            finderArgs = new Object[] { vcgId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_VCGID;
            finderArgs = new Object[] { vcgId, start, end, orderByComparator };
        }

        List<VcgAn> list = (List<VcgAn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (VcgAn vcgAn : list) {
                if ((vcgId != vcgAn.getVcgId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_VCGAN_WHERE);

            query.append(_FINDER_COLUMN_VCGID_VCGID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(VcgAnModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(vcgId);

                if (!pagination) {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<VcgAn>(list);
                } else {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first vcg an in the ordered set where vcgId = &#63;.
     *
     * @param vcgId the vcg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findByVcgId_First(long vcgId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = fetchByVcgId_First(vcgId, orderByComparator);

        if (vcgAn != null) {
            return vcgAn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("vcgId=");
        msg.append(vcgId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVcgAnException(msg.toString());
    }

    /**
     * Returns the first vcg an in the ordered set where vcgId = &#63;.
     *
     * @param vcgId the vcg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vcg an, or <code>null</code> if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchByVcgId_First(long vcgId,
        OrderByComparator orderByComparator) throws SystemException {
        List<VcgAn> list = findByVcgId(vcgId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last vcg an in the ordered set where vcgId = &#63;.
     *
     * @param vcgId the vcg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findByVcgId_Last(long vcgId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = fetchByVcgId_Last(vcgId, orderByComparator);

        if (vcgAn != null) {
            return vcgAn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("vcgId=");
        msg.append(vcgId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVcgAnException(msg.toString());
    }

    /**
     * Returns the last vcg an in the ordered set where vcgId = &#63;.
     *
     * @param vcgId the vcg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vcg an, or <code>null</code> if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchByVcgId_Last(long vcgId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByVcgId(vcgId);

        if (count == 0) {
            return null;
        }

        List<VcgAn> list = findByVcgId(vcgId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the vcg ans before and after the current vcg an in the ordered set where vcgId = &#63;.
     *
     * @param vcgAnId the primary key of the current vcg an
     * @param vcgId the vcg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn[] findByVcgId_PrevAndNext(long vcgAnId, long vcgId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = findByPrimaryKey(vcgAnId);

        Session session = null;

        try {
            session = openSession();

            VcgAn[] array = new VcgAnImpl[3];

            array[0] = getByVcgId_PrevAndNext(session, vcgAn, vcgId,
                    orderByComparator, true);

            array[1] = vcgAn;

            array[2] = getByVcgId_PrevAndNext(session, vcgAn, vcgId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected VcgAn getByVcgId_PrevAndNext(Session session, VcgAn vcgAn,
        long vcgId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_VCGAN_WHERE);

        query.append(_FINDER_COLUMN_VCGID_VCGID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(VcgAnModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(vcgId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(vcgAn);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<VcgAn> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the vcg ans where vcgId = &#63; from the database.
     *
     * @param vcgId the vcg ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByVcgId(long vcgId) throws SystemException {
        for (VcgAn vcgAn : findByVcgId(vcgId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(vcgAn);
        }
    }

    /**
     * Returns the number of vcg ans where vcgId = &#63;.
     *
     * @param vcgId the vcg ID
     * @return the number of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByVcgId(long vcgId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_VCGID;

        Object[] finderArgs = new Object[] { vcgId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_VCGAN_WHERE);

            query.append(_FINDER_COLUMN_VCGID_VCGID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(vcgId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the vcg ans where veteranId = &#63;.
     *
     * @param veteranId the veteran ID
     * @return the matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findByVeteranId(long veteranId)
        throws SystemException {
        return findByVeteranId(veteranId, QueryUtil.ALL_POS, QueryUtil.ALL_POS,
            null);
    }

    /**
     * Returns a range of all the vcg ans where veteranId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param veteranId the veteran ID
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @return the range of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findByVeteranId(long veteranId, int start, int end)
        throws SystemException {
        return findByVeteranId(veteranId, start, end, null);
    }

    /**
     * Returns an ordered range of all the vcg ans where veteranId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param veteranId the veteran ID
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findByVeteranId(long veteranId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VETERANID;
            finderArgs = new Object[] { veteranId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_VETERANID;
            finderArgs = new Object[] { veteranId, start, end, orderByComparator };
        }

        List<VcgAn> list = (List<VcgAn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (VcgAn vcgAn : list) {
                if ((veteranId != vcgAn.getVeteranId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_VCGAN_WHERE);

            query.append(_FINDER_COLUMN_VETERANID_VETERANID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(VcgAnModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(veteranId);

                if (!pagination) {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<VcgAn>(list);
                } else {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first vcg an in the ordered set where veteranId = &#63;.
     *
     * @param veteranId the veteran ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findByVeteranId_First(long veteranId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = fetchByVeteranId_First(veteranId, orderByComparator);

        if (vcgAn != null) {
            return vcgAn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("veteranId=");
        msg.append(veteranId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVcgAnException(msg.toString());
    }

    /**
     * Returns the first vcg an in the ordered set where veteranId = &#63;.
     *
     * @param veteranId the veteran ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vcg an, or <code>null</code> if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchByVeteranId_First(long veteranId,
        OrderByComparator orderByComparator) throws SystemException {
        List<VcgAn> list = findByVeteranId(veteranId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last vcg an in the ordered set where veteranId = &#63;.
     *
     * @param veteranId the veteran ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findByVeteranId_Last(long veteranId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = fetchByVeteranId_Last(veteranId, orderByComparator);

        if (vcgAn != null) {
            return vcgAn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("veteranId=");
        msg.append(veteranId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVcgAnException(msg.toString());
    }

    /**
     * Returns the last vcg an in the ordered set where veteranId = &#63;.
     *
     * @param veteranId the veteran ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vcg an, or <code>null</code> if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchByVeteranId_Last(long veteranId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByVeteranId(veteranId);

        if (count == 0) {
            return null;
        }

        List<VcgAn> list = findByVeteranId(veteranId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the vcg ans before and after the current vcg an in the ordered set where veteranId = &#63;.
     *
     * @param vcgAnId the primary key of the current vcg an
     * @param veteranId the veteran ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn[] findByVeteranId_PrevAndNext(long vcgAnId, long veteranId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = findByPrimaryKey(vcgAnId);

        Session session = null;

        try {
            session = openSession();

            VcgAn[] array = new VcgAnImpl[3];

            array[0] = getByVeteranId_PrevAndNext(session, vcgAn, veteranId,
                    orderByComparator, true);

            array[1] = vcgAn;

            array[2] = getByVeteranId_PrevAndNext(session, vcgAn, veteranId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected VcgAn getByVeteranId_PrevAndNext(Session session, VcgAn vcgAn,
        long veteranId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_VCGAN_WHERE);

        query.append(_FINDER_COLUMN_VETERANID_VETERANID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(VcgAnModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(veteranId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(vcgAn);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<VcgAn> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the vcg ans where veteranId = &#63; from the database.
     *
     * @param veteranId the veteran ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByVeteranId(long veteranId) throws SystemException {
        for (VcgAn vcgAn : findByVeteranId(veteranId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(vcgAn);
        }
    }

    /**
     * Returns the number of vcg ans where veteranId = &#63;.
     *
     * @param veteranId the veteran ID
     * @return the number of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByVeteranId(long veteranId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_VETERANID;

        Object[] finderArgs = new Object[] { veteranId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_VCGAN_WHERE);

            query.append(_FINDER_COLUMN_VETERANID_VETERANID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(veteranId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the vcg ans where primaryId = &#63;.
     *
     * @param primaryId the primary ID
     * @return the matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findByPrimaryId(long primaryId)
        throws SystemException {
        return findByPrimaryId(primaryId, QueryUtil.ALL_POS, QueryUtil.ALL_POS,
            null);
    }

    /**
     * Returns a range of all the vcg ans where primaryId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param primaryId the primary ID
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @return the range of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findByPrimaryId(long primaryId, int start, int end)
        throws SystemException {
        return findByPrimaryId(primaryId, start, end, null);
    }

    /**
     * Returns an ordered range of all the vcg ans where primaryId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param primaryId the primary ID
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findByPrimaryId(long primaryId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PRIMARYID;
            finderArgs = new Object[] { primaryId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_PRIMARYID;
            finderArgs = new Object[] { primaryId, start, end, orderByComparator };
        }

        List<VcgAn> list = (List<VcgAn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (VcgAn vcgAn : list) {
                if ((primaryId != vcgAn.getPrimaryId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_VCGAN_WHERE);

            query.append(_FINDER_COLUMN_PRIMARYID_PRIMARYID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(VcgAnModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(primaryId);

                if (!pagination) {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<VcgAn>(list);
                } else {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first vcg an in the ordered set where primaryId = &#63;.
     *
     * @param primaryId the primary ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findByPrimaryId_First(long primaryId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = fetchByPrimaryId_First(primaryId, orderByComparator);

        if (vcgAn != null) {
            return vcgAn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("primaryId=");
        msg.append(primaryId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVcgAnException(msg.toString());
    }

    /**
     * Returns the first vcg an in the ordered set where primaryId = &#63;.
     *
     * @param primaryId the primary ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vcg an, or <code>null</code> if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchByPrimaryId_First(long primaryId,
        OrderByComparator orderByComparator) throws SystemException {
        List<VcgAn> list = findByPrimaryId(primaryId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last vcg an in the ordered set where primaryId = &#63;.
     *
     * @param primaryId the primary ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findByPrimaryId_Last(long primaryId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = fetchByPrimaryId_Last(primaryId, orderByComparator);

        if (vcgAn != null) {
            return vcgAn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("primaryId=");
        msg.append(primaryId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVcgAnException(msg.toString());
    }

    /**
     * Returns the last vcg an in the ordered set where primaryId = &#63;.
     *
     * @param primaryId the primary ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vcg an, or <code>null</code> if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchByPrimaryId_Last(long primaryId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByPrimaryId(primaryId);

        if (count == 0) {
            return null;
        }

        List<VcgAn> list = findByPrimaryId(primaryId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the vcg ans before and after the current vcg an in the ordered set where primaryId = &#63;.
     *
     * @param vcgAnId the primary key of the current vcg an
     * @param primaryId the primary ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn[] findByPrimaryId_PrevAndNext(long vcgAnId, long primaryId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = findByPrimaryKey(vcgAnId);

        Session session = null;

        try {
            session = openSession();

            VcgAn[] array = new VcgAnImpl[3];

            array[0] = getByPrimaryId_PrevAndNext(session, vcgAn, primaryId,
                    orderByComparator, true);

            array[1] = vcgAn;

            array[2] = getByPrimaryId_PrevAndNext(session, vcgAn, primaryId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected VcgAn getByPrimaryId_PrevAndNext(Session session, VcgAn vcgAn,
        long primaryId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_VCGAN_WHERE);

        query.append(_FINDER_COLUMN_PRIMARYID_PRIMARYID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(VcgAnModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(primaryId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(vcgAn);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<VcgAn> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the vcg ans where primaryId = &#63; from the database.
     *
     * @param primaryId the primary ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByPrimaryId(long primaryId) throws SystemException {
        for (VcgAn vcgAn : findByPrimaryId(primaryId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(vcgAn);
        }
    }

    /**
     * Returns the number of vcg ans where primaryId = &#63;.
     *
     * @param primaryId the primary ID
     * @return the number of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByPrimaryId(long primaryId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_PRIMARYID;

        Object[] finderArgs = new Object[] { primaryId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_VCGAN_WHERE);

            query.append(_FINDER_COLUMN_PRIMARYID_PRIMARYID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(primaryId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the vcg ans where secondaryId = &#63;.
     *
     * @param secondaryId the secondary ID
     * @return the matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findBySecondaryId(long secondaryId)
        throws SystemException {
        return findBySecondaryId(secondaryId, QueryUtil.ALL_POS,
            QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the vcg ans where secondaryId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param secondaryId the secondary ID
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @return the range of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findBySecondaryId(long secondaryId, int start, int end)
        throws SystemException {
        return findBySecondaryId(secondaryId, start, end, null);
    }

    /**
     * Returns an ordered range of all the vcg ans where secondaryId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param secondaryId the secondary ID
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findBySecondaryId(long secondaryId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SECONDARYID;
            finderArgs = new Object[] { secondaryId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_SECONDARYID;
            finderArgs = new Object[] { secondaryId, start, end, orderByComparator };
        }

        List<VcgAn> list = (List<VcgAn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (VcgAn vcgAn : list) {
                if ((secondaryId != vcgAn.getSecondaryId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_VCGAN_WHERE);

            query.append(_FINDER_COLUMN_SECONDARYID_SECONDARYID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(VcgAnModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(secondaryId);

                if (!pagination) {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<VcgAn>(list);
                } else {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first vcg an in the ordered set where secondaryId = &#63;.
     *
     * @param secondaryId the secondary ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findBySecondaryId_First(long secondaryId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = fetchBySecondaryId_First(secondaryId, orderByComparator);

        if (vcgAn != null) {
            return vcgAn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("secondaryId=");
        msg.append(secondaryId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVcgAnException(msg.toString());
    }

    /**
     * Returns the first vcg an in the ordered set where secondaryId = &#63;.
     *
     * @param secondaryId the secondary ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vcg an, or <code>null</code> if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchBySecondaryId_First(long secondaryId,
        OrderByComparator orderByComparator) throws SystemException {
        List<VcgAn> list = findBySecondaryId(secondaryId, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last vcg an in the ordered set where secondaryId = &#63;.
     *
     * @param secondaryId the secondary ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findBySecondaryId_Last(long secondaryId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = fetchBySecondaryId_Last(secondaryId, orderByComparator);

        if (vcgAn != null) {
            return vcgAn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("secondaryId=");
        msg.append(secondaryId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVcgAnException(msg.toString());
    }

    /**
     * Returns the last vcg an in the ordered set where secondaryId = &#63;.
     *
     * @param secondaryId the secondary ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vcg an, or <code>null</code> if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchBySecondaryId_Last(long secondaryId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countBySecondaryId(secondaryId);

        if (count == 0) {
            return null;
        }

        List<VcgAn> list = findBySecondaryId(secondaryId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the vcg ans before and after the current vcg an in the ordered set where secondaryId = &#63;.
     *
     * @param vcgAnId the primary key of the current vcg an
     * @param secondaryId the secondary ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn[] findBySecondaryId_PrevAndNext(long vcgAnId,
        long secondaryId, OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = findByPrimaryKey(vcgAnId);

        Session session = null;

        try {
            session = openSession();

            VcgAn[] array = new VcgAnImpl[3];

            array[0] = getBySecondaryId_PrevAndNext(session, vcgAn,
                    secondaryId, orderByComparator, true);

            array[1] = vcgAn;

            array[2] = getBySecondaryId_PrevAndNext(session, vcgAn,
                    secondaryId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected VcgAn getBySecondaryId_PrevAndNext(Session session, VcgAn vcgAn,
        long secondaryId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_VCGAN_WHERE);

        query.append(_FINDER_COLUMN_SECONDARYID_SECONDARYID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(VcgAnModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(secondaryId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(vcgAn);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<VcgAn> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the vcg ans where secondaryId = &#63; from the database.
     *
     * @param secondaryId the secondary ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeBySecondaryId(long secondaryId) throws SystemException {
        for (VcgAn vcgAn : findBySecondaryId(secondaryId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(vcgAn);
        }
    }

    /**
     * Returns the number of vcg ans where secondaryId = &#63;.
     *
     * @param secondaryId the secondary ID
     * @return the number of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countBySecondaryId(long secondaryId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_SECONDARYID;

        Object[] finderArgs = new Object[] { secondaryId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_VCGAN_WHERE);

            query.append(_FINDER_COLUMN_SECONDARYID_SECONDARYID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(secondaryId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the vcg ans where secondaryTwoId = &#63;.
     *
     * @param secondaryTwoId the secondary two ID
     * @return the matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findBySecondaryTwoId(long secondaryTwoId)
        throws SystemException {
        return findBySecondaryTwoId(secondaryTwoId, QueryUtil.ALL_POS,
            QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the vcg ans where secondaryTwoId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param secondaryTwoId the secondary two ID
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @return the range of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findBySecondaryTwoId(long secondaryTwoId, int start,
        int end) throws SystemException {
        return findBySecondaryTwoId(secondaryTwoId, start, end, null);
    }

    /**
     * Returns an ordered range of all the vcg ans where secondaryTwoId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param secondaryTwoId the secondary two ID
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findBySecondaryTwoId(long secondaryTwoId, int start,
        int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SECONDARYTWOID;
            finderArgs = new Object[] { secondaryTwoId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_SECONDARYTWOID;
            finderArgs = new Object[] {
                    secondaryTwoId,
                    
                    start, end, orderByComparator
                };
        }

        List<VcgAn> list = (List<VcgAn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (VcgAn vcgAn : list) {
                if ((secondaryTwoId != vcgAn.getSecondaryTwoId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_VCGAN_WHERE);

            query.append(_FINDER_COLUMN_SECONDARYTWOID_SECONDARYTWOID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(VcgAnModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(secondaryTwoId);

                if (!pagination) {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<VcgAn>(list);
                } else {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first vcg an in the ordered set where secondaryTwoId = &#63;.
     *
     * @param secondaryTwoId the secondary two ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findBySecondaryTwoId_First(long secondaryTwoId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = fetchBySecondaryTwoId_First(secondaryTwoId,
                orderByComparator);

        if (vcgAn != null) {
            return vcgAn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("secondaryTwoId=");
        msg.append(secondaryTwoId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVcgAnException(msg.toString());
    }

    /**
     * Returns the first vcg an in the ordered set where secondaryTwoId = &#63;.
     *
     * @param secondaryTwoId the secondary two ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vcg an, or <code>null</code> if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchBySecondaryTwoId_First(long secondaryTwoId,
        OrderByComparator orderByComparator) throws SystemException {
        List<VcgAn> list = findBySecondaryTwoId(secondaryTwoId, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last vcg an in the ordered set where secondaryTwoId = &#63;.
     *
     * @param secondaryTwoId the secondary two ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findBySecondaryTwoId_Last(long secondaryTwoId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = fetchBySecondaryTwoId_Last(secondaryTwoId,
                orderByComparator);

        if (vcgAn != null) {
            return vcgAn;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("secondaryTwoId=");
        msg.append(secondaryTwoId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVcgAnException(msg.toString());
    }

    /**
     * Returns the last vcg an in the ordered set where secondaryTwoId = &#63;.
     *
     * @param secondaryTwoId the secondary two ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vcg an, or <code>null</code> if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchBySecondaryTwoId_Last(long secondaryTwoId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countBySecondaryTwoId(secondaryTwoId);

        if (count == 0) {
            return null;
        }

        List<VcgAn> list = findBySecondaryTwoId(secondaryTwoId, count - 1,
                count, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the vcg ans before and after the current vcg an in the ordered set where secondaryTwoId = &#63;.
     *
     * @param vcgAnId the primary key of the current vcg an
     * @param secondaryTwoId the secondary two ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn[] findBySecondaryTwoId_PrevAndNext(long vcgAnId,
        long secondaryTwoId, OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = findByPrimaryKey(vcgAnId);

        Session session = null;

        try {
            session = openSession();

            VcgAn[] array = new VcgAnImpl[3];

            array[0] = getBySecondaryTwoId_PrevAndNext(session, vcgAn,
                    secondaryTwoId, orderByComparator, true);

            array[1] = vcgAn;

            array[2] = getBySecondaryTwoId_PrevAndNext(session, vcgAn,
                    secondaryTwoId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected VcgAn getBySecondaryTwoId_PrevAndNext(Session session,
        VcgAn vcgAn, long secondaryTwoId, OrderByComparator orderByComparator,
        boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_VCGAN_WHERE);

        query.append(_FINDER_COLUMN_SECONDARYTWOID_SECONDARYTWOID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(VcgAnModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(secondaryTwoId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(vcgAn);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<VcgAn> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the vcg ans where secondaryTwoId = &#63; from the database.
     *
     * @param secondaryTwoId the secondary two ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeBySecondaryTwoId(long secondaryTwoId)
        throws SystemException {
        for (VcgAn vcgAn : findBySecondaryTwoId(secondaryTwoId,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(vcgAn);
        }
    }

    /**
     * Returns the number of vcg ans where secondaryTwoId = &#63;.
     *
     * @param secondaryTwoId the secondary two ID
     * @return the number of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countBySecondaryTwoId(long secondaryTwoId)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_SECONDARYTWOID;

        Object[] finderArgs = new Object[] { secondaryTwoId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_VCGAN_WHERE);

            query.append(_FINDER_COLUMN_SECONDARYTWOID_SECONDARYTWOID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(secondaryTwoId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the vcg ans where primaryId &gt; &#63; and veteranId = &#63;.
     *
     * @param primaryId the primary ID
     * @param veteranId the veteran ID
     * @return the matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findByPrimaryApp(long primaryId, long veteranId)
        throws SystemException {
        return findByPrimaryApp(primaryId, veteranId, QueryUtil.ALL_POS,
            QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the vcg ans where primaryId &gt; &#63; and veteranId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param primaryId the primary ID
     * @param veteranId the veteran ID
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @return the range of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findByPrimaryApp(long primaryId, long veteranId,
        int start, int end) throws SystemException {
        return findByPrimaryApp(primaryId, veteranId, start, end, null);
    }

    /**
     * Returns an ordered range of all the vcg ans where primaryId &gt; &#63; and veteranId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param primaryId the primary ID
     * @param veteranId the veteran ID
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findByPrimaryApp(long primaryId, long veteranId,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_PRIMARYAPP;
        finderArgs = new Object[] {
                primaryId, veteranId,
                
                start, end, orderByComparator
            };

        List<VcgAn> list = (List<VcgAn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (VcgAn vcgAn : list) {
                if ((primaryId >= vcgAn.getPrimaryId()) ||
                        (veteranId != vcgAn.getVeteranId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(4 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(4);
            }

            query.append(_SQL_SELECT_VCGAN_WHERE);

            query.append(_FINDER_COLUMN_PRIMARYAPP_PRIMARYID_2);

            query.append(_FINDER_COLUMN_PRIMARYAPP_VETERANID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(VcgAnModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(primaryId);

                qPos.add(veteranId);

                if (!pagination) {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<VcgAn>(list);
                } else {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first vcg an in the ordered set where primaryId &gt; &#63; and veteranId = &#63;.
     *
     * @param primaryId the primary ID
     * @param veteranId the veteran ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findByPrimaryApp_First(long primaryId, long veteranId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = fetchByPrimaryApp_First(primaryId, veteranId,
                orderByComparator);

        if (vcgAn != null) {
            return vcgAn;
        }

        StringBundler msg = new StringBundler(6);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("primaryId=");
        msg.append(primaryId);

        msg.append(", veteranId=");
        msg.append(veteranId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVcgAnException(msg.toString());
    }

    /**
     * Returns the first vcg an in the ordered set where primaryId &gt; &#63; and veteranId = &#63;.
     *
     * @param primaryId the primary ID
     * @param veteranId the veteran ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching vcg an, or <code>null</code> if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchByPrimaryApp_First(long primaryId, long veteranId,
        OrderByComparator orderByComparator) throws SystemException {
        List<VcgAn> list = findByPrimaryApp(primaryId, veteranId, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last vcg an in the ordered set where primaryId &gt; &#63; and veteranId = &#63;.
     *
     * @param primaryId the primary ID
     * @param veteranId the veteran ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findByPrimaryApp_Last(long primaryId, long veteranId,
        OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = fetchByPrimaryApp_Last(primaryId, veteranId,
                orderByComparator);

        if (vcgAn != null) {
            return vcgAn;
        }

        StringBundler msg = new StringBundler(6);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("primaryId=");
        msg.append(primaryId);

        msg.append(", veteranId=");
        msg.append(veteranId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchVcgAnException(msg.toString());
    }

    /**
     * Returns the last vcg an in the ordered set where primaryId &gt; &#63; and veteranId = &#63;.
     *
     * @param primaryId the primary ID
     * @param veteranId the veteran ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching vcg an, or <code>null</code> if a matching vcg an could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchByPrimaryApp_Last(long primaryId, long veteranId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByPrimaryApp(primaryId, veteranId);

        if (count == 0) {
            return null;
        }

        List<VcgAn> list = findByPrimaryApp(primaryId, veteranId, count - 1,
                count, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the vcg ans before and after the current vcg an in the ordered set where primaryId &gt; &#63; and veteranId = &#63;.
     *
     * @param vcgAnId the primary key of the current vcg an
     * @param primaryId the primary ID
     * @param veteranId the veteran ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn[] findByPrimaryApp_PrevAndNext(long vcgAnId, long primaryId,
        long veteranId, OrderByComparator orderByComparator)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = findByPrimaryKey(vcgAnId);

        Session session = null;

        try {
            session = openSession();

            VcgAn[] array = new VcgAnImpl[3];

            array[0] = getByPrimaryApp_PrevAndNext(session, vcgAn, primaryId,
                    veteranId, orderByComparator, true);

            array[1] = vcgAn;

            array[2] = getByPrimaryApp_PrevAndNext(session, vcgAn, primaryId,
                    veteranId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected VcgAn getByPrimaryApp_PrevAndNext(Session session, VcgAn vcgAn,
        long primaryId, long veteranId, OrderByComparator orderByComparator,
        boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_VCGAN_WHERE);

        query.append(_FINDER_COLUMN_PRIMARYAPP_PRIMARYID_2);

        query.append(_FINDER_COLUMN_PRIMARYAPP_VETERANID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(VcgAnModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(primaryId);

        qPos.add(veteranId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(vcgAn);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<VcgAn> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the vcg ans where primaryId &gt; &#63; and veteranId = &#63; from the database.
     *
     * @param primaryId the primary ID
     * @param veteranId the veteran ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByPrimaryApp(long primaryId, long veteranId)
        throws SystemException {
        for (VcgAn vcgAn : findByPrimaryApp(primaryId, veteranId,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(vcgAn);
        }
    }

    /**
     * Returns the number of vcg ans where primaryId &gt; &#63; and veteranId = &#63;.
     *
     * @param primaryId the primary ID
     * @param veteranId the veteran ID
     * @return the number of matching vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByPrimaryApp(long primaryId, long veteranId)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_WITH_PAGINATION_COUNT_BY_PRIMARYAPP;

        Object[] finderArgs = new Object[] { primaryId, veteranId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_COUNT_VCGAN_WHERE);

            query.append(_FINDER_COLUMN_PRIMARYAPP_PRIMARYID_2);

            query.append(_FINDER_COLUMN_PRIMARYAPP_VETERANID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(primaryId);

                qPos.add(veteranId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the vcg an in the entity cache if it is enabled.
     *
     * @param vcgAn the vcg an
     */
    @Override
    public void cacheResult(VcgAn vcgAn) {
        EntityCacheUtil.putResult(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnImpl.class, vcgAn.getPrimaryKey(), vcgAn);

        vcgAn.resetOriginalValues();
    }

    /**
     * Caches the vcg ans in the entity cache if it is enabled.
     *
     * @param vcgAns the vcg ans
     */
    @Override
    public void cacheResult(List<VcgAn> vcgAns) {
        for (VcgAn vcgAn : vcgAns) {
            if (EntityCacheUtil.getResult(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
                        VcgAnImpl.class, vcgAn.getPrimaryKey()) == null) {
                cacheResult(vcgAn);
            } else {
                vcgAn.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all vcg ans.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(VcgAnImpl.class.getName());
        }

        EntityCacheUtil.clearCache(VcgAnImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the vcg an.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(VcgAn vcgAn) {
        EntityCacheUtil.removeResult(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnImpl.class, vcgAn.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<VcgAn> vcgAns) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (VcgAn vcgAn : vcgAns) {
            EntityCacheUtil.removeResult(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
                VcgAnImpl.class, vcgAn.getPrimaryKey());
        }
    }

    /**
     * Creates a new vcg an with the primary key. Does not add the vcg an to the database.
     *
     * @param vcgAnId the primary key for the new vcg an
     * @return the new vcg an
     */
    @Override
    public VcgAn create(long vcgAnId) {
        VcgAn vcgAn = new VcgAnImpl();

        vcgAn.setNew(true);
        vcgAn.setPrimaryKey(vcgAnId);

        return vcgAn;
    }

    /**
     * Removes the vcg an with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param vcgAnId the primary key of the vcg an
     * @return the vcg an that was removed
     * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn remove(long vcgAnId)
        throws NoSuchVcgAnException, SystemException {
        return remove((Serializable) vcgAnId);
    }

    /**
     * Removes the vcg an with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the vcg an
     * @return the vcg an that was removed
     * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn remove(Serializable primaryKey)
        throws NoSuchVcgAnException, SystemException {
        Session session = null;

        try {
            session = openSession();

            VcgAn vcgAn = (VcgAn) session.get(VcgAnImpl.class, primaryKey);

            if (vcgAn == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchVcgAnException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(vcgAn);
        } catch (NoSuchVcgAnException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected VcgAn removeImpl(VcgAn vcgAn) throws SystemException {
        vcgAn = toUnwrappedModel(vcgAn);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(vcgAn)) {
                vcgAn = (VcgAn) session.get(VcgAnImpl.class,
                        vcgAn.getPrimaryKeyObj());
            }

            if (vcgAn != null) {
                session.delete(vcgAn);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (vcgAn != null) {
            clearCache(vcgAn);
        }

        return vcgAn;
    }

    @Override
    public VcgAn updateImpl(gov.va.caret.model.VcgAn vcgAn)
        throws SystemException {
        vcgAn = toUnwrappedModel(vcgAn);

        boolean isNew = vcgAn.isNew();

        VcgAnModelImpl vcgAnModelImpl = (VcgAnModelImpl) vcgAn;

        Session session = null;

        try {
            session = openSession();

            if (vcgAn.isNew()) {
                session.save(vcgAn);

                vcgAn.setNew(false);
            } else {
                session.merge(vcgAn);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !VcgAnModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((vcgAnModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { vcgAnModelImpl.getOriginalVcgId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VCGID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGID,
                    args);

                args = new Object[] { vcgAnModelImpl.getVcgId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VCGID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGID,
                    args);
            }

            if ((vcgAnModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VETERANID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        vcgAnModelImpl.getOriginalVeteranId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VETERANID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VETERANID,
                    args);

                args = new Object[] { vcgAnModelImpl.getVeteranId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VETERANID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VETERANID,
                    args);
            }

            if ((vcgAnModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PRIMARYID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        vcgAnModelImpl.getOriginalPrimaryId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_PRIMARYID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PRIMARYID,
                    args);

                args = new Object[] { vcgAnModelImpl.getPrimaryId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_PRIMARYID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PRIMARYID,
                    args);
            }

            if ((vcgAnModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SECONDARYID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        vcgAnModelImpl.getOriginalSecondaryId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_SECONDARYID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SECONDARYID,
                    args);

                args = new Object[] { vcgAnModelImpl.getSecondaryId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_SECONDARYID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SECONDARYID,
                    args);
            }

            if ((vcgAnModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SECONDARYTWOID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        vcgAnModelImpl.getOriginalSecondaryTwoId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_SECONDARYTWOID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SECONDARYTWOID,
                    args);

                args = new Object[] { vcgAnModelImpl.getSecondaryTwoId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_SECONDARYTWOID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SECONDARYTWOID,
                    args);
            }
        }

        EntityCacheUtil.putResult(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
            VcgAnImpl.class, vcgAn.getPrimaryKey(), vcgAn);

        return vcgAn;
    }

    protected VcgAn toUnwrappedModel(VcgAn vcgAn) {
        if (vcgAn instanceof VcgAnImpl) {
            return vcgAn;
        }

        VcgAnImpl vcgAnImpl = new VcgAnImpl();

        vcgAnImpl.setNew(vcgAn.isNew());
        vcgAnImpl.setPrimaryKey(vcgAn.getPrimaryKey());

        vcgAnImpl.setVcgAnId(vcgAn.getVcgAnId());
        vcgAnImpl.setVcgId(vcgAn.getVcgId());
        vcgAnImpl.setVeteranId(vcgAn.getVeteranId());
        vcgAnImpl.setPrimaryId(vcgAn.getPrimaryId());
        vcgAnImpl.setSecondaryId(vcgAn.getSecondaryId());
        vcgAnImpl.setSecondaryTwoId(vcgAn.getSecondaryTwoId());
        vcgAnImpl.setStatus(vcgAn.getStatus());
        vcgAnImpl.setReceivedDate(vcgAn.getReceivedDate());
        vcgAnImpl.setPrimaryRelationship(vcgAn.getPrimaryRelationship());
        vcgAnImpl.setSecondaryRelationship(vcgAn.getSecondaryRelationship());
        vcgAnImpl.setSecondaryTwoRelationship(vcgAn.getSecondaryTwoRelationship());
        vcgAnImpl.setPrimarySignDate(vcgAn.getPrimarySignDate());
        vcgAnImpl.setSecondarySignDate(vcgAn.getSecondarySignDate());
        vcgAnImpl.setSecondaryTwoSignDate(vcgAn.getSecondaryTwoSignDate());
        vcgAnImpl.setVaHealthEnrolled(vcgAn.isVaHealthEnrolled());
        vcgAnImpl.setMediEnrolled(vcgAn.isMediEnrolled());
        vcgAnImpl.setLastTreatmentPlace(vcgAn.getLastTreatmentPlace());
        vcgAnImpl.setHospital(vcgAn.isHospital());
        vcgAnImpl.setClinic(vcgAn.isClinic());
        vcgAnImpl.setSubmitDate(vcgAn.getSubmitDate());
        vcgAnImpl.setCreationDate(vcgAn.getCreationDate());
        vcgAnImpl.setGroupId(vcgAn.getGroupId());

        return vcgAnImpl;
    }

    /**
     * Returns the vcg an with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the vcg an
     * @return the vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findByPrimaryKey(Serializable primaryKey)
        throws NoSuchVcgAnException, SystemException {
        VcgAn vcgAn = fetchByPrimaryKey(primaryKey);

        if (vcgAn == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchVcgAnException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return vcgAn;
    }

    /**
     * Returns the vcg an with the primary key or throws a {@link gov.va.caret.NoSuchVcgAnException} if it could not be found.
     *
     * @param vcgAnId the primary key of the vcg an
     * @return the vcg an
     * @throws gov.va.caret.NoSuchVcgAnException if a vcg an with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn findByPrimaryKey(long vcgAnId)
        throws NoSuchVcgAnException, SystemException {
        return findByPrimaryKey((Serializable) vcgAnId);
    }

    /**
     * Returns the vcg an with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the vcg an
     * @return the vcg an, or <code>null</code> if a vcg an with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        VcgAn vcgAn = (VcgAn) EntityCacheUtil.getResult(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
                VcgAnImpl.class, primaryKey);

        if (vcgAn == _nullVcgAn) {
            return null;
        }

        if (vcgAn == null) {
            Session session = null;

            try {
                session = openSession();

                vcgAn = (VcgAn) session.get(VcgAnImpl.class, primaryKey);

                if (vcgAn != null) {
                    cacheResult(vcgAn);
                } else {
                    EntityCacheUtil.putResult(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
                        VcgAnImpl.class, primaryKey, _nullVcgAn);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(VcgAnModelImpl.ENTITY_CACHE_ENABLED,
                    VcgAnImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return vcgAn;
    }

    /**
     * Returns the vcg an with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param vcgAnId the primary key of the vcg an
     * @return the vcg an, or <code>null</code> if a vcg an with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public VcgAn fetchByPrimaryKey(long vcgAnId) throws SystemException {
        return fetchByPrimaryKey((Serializable) vcgAnId);
    }

    /**
     * Returns all the vcg ans.
     *
     * @return the vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the vcg ans.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @return the range of vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the vcg ans.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.VcgAnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of vcg ans
     * @param end the upper bound of the range of vcg ans (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<VcgAn> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<VcgAn> list = (List<VcgAn>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_VCGAN);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_VCGAN;

                if (pagination) {
                    sql = sql.concat(VcgAnModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<VcgAn>(list);
                } else {
                    list = (List<VcgAn>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the vcg ans from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (VcgAn vcgAn : findAll()) {
            remove(vcgAn);
        }
    }

    /**
     * Returns the number of vcg ans.
     *
     * @return the number of vcg ans
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_VCGAN);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the vcg an persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.VcgAn")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<VcgAn>> listenersList = new ArrayList<ModelListener<VcgAn>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<VcgAn>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(VcgAnImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
