package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchStiPtException;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.impl.StiPtImpl;
import gov.va.caret.model.impl.StiPtModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * The persistence implementation for the sti pt service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see StiPtPersistence
 * @see StiPtUtil
 * @generated
 */
public class StiPtPersistenceImpl extends BasePersistenceImpl<StiPt>
    implements StiPtPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link StiPtUtil} to access the sti pt persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = StiPtImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtModelImpl.FINDER_CACHE_ENABLED, StiPtImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtModelImpl.FINDER_CACHE_ENABLED, StiPtImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_STIRDID = new FinderPath(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtModelImpl.FINDER_CACHE_ENABLED, StiPtImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByStiRdId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIRDID =
        new FinderPath(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtModelImpl.FINDER_CACHE_ENABLED, StiPtImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByStiRdId",
            new String[] { Long.class.getName() },
            StiPtModelImpl.STIRDID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_STIRDID = new FinderPath(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByStiRdId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_STIRDID_STIRDID_2 = "stiPt.stiRdId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_VENDRID = new FinderPath(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtModelImpl.FINDER_CACHE_ENABLED, StiPtImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByVendrId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VENDRID =
        new FinderPath(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtModelImpl.FINDER_CACHE_ENABLED, StiPtImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByVendrId",
            new String[] { Long.class.getName() },
            StiPtModelImpl.VENDRID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_VENDRID = new FinderPath(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByVendrId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_VENDRID_VENDRID_2 = "stiPt.vendrId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_STIPENDSTATUS =
        new FinderPath(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtModelImpl.FINDER_CACHE_ENABLED, StiPtImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByStipendStatus",
            new String[] {
                String.class.getName(), Date.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIPENDSTATUS =
        new FinderPath(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtModelImpl.FINDER_CACHE_ENABLED, StiPtImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByStipendStatus",
            new String[] { String.class.getName(), Date.class.getName() },
            StiPtModelImpl.STIPENDSTATUS_COLUMN_BITMASK |
            StiPtModelImpl.STIPENDSTARTDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_STIPENDSTATUS = new FinderPath(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByStipendStatus",
            new String[] { String.class.getName(), Date.class.getName() });
    private static final String _FINDER_COLUMN_STIPENDSTATUS_STIPENDSTATUS_1 = "stiPt.stipendStatus IS NULL AND ";
    private static final String _FINDER_COLUMN_STIPENDSTATUS_STIPENDSTATUS_2 = "stiPt.stipendStatus = ? AND ";
    private static final String _FINDER_COLUMN_STIPENDSTATUS_STIPENDSTATUS_3 = "(stiPt.stipendStatus IS NULL OR stiPt.stipendStatus = '') AND ";
    private static final String _FINDER_COLUMN_STIPENDSTATUS_STIPENDSTARTDATE_1 = "stiPt.stipendStartDate IS NULL";
    private static final String _FINDER_COLUMN_STIPENDSTATUS_STIPENDSTARTDATE_2 = "stiPt.stipendStartDate = ?";
    private static final String _SQL_SELECT_STIPT = "SELECT stiPt FROM StiPt stiPt";
    private static final String _SQL_SELECT_STIPT_WHERE = "SELECT stiPt FROM StiPt stiPt WHERE ";
    private static final String _SQL_COUNT_STIPT = "SELECT COUNT(stiPt) FROM StiPt stiPt";
    private static final String _SQL_COUNT_STIPT_WHERE = "SELECT COUNT(stiPt) FROM StiPt stiPt WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "stiPt.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No StiPt exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No StiPt exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(StiPtPersistenceImpl.class);
    private static StiPt _nullStiPt = new StiPtImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<StiPt> toCacheModel() {
                return _nullStiPtCacheModel;
            }
        };

    private static CacheModel<StiPt> _nullStiPtCacheModel = new CacheModel<StiPt>() {
            @Override
            public StiPt toEntityModel() {
                return _nullStiPt;
            }
        };

    public StiPtPersistenceImpl() {
        setModelClass(StiPt.class);
    }

    /**
     * Returns all the sti pts where stiRdId = &#63;.
     *
     * @param stiRdId the sti rd ID
     * @return the matching sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiPt> findByStiRdId(long stiRdId) throws SystemException {
        return findByStiRdId(stiRdId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the sti pts where stiRdId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param stiRdId the sti rd ID
     * @param start the lower bound of the range of sti pts
     * @param end the upper bound of the range of sti pts (not inclusive)
     * @return the range of matching sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiPt> findByStiRdId(long stiRdId, int start, int end)
        throws SystemException {
        return findByStiRdId(stiRdId, start, end, null);
    }

    /**
     * Returns an ordered range of all the sti pts where stiRdId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param stiRdId the sti rd ID
     * @param start the lower bound of the range of sti pts
     * @param end the upper bound of the range of sti pts (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiPt> findByStiRdId(long stiRdId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIRDID;
            finderArgs = new Object[] { stiRdId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_STIRDID;
            finderArgs = new Object[] { stiRdId, start, end, orderByComparator };
        }

        List<StiPt> list = (List<StiPt>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (StiPt stiPt : list) {
                if ((stiRdId != stiPt.getStiRdId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_STIPT_WHERE);

            query.append(_FINDER_COLUMN_STIRDID_STIRDID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(StiPtModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(stiRdId);

                if (!pagination) {
                    list = (List<StiPt>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<StiPt>(list);
                } else {
                    list = (List<StiPt>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first sti pt in the ordered set where stiRdId = &#63;.
     *
     * @param stiRdId the sti rd ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching sti pt
     * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt findByStiRdId_First(long stiRdId,
        OrderByComparator orderByComparator)
        throws NoSuchStiPtException, SystemException {
        StiPt stiPt = fetchByStiRdId_First(stiRdId, orderByComparator);

        if (stiPt != null) {
            return stiPt;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("stiRdId=");
        msg.append(stiRdId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchStiPtException(msg.toString());
    }

    /**
     * Returns the first sti pt in the ordered set where stiRdId = &#63;.
     *
     * @param stiRdId the sti rd ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching sti pt, or <code>null</code> if a matching sti pt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt fetchByStiRdId_First(long stiRdId,
        OrderByComparator orderByComparator) throws SystemException {
        List<StiPt> list = findByStiRdId(stiRdId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last sti pt in the ordered set where stiRdId = &#63;.
     *
     * @param stiRdId the sti rd ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching sti pt
     * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt findByStiRdId_Last(long stiRdId,
        OrderByComparator orderByComparator)
        throws NoSuchStiPtException, SystemException {
        StiPt stiPt = fetchByStiRdId_Last(stiRdId, orderByComparator);

        if (stiPt != null) {
            return stiPt;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("stiRdId=");
        msg.append(stiRdId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchStiPtException(msg.toString());
    }

    /**
     * Returns the last sti pt in the ordered set where stiRdId = &#63;.
     *
     * @param stiRdId the sti rd ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching sti pt, or <code>null</code> if a matching sti pt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt fetchByStiRdId_Last(long stiRdId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByStiRdId(stiRdId);

        if (count == 0) {
            return null;
        }

        List<StiPt> list = findByStiRdId(stiRdId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the sti pts before and after the current sti pt in the ordered set where stiRdId = &#63;.
     *
     * @param stiPtId the primary key of the current sti pt
     * @param stiRdId the sti rd ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next sti pt
     * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt[] findByStiRdId_PrevAndNext(long stiPtId, long stiRdId,
        OrderByComparator orderByComparator)
        throws NoSuchStiPtException, SystemException {
        StiPt stiPt = findByPrimaryKey(stiPtId);

        Session session = null;

        try {
            session = openSession();

            StiPt[] array = new StiPtImpl[3];

            array[0] = getByStiRdId_PrevAndNext(session, stiPt, stiRdId,
                    orderByComparator, true);

            array[1] = stiPt;

            array[2] = getByStiRdId_PrevAndNext(session, stiPt, stiRdId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected StiPt getByStiRdId_PrevAndNext(Session session, StiPt stiPt,
        long stiRdId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_STIPT_WHERE);

        query.append(_FINDER_COLUMN_STIRDID_STIRDID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(StiPtModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(stiRdId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(stiPt);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<StiPt> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the sti pts where stiRdId = &#63; from the database.
     *
     * @param stiRdId the sti rd ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByStiRdId(long stiRdId) throws SystemException {
        for (StiPt stiPt : findByStiRdId(stiRdId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(stiPt);
        }
    }

    /**
     * Returns the number of sti pts where stiRdId = &#63;.
     *
     * @param stiRdId the sti rd ID
     * @return the number of matching sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByStiRdId(long stiRdId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_STIRDID;

        Object[] finderArgs = new Object[] { stiRdId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_STIPT_WHERE);

            query.append(_FINDER_COLUMN_STIRDID_STIRDID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(stiRdId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the sti pts where vendrId = &#63;.
     *
     * @param vendrId the vendr ID
     * @return the matching sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiPt> findByVendrId(long vendrId) throws SystemException {
        return findByVendrId(vendrId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the sti pts where vendrId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param vendrId the vendr ID
     * @param start the lower bound of the range of sti pts
     * @param end the upper bound of the range of sti pts (not inclusive)
     * @return the range of matching sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiPt> findByVendrId(long vendrId, int start, int end)
        throws SystemException {
        return findByVendrId(vendrId, start, end, null);
    }

    /**
     * Returns an ordered range of all the sti pts where vendrId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param vendrId the vendr ID
     * @param start the lower bound of the range of sti pts
     * @param end the upper bound of the range of sti pts (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiPt> findByVendrId(long vendrId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VENDRID;
            finderArgs = new Object[] { vendrId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_VENDRID;
            finderArgs = new Object[] { vendrId, start, end, orderByComparator };
        }

        List<StiPt> list = (List<StiPt>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (StiPt stiPt : list) {
                if ((vendrId != stiPt.getVendrId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_STIPT_WHERE);

            query.append(_FINDER_COLUMN_VENDRID_VENDRID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(StiPtModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(vendrId);

                if (!pagination) {
                    list = (List<StiPt>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<StiPt>(list);
                } else {
                    list = (List<StiPt>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first sti pt in the ordered set where vendrId = &#63;.
     *
     * @param vendrId the vendr ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching sti pt
     * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt findByVendrId_First(long vendrId,
        OrderByComparator orderByComparator)
        throws NoSuchStiPtException, SystemException {
        StiPt stiPt = fetchByVendrId_First(vendrId, orderByComparator);

        if (stiPt != null) {
            return stiPt;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("vendrId=");
        msg.append(vendrId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchStiPtException(msg.toString());
    }

    /**
     * Returns the first sti pt in the ordered set where vendrId = &#63;.
     *
     * @param vendrId the vendr ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching sti pt, or <code>null</code> if a matching sti pt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt fetchByVendrId_First(long vendrId,
        OrderByComparator orderByComparator) throws SystemException {
        List<StiPt> list = findByVendrId(vendrId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last sti pt in the ordered set where vendrId = &#63;.
     *
     * @param vendrId the vendr ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching sti pt
     * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt findByVendrId_Last(long vendrId,
        OrderByComparator orderByComparator)
        throws NoSuchStiPtException, SystemException {
        StiPt stiPt = fetchByVendrId_Last(vendrId, orderByComparator);

        if (stiPt != null) {
            return stiPt;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("vendrId=");
        msg.append(vendrId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchStiPtException(msg.toString());
    }

    /**
     * Returns the last sti pt in the ordered set where vendrId = &#63;.
     *
     * @param vendrId the vendr ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching sti pt, or <code>null</code> if a matching sti pt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt fetchByVendrId_Last(long vendrId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByVendrId(vendrId);

        if (count == 0) {
            return null;
        }

        List<StiPt> list = findByVendrId(vendrId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the sti pts before and after the current sti pt in the ordered set where vendrId = &#63;.
     *
     * @param stiPtId the primary key of the current sti pt
     * @param vendrId the vendr ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next sti pt
     * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt[] findByVendrId_PrevAndNext(long stiPtId, long vendrId,
        OrderByComparator orderByComparator)
        throws NoSuchStiPtException, SystemException {
        StiPt stiPt = findByPrimaryKey(stiPtId);

        Session session = null;

        try {
            session = openSession();

            StiPt[] array = new StiPtImpl[3];

            array[0] = getByVendrId_PrevAndNext(session, stiPt, vendrId,
                    orderByComparator, true);

            array[1] = stiPt;

            array[2] = getByVendrId_PrevAndNext(session, stiPt, vendrId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected StiPt getByVendrId_PrevAndNext(Session session, StiPt stiPt,
        long vendrId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_STIPT_WHERE);

        query.append(_FINDER_COLUMN_VENDRID_VENDRID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(StiPtModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(vendrId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(stiPt);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<StiPt> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the sti pts where vendrId = &#63; from the database.
     *
     * @param vendrId the vendr ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByVendrId(long vendrId) throws SystemException {
        for (StiPt stiPt : findByVendrId(vendrId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(stiPt);
        }
    }

    /**
     * Returns the number of sti pts where vendrId = &#63;.
     *
     * @param vendrId the vendr ID
     * @return the number of matching sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByVendrId(long vendrId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_VENDRID;

        Object[] finderArgs = new Object[] { vendrId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_STIPT_WHERE);

            query.append(_FINDER_COLUMN_VENDRID_VENDRID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(vendrId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the sti pts where stipendStatus = &#63; and stipendStartDate = &#63;.
     *
     * @param stipendStatus the stipend status
     * @param stipendStartDate the stipend start date
     * @return the matching sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiPt> findByStipendStatus(String stipendStatus,
        Date stipendStartDate) throws SystemException {
        return findByStipendStatus(stipendStatus, stipendStartDate,
            QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the sti pts where stipendStatus = &#63; and stipendStartDate = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param stipendStatus the stipend status
     * @param stipendStartDate the stipend start date
     * @param start the lower bound of the range of sti pts
     * @param end the upper bound of the range of sti pts (not inclusive)
     * @return the range of matching sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiPt> findByStipendStatus(String stipendStatus,
        Date stipendStartDate, int start, int end) throws SystemException {
        return findByStipendStatus(stipendStatus, stipendStartDate, start, end,
            null);
    }

    /**
     * Returns an ordered range of all the sti pts where stipendStatus = &#63; and stipendStartDate = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param stipendStatus the stipend status
     * @param stipendStartDate the stipend start date
     * @param start the lower bound of the range of sti pts
     * @param end the upper bound of the range of sti pts (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiPt> findByStipendStatus(String stipendStatus,
        Date stipendStartDate, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIPENDSTATUS;
            finderArgs = new Object[] { stipendStatus, stipendStartDate };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_STIPENDSTATUS;
            finderArgs = new Object[] {
                    stipendStatus, stipendStartDate,
                    
                    start, end, orderByComparator
                };
        }

        List<StiPt> list = (List<StiPt>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (StiPt stiPt : list) {
                if (!Validator.equals(stipendStatus, stiPt.getStipendStatus()) ||
                        !Validator.equals(stipendStartDate,
                            stiPt.getStipendStartDate())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(4 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(4);
            }

            query.append(_SQL_SELECT_STIPT_WHERE);

            boolean bindStipendStatus = false;

            if (stipendStatus == null) {
                query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTATUS_1);
            } else if (stipendStatus.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTATUS_3);
            } else {
                bindStipendStatus = true;

                query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTATUS_2);
            }

            boolean bindStipendStartDate = false;

            if (stipendStartDate == null) {
                query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTARTDATE_1);
            } else {
                bindStipendStartDate = true;

                query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTARTDATE_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(StiPtModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindStipendStatus) {
                    qPos.add(stipendStatus);
                }

                if (bindStipendStartDate) {
                    qPos.add(CalendarUtil.getTimestamp(stipendStartDate));
                }

                if (!pagination) {
                    list = (List<StiPt>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<StiPt>(list);
                } else {
                    list = (List<StiPt>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
     *
     * @param stipendStatus the stipend status
     * @param stipendStartDate the stipend start date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching sti pt
     * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt findByStipendStatus_First(String stipendStatus,
        Date stipendStartDate, OrderByComparator orderByComparator)
        throws NoSuchStiPtException, SystemException {
        StiPt stiPt = fetchByStipendStatus_First(stipendStatus,
                stipendStartDate, orderByComparator);

        if (stiPt != null) {
            return stiPt;
        }

        StringBundler msg = new StringBundler(6);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("stipendStatus=");
        msg.append(stipendStatus);

        msg.append(", stipendStartDate=");
        msg.append(stipendStartDate);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchStiPtException(msg.toString());
    }

    /**
     * Returns the first sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
     *
     * @param stipendStatus the stipend status
     * @param stipendStartDate the stipend start date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching sti pt, or <code>null</code> if a matching sti pt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt fetchByStipendStatus_First(String stipendStatus,
        Date stipendStartDate, OrderByComparator orderByComparator)
        throws SystemException {
        List<StiPt> list = findByStipendStatus(stipendStatus, stipendStartDate,
                0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
     *
     * @param stipendStatus the stipend status
     * @param stipendStartDate the stipend start date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching sti pt
     * @throws gov.va.caret.NoSuchStiPtException if a matching sti pt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt findByStipendStatus_Last(String stipendStatus,
        Date stipendStartDate, OrderByComparator orderByComparator)
        throws NoSuchStiPtException, SystemException {
        StiPt stiPt = fetchByStipendStatus_Last(stipendStatus,
                stipendStartDate, orderByComparator);

        if (stiPt != null) {
            return stiPt;
        }

        StringBundler msg = new StringBundler(6);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("stipendStatus=");
        msg.append(stipendStatus);

        msg.append(", stipendStartDate=");
        msg.append(stipendStartDate);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchStiPtException(msg.toString());
    }

    /**
     * Returns the last sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
     *
     * @param stipendStatus the stipend status
     * @param stipendStartDate the stipend start date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching sti pt, or <code>null</code> if a matching sti pt could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt fetchByStipendStatus_Last(String stipendStatus,
        Date stipendStartDate, OrderByComparator orderByComparator)
        throws SystemException {
        int count = countByStipendStatus(stipendStatus, stipendStartDate);

        if (count == 0) {
            return null;
        }

        List<StiPt> list = findByStipendStatus(stipendStatus, stipendStartDate,
                count - 1, count, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the sti pts before and after the current sti pt in the ordered set where stipendStatus = &#63; and stipendStartDate = &#63;.
     *
     * @param stiPtId the primary key of the current sti pt
     * @param stipendStatus the stipend status
     * @param stipendStartDate the stipend start date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next sti pt
     * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt[] findByStipendStatus_PrevAndNext(long stiPtId,
        String stipendStatus, Date stipendStartDate,
        OrderByComparator orderByComparator)
        throws NoSuchStiPtException, SystemException {
        StiPt stiPt = findByPrimaryKey(stiPtId);

        Session session = null;

        try {
            session = openSession();

            StiPt[] array = new StiPtImpl[3];

            array[0] = getByStipendStatus_PrevAndNext(session, stiPt,
                    stipendStatus, stipendStartDate, orderByComparator, true);

            array[1] = stiPt;

            array[2] = getByStipendStatus_PrevAndNext(session, stiPt,
                    stipendStatus, stipendStartDate, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected StiPt getByStipendStatus_PrevAndNext(Session session,
        StiPt stiPt, String stipendStatus, Date stipendStartDate,
        OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_STIPT_WHERE);

        boolean bindStipendStatus = false;

        if (stipendStatus == null) {
            query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTATUS_1);
        } else if (stipendStatus.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTATUS_3);
        } else {
            bindStipendStatus = true;

            query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTATUS_2);
        }

        boolean bindStipendStartDate = false;

        if (stipendStartDate == null) {
            query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTARTDATE_1);
        } else {
            bindStipendStartDate = true;

            query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTARTDATE_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(StiPtModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindStipendStatus) {
            qPos.add(stipendStatus);
        }

        if (bindStipendStartDate) {
            qPos.add(CalendarUtil.getTimestamp(stipendStartDate));
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(stiPt);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<StiPt> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the sti pts where stipendStatus = &#63; and stipendStartDate = &#63; from the database.
     *
     * @param stipendStatus the stipend status
     * @param stipendStartDate the stipend start date
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByStipendStatus(String stipendStatus,
        Date stipendStartDate) throws SystemException {
        for (StiPt stiPt : findByStipendStatus(stipendStatus, stipendStartDate,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(stiPt);
        }
    }

    /**
     * Returns the number of sti pts where stipendStatus = &#63; and stipendStartDate = &#63;.
     *
     * @param stipendStatus the stipend status
     * @param stipendStartDate the stipend start date
     * @return the number of matching sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByStipendStatus(String stipendStatus, Date stipendStartDate)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_STIPENDSTATUS;

        Object[] finderArgs = new Object[] { stipendStatus, stipendStartDate };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_COUNT_STIPT_WHERE);

            boolean bindStipendStatus = false;

            if (stipendStatus == null) {
                query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTATUS_1);
            } else if (stipendStatus.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTATUS_3);
            } else {
                bindStipendStatus = true;

                query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTATUS_2);
            }

            boolean bindStipendStartDate = false;

            if (stipendStartDate == null) {
                query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTARTDATE_1);
            } else {
                bindStipendStartDate = true;

                query.append(_FINDER_COLUMN_STIPENDSTATUS_STIPENDSTARTDATE_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindStipendStatus) {
                    qPos.add(stipendStatus);
                }

                if (bindStipendStartDate) {
                    qPos.add(CalendarUtil.getTimestamp(stipendStartDate));
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the sti pt in the entity cache if it is enabled.
     *
     * @param stiPt the sti pt
     */
    @Override
    public void cacheResult(StiPt stiPt) {
        EntityCacheUtil.putResult(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtImpl.class, stiPt.getPrimaryKey(), stiPt);

        stiPt.resetOriginalValues();
    }

    /**
     * Caches the sti pts in the entity cache if it is enabled.
     *
     * @param stiPts the sti pts
     */
    @Override
    public void cacheResult(List<StiPt> stiPts) {
        for (StiPt stiPt : stiPts) {
            if (EntityCacheUtil.getResult(StiPtModelImpl.ENTITY_CACHE_ENABLED,
                        StiPtImpl.class, stiPt.getPrimaryKey()) == null) {
                cacheResult(stiPt);
            } else {
                stiPt.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all sti pts.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(StiPtImpl.class.getName());
        }

        EntityCacheUtil.clearCache(StiPtImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the sti pt.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(StiPt stiPt) {
        EntityCacheUtil.removeResult(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtImpl.class, stiPt.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<StiPt> stiPts) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (StiPt stiPt : stiPts) {
            EntityCacheUtil.removeResult(StiPtModelImpl.ENTITY_CACHE_ENABLED,
                StiPtImpl.class, stiPt.getPrimaryKey());
        }
    }

    /**
     * Creates a new sti pt with the primary key. Does not add the sti pt to the database.
     *
     * @param stiPtId the primary key for the new sti pt
     * @return the new sti pt
     */
    @Override
    public StiPt create(long stiPtId) {
        StiPt stiPt = new StiPtImpl();

        stiPt.setNew(true);
        stiPt.setPrimaryKey(stiPtId);

        return stiPt;
    }

    /**
     * Removes the sti pt with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param stiPtId the primary key of the sti pt
     * @return the sti pt that was removed
     * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt remove(long stiPtId)
        throws NoSuchStiPtException, SystemException {
        return remove((Serializable) stiPtId);
    }

    /**
     * Removes the sti pt with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the sti pt
     * @return the sti pt that was removed
     * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt remove(Serializable primaryKey)
        throws NoSuchStiPtException, SystemException {
        Session session = null;

        try {
            session = openSession();

            StiPt stiPt = (StiPt) session.get(StiPtImpl.class, primaryKey);

            if (stiPt == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchStiPtException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(stiPt);
        } catch (NoSuchStiPtException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected StiPt removeImpl(StiPt stiPt) throws SystemException {
        stiPt = toUnwrappedModel(stiPt);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(stiPt)) {
                stiPt = (StiPt) session.get(StiPtImpl.class,
                        stiPt.getPrimaryKeyObj());
            }

            if (stiPt != null) {
                session.delete(stiPt);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (stiPt != null) {
            clearCache(stiPt);
        }

        return stiPt;
    }

    @Override
    public StiPt updateImpl(gov.va.caret.model.StiPt stiPt)
        throws SystemException {
        stiPt = toUnwrappedModel(stiPt);

        boolean isNew = stiPt.isNew();

        StiPtModelImpl stiPtModelImpl = (StiPtModelImpl) stiPt;

        Session session = null;

        try {
            session = openSession();

            if (stiPt.isNew()) {
                session.save(stiPt);

                stiPt.setNew(false);
            } else {
                session.merge(stiPt);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !StiPtModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((stiPtModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIRDID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { stiPtModelImpl.getOriginalStiRdId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_STIRDID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIRDID,
                    args);

                args = new Object[] { stiPtModelImpl.getStiRdId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_STIRDID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIRDID,
                    args);
            }

            if ((stiPtModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VENDRID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { stiPtModelImpl.getOriginalVendrId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VENDRID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VENDRID,
                    args);

                args = new Object[] { stiPtModelImpl.getVendrId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VENDRID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VENDRID,
                    args);
            }

            if ((stiPtModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIPENDSTATUS.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        stiPtModelImpl.getOriginalStipendStatus(),
                        stiPtModelImpl.getOriginalStipendStartDate()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_STIPENDSTATUS,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIPENDSTATUS,
                    args);

                args = new Object[] {
                        stiPtModelImpl.getStipendStatus(),
                        stiPtModelImpl.getStipendStartDate()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_STIPENDSTATUS,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIPENDSTATUS,
                    args);
            }
        }

        EntityCacheUtil.putResult(StiPtModelImpl.ENTITY_CACHE_ENABLED,
            StiPtImpl.class, stiPt.getPrimaryKey(), stiPt);

        return stiPt;
    }

    protected StiPt toUnwrappedModel(StiPt stiPt) {
        if (stiPt instanceof StiPtImpl) {
            return stiPt;
        }

        StiPtImpl stiPtImpl = new StiPtImpl();

        stiPtImpl.setNew(stiPt.isNew());
        stiPtImpl.setPrimaryKey(stiPt.getPrimaryKey());

        stiPtImpl.setStiPtId(stiPt.getStiPtId());
        stiPtImpl.setStiRdId(stiPt.getStiRdId());
        stiPtImpl.setVendrId(stiPt.getVendrId());
        stiPtImpl.setTier(stiPt.getTier());
        stiPtImpl.setTierHours(stiPt.getTierHours());
        stiPtImpl.setBlsRateHourly(stiPt.getBlsRateHourly());
        stiPtImpl.setDailyRate(stiPt.getDailyRate());
        stiPtImpl.setMonthlyPayment(stiPt.getMonthlyPayment());
        stiPtImpl.setStipendStatus(stiPt.getStipendStatus());
        stiPtImpl.setStipendApprovedDate(stiPt.getStipendApprovedDate());
        stiPtImpl.setStipendStartDate(stiPt.getStipendStartDate());
        stiPtImpl.setGroupId(stiPt.getGroupId());

        return stiPtImpl;
    }

    /**
     * Returns the sti pt with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the sti pt
     * @return the sti pt
     * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt findByPrimaryKey(Serializable primaryKey)
        throws NoSuchStiPtException, SystemException {
        StiPt stiPt = fetchByPrimaryKey(primaryKey);

        if (stiPt == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchStiPtException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return stiPt;
    }

    /**
     * Returns the sti pt with the primary key or throws a {@link gov.va.caret.NoSuchStiPtException} if it could not be found.
     *
     * @param stiPtId the primary key of the sti pt
     * @return the sti pt
     * @throws gov.va.caret.NoSuchStiPtException if a sti pt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt findByPrimaryKey(long stiPtId)
        throws NoSuchStiPtException, SystemException {
        return findByPrimaryKey((Serializable) stiPtId);
    }

    /**
     * Returns the sti pt with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the sti pt
     * @return the sti pt, or <code>null</code> if a sti pt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        StiPt stiPt = (StiPt) EntityCacheUtil.getResult(StiPtModelImpl.ENTITY_CACHE_ENABLED,
                StiPtImpl.class, primaryKey);

        if (stiPt == _nullStiPt) {
            return null;
        }

        if (stiPt == null) {
            Session session = null;

            try {
                session = openSession();

                stiPt = (StiPt) session.get(StiPtImpl.class, primaryKey);

                if (stiPt != null) {
                    cacheResult(stiPt);
                } else {
                    EntityCacheUtil.putResult(StiPtModelImpl.ENTITY_CACHE_ENABLED,
                        StiPtImpl.class, primaryKey, _nullStiPt);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(StiPtModelImpl.ENTITY_CACHE_ENABLED,
                    StiPtImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return stiPt;
    }

    /**
     * Returns the sti pt with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param stiPtId the primary key of the sti pt
     * @return the sti pt, or <code>null</code> if a sti pt with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiPt fetchByPrimaryKey(long stiPtId) throws SystemException {
        return fetchByPrimaryKey((Serializable) stiPtId);
    }

    /**
     * Returns all the sti pts.
     *
     * @return the sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiPt> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the sti pts.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of sti pts
     * @param end the upper bound of the range of sti pts (not inclusive)
     * @return the range of sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiPt> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the sti pts.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiPtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of sti pts
     * @param end the upper bound of the range of sti pts (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiPt> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<StiPt> list = (List<StiPt>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_STIPT);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_STIPT;

                if (pagination) {
                    sql = sql.concat(StiPtModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<StiPt>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<StiPt>(list);
                } else {
                    list = (List<StiPt>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the sti pts from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (StiPt stiPt : findAll()) {
            remove(stiPt);
        }
    }

    /**
     * Returns the number of sti pts.
     *
     * @return the number of sti pts
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_STIPT);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the sti pt persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.StiPt")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<StiPt>> listenersList = new ArrayList<ModelListener<StiPt>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<StiPt>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(StiPtImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
