package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchPayLgException;
import gov.va.caret.model.PayLg;
import gov.va.caret.model.impl.PayLgImpl;
import gov.va.caret.model.impl.PayLgModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * The persistence implementation for the pay lg service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see PayLgPersistence
 * @see PayLgUtil
 * @generated
 */
public class PayLgPersistenceImpl extends BasePersistenceImpl<PayLg>
    implements PayLgPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link PayLgUtil} to access the pay lg persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = PayLgImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(PayLgModelImpl.ENTITY_CACHE_ENABLED,
            PayLgModelImpl.FINDER_CACHE_ENABLED, PayLgImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(PayLgModelImpl.ENTITY_CACHE_ENABLED,
            PayLgModelImpl.FINDER_CACHE_ENABLED, PayLgImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(PayLgModelImpl.ENTITY_CACHE_ENABLED,
            PayLgModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_PAYMENTDATE =
        new FinderPath(PayLgModelImpl.ENTITY_CACHE_ENABLED,
            PayLgModelImpl.FINDER_CACHE_ENABLED, PayLgImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByPaymentDate",
            new String[] {
                Date.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PAYMENTDATE =
        new FinderPath(PayLgModelImpl.ENTITY_CACHE_ENABLED,
            PayLgModelImpl.FINDER_CACHE_ENABLED, PayLgImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByPaymentDate",
            new String[] { Date.class.getName() },
            PayLgModelImpl.PAYMENTDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_PAYMENTDATE = new FinderPath(PayLgModelImpl.ENTITY_CACHE_ENABLED,
            PayLgModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByPaymentDate",
            new String[] { Date.class.getName() });
    private static final String _FINDER_COLUMN_PAYMENTDATE_PAYMENTDATE_1 = "payLg.paymentDate IS NULL";
    private static final String _FINDER_COLUMN_PAYMENTDATE_PAYMENTDATE_2 = "payLg.paymentDate = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_STIPTID = new FinderPath(PayLgModelImpl.ENTITY_CACHE_ENABLED,
            PayLgModelImpl.FINDER_CACHE_ENABLED, PayLgImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByStiPtId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIPTID =
        new FinderPath(PayLgModelImpl.ENTITY_CACHE_ENABLED,
            PayLgModelImpl.FINDER_CACHE_ENABLED, PayLgImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByStiPtId",
            new String[] { Long.class.getName() },
            PayLgModelImpl.STIPTID_COLUMN_BITMASK |
            PayLgModelImpl.PAYMENTDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_STIPTID = new FinderPath(PayLgModelImpl.ENTITY_CACHE_ENABLED,
            PayLgModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByStiPtId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_STIPTID_STIPTID_2 = "payLg.stiPtId = ?";
    private static final String _SQL_SELECT_PAYLG = "SELECT payLg FROM PayLg payLg";
    private static final String _SQL_SELECT_PAYLG_WHERE = "SELECT payLg FROM PayLg payLg WHERE ";
    private static final String _SQL_COUNT_PAYLG = "SELECT COUNT(payLg) FROM PayLg payLg";
    private static final String _SQL_COUNT_PAYLG_WHERE = "SELECT COUNT(payLg) FROM PayLg payLg WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "payLg.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No PayLg exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No PayLg exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(PayLgPersistenceImpl.class);
    private static PayLg _nullPayLg = new PayLgImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<PayLg> toCacheModel() {
                return _nullPayLgCacheModel;
            }
        };

    private static CacheModel<PayLg> _nullPayLgCacheModel = new CacheModel<PayLg>() {
            @Override
            public PayLg toEntityModel() {
                return _nullPayLg;
            }
        };

    public PayLgPersistenceImpl() {
        setModelClass(PayLg.class);
    }

    /**
     * Returns all the pay lgs where paymentDate = &#63;.
     *
     * @param paymentDate the payment date
     * @return the matching pay lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<PayLg> findByPaymentDate(Date paymentDate)
        throws SystemException {
        return findByPaymentDate(paymentDate, QueryUtil.ALL_POS,
            QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the pay lgs where paymentDate = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param paymentDate the payment date
     * @param start the lower bound of the range of pay lgs
     * @param end the upper bound of the range of pay lgs (not inclusive)
     * @return the range of matching pay lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<PayLg> findByPaymentDate(Date paymentDate, int start, int end)
        throws SystemException {
        return findByPaymentDate(paymentDate, start, end, null);
    }

    /**
     * Returns an ordered range of all the pay lgs where paymentDate = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param paymentDate the payment date
     * @param start the lower bound of the range of pay lgs
     * @param end the upper bound of the range of pay lgs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching pay lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<PayLg> findByPaymentDate(Date paymentDate, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PAYMENTDATE;
            finderArgs = new Object[] { paymentDate };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_PAYMENTDATE;
            finderArgs = new Object[] { paymentDate, start, end, orderByComparator };
        }

        List<PayLg> list = (List<PayLg>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (PayLg payLg : list) {
                if (!Validator.equals(paymentDate, payLg.getPaymentDate())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_PAYLG_WHERE);

            boolean bindPaymentDate = false;

            if (paymentDate == null) {
                query.append(_FINDER_COLUMN_PAYMENTDATE_PAYMENTDATE_1);
            } else {
                bindPaymentDate = true;

                query.append(_FINDER_COLUMN_PAYMENTDATE_PAYMENTDATE_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(PayLgModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindPaymentDate) {
                    qPos.add(CalendarUtil.getTimestamp(paymentDate));
                }

                if (!pagination) {
                    list = (List<PayLg>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<PayLg>(list);
                } else {
                    list = (List<PayLg>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first pay lg in the ordered set where paymentDate = &#63;.
     *
     * @param paymentDate the payment date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching pay lg
     * @throws gov.va.caret.NoSuchPayLgException if a matching pay lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg findByPaymentDate_First(Date paymentDate,
        OrderByComparator orderByComparator)
        throws NoSuchPayLgException, SystemException {
        PayLg payLg = fetchByPaymentDate_First(paymentDate, orderByComparator);

        if (payLg != null) {
            return payLg;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("paymentDate=");
        msg.append(paymentDate);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchPayLgException(msg.toString());
    }

    /**
     * Returns the first pay lg in the ordered set where paymentDate = &#63;.
     *
     * @param paymentDate the payment date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching pay lg, or <code>null</code> if a matching pay lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg fetchByPaymentDate_First(Date paymentDate,
        OrderByComparator orderByComparator) throws SystemException {
        List<PayLg> list = findByPaymentDate(paymentDate, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last pay lg in the ordered set where paymentDate = &#63;.
     *
     * @param paymentDate the payment date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching pay lg
     * @throws gov.va.caret.NoSuchPayLgException if a matching pay lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg findByPaymentDate_Last(Date paymentDate,
        OrderByComparator orderByComparator)
        throws NoSuchPayLgException, SystemException {
        PayLg payLg = fetchByPaymentDate_Last(paymentDate, orderByComparator);

        if (payLg != null) {
            return payLg;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("paymentDate=");
        msg.append(paymentDate);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchPayLgException(msg.toString());
    }

    /**
     * Returns the last pay lg in the ordered set where paymentDate = &#63;.
     *
     * @param paymentDate the payment date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching pay lg, or <code>null</code> if a matching pay lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg fetchByPaymentDate_Last(Date paymentDate,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByPaymentDate(paymentDate);

        if (count == 0) {
            return null;
        }

        List<PayLg> list = findByPaymentDate(paymentDate, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the pay lgs before and after the current pay lg in the ordered set where paymentDate = &#63;.
     *
     * @param paymentLogId the primary key of the current pay lg
     * @param paymentDate the payment date
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next pay lg
     * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg[] findByPaymentDate_PrevAndNext(long paymentLogId,
        Date paymentDate, OrderByComparator orderByComparator)
        throws NoSuchPayLgException, SystemException {
        PayLg payLg = findByPrimaryKey(paymentLogId);

        Session session = null;

        try {
            session = openSession();

            PayLg[] array = new PayLgImpl[3];

            array[0] = getByPaymentDate_PrevAndNext(session, payLg,
                    paymentDate, orderByComparator, true);

            array[1] = payLg;

            array[2] = getByPaymentDate_PrevAndNext(session, payLg,
                    paymentDate, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected PayLg getByPaymentDate_PrevAndNext(Session session, PayLg payLg,
        Date paymentDate, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_PAYLG_WHERE);

        boolean bindPaymentDate = false;

        if (paymentDate == null) {
            query.append(_FINDER_COLUMN_PAYMENTDATE_PAYMENTDATE_1);
        } else {
            bindPaymentDate = true;

            query.append(_FINDER_COLUMN_PAYMENTDATE_PAYMENTDATE_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(PayLgModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindPaymentDate) {
            qPos.add(CalendarUtil.getTimestamp(paymentDate));
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(payLg);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<PayLg> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the pay lgs where paymentDate = &#63; from the database.
     *
     * @param paymentDate the payment date
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByPaymentDate(Date paymentDate) throws SystemException {
        for (PayLg payLg : findByPaymentDate(paymentDate, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(payLg);
        }
    }

    /**
     * Returns the number of pay lgs where paymentDate = &#63;.
     *
     * @param paymentDate the payment date
     * @return the number of matching pay lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByPaymentDate(Date paymentDate) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_PAYMENTDATE;

        Object[] finderArgs = new Object[] { paymentDate };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_PAYLG_WHERE);

            boolean bindPaymentDate = false;

            if (paymentDate == null) {
                query.append(_FINDER_COLUMN_PAYMENTDATE_PAYMENTDATE_1);
            } else {
                bindPaymentDate = true;

                query.append(_FINDER_COLUMN_PAYMENTDATE_PAYMENTDATE_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindPaymentDate) {
                    qPos.add(CalendarUtil.getTimestamp(paymentDate));
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the pay lgs where stiPtId = &#63;.
     *
     * @param stiPtId the sti pt ID
     * @return the matching pay lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<PayLg> findByStiPtId(long stiPtId) throws SystemException {
        return findByStiPtId(stiPtId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the pay lgs where stiPtId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param stiPtId the sti pt ID
     * @param start the lower bound of the range of pay lgs
     * @param end the upper bound of the range of pay lgs (not inclusive)
     * @return the range of matching pay lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<PayLg> findByStiPtId(long stiPtId, int start, int end)
        throws SystemException {
        return findByStiPtId(stiPtId, start, end, null);
    }

    /**
     * Returns an ordered range of all the pay lgs where stiPtId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param stiPtId the sti pt ID
     * @param start the lower bound of the range of pay lgs
     * @param end the upper bound of the range of pay lgs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching pay lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<PayLg> findByStiPtId(long stiPtId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIPTID;
            finderArgs = new Object[] { stiPtId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_STIPTID;
            finderArgs = new Object[] { stiPtId, start, end, orderByComparator };
        }

        List<PayLg> list = (List<PayLg>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (PayLg payLg : list) {
                if ((stiPtId != payLg.getStiPtId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_PAYLG_WHERE);

            query.append(_FINDER_COLUMN_STIPTID_STIPTID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(PayLgModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(stiPtId);

                if (!pagination) {
                    list = (List<PayLg>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<PayLg>(list);
                } else {
                    list = (List<PayLg>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first pay lg in the ordered set where stiPtId = &#63;.
     *
     * @param stiPtId the sti pt ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching pay lg
     * @throws gov.va.caret.NoSuchPayLgException if a matching pay lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg findByStiPtId_First(long stiPtId,
        OrderByComparator orderByComparator)
        throws NoSuchPayLgException, SystemException {
        PayLg payLg = fetchByStiPtId_First(stiPtId, orderByComparator);

        if (payLg != null) {
            return payLg;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("stiPtId=");
        msg.append(stiPtId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchPayLgException(msg.toString());
    }

    /**
     * Returns the first pay lg in the ordered set where stiPtId = &#63;.
     *
     * @param stiPtId the sti pt ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching pay lg, or <code>null</code> if a matching pay lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg fetchByStiPtId_First(long stiPtId,
        OrderByComparator orderByComparator) throws SystemException {
        List<PayLg> list = findByStiPtId(stiPtId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last pay lg in the ordered set where stiPtId = &#63;.
     *
     * @param stiPtId the sti pt ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching pay lg
     * @throws gov.va.caret.NoSuchPayLgException if a matching pay lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg findByStiPtId_Last(long stiPtId,
        OrderByComparator orderByComparator)
        throws NoSuchPayLgException, SystemException {
        PayLg payLg = fetchByStiPtId_Last(stiPtId, orderByComparator);

        if (payLg != null) {
            return payLg;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("stiPtId=");
        msg.append(stiPtId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchPayLgException(msg.toString());
    }

    /**
     * Returns the last pay lg in the ordered set where stiPtId = &#63;.
     *
     * @param stiPtId the sti pt ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching pay lg, or <code>null</code> if a matching pay lg could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg fetchByStiPtId_Last(long stiPtId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByStiPtId(stiPtId);

        if (count == 0) {
            return null;
        }

        List<PayLg> list = findByStiPtId(stiPtId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the pay lgs before and after the current pay lg in the ordered set where stiPtId = &#63;.
     *
     * @param paymentLogId the primary key of the current pay lg
     * @param stiPtId the sti pt ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next pay lg
     * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg[] findByStiPtId_PrevAndNext(long paymentLogId, long stiPtId,
        OrderByComparator orderByComparator)
        throws NoSuchPayLgException, SystemException {
        PayLg payLg = findByPrimaryKey(paymentLogId);

        Session session = null;

        try {
            session = openSession();

            PayLg[] array = new PayLgImpl[3];

            array[0] = getByStiPtId_PrevAndNext(session, payLg, stiPtId,
                    orderByComparator, true);

            array[1] = payLg;

            array[2] = getByStiPtId_PrevAndNext(session, payLg, stiPtId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected PayLg getByStiPtId_PrevAndNext(Session session, PayLg payLg,
        long stiPtId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_PAYLG_WHERE);

        query.append(_FINDER_COLUMN_STIPTID_STIPTID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(PayLgModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(stiPtId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(payLg);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<PayLg> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the pay lgs where stiPtId = &#63; from the database.
     *
     * @param stiPtId the sti pt ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByStiPtId(long stiPtId) throws SystemException {
        for (PayLg payLg : findByStiPtId(stiPtId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(payLg);
        }
    }

    /**
     * Returns the number of pay lgs where stiPtId = &#63;.
     *
     * @param stiPtId the sti pt ID
     * @return the number of matching pay lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByStiPtId(long stiPtId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_STIPTID;

        Object[] finderArgs = new Object[] { stiPtId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_PAYLG_WHERE);

            query.append(_FINDER_COLUMN_STIPTID_STIPTID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(stiPtId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the pay lg in the entity cache if it is enabled.
     *
     * @param payLg the pay lg
     */
    @Override
    public void cacheResult(PayLg payLg) {
        EntityCacheUtil.putResult(PayLgModelImpl.ENTITY_CACHE_ENABLED,
            PayLgImpl.class, payLg.getPrimaryKey(), payLg);

        payLg.resetOriginalValues();
    }

    /**
     * Caches the pay lgs in the entity cache if it is enabled.
     *
     * @param payLgs the pay lgs
     */
    @Override
    public void cacheResult(List<PayLg> payLgs) {
        for (PayLg payLg : payLgs) {
            if (EntityCacheUtil.getResult(PayLgModelImpl.ENTITY_CACHE_ENABLED,
                        PayLgImpl.class, payLg.getPrimaryKey()) == null) {
                cacheResult(payLg);
            } else {
                payLg.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all pay lgs.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(PayLgImpl.class.getName());
        }

        EntityCacheUtil.clearCache(PayLgImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the pay lg.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(PayLg payLg) {
        EntityCacheUtil.removeResult(PayLgModelImpl.ENTITY_CACHE_ENABLED,
            PayLgImpl.class, payLg.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<PayLg> payLgs) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (PayLg payLg : payLgs) {
            EntityCacheUtil.removeResult(PayLgModelImpl.ENTITY_CACHE_ENABLED,
                PayLgImpl.class, payLg.getPrimaryKey());
        }
    }

    /**
     * Creates a new pay lg with the primary key. Does not add the pay lg to the database.
     *
     * @param paymentLogId the primary key for the new pay lg
     * @return the new pay lg
     */
    @Override
    public PayLg create(long paymentLogId) {
        PayLg payLg = new PayLgImpl();

        payLg.setNew(true);
        payLg.setPrimaryKey(paymentLogId);

        return payLg;
    }

    /**
     * Removes the pay lg with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param paymentLogId the primary key of the pay lg
     * @return the pay lg that was removed
     * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg remove(long paymentLogId)
        throws NoSuchPayLgException, SystemException {
        return remove((Serializable) paymentLogId);
    }

    /**
     * Removes the pay lg with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the pay lg
     * @return the pay lg that was removed
     * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg remove(Serializable primaryKey)
        throws NoSuchPayLgException, SystemException {
        Session session = null;

        try {
            session = openSession();

            PayLg payLg = (PayLg) session.get(PayLgImpl.class, primaryKey);

            if (payLg == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchPayLgException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(payLg);
        } catch (NoSuchPayLgException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected PayLg removeImpl(PayLg payLg) throws SystemException {
        payLg = toUnwrappedModel(payLg);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(payLg)) {
                payLg = (PayLg) session.get(PayLgImpl.class,
                        payLg.getPrimaryKeyObj());
            }

            if (payLg != null) {
                session.delete(payLg);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (payLg != null) {
            clearCache(payLg);
        }

        return payLg;
    }

    @Override
    public PayLg updateImpl(gov.va.caret.model.PayLg payLg)
        throws SystemException {
        payLg = toUnwrappedModel(payLg);

        boolean isNew = payLg.isNew();

        PayLgModelImpl payLgModelImpl = (PayLgModelImpl) payLg;

        Session session = null;

        try {
            session = openSession();

            if (payLg.isNew()) {
                session.save(payLg);

                payLg.setNew(false);
            } else {
                session.merge(payLg);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !PayLgModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((payLgModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PAYMENTDATE.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        payLgModelImpl.getOriginalPaymentDate()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_PAYMENTDATE,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PAYMENTDATE,
                    args);

                args = new Object[] { payLgModelImpl.getPaymentDate() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_PAYMENTDATE,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_PAYMENTDATE,
                    args);
            }

            if ((payLgModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIPTID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { payLgModelImpl.getOriginalStiPtId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_STIPTID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIPTID,
                    args);

                args = new Object[] { payLgModelImpl.getStiPtId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_STIPTID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_STIPTID,
                    args);
            }
        }

        EntityCacheUtil.putResult(PayLgModelImpl.ENTITY_CACHE_ENABLED,
            PayLgImpl.class, payLg.getPrimaryKey(), payLg);

        return payLg;
    }

    protected PayLg toUnwrappedModel(PayLg payLg) {
        if (payLg instanceof PayLgImpl) {
            return payLg;
        }

        PayLgImpl payLgImpl = new PayLgImpl();

        payLgImpl.setNew(payLg.isNew());
        payLgImpl.setPrimaryKey(payLg.getPrimaryKey());

        payLgImpl.setPaymentLogId(payLg.getPaymentLogId());
        payLgImpl.setStiPtId(payLg.getStiPtId());
        payLgImpl.setAmount(payLg.getAmount());
        payLgImpl.setPaymentDate(payLg.getPaymentDate());
        payLgImpl.setStatus(payLg.getStatus());
        payLgImpl.setReason(payLg.getReason());
        payLgImpl.setCreationDate(payLg.getCreationDate());
        payLgImpl.setUserId(payLg.getUserId());

        return payLgImpl;
    }

    /**
     * Returns the pay lg with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the pay lg
     * @return the pay lg
     * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg findByPrimaryKey(Serializable primaryKey)
        throws NoSuchPayLgException, SystemException {
        PayLg payLg = fetchByPrimaryKey(primaryKey);

        if (payLg == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchPayLgException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return payLg;
    }

    /**
     * Returns the pay lg with the primary key or throws a {@link gov.va.caret.NoSuchPayLgException} if it could not be found.
     *
     * @param paymentLogId the primary key of the pay lg
     * @return the pay lg
     * @throws gov.va.caret.NoSuchPayLgException if a pay lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg findByPrimaryKey(long paymentLogId)
        throws NoSuchPayLgException, SystemException {
        return findByPrimaryKey((Serializable) paymentLogId);
    }

    /**
     * Returns the pay lg with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the pay lg
     * @return the pay lg, or <code>null</code> if a pay lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        PayLg payLg = (PayLg) EntityCacheUtil.getResult(PayLgModelImpl.ENTITY_CACHE_ENABLED,
                PayLgImpl.class, primaryKey);

        if (payLg == _nullPayLg) {
            return null;
        }

        if (payLg == null) {
            Session session = null;

            try {
                session = openSession();

                payLg = (PayLg) session.get(PayLgImpl.class, primaryKey);

                if (payLg != null) {
                    cacheResult(payLg);
                } else {
                    EntityCacheUtil.putResult(PayLgModelImpl.ENTITY_CACHE_ENABLED,
                        PayLgImpl.class, primaryKey, _nullPayLg);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(PayLgModelImpl.ENTITY_CACHE_ENABLED,
                    PayLgImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return payLg;
    }

    /**
     * Returns the pay lg with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param paymentLogId the primary key of the pay lg
     * @return the pay lg, or <code>null</code> if a pay lg with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public PayLg fetchByPrimaryKey(long paymentLogId) throws SystemException {
        return fetchByPrimaryKey((Serializable) paymentLogId);
    }

    /**
     * Returns all the pay lgs.
     *
     * @return the pay lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<PayLg> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the pay lgs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of pay lgs
     * @param end the upper bound of the range of pay lgs (not inclusive)
     * @return the range of pay lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<PayLg> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the pay lgs.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.PayLgModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of pay lgs
     * @param end the upper bound of the range of pay lgs (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of pay lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<PayLg> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<PayLg> list = (List<PayLg>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_PAYLG);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_PAYLG;

                if (pagination) {
                    sql = sql.concat(PayLgModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<PayLg>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<PayLg>(list);
                } else {
                    list = (List<PayLg>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the pay lgs from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (PayLg payLg : findAll()) {
            remove(payLg);
        }
    }

    /**
     * Returns the number of pay lgs.
     *
     * @return the number of pay lgs
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_PAYLG);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the pay lg persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.PayLg")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<PayLg>> listenersList = new ArrayList<ModelListener<PayLg>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<PayLg>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(PayLgImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
