package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchEEMonetaryBenefitException;
import gov.va.caret.model.EEMonetaryBenefit;
import gov.va.caret.model.impl.EEMonetaryBenefitImpl;
import gov.va.caret.model.impl.EEMonetaryBenefitModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * The persistence implementation for the e e monetary benefit service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see EEMonetaryBenefitPersistence
 * @see EEMonetaryBenefitUtil
 * @generated
 */
public class EEMonetaryBenefitPersistenceImpl extends BasePersistenceImpl<EEMonetaryBenefit>
    implements EEMonetaryBenefitPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link EEMonetaryBenefitUtil} to access the e e monetary benefit persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = EEMonetaryBenefitImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
            EEMonetaryBenefitModelImpl.FINDER_CACHE_ENABLED,
            EEMonetaryBenefitImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
            EEMonetaryBenefitModelImpl.FINDER_CACHE_ENABLED,
            EEMonetaryBenefitImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
            EEMonetaryBenefitModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_EELGID = new FinderPath(EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
            EEMonetaryBenefitModelImpl.FINDER_CACHE_ENABLED,
            EEMonetaryBenefitImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByeeLgId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID =
        new FinderPath(EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
            EEMonetaryBenefitModelImpl.FINDER_CACHE_ENABLED,
            EEMonetaryBenefitImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByeeLgId",
            new String[] { Long.class.getName() },
            EEMonetaryBenefitModelImpl.EELGID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_EELGID = new FinderPath(EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
            EEMonetaryBenefitModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByeeLgId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_EELGID_EELGID_2 = "eeMonetaryBenefit.eeLgId = ?";
    private static final String _SQL_SELECT_EEMONETARYBENEFIT = "SELECT eeMonetaryBenefit FROM EEMonetaryBenefit eeMonetaryBenefit";
    private static final String _SQL_SELECT_EEMONETARYBENEFIT_WHERE = "SELECT eeMonetaryBenefit FROM EEMonetaryBenefit eeMonetaryBenefit WHERE ";
    private static final String _SQL_COUNT_EEMONETARYBENEFIT = "SELECT COUNT(eeMonetaryBenefit) FROM EEMonetaryBenefit eeMonetaryBenefit";
    private static final String _SQL_COUNT_EEMONETARYBENEFIT_WHERE = "SELECT COUNT(eeMonetaryBenefit) FROM EEMonetaryBenefit eeMonetaryBenefit WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "eeMonetaryBenefit.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No EEMonetaryBenefit exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No EEMonetaryBenefit exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(EEMonetaryBenefitPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray(new String[] {
                "type"
            });
    private static EEMonetaryBenefit _nullEEMonetaryBenefit = new EEMonetaryBenefitImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<EEMonetaryBenefit> toCacheModel() {
                return _nullEEMonetaryBenefitCacheModel;
            }
        };

    private static CacheModel<EEMonetaryBenefit> _nullEEMonetaryBenefitCacheModel =
        new CacheModel<EEMonetaryBenefit>() {
            @Override
            public EEMonetaryBenefit toEntityModel() {
                return _nullEEMonetaryBenefit;
            }
        };

    public EEMonetaryBenefitPersistenceImpl() {
        setModelClass(EEMonetaryBenefit.class);
    }

    /**
     * Returns all the e e monetary benefits where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @return the matching e e monetary benefits
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EEMonetaryBenefit> findByeeLgId(long eeLgId)
        throws SystemException {
        return findByeeLgId(eeLgId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the e e monetary benefits where eeLgId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EEMonetaryBenefitModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param eeLgId the ee lg ID
     * @param start the lower bound of the range of e e monetary benefits
     * @param end the upper bound of the range of e e monetary benefits (not inclusive)
     * @return the range of matching e e monetary benefits
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EEMonetaryBenefit> findByeeLgId(long eeLgId, int start, int end)
        throws SystemException {
        return findByeeLgId(eeLgId, start, end, null);
    }

    /**
     * Returns an ordered range of all the e e monetary benefits where eeLgId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EEMonetaryBenefitModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param eeLgId the ee lg ID
     * @param start the lower bound of the range of e e monetary benefits
     * @param end the upper bound of the range of e e monetary benefits (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching e e monetary benefits
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EEMonetaryBenefit> findByeeLgId(long eeLgId, int start,
        int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID;
            finderArgs = new Object[] { eeLgId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_EELGID;
            finderArgs = new Object[] { eeLgId, start, end, orderByComparator };
        }

        List<EEMonetaryBenefit> list = (List<EEMonetaryBenefit>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (EEMonetaryBenefit eeMonetaryBenefit : list) {
                if ((eeLgId != eeMonetaryBenefit.getEeLgId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_EEMONETARYBENEFIT_WHERE);

            query.append(_FINDER_COLUMN_EELGID_EELGID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(EEMonetaryBenefitModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(eeLgId);

                if (!pagination) {
                    list = (List<EEMonetaryBenefit>) QueryUtil.list(q,
                            getDialect(), start, end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<EEMonetaryBenefit>(list);
                } else {
                    list = (List<EEMonetaryBenefit>) QueryUtil.list(q,
                            getDialect(), start, end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first e e monetary benefit in the ordered set where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching e e monetary benefit
     * @throws gov.va.caret.NoSuchEEMonetaryBenefitException if a matching e e monetary benefit could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMonetaryBenefit findByeeLgId_First(long eeLgId,
        OrderByComparator orderByComparator)
        throws NoSuchEEMonetaryBenefitException, SystemException {
        EEMonetaryBenefit eeMonetaryBenefit = fetchByeeLgId_First(eeLgId,
                orderByComparator);

        if (eeMonetaryBenefit != null) {
            return eeMonetaryBenefit;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("eeLgId=");
        msg.append(eeLgId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchEEMonetaryBenefitException(msg.toString());
    }

    /**
     * Returns the first e e monetary benefit in the ordered set where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching e e monetary benefit, or <code>null</code> if a matching e e monetary benefit could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMonetaryBenefit fetchByeeLgId_First(long eeLgId,
        OrderByComparator orderByComparator) throws SystemException {
        List<EEMonetaryBenefit> list = findByeeLgId(eeLgId, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last e e monetary benefit in the ordered set where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching e e monetary benefit
     * @throws gov.va.caret.NoSuchEEMonetaryBenefitException if a matching e e monetary benefit could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMonetaryBenefit findByeeLgId_Last(long eeLgId,
        OrderByComparator orderByComparator)
        throws NoSuchEEMonetaryBenefitException, SystemException {
        EEMonetaryBenefit eeMonetaryBenefit = fetchByeeLgId_Last(eeLgId,
                orderByComparator);

        if (eeMonetaryBenefit != null) {
            return eeMonetaryBenefit;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("eeLgId=");
        msg.append(eeLgId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchEEMonetaryBenefitException(msg.toString());
    }

    /**
     * Returns the last e e monetary benefit in the ordered set where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching e e monetary benefit, or <code>null</code> if a matching e e monetary benefit could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMonetaryBenefit fetchByeeLgId_Last(long eeLgId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByeeLgId(eeLgId);

        if (count == 0) {
            return null;
        }

        List<EEMonetaryBenefit> list = findByeeLgId(eeLgId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the e e monetary benefits before and after the current e e monetary benefit in the ordered set where eeLgId = &#63;.
     *
     * @param eeMonBenefitId the primary key of the current e e monetary benefit
     * @param eeLgId the ee lg ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next e e monetary benefit
     * @throws gov.va.caret.NoSuchEEMonetaryBenefitException if a e e monetary benefit with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMonetaryBenefit[] findByeeLgId_PrevAndNext(long eeMonBenefitId,
        long eeLgId, OrderByComparator orderByComparator)
        throws NoSuchEEMonetaryBenefitException, SystemException {
        EEMonetaryBenefit eeMonetaryBenefit = findByPrimaryKey(eeMonBenefitId);

        Session session = null;

        try {
            session = openSession();

            EEMonetaryBenefit[] array = new EEMonetaryBenefitImpl[3];

            array[0] = getByeeLgId_PrevAndNext(session, eeMonetaryBenefit,
                    eeLgId, orderByComparator, true);

            array[1] = eeMonetaryBenefit;

            array[2] = getByeeLgId_PrevAndNext(session, eeMonetaryBenefit,
                    eeLgId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected EEMonetaryBenefit getByeeLgId_PrevAndNext(Session session,
        EEMonetaryBenefit eeMonetaryBenefit, long eeLgId,
        OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_EEMONETARYBENEFIT_WHERE);

        query.append(_FINDER_COLUMN_EELGID_EELGID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(EEMonetaryBenefitModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(eeLgId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(eeMonetaryBenefit);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<EEMonetaryBenefit> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the e e monetary benefits where eeLgId = &#63; from the database.
     *
     * @param eeLgId the ee lg ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByeeLgId(long eeLgId) throws SystemException {
        for (EEMonetaryBenefit eeMonetaryBenefit : findByeeLgId(eeLgId,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(eeMonetaryBenefit);
        }
    }

    /**
     * Returns the number of e e monetary benefits where eeLgId = &#63;.
     *
     * @param eeLgId the ee lg ID
     * @return the number of matching e e monetary benefits
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByeeLgId(long eeLgId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_EELGID;

        Object[] finderArgs = new Object[] { eeLgId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_EEMONETARYBENEFIT_WHERE);

            query.append(_FINDER_COLUMN_EELGID_EELGID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(eeLgId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the e e monetary benefit in the entity cache if it is enabled.
     *
     * @param eeMonetaryBenefit the e e monetary benefit
     */
    @Override
    public void cacheResult(EEMonetaryBenefit eeMonetaryBenefit) {
        EntityCacheUtil.putResult(EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
            EEMonetaryBenefitImpl.class, eeMonetaryBenefit.getPrimaryKey(),
            eeMonetaryBenefit);

        eeMonetaryBenefit.resetOriginalValues();
    }

    /**
     * Caches the e e monetary benefits in the entity cache if it is enabled.
     *
     * @param eeMonetaryBenefits the e e monetary benefits
     */
    @Override
    public void cacheResult(List<EEMonetaryBenefit> eeMonetaryBenefits) {
        for (EEMonetaryBenefit eeMonetaryBenefit : eeMonetaryBenefits) {
            if (EntityCacheUtil.getResult(
                        EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
                        EEMonetaryBenefitImpl.class,
                        eeMonetaryBenefit.getPrimaryKey()) == null) {
                cacheResult(eeMonetaryBenefit);
            } else {
                eeMonetaryBenefit.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all e e monetary benefits.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(EEMonetaryBenefitImpl.class.getName());
        }

        EntityCacheUtil.clearCache(EEMonetaryBenefitImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the e e monetary benefit.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(EEMonetaryBenefit eeMonetaryBenefit) {
        EntityCacheUtil.removeResult(EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
            EEMonetaryBenefitImpl.class, eeMonetaryBenefit.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<EEMonetaryBenefit> eeMonetaryBenefits) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (EEMonetaryBenefit eeMonetaryBenefit : eeMonetaryBenefits) {
            EntityCacheUtil.removeResult(EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
                EEMonetaryBenefitImpl.class, eeMonetaryBenefit.getPrimaryKey());
        }
    }

    /**
     * Creates a new e e monetary benefit with the primary key. Does not add the e e monetary benefit to the database.
     *
     * @param eeMonBenefitId the primary key for the new e e monetary benefit
     * @return the new e e monetary benefit
     */
    @Override
    public EEMonetaryBenefit create(long eeMonBenefitId) {
        EEMonetaryBenefit eeMonetaryBenefit = new EEMonetaryBenefitImpl();

        eeMonetaryBenefit.setNew(true);
        eeMonetaryBenefit.setPrimaryKey(eeMonBenefitId);

        return eeMonetaryBenefit;
    }

    /**
     * Removes the e e monetary benefit with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param eeMonBenefitId the primary key of the e e monetary benefit
     * @return the e e monetary benefit that was removed
     * @throws gov.va.caret.NoSuchEEMonetaryBenefitException if a e e monetary benefit with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMonetaryBenefit remove(long eeMonBenefitId)
        throws NoSuchEEMonetaryBenefitException, SystemException {
        return remove((Serializable) eeMonBenefitId);
    }

    /**
     * Removes the e e monetary benefit with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the e e monetary benefit
     * @return the e e monetary benefit that was removed
     * @throws gov.va.caret.NoSuchEEMonetaryBenefitException if a e e monetary benefit with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMonetaryBenefit remove(Serializable primaryKey)
        throws NoSuchEEMonetaryBenefitException, SystemException {
        Session session = null;

        try {
            session = openSession();

            EEMonetaryBenefit eeMonetaryBenefit = (EEMonetaryBenefit) session.get(EEMonetaryBenefitImpl.class,
                    primaryKey);

            if (eeMonetaryBenefit == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchEEMonetaryBenefitException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(eeMonetaryBenefit);
        } catch (NoSuchEEMonetaryBenefitException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected EEMonetaryBenefit removeImpl(EEMonetaryBenefit eeMonetaryBenefit)
        throws SystemException {
        eeMonetaryBenefit = toUnwrappedModel(eeMonetaryBenefit);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(eeMonetaryBenefit)) {
                eeMonetaryBenefit = (EEMonetaryBenefit) session.get(EEMonetaryBenefitImpl.class,
                        eeMonetaryBenefit.getPrimaryKeyObj());
            }

            if (eeMonetaryBenefit != null) {
                session.delete(eeMonetaryBenefit);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (eeMonetaryBenefit != null) {
            clearCache(eeMonetaryBenefit);
        }

        return eeMonetaryBenefit;
    }

    @Override
    public EEMonetaryBenefit updateImpl(
        gov.va.caret.model.EEMonetaryBenefit eeMonetaryBenefit)
        throws SystemException {
        eeMonetaryBenefit = toUnwrappedModel(eeMonetaryBenefit);

        boolean isNew = eeMonetaryBenefit.isNew();

        EEMonetaryBenefitModelImpl eeMonetaryBenefitModelImpl = (EEMonetaryBenefitModelImpl) eeMonetaryBenefit;

        Session session = null;

        try {
            session = openSession();

            if (eeMonetaryBenefit.isNew()) {
                session.save(eeMonetaryBenefit);

                eeMonetaryBenefit.setNew(false);
            } else {
                session.merge(eeMonetaryBenefit);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !EEMonetaryBenefitModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((eeMonetaryBenefitModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        eeMonetaryBenefitModelImpl.getOriginalEeLgId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_EELGID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID,
                    args);

                args = new Object[] { eeMonetaryBenefitModelImpl.getEeLgId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_EELGID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_EELGID,
                    args);
            }
        }

        EntityCacheUtil.putResult(EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
            EEMonetaryBenefitImpl.class, eeMonetaryBenefit.getPrimaryKey(),
            eeMonetaryBenefit);

        return eeMonetaryBenefit;
    }

    protected EEMonetaryBenefit toUnwrappedModel(
        EEMonetaryBenefit eeMonetaryBenefit) {
        if (eeMonetaryBenefit instanceof EEMonetaryBenefitImpl) {
            return eeMonetaryBenefit;
        }

        EEMonetaryBenefitImpl eeMonetaryBenefitImpl = new EEMonetaryBenefitImpl();

        eeMonetaryBenefitImpl.setNew(eeMonetaryBenefit.isNew());
        eeMonetaryBenefitImpl.setPrimaryKey(eeMonetaryBenefit.getPrimaryKey());

        eeMonetaryBenefitImpl.setEeMonBenefitId(eeMonetaryBenefit.getEeMonBenefitId());
        eeMonetaryBenefitImpl.setEeLgId(eeMonetaryBenefit.getEeLgId());
        eeMonetaryBenefitImpl.setMonetaryBenefit(eeMonetaryBenefit.getMonetaryBenefit());
        eeMonetaryBenefitImpl.setType(eeMonetaryBenefit.getType());
        eeMonetaryBenefitImpl.setReportDate(eeMonetaryBenefit.getReportDate());

        return eeMonetaryBenefitImpl;
    }

    /**
     * Returns the e e monetary benefit with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the e e monetary benefit
     * @return the e e monetary benefit
     * @throws gov.va.caret.NoSuchEEMonetaryBenefitException if a e e monetary benefit with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMonetaryBenefit findByPrimaryKey(Serializable primaryKey)
        throws NoSuchEEMonetaryBenefitException, SystemException {
        EEMonetaryBenefit eeMonetaryBenefit = fetchByPrimaryKey(primaryKey);

        if (eeMonetaryBenefit == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchEEMonetaryBenefitException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return eeMonetaryBenefit;
    }

    /**
     * Returns the e e monetary benefit with the primary key or throws a {@link gov.va.caret.NoSuchEEMonetaryBenefitException} if it could not be found.
     *
     * @param eeMonBenefitId the primary key of the e e monetary benefit
     * @return the e e monetary benefit
     * @throws gov.va.caret.NoSuchEEMonetaryBenefitException if a e e monetary benefit with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMonetaryBenefit findByPrimaryKey(long eeMonBenefitId)
        throws NoSuchEEMonetaryBenefitException, SystemException {
        return findByPrimaryKey((Serializable) eeMonBenefitId);
    }

    /**
     * Returns the e e monetary benefit with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the e e monetary benefit
     * @return the e e monetary benefit, or <code>null</code> if a e e monetary benefit with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMonetaryBenefit fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        EEMonetaryBenefit eeMonetaryBenefit = (EEMonetaryBenefit) EntityCacheUtil.getResult(EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
                EEMonetaryBenefitImpl.class, primaryKey);

        if (eeMonetaryBenefit == _nullEEMonetaryBenefit) {
            return null;
        }

        if (eeMonetaryBenefit == null) {
            Session session = null;

            try {
                session = openSession();

                eeMonetaryBenefit = (EEMonetaryBenefit) session.get(EEMonetaryBenefitImpl.class,
                        primaryKey);

                if (eeMonetaryBenefit != null) {
                    cacheResult(eeMonetaryBenefit);
                } else {
                    EntityCacheUtil.putResult(EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
                        EEMonetaryBenefitImpl.class, primaryKey,
                        _nullEEMonetaryBenefit);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(EEMonetaryBenefitModelImpl.ENTITY_CACHE_ENABLED,
                    EEMonetaryBenefitImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return eeMonetaryBenefit;
    }

    /**
     * Returns the e e monetary benefit with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param eeMonBenefitId the primary key of the e e monetary benefit
     * @return the e e monetary benefit, or <code>null</code> if a e e monetary benefit with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public EEMonetaryBenefit fetchByPrimaryKey(long eeMonBenefitId)
        throws SystemException {
        return fetchByPrimaryKey((Serializable) eeMonBenefitId);
    }

    /**
     * Returns all the e e monetary benefits.
     *
     * @return the e e monetary benefits
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EEMonetaryBenefit> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the e e monetary benefits.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EEMonetaryBenefitModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of e e monetary benefits
     * @param end the upper bound of the range of e e monetary benefits (not inclusive)
     * @return the range of e e monetary benefits
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EEMonetaryBenefit> findAll(int start, int end)
        throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the e e monetary benefits.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.EEMonetaryBenefitModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of e e monetary benefits
     * @param end the upper bound of the range of e e monetary benefits (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of e e monetary benefits
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<EEMonetaryBenefit> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<EEMonetaryBenefit> list = (List<EEMonetaryBenefit>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_EEMONETARYBENEFIT);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_EEMONETARYBENEFIT;

                if (pagination) {
                    sql = sql.concat(EEMonetaryBenefitModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<EEMonetaryBenefit>) QueryUtil.list(q,
                            getDialect(), start, end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<EEMonetaryBenefit>(list);
                } else {
                    list = (List<EEMonetaryBenefit>) QueryUtil.list(q,
                            getDialect(), start, end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the e e monetary benefits from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (EEMonetaryBenefit eeMonetaryBenefit : findAll()) {
            remove(eeMonetaryBenefit);
        }
    }

    /**
     * Returns the number of e e monetary benefits.
     *
     * @return the number of e e monetary benefits
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_EEMONETARYBENEFIT);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    @Override
    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    /**
     * Initializes the e e monetary benefit persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.EEMonetaryBenefit")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<EEMonetaryBenefit>> listenersList = new ArrayList<ModelListener<EEMonetaryBenefit>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<EEMonetaryBenefit>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(EEMonetaryBenefitImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
