package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchBoxGpException;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.model.impl.BoxGpModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the box gp service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BoxGpPersistence
 * @see BoxGpUtil
 * @generated
 */
public class BoxGpPersistenceImpl extends BasePersistenceImpl<BoxGp>
    implements BoxGpPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link BoxGpUtil} to access the box gp persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = BoxGpImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
            BoxGpModelImpl.FINDER_CACHE_ENABLED, BoxGpImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
            BoxGpModelImpl.FINDER_CACHE_ENABLED, BoxGpImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
            BoxGpModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_BOXGROUP = new FinderPath(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
            BoxGpModelImpl.FINDER_CACHE_ENABLED, BoxGpImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByBoxGroup",
            new String[] {
                String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUP =
        new FinderPath(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
            BoxGpModelImpl.FINDER_CACHE_ENABLED, BoxGpImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByBoxGroup",
            new String[] { String.class.getName() },
            BoxGpModelImpl.BOXGROUP_COLUMN_BITMASK |
            BoxGpModelImpl.VIEWSEQUENCE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_BOXGROUP = new FinderPath(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
            BoxGpModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByBoxGroup",
            new String[] { String.class.getName() });
    private static final String _FINDER_COLUMN_BOXGROUP_BOXGROUP_1 = "boxGp.boxGroup IS NULL";
    private static final String _FINDER_COLUMN_BOXGROUP_BOXGROUP_2 = "boxGp.boxGroup = ?";
    private static final String _FINDER_COLUMN_BOXGROUP_BOXGROUP_3 = "(boxGp.boxGroup IS NULL OR boxGp.boxGroup = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_BOXSUBGROUP =
        new FinderPath(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
            BoxGpModelImpl.FINDER_CACHE_ENABLED, BoxGpImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByBoxSubGroup",
            new String[] {
                String.class.getName(), String.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXSUBGROUP =
        new FinderPath(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
            BoxGpModelImpl.FINDER_CACHE_ENABLED, BoxGpImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByBoxSubGroup",
            new String[] { String.class.getName(), String.class.getName() },
            BoxGpModelImpl.BOXGROUP_COLUMN_BITMASK |
            BoxGpModelImpl.BOXSUBGROUP_COLUMN_BITMASK |
            BoxGpModelImpl.VIEWSEQUENCE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_BOXSUBGROUP = new FinderPath(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
            BoxGpModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByBoxSubGroup",
            new String[] { String.class.getName(), String.class.getName() });
    private static final String _FINDER_COLUMN_BOXSUBGROUP_BOXGROUP_1 = "boxGp.boxGroup IS NULL AND ";
    private static final String _FINDER_COLUMN_BOXSUBGROUP_BOXGROUP_2 = "boxGp.boxGroup = ? AND ";
    private static final String _FINDER_COLUMN_BOXSUBGROUP_BOXGROUP_3 = "(boxGp.boxGroup IS NULL OR boxGp.boxGroup = '') AND ";
    private static final String _FINDER_COLUMN_BOXSUBGROUP_BOXSUBGROUP_1 = "boxGp.boxSubGroup IS NULL";
    private static final String _FINDER_COLUMN_BOXSUBGROUP_BOXSUBGROUP_2 = "boxGp.boxSubGroup = ?";
    private static final String _FINDER_COLUMN_BOXSUBGROUP_BOXSUBGROUP_3 = "(boxGp.boxSubGroup IS NULL OR boxGp.boxSubGroup = '')";
    private static final String _SQL_SELECT_BOXGP = "SELECT boxGp FROM BoxGp boxGp";
    private static final String _SQL_SELECT_BOXGP_WHERE = "SELECT boxGp FROM BoxGp boxGp WHERE ";
    private static final String _SQL_COUNT_BOXGP = "SELECT COUNT(boxGp) FROM BoxGp boxGp";
    private static final String _SQL_COUNT_BOXGP_WHERE = "SELECT COUNT(boxGp) FROM BoxGp boxGp WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "boxGp.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No BoxGp exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No BoxGp exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(BoxGpPersistenceImpl.class);
    private static BoxGp _nullBoxGp = new BoxGpImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<BoxGp> toCacheModel() {
                return _nullBoxGpCacheModel;
            }
        };

    private static CacheModel<BoxGp> _nullBoxGpCacheModel = new CacheModel<BoxGp>() {
            @Override
            public BoxGp toEntityModel() {
                return _nullBoxGp;
            }
        };

    public BoxGpPersistenceImpl() {
        setModelClass(BoxGp.class);
    }

    /**
     * Returns all the box gps where boxGroup = &#63;.
     *
     * @param boxGroup the box group
     * @return the matching box gps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BoxGp> findByBoxGroup(String boxGroup)
        throws SystemException {
        return findByBoxGroup(boxGroup, QueryUtil.ALL_POS, QueryUtil.ALL_POS,
            null);
    }

    /**
     * Returns a range of all the box gps where boxGroup = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param boxGroup the box group
     * @param start the lower bound of the range of box gps
     * @param end the upper bound of the range of box gps (not inclusive)
     * @return the range of matching box gps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BoxGp> findByBoxGroup(String boxGroup, int start, int end)
        throws SystemException {
        return findByBoxGroup(boxGroup, start, end, null);
    }

    /**
     * Returns an ordered range of all the box gps where boxGroup = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param boxGroup the box group
     * @param start the lower bound of the range of box gps
     * @param end the upper bound of the range of box gps (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching box gps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BoxGp> findByBoxGroup(String boxGroup, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUP;
            finderArgs = new Object[] { boxGroup };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_BOXGROUP;
            finderArgs = new Object[] { boxGroup, start, end, orderByComparator };
        }

        List<BoxGp> list = (List<BoxGp>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (BoxGp boxGp : list) {
                if (!Validator.equals(boxGroup, boxGp.getBoxGroup())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_BOXGP_WHERE);

            boolean bindBoxGroup = false;

            if (boxGroup == null) {
                query.append(_FINDER_COLUMN_BOXGROUP_BOXGROUP_1);
            } else if (boxGroup.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_BOXGROUP_BOXGROUP_3);
            } else {
                bindBoxGroup = true;

                query.append(_FINDER_COLUMN_BOXGROUP_BOXGROUP_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(BoxGpModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindBoxGroup) {
                    qPos.add(boxGroup);
                }

                if (!pagination) {
                    list = (List<BoxGp>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BoxGp>(list);
                } else {
                    list = (List<BoxGp>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first box gp in the ordered set where boxGroup = &#63;.
     *
     * @param boxGroup the box group
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching box gp
     * @throws gov.va.caret.NoSuchBoxGpException if a matching box gp could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp findByBoxGroup_First(String boxGroup,
        OrderByComparator orderByComparator)
        throws NoSuchBoxGpException, SystemException {
        BoxGp boxGp = fetchByBoxGroup_First(boxGroup, orderByComparator);

        if (boxGp != null) {
            return boxGp;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("boxGroup=");
        msg.append(boxGroup);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBoxGpException(msg.toString());
    }

    /**
     * Returns the first box gp in the ordered set where boxGroup = &#63;.
     *
     * @param boxGroup the box group
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching box gp, or <code>null</code> if a matching box gp could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp fetchByBoxGroup_First(String boxGroup,
        OrderByComparator orderByComparator) throws SystemException {
        List<BoxGp> list = findByBoxGroup(boxGroup, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last box gp in the ordered set where boxGroup = &#63;.
     *
     * @param boxGroup the box group
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching box gp
     * @throws gov.va.caret.NoSuchBoxGpException if a matching box gp could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp findByBoxGroup_Last(String boxGroup,
        OrderByComparator orderByComparator)
        throws NoSuchBoxGpException, SystemException {
        BoxGp boxGp = fetchByBoxGroup_Last(boxGroup, orderByComparator);

        if (boxGp != null) {
            return boxGp;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("boxGroup=");
        msg.append(boxGroup);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBoxGpException(msg.toString());
    }

    /**
     * Returns the last box gp in the ordered set where boxGroup = &#63;.
     *
     * @param boxGroup the box group
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching box gp, or <code>null</code> if a matching box gp could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp fetchByBoxGroup_Last(String boxGroup,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByBoxGroup(boxGroup);

        if (count == 0) {
            return null;
        }

        List<BoxGp> list = findByBoxGroup(boxGroup, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the box gps before and after the current box gp in the ordered set where boxGroup = &#63;.
     *
     * @param boxGpId the primary key of the current box gp
     * @param boxGroup the box group
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next box gp
     * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp[] findByBoxGroup_PrevAndNext(long boxGpId, String boxGroup,
        OrderByComparator orderByComparator)
        throws NoSuchBoxGpException, SystemException {
        BoxGp boxGp = findByPrimaryKey(boxGpId);

        Session session = null;

        try {
            session = openSession();

            BoxGp[] array = new BoxGpImpl[3];

            array[0] = getByBoxGroup_PrevAndNext(session, boxGp, boxGroup,
                    orderByComparator, true);

            array[1] = boxGp;

            array[2] = getByBoxGroup_PrevAndNext(session, boxGp, boxGroup,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected BoxGp getByBoxGroup_PrevAndNext(Session session, BoxGp boxGp,
        String boxGroup, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_BOXGP_WHERE);

        boolean bindBoxGroup = false;

        if (boxGroup == null) {
            query.append(_FINDER_COLUMN_BOXGROUP_BOXGROUP_1);
        } else if (boxGroup.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_BOXGROUP_BOXGROUP_3);
        } else {
            bindBoxGroup = true;

            query.append(_FINDER_COLUMN_BOXGROUP_BOXGROUP_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(BoxGpModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindBoxGroup) {
            qPos.add(boxGroup);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(boxGp);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<BoxGp> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the box gps where boxGroup = &#63; from the database.
     *
     * @param boxGroup the box group
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByBoxGroup(String boxGroup) throws SystemException {
        for (BoxGp boxGp : findByBoxGroup(boxGroup, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(boxGp);
        }
    }

    /**
     * Returns the number of box gps where boxGroup = &#63;.
     *
     * @param boxGroup the box group
     * @return the number of matching box gps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByBoxGroup(String boxGroup) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_BOXGROUP;

        Object[] finderArgs = new Object[] { boxGroup };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_BOXGP_WHERE);

            boolean bindBoxGroup = false;

            if (boxGroup == null) {
                query.append(_FINDER_COLUMN_BOXGROUP_BOXGROUP_1);
            } else if (boxGroup.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_BOXGROUP_BOXGROUP_3);
            } else {
                bindBoxGroup = true;

                query.append(_FINDER_COLUMN_BOXGROUP_BOXGROUP_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindBoxGroup) {
                    qPos.add(boxGroup);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the box gps where boxGroup = &#63; and boxSubGroup = &#63;.
     *
     * @param boxGroup the box group
     * @param boxSubGroup the box sub group
     * @return the matching box gps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BoxGp> findByBoxSubGroup(String boxGroup, String boxSubGroup)
        throws SystemException {
        return findByBoxSubGroup(boxGroup, boxSubGroup, QueryUtil.ALL_POS,
            QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the box gps where boxGroup = &#63; and boxSubGroup = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param boxGroup the box group
     * @param boxSubGroup the box sub group
     * @param start the lower bound of the range of box gps
     * @param end the upper bound of the range of box gps (not inclusive)
     * @return the range of matching box gps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BoxGp> findByBoxSubGroup(String boxGroup, String boxSubGroup,
        int start, int end) throws SystemException {
        return findByBoxSubGroup(boxGroup, boxSubGroup, start, end, null);
    }

    /**
     * Returns an ordered range of all the box gps where boxGroup = &#63; and boxSubGroup = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param boxGroup the box group
     * @param boxSubGroup the box sub group
     * @param start the lower bound of the range of box gps
     * @param end the upper bound of the range of box gps (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching box gps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BoxGp> findByBoxSubGroup(String boxGroup, String boxSubGroup,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXSUBGROUP;
            finderArgs = new Object[] { boxGroup, boxSubGroup };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_BOXSUBGROUP;
            finderArgs = new Object[] {
                    boxGroup, boxSubGroup,
                    
                    start, end, orderByComparator
                };
        }

        List<BoxGp> list = (List<BoxGp>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (BoxGp boxGp : list) {
                if (!Validator.equals(boxGroup, boxGp.getBoxGroup()) ||
                        !Validator.equals(boxSubGroup, boxGp.getBoxSubGroup())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(4 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(4);
            }

            query.append(_SQL_SELECT_BOXGP_WHERE);

            boolean bindBoxGroup = false;

            if (boxGroup == null) {
                query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXGROUP_1);
            } else if (boxGroup.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXGROUP_3);
            } else {
                bindBoxGroup = true;

                query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXGROUP_2);
            }

            boolean bindBoxSubGroup = false;

            if (boxSubGroup == null) {
                query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXSUBGROUP_1);
            } else if (boxSubGroup.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXSUBGROUP_3);
            } else {
                bindBoxSubGroup = true;

                query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXSUBGROUP_2);
            }

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(BoxGpModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindBoxGroup) {
                    qPos.add(boxGroup);
                }

                if (bindBoxSubGroup) {
                    qPos.add(boxSubGroup);
                }

                if (!pagination) {
                    list = (List<BoxGp>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BoxGp>(list);
                } else {
                    list = (List<BoxGp>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
     *
     * @param boxGroup the box group
     * @param boxSubGroup the box sub group
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching box gp
     * @throws gov.va.caret.NoSuchBoxGpException if a matching box gp could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp findByBoxSubGroup_First(String boxGroup, String boxSubGroup,
        OrderByComparator orderByComparator)
        throws NoSuchBoxGpException, SystemException {
        BoxGp boxGp = fetchByBoxSubGroup_First(boxGroup, boxSubGroup,
                orderByComparator);

        if (boxGp != null) {
            return boxGp;
        }

        StringBundler msg = new StringBundler(6);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("boxGroup=");
        msg.append(boxGroup);

        msg.append(", boxSubGroup=");
        msg.append(boxSubGroup);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBoxGpException(msg.toString());
    }

    /**
     * Returns the first box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
     *
     * @param boxGroup the box group
     * @param boxSubGroup the box sub group
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching box gp, or <code>null</code> if a matching box gp could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp fetchByBoxSubGroup_First(String boxGroup, String boxSubGroup,
        OrderByComparator orderByComparator) throws SystemException {
        List<BoxGp> list = findByBoxSubGroup(boxGroup, boxSubGroup, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
     *
     * @param boxGroup the box group
     * @param boxSubGroup the box sub group
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching box gp
     * @throws gov.va.caret.NoSuchBoxGpException if a matching box gp could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp findByBoxSubGroup_Last(String boxGroup, String boxSubGroup,
        OrderByComparator orderByComparator)
        throws NoSuchBoxGpException, SystemException {
        BoxGp boxGp = fetchByBoxSubGroup_Last(boxGroup, boxSubGroup,
                orderByComparator);

        if (boxGp != null) {
            return boxGp;
        }

        StringBundler msg = new StringBundler(6);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("boxGroup=");
        msg.append(boxGroup);

        msg.append(", boxSubGroup=");
        msg.append(boxSubGroup);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchBoxGpException(msg.toString());
    }

    /**
     * Returns the last box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
     *
     * @param boxGroup the box group
     * @param boxSubGroup the box sub group
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching box gp, or <code>null</code> if a matching box gp could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp fetchByBoxSubGroup_Last(String boxGroup, String boxSubGroup,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByBoxSubGroup(boxGroup, boxSubGroup);

        if (count == 0) {
            return null;
        }

        List<BoxGp> list = findByBoxSubGroup(boxGroup, boxSubGroup, count - 1,
                count, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the box gps before and after the current box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
     *
     * @param boxGpId the primary key of the current box gp
     * @param boxGroup the box group
     * @param boxSubGroup the box sub group
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next box gp
     * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp[] findByBoxSubGroup_PrevAndNext(long boxGpId, String boxGroup,
        String boxSubGroup, OrderByComparator orderByComparator)
        throws NoSuchBoxGpException, SystemException {
        BoxGp boxGp = findByPrimaryKey(boxGpId);

        Session session = null;

        try {
            session = openSession();

            BoxGp[] array = new BoxGpImpl[3];

            array[0] = getByBoxSubGroup_PrevAndNext(session, boxGp, boxGroup,
                    boxSubGroup, orderByComparator, true);

            array[1] = boxGp;

            array[2] = getByBoxSubGroup_PrevAndNext(session, boxGp, boxGroup,
                    boxSubGroup, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected BoxGp getByBoxSubGroup_PrevAndNext(Session session, BoxGp boxGp,
        String boxGroup, String boxSubGroup,
        OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_BOXGP_WHERE);

        boolean bindBoxGroup = false;

        if (boxGroup == null) {
            query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXGROUP_1);
        } else if (boxGroup.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXGROUP_3);
        } else {
            bindBoxGroup = true;

            query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXGROUP_2);
        }

        boolean bindBoxSubGroup = false;

        if (boxSubGroup == null) {
            query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXSUBGROUP_1);
        } else if (boxSubGroup.equals(StringPool.BLANK)) {
            query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXSUBGROUP_3);
        } else {
            bindBoxSubGroup = true;

            query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXSUBGROUP_2);
        }

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(BoxGpModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        if (bindBoxGroup) {
            qPos.add(boxGroup);
        }

        if (bindBoxSubGroup) {
            qPos.add(boxSubGroup);
        }

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(boxGp);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<BoxGp> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the box gps where boxGroup = &#63; and boxSubGroup = &#63; from the database.
     *
     * @param boxGroup the box group
     * @param boxSubGroup the box sub group
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByBoxSubGroup(String boxGroup, String boxSubGroup)
        throws SystemException {
        for (BoxGp boxGp : findByBoxSubGroup(boxGroup, boxSubGroup,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(boxGp);
        }
    }

    /**
     * Returns the number of box gps where boxGroup = &#63; and boxSubGroup = &#63;.
     *
     * @param boxGroup the box group
     * @param boxSubGroup the box sub group
     * @return the number of matching box gps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByBoxSubGroup(String boxGroup, String boxSubGroup)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_BOXSUBGROUP;

        Object[] finderArgs = new Object[] { boxGroup, boxSubGroup };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(3);

            query.append(_SQL_COUNT_BOXGP_WHERE);

            boolean bindBoxGroup = false;

            if (boxGroup == null) {
                query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXGROUP_1);
            } else if (boxGroup.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXGROUP_3);
            } else {
                bindBoxGroup = true;

                query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXGROUP_2);
            }

            boolean bindBoxSubGroup = false;

            if (boxSubGroup == null) {
                query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXSUBGROUP_1);
            } else if (boxSubGroup.equals(StringPool.BLANK)) {
                query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXSUBGROUP_3);
            } else {
                bindBoxSubGroup = true;

                query.append(_FINDER_COLUMN_BOXSUBGROUP_BOXSUBGROUP_2);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                if (bindBoxGroup) {
                    qPos.add(boxGroup);
                }

                if (bindBoxSubGroup) {
                    qPos.add(boxSubGroup);
                }

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the box gp in the entity cache if it is enabled.
     *
     * @param boxGp the box gp
     */
    @Override
    public void cacheResult(BoxGp boxGp) {
        EntityCacheUtil.putResult(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
            BoxGpImpl.class, boxGp.getPrimaryKey(), boxGp);

        boxGp.resetOriginalValues();
    }

    /**
     * Caches the box gps in the entity cache if it is enabled.
     *
     * @param boxGps the box gps
     */
    @Override
    public void cacheResult(List<BoxGp> boxGps) {
        for (BoxGp boxGp : boxGps) {
            if (EntityCacheUtil.getResult(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
                        BoxGpImpl.class, boxGp.getPrimaryKey()) == null) {
                cacheResult(boxGp);
            } else {
                boxGp.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all box gps.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(BoxGpImpl.class.getName());
        }

        EntityCacheUtil.clearCache(BoxGpImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the box gp.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(BoxGp boxGp) {
        EntityCacheUtil.removeResult(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
            BoxGpImpl.class, boxGp.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<BoxGp> boxGps) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (BoxGp boxGp : boxGps) {
            EntityCacheUtil.removeResult(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
                BoxGpImpl.class, boxGp.getPrimaryKey());
        }
    }

    /**
     * Creates a new box gp with the primary key. Does not add the box gp to the database.
     *
     * @param boxGpId the primary key for the new box gp
     * @return the new box gp
     */
    @Override
    public BoxGp create(long boxGpId) {
        BoxGp boxGp = new BoxGpImpl();

        boxGp.setNew(true);
        boxGp.setPrimaryKey(boxGpId);

        return boxGp;
    }

    /**
     * Removes the box gp with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param boxGpId the primary key of the box gp
     * @return the box gp that was removed
     * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp remove(long boxGpId)
        throws NoSuchBoxGpException, SystemException {
        return remove((Serializable) boxGpId);
    }

    /**
     * Removes the box gp with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the box gp
     * @return the box gp that was removed
     * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp remove(Serializable primaryKey)
        throws NoSuchBoxGpException, SystemException {
        Session session = null;

        try {
            session = openSession();

            BoxGp boxGp = (BoxGp) session.get(BoxGpImpl.class, primaryKey);

            if (boxGp == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchBoxGpException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(boxGp);
        } catch (NoSuchBoxGpException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected BoxGp removeImpl(BoxGp boxGp) throws SystemException {
        boxGp = toUnwrappedModel(boxGp);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(boxGp)) {
                boxGp = (BoxGp) session.get(BoxGpImpl.class,
                        boxGp.getPrimaryKeyObj());
            }

            if (boxGp != null) {
                session.delete(boxGp);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (boxGp != null) {
            clearCache(boxGp);
        }

        return boxGp;
    }

    @Override
    public BoxGp updateImpl(gov.va.caret.model.BoxGp boxGp)
        throws SystemException {
        boxGp = toUnwrappedModel(boxGp);

        boolean isNew = boxGp.isNew();

        BoxGpModelImpl boxGpModelImpl = (BoxGpModelImpl) boxGp;

        Session session = null;

        try {
            session = openSession();

            if (boxGp.isNew()) {
                session.save(boxGp);

                boxGp.setNew(false);
            } else {
                session.merge(boxGp);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !BoxGpModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((boxGpModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUP.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        boxGpModelImpl.getOriginalBoxGroup()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BOXGROUP, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUP,
                    args);

                args = new Object[] { boxGpModelImpl.getBoxGroup() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BOXGROUP, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXGROUP,
                    args);
            }

            if ((boxGpModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXSUBGROUP.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        boxGpModelImpl.getOriginalBoxGroup(),
                        boxGpModelImpl.getOriginalBoxSubGroup()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BOXSUBGROUP,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXSUBGROUP,
                    args);

                args = new Object[] {
                        boxGpModelImpl.getBoxGroup(),
                        boxGpModelImpl.getBoxSubGroup()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_BOXSUBGROUP,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_BOXSUBGROUP,
                    args);
            }
        }

        EntityCacheUtil.putResult(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
            BoxGpImpl.class, boxGp.getPrimaryKey(), boxGp);

        return boxGp;
    }

    protected BoxGp toUnwrappedModel(BoxGp boxGp) {
        if (boxGp instanceof BoxGpImpl) {
            return boxGp;
        }

        BoxGpImpl boxGpImpl = new BoxGpImpl();

        boxGpImpl.setNew(boxGp.isNew());
        boxGpImpl.setPrimaryKey(boxGp.getPrimaryKey());

        boxGpImpl.setBoxGpId(boxGp.getBoxGpId());
        boxGpImpl.setBoxGroup(boxGp.getBoxGroup());
        boxGpImpl.setBoxSubGroup(boxGp.getBoxSubGroup());
        boxGpImpl.setLabel(boxGp.getLabel());
        boxGpImpl.setViewSequence(boxGp.getViewSequence());

        return boxGpImpl;
    }

    /**
     * Returns the box gp with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the box gp
     * @return the box gp
     * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp findByPrimaryKey(Serializable primaryKey)
        throws NoSuchBoxGpException, SystemException {
        BoxGp boxGp = fetchByPrimaryKey(primaryKey);

        if (boxGp == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchBoxGpException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return boxGp;
    }

    /**
     * Returns the box gp with the primary key or throws a {@link gov.va.caret.NoSuchBoxGpException} if it could not be found.
     *
     * @param boxGpId the primary key of the box gp
     * @return the box gp
     * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp findByPrimaryKey(long boxGpId)
        throws NoSuchBoxGpException, SystemException {
        return findByPrimaryKey((Serializable) boxGpId);
    }

    /**
     * Returns the box gp with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the box gp
     * @return the box gp, or <code>null</code> if a box gp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        BoxGp boxGp = (BoxGp) EntityCacheUtil.getResult(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
                BoxGpImpl.class, primaryKey);

        if (boxGp == _nullBoxGp) {
            return null;
        }

        if (boxGp == null) {
            Session session = null;

            try {
                session = openSession();

                boxGp = (BoxGp) session.get(BoxGpImpl.class, primaryKey);

                if (boxGp != null) {
                    cacheResult(boxGp);
                } else {
                    EntityCacheUtil.putResult(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
                        BoxGpImpl.class, primaryKey, _nullBoxGp);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(BoxGpModelImpl.ENTITY_CACHE_ENABLED,
                    BoxGpImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return boxGp;
    }

    /**
     * Returns the box gp with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param boxGpId the primary key of the box gp
     * @return the box gp, or <code>null</code> if a box gp with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BoxGp fetchByPrimaryKey(long boxGpId) throws SystemException {
        return fetchByPrimaryKey((Serializable) boxGpId);
    }

    /**
     * Returns all the box gps.
     *
     * @return the box gps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BoxGp> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the box gps.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of box gps
     * @param end the upper bound of the range of box gps (not inclusive)
     * @return the range of box gps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BoxGp> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the box gps.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of box gps
     * @param end the upper bound of the range of box gps (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of box gps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BoxGp> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<BoxGp> list = (List<BoxGp>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_BOXGP);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_BOXGP;

                if (pagination) {
                    sql = sql.concat(BoxGpModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<BoxGp>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<BoxGp>(list);
                } else {
                    list = (List<BoxGp>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the box gps from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (BoxGp boxGp : findAll()) {
            remove(boxGp);
        }
    }

    /**
     * Returns the number of box gps.
     *
     * @return the number of box gps
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_BOXGP);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the box gp persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.BoxGp")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<BoxGp>> listenersList = new ArrayList<ModelListener<BoxGp>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<BoxGp>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(BoxGpImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
