package gov.va.caret.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.hook.LandingGroupSequence;
import gov.va.caret.model.Persn;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Primary;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.security.CAction;
import gov.va.caret.service.CaretServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.base.PersnServiceBaseImpl;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;

/**
 * The implementation of the persn remote service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.PersnService} interface.
 *
 * <p>
 * This is a remote service. Methods of this service are expected to have security checks based on the propagated JAAS credentials because this service can be accessed remotely.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.PersnServiceBaseImpl
 * @see gov.va.caret.service.PersnServiceUtil
 */
public class PersnServiceImpl extends PersnServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.PersnServiceUtil} to access the persn remote service.
     */
	
	Log _log = LogFactoryUtil.getLog(PersnServiceImpl.class);
	
	
	public Persn inactivateBySamAcctNm ( String samAccountName ) throws PortalException, SystemException {
		
		PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
		String permission = " does not have permission [permissionChecker==null]";
		if ( permissionChecker != null ){
			permission = " permissionChecker not null";
		}
		
		_log.info("samAccountName =" + samAccountName + permission );
		
		return new PersnImpl();
	}
	
	public Persn getPersonBySamAcctNm ( String samAccountName ) throws PortalException, SystemException {
		
		PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
		Persn persn = null;
		CAction.CaretCan permission = CAction.CaretCan.VIEW_VETERANS;
		if ( permissionChecker != null ){ 
			if ( hasAccess( LandingGroupSequence.getUserSite( PermissionThreadLocal.getPermissionChecker().getUser() ).getGroupId(), 
					permission.name()) ){
				User p = UserLocalServiceUtil.getUserByScreenName( PortalUtil.getDefaultCompanyId(), samAccountName );
				if ( p!= null ){
					persn = PersnLocalServiceUtil.getByUser( p.getUserId() );
					persn.setStatus( p.isActive()? "_ACTIVE": "_INACTIVE");
				} else {
					persn = new PersnImpl();
					persn.setStatus("NO PERSON FOUND");
				}
			} else {
				persn = new PersnImpl();
				persn.setStatus("PermissionChecker: You not have permission for this action [" + LanguageUtil.get(Locale.getDefault(), permission.toString() ));
			}
		} else {
			persn = new PersnImpl();
			persn.setStatus("PermissionChecker init failure...");
		}
		persn.setExternalId( samAccountName );
		
		_log.info( "service-status = " + persn.getStatus() );
		
		return persn;
	}
	
	public Persn updatePersonBySamAcctNm ( Persn person ) throws PortalException, SystemException {
		//TODO: determine if Activate/Deactivate is all thats needed.
		String screenName = person.getExternalId();
		PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
		CAction.CaretCan permission = CAction.CaretCan.VIEW_VETERANS;
		if ( permissionChecker != null ){ 
			if ( hasAccess( LandingGroupSequence.getUserSite( 
					PermissionThreadLocal.getPermissionChecker().getUser() ).getGroupId(), 
					permission.name() ) ) {
				String status = person.getStatus();
				User user = null;
				try{
					user = UserLocalServiceUtil.getUserByScreenName( PortalUtil.getDefaultCompanyId(), screenName );
					if ( "DEACTIVATE".equals(status) ){
						user = UserLocalServiceUtil.updateStatus(user.getUserId(), 
								WorkflowConstants.STATUS_INACTIVE, 
								getCaretServiceContext() );
					} else if ( "ACTIVATE".equals(status) ) {
						user = UserLocalServiceUtil.updateStatus(user.getUserId(), 
								WorkflowConstants.STATUS_APPROVED, 
								getCaretServiceContext() );
					}
					status = user.isActive()? "_ACTIVE": "_INACTIVE"; 
				}catch(PortalException p){
					_log.warn(p);
				}
				
				if ( user!= null ){
					person = PersnLocalServiceUtil.getByUser( user.getUserId() );
					person.setStatus( status );
				} else {
					_log.warn("Person does not exist, call create first[" + screenName + "]");
					person.setStatus("USE_CREATE_BEFORE_UPDATE");
				}
				person.setExternalId( screenName );
			} else {
				person.setStatus( "Does not have permission to update" );
			}
		}
		return person;
	}
	
	public Persn createPerson ( Persn persn ) throws PortalException, SystemException {
	
		PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
		String permission = " does not have permission [permissionChecker==null]";
		if ( permissionChecker != null ){ 
			if ( hasAccess ( LandingGroupSequence.getUserSite( permissionChecker.getUser() ).getGroupId(), CAction.CaretCan.TECH_FUNCTION.name() ) ){
				permission = " permissionChecker not null, has permission";
			} else {
				permission = " permissionChecker not null, Does not have permission";
			}
		}
		
		_log.info("samAccountName = " + persn.getExternalId() + permission );
		
		User p = UserLocalServiceUtil.getUserByScreenName( PortalUtil.getDefaultCompanyId(), persn.getExternalId() );
		if ( p!= null ){
			
			persn = PersnLocalServiceUtil.getByUser( p.getUserId() );
		} else {
			persn = new PersnImpl();
		}
		
		return persn;
	}
	
	private ServiceContext getCaretServiceContext() {
		PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
		
		ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
		if ( sc == null ) {
			sc = new ServiceContext();
			ServiceContextThreadLocal.pushServiceContext(sc);
		}
		sc.setAddGuestPermissions(false);
		
		sc.setCreateDate ( new java.util.Date() );
		sc.setModifiedDate( sc.getCreateDate() );
		sc.setAttribute( CaretStrPool.USER_ID, permissionChecker.getUserId() );
		
		sc.setAttribute( CaretStrPool.ROLE_ID, 0 );
		sc.setAttribute( CaretStrPool.DASHBOARD_ROLE_NAME, "SERVICE" );
		
		return sc;
	}
	
	private Boolean hasAccess ( long groupId, String action ) throws PortalException, SystemException {
		PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
		if ( permissionChecker != null ){ 
			try { 
				 return CAction.canDoCaret( permissionChecker, CAction.CaretCan.valueOf(action), groupId );
			} catch (Exception e ){
				_log.error("Permissioning Error", e);
			}
		} else {
			_log.error("PermissionChecker is null ");
		}
		return false;
	}
	
}
