package gov.va.caret.service.impl;

import java.util.List;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Apeal;
import gov.va.caret.service.base.ApealLocalServiceBaseImpl;

/**
 * The implementation of the apeal local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.ApealLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.ApealLocalServiceBaseImpl
 * @see gov.va.caret.service.ApealLocalServiceUtil
 */
public class ApealLocalServiceImpl extends ApealLocalServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.ApealLocalServiceUtil} to access the apeal local service.
     */
	
	public Apeal getByOwner ( long classPk, long persnId, String reasonType ){
		try {
			return getApealPersistence().fetchByOwner_Last(reasonType, classPk, persnId, null);
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public List<Apeal> getByVcgAn ( long[] classPk ){
		try {
			return getApealPersistence().findByVcgAn(classPk);
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public int countByOwner ( long classPk, long persnId, String reasonType ){
		try {
			return getApealPersistence().countByOwner(reasonType, classPk, persnId);
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return 0;
	}
}
