package gov.va.caret.service.ctssh.response;

import org.w3c.dom.Node;

import gov.va.caret.service.ctssh.template.TemplateResponseField;
import gov.va.caret.service.ctssh.util.AppHelper;

public class ResponseField  {

	
	/**
	 * 
	 */
	String _path = null;
	/**
	 * 
	 */
	boolean _default_used = false;
	/**
	 * 
	 */
	boolean _path_found = true;
	/**
	 * 
	 */
	String _value = null;
	/**
	 * 
	 */
	String _default_value = null;
	/**
	 * 
	 */
	String _name = null;
	
	
	/**
	 * @param tfld
	 * @param record_node
	 * @throws Exception
	 */
	public ResponseField(TemplateResponseField tfld, Node record_node) throws Exception
	{
		_path = tfld.xpath();
		_default_value = tfld.def();
		_name = tfld.name();
		
		_value = AppHelper.getStringValue(_path, record_node);
		if(_value == null)
		{
			_value = _default_value;
			_default_used = true;
			_path_found = false;
		}
		
	}
	

	
	/**
	 * @return
	 */
	public String path() {
		return _path;
	}
	
	/**
	 * @return
	 */
	public boolean defaultused() {
		return _default_used;
	}
	
	/**
	 * @return
	 */
	public boolean pathfound() {
		return _path_found;
	}
	
	/**
	 * @return
	 */
	public String value() {
		return _value;
	}
	
	/**
	 * @return
	 */
	public String def() {
		return _default_value;
	}
	
	/**
	 * @return
	 */
	public String name(){
		return _name;
	}

	/**
	 * @param prefix
	 * @return
	 */
	public static String fieldheader(String prefix)
	{
		StringBuilder sb = new StringBuilder();
		sb.append(prefix);
		sb.append(AppHelper.makeStringSize("NAME",20,"L"));
		sb.append(AppHelper.makeStringSize("VALUE",60,"L"));
		sb.append(AppHelper.makeStringSize("DEFAULT",20,"L"));
		sb.append(AppHelper.makeStringSize("PATH",20,"L"));
		sb.append(AppHelper.makeStringSize("PATH_FOUND",15,"L"));
		sb.append(AppHelper.makeStringSize("DEFAULT_USED",15,"L"));
		sb.append("\n");
		sb.append(prefix);
		sb.append(AppHelper.makeString("-", sb.length()));
		return sb.toString();
	}
	
	/**
	 * @param prefix
	 * @return
	 */
	public static String fieldheader2(String prefix)
	{
		StringBuilder sb = new StringBuilder();
		sb.append(prefix);
		sb.append("KEY");
		sb.append(prefix);
		sb.append(AppHelper.makeStringSize("NAME",20,"L"));
		sb.append(AppHelper.makeStringSize("VALUE",60,"L"));
		sb.append(AppHelper.makeStringSize("DEFAULT",20,"L"));
		sb.append(AppHelper.makeStringSize("PATH",20,"L"));
		sb.append(AppHelper.makeStringSize("PATH_FOUND",15,"L"));
		sb.append(AppHelper.makeStringSize("DEFAULT_USED",15,"L"));
		sb.append("\n");
		sb.append(prefix);
		sb.append(AppHelper.makeString("-", sb.length()));
		return sb.toString();
	}
	
	/**
	 * @param prefix
	 * @return
	 */
	public String toString(String prefix)
	{
		StringBuilder sb = new StringBuilder();
		sb.append(prefix);
		sb.append(AppHelper.makeStringSize(_name,20,"L"));
		sb.append(AppHelper.makeStringSize(_value,60,"L"));
		sb.append(AppHelper.makeStringSize(_default_value,20,"L"));
		sb.append(AppHelper.makeStringSize(_path,20,"L"));
		sb.append(AppHelper.makeStringSize(_path_found,15,"L"));
		sb.append(AppHelper.makeStringSize(_default_used,15,"L"));
		return sb.toString();
	}
	
}
