package gov.va.caret.service.ctssh.request;


import java.util.HashMap;
import java.util.Map;

import gov.va.caret.service.ctssh.template.ParameterValidationResult;
import gov.va.caret.service.ctssh.template.SimpleTemplate;
import gov.va.caret.service.ctssh.util.AppHelper;



public class SimpleRequest extends Request {

    /**
     * 
     */
    private HashMap<String, String> _parameters;
    /**
     * 
     */
    SimpleTemplate _template;
    /**
     * 
     */
    private ParameterValidationResult _validation_result;
    
    /**
     * @param ikey
     * @throws Exception
     */
    public SimpleRequest(String ikey) throws Exception
	{
            super(ikey);
            _template = (SimpleTemplate)super.template();
	}	
	

	
	/**
	 * @param name
	 * @return
	 */
	public String getParameter(String name)
	{
            return _parameters.get(name);
	}
	
	
	/* (non-Javadoc)
	 * @see gov.va.caret.service.ctssh.request.Request#setParameter(java.lang.String, java.lang.String)
	 */
	@Override
	public void setParameter(String name, String value) throws Exception
	{
            if(_parameters == null)
            	_parameters = new HashMap<>();
            
            if(_template.isParameter(name.toLowerCase()))
            {
            	_parameters.put(name.toLowerCase(), value);
            	AppHelper.log("Parameter " + name.toLowerCase() + " set to " + value);
            }
            // removed this because the chained request was blowing up on precedent parameters
           // else
           //     throw new CTSHException("Invalid parameter \"" + name + "\" for template " + _template.key());
	}
	
	/* (non-Javadoc)
	 * @see gov.va.caret.service.ctssh.request.Request#setParameter(java.lang.String, int)
	 */
	@Override
	public void setParameter(String name, int value) throws Exception
	{
            setParameter(name, String.valueOf(value));
	}
	
	/* (non-Javadoc)
	 * @see gov.va.caret.service.ctssh.request.Request#setParameter(java.lang.String, long)
	 */
	@Override
	public void setParameter(String name, long value) throws Exception
	{
            setParameter(name, String.valueOf(value));
	}
	
	/* (non-Javadoc)
	 * @see gov.va.caret.service.ctssh.request.Request#setParameter(java.lang.String, double)
	 */
	@Override
	public void setParameter(String name, double value) throws Exception
	{
            setParameter(name, String.valueOf(value));
	}
        
    /* (non-Javadoc)
     * @see gov.va.caret.service.ctssh.request.Request#validate()
     */
    @Override
	public ParameterValidationResult validate() throws Exception
    {
    	_validation_result = _template.validateParameters(_parameters);
    	return _validation_result; 
            
            
    }
        
    
    
	
    
	/**
	 * @return
	 * @throws Exception
	 */
	public String report() throws Exception {

		

		
		StringBuilder sb = new StringBuilder();
		
		sb.append("....................................................................................................\n");
	  	sb.append("INPUT PARAMETERS\n");
	  	sb.append("----------------------------------------------------------------------------------------------------\n");
	  	sb.append("URL : " + _template.url());
	  	sb.append("\n");


	  	for(Map.Entry<String,String> entry: _parameters.entrySet())
	  	{
		  	sb.append(entry.getKey().toUpperCase() + " : " + entry.getValue());
		  	sb.append("\n");
	  	}
		sb.append("----------------------------------------------------------------------------------------------------\n");
		
		
		
		
		
		
		
		
		
		
		return sb.toString();		
	}

	/**
	 * @return
	 */
	public HashMap<String,String> parameters()
    {
        return _parameters;
    }
    
    /* (non-Javadoc)
     * @see gov.va.caret.service.ctssh.request.Request#template()
     */
    @Override
	public SimpleTemplate template()
    {
        return _template;
    }
    
    /* (non-Javadoc)
     * @see gov.va.caret.service.ctssh.request.Request#toString()
     */
    @Override
    public String toString()
    {
        return super.toString() + ":SIMPLE";
    }



	/**
	 * @param parameters
	 * @throws Exception
	 */
	public void pushParameters(HashMap<String, String> parameters) throws Exception {

		for(Map.Entry<String, String> entry: parameters.entrySet())
		{
			setParameter(entry.getKey(),entry.getValue());
		}
		
	}



        
}
