package gov.va.caret.portlet.resource;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.CaretBaseViewController;
import gov.va.caret.controller.OnlineViewController;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Persn;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.impl.BgAsnImpl;
import gov.va.caret.model.impl.BgLaeImpl;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.impl.VcgAnImpl;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Primary;
import gov.va.caret.model.support.Secondary;
import gov.va.caret.model.support.SecondaryTwo;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.pdf.PdfHandler;
import gov.va.caret.pdf.VaForm1010cgSection;
import gov.va.caret.service.BgAsnLocalServiceUtil;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.thread.Monitor;
import gov.va.caret.util.CaretMap;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.CaretUtil;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.CaretParam;
import gov.va.iam.IamService;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.portlet.ProcessAction;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;

public class OnlineResourceCommand extends ResourceCommand {
	
	public String load1010cg ( ResourceRequest request, ResourceResponse response ){
		OnlineViewController.get().loadApplication( request );
		return "edit1010cg";
	}
	
	public String getCities ( ResourceRequest request, ResourceResponse response ){
		 _log.info("inside getCities... ");
		return super.getCities(request, response);
	}
	
	public void getUSPSZips ( ResourceRequest request, ResourceResponse response ){
		super.getUSPSZips(request, response);
	}
	public void validateUSPSAddress ( ResourceRequest request, ResourceResponse response ){
	    super.validateUSPSAddress(request, response);
	}

	
	public String getZips ( ResourceRequest request, ResourceResponse response ){
		 _log.info("inside getZips... ");
		return super.getZips(request, response);
	}
	
	public String getFacils ( ResourceRequest request, ResourceResponse response ){
		 return super.getFacils(request, response);
	}
	
	@SuppressWarnings("rawtypes")
	protected String getApplicationReview ( ResourceRequest request, ResourceResponse response ){
		
		try {
            _log.info("inside getPdf form... ");
			PDDocument pdfDoc = PDDocument.load( PdfHandler.getSeedUrl() );
        	try{
        		long userId = PortalUtil.getUserId(request);
    			long vcgAnId = ParamUtil.getLong(request, "vcgAnId", 0);
    			BaseModel vcgApplication = vcgAnId > 0 ? VcgAnLocalServiceUtil.getVcgAn(vcgAnId) : new VcgAnImpl();
    			
    			//TODO: pass list of parameter names 
    			VcgAn vcgAn = (VcgAn) CaretParam.loadModel(request, vcgApplication, vcgApplication.getModelAttributes().keySet(), "vcgAn_");
    			
    			long persnId = CaretParam.getPersnId(request);
				OnlineViewController controller = OnlineViewController.get();
				Person intent = null;
				
    			if ( vcgAn.getVcgAnId() == 0 ){
    				intent = new Veteran( PersnLocalServiceUtil.getPersn( CaretParam.getPersnId(request) ) );
    				intent = (Veteran) CaretParam.loadModel(request, intent, intent.getModelAttributes().keySet(),  CaretStrPool.VETERAN_PERSN  + StringPool.UNDERLINE);
    				controller.loadPersnAddress( request, intent, CaretStrPool.VETERAN_PERSN );
    				((Veteran)intent).setVaHealthEnrolled(vcgAn.getVaHealthEnrolled());
    			} else {
    				if ( vcgAn.getPrimaryId() > 0 && new Person( PersnLocalServiceUtil.getPersn( vcgAn.getPrimaryId() ), true).getRootUserId() == userId ){
    					intent = new Primary ( PersnLocalServiceUtil.getPersn( persnId ) );
    					intent = (Primary) CaretParam.loadModel(request, intent, intent.getModelAttributes().keySet(), CaretStrPool.PRIMARY_PERSN  + StringPool.UNDERLINE);
    					controller.loadPersnAddress( request, intent, CaretStrPool.PRIMARY_PERSN );
    					intent.setRelationship(vcgAn.getPrimaryRelationship());
    					((Person)intent).setFamily( ParamUtil.getBoolean( request, "certifyFamily") ); 
    					((Person)intent).setNotFamily( ParamUtil.getBoolean( request, "certifyNotFamily") ); 
    					boolean otherInsChecked = ParamUtil.getBoolean(request, "otherHealthInsurance", false);
    					if ( !otherInsChecked ){
    						intent.setOtherHealthInsurance(StringPool.BLANK);
    					}
    					((Primary)intent).setOtherInsChecked(otherInsChecked);
    				} else if ( vcgAn.getSecondaryId() > 0 && new Person(PersnLocalServiceUtil.getPersn( vcgAn.getSecondaryId() ), true).getRootUserId() == userId  ){
    					intent = new Secondary( PersnLocalServiceUtil.getPersn( persnId ) );
    					intent = (Person) CaretParam.loadModel(request, intent, intent.getModelAttributes().keySet(),  CaretStrPool.SECONDARY_PERSN  + StringPool.UNDERLINE);
    					controller.loadPersnAddress( request, intent, CaretStrPool.SECONDARY_PERSN );
    					intent.setRelationship(vcgAn.getSecondaryRelationship());
    					((Person)intent).setFamily( ParamUtil.getBoolean( request, "certifyFamily") ); 
    					((Person)intent).setNotFamily( ParamUtil.getBoolean( request, "certifyNotFamily") ); 
    				} else if ( vcgAn.getSecondaryTwoId() > 0 && new Person(PersnLocalServiceUtil.getPersn( vcgAn.getSecondaryTwoId() ), true).getRootUserId() == userId ){
    					intent = new SecondaryTwo( PersnLocalServiceUtil.getPersn( persnId ) );
    					intent = (Person) CaretParam.loadModel(request, intent, intent.getModelAttributes().keySet(), CaretStrPool.SECONDARY_TWO_PERSN  + StringPool.UNDERLINE);
    					controller.loadPersnAddress( request, intent, CaretStrPool.SECONDARY_TWO_PERSN );
    					intent.setRelationship(vcgAn.getSecondaryTwoRelationship());
    					((Person)intent).setFamily( ParamUtil.getBoolean( request, "certifyFamily") ); 
    					((Person)intent).setNotFamily( ParamUtil.getBoolean( request, "certifyNotFamily") ); 
    				} 
    			}
    			CaretParam.setOnlineServiceContext(request);
    			VaForm1010cgSection pdfFields = new VaForm1010cgSection(intent, vcgAn, pdfDoc );
    			request.getPortletSession().setAttribute("pdfFields", Collections.singletonMap(intent, vcgAn));
    			
    			ByteArrayOutputStream output = new ByteArrayOutputStream();
    			new PdfHandler().setFields(pdfFields);
    			pdfDoc.save( output );
    	        pdfDoc.close();
    	        output.flush();

    			response.setContentType( "application/pdf");
    			response.setProperty("Cache-Control", "no-cache");
    			writeStream( response, output.toByteArray(), "Review_10-10CG.pdf" );
        	} catch (IOException e) {
    			ApplicationWorkFlowException.handleException(e);
    		} finally {
   				pdfDoc.close();
    		}
        } catch(Exception e) {
        	ApplicationWorkFlowException.handleException(e);
        } 
		return StringPool.BLANK;
	}

	public String getDocum ( ResourceRequest request, ResourceResponse response ){
		return super.getDocum (request, response);
	}
	
	public String searchVcg ( ResourceRequest request, ResourceResponse response ){
		
		 String fname = ParamUtil.get(request, "fname", StringPool.BLANK);
		 String lname = getValue(request, "lname");
		 String mname = getValue(request, "mname");
		 String ssn = getValue(request, "ssn");
		 String phone = getValue(request, "phone");
		 String phone2 = getValue(request, "phone2");
		 String gender = getValue(request, "gender");
		 String address = getValue(request, "address" );
		 String zip = getValue(request, "zip" );
		 String email = getValue(request, "email" );
		 Date birthdate = Toolbox.parseDate( getValue(request, "birthdate" ) );
		 String city = getValue(request, "city" );
		 Long cg1 = ParamUtil.getLong(request, "cg1");
		 Long cg2 = ParamUtil.getLong(request, "cg2");
		 Long cg3 = ParamUtil.getLong(request, "cg3");
		 _log.info( "gender="+ gender + ", lname=" + lname+ ", address=" + address );
		 
		 
		JSONObject vcg, json = JSONFactoryUtil.createJSONObject();
		JSONArray vcgs = JSONFactoryUtil.createJSONArray();

		boolean skipSearch = fname.isEmpty() && lname.isEmpty();
		List<? extends Persn> list = null;
		int size = 0;
		String message = StringPool.BLANK;
		if ( skipSearch ){
			list = Collections.emptyList();
		} else	 {
			
			list = CachedReport.searchPerson(fname, lname, mname, ssn, phone, phone2, gender, address, city, zip, email, birthdate, true);
			if ( list.isEmpty() ){
				Map<String, Object> map = new CaretMap<String, Object>(StringPool.BLANK);
				map.put("searchLastName", lname);
				map.put("searchFirstName", fname);
				map.put("searchMiddleName", mname);
				map.put("searchSuffix", getValue(request, "suffix"));
				map.put("searchBirthday", Person.mviFormat( Person.DOB, getValue(request, "birthdate" )  ) );
				map.put("searchSsn", Person.mviFormat( Person.SSN, ssn ) );
				map.put("searchGender", Person.mviFormat( Person.GENDER, gender ) );
				map.put("searchPhone", Person.mviFormat( Person.PHONE, phone) );
				
				map.put("searchStreet", address);
				map.put("searchCity", city);
				map.put("searchZip", zip);
				
				map.put("senderOid", PortletProps.get("mvi.senderOid") );
				map.put("senderId", IamService.appId);
				map.put("creationTime", Toolbox.getDateTimeFormatOrient().format( new Date() ) );
				Map<String, Object> result = null;
				try {
					User user = PortalUtil.getUser(request);
					map.put("senderFirstName", user.getFirstName());
					map.put("senderLastName", user.getLastName());
					result = gov.va.iam.IamService.searchUnattended(map);
				} catch ( Exception e) {
					e.printStackTrace();
				}
				if ( result == null ){
					json.put("msg", "error");
					json.put("size", -1 );
					return writeJson ( response, json );
				} else if (!result.isEmpty()) {
					Persn p = null;
					String icn = Toolbox.nullSafe( result.get(CaretStrPool.ICN) );
					if ( !Toolbox.isEmpty( icn ) ){
						try {
							p = PersnLocalServiceUtil.getByIcn(icn);
						} catch (ApplicationWorkFlowException e) {
							_log.info("No user found with returned ICN");
						}
					}
					boolean isNew2CareT = p == null; 
					if ( isNew2CareT ){
						p = new PersnImpl();
					}
					p = new Person( p );
					
					p.setModelAttributes(result);
					if ( isNew2CareT ) try {
						p.setICN(icn);
						CaretLocalServiceUtil.save(p);
					} catch (ApplicationWorkFlowException e) {
						e.printStackTrace();
					}
					list = Collections.singletonList(p);
				}
			}
			int listSize = list.size();
			Set<Long> caregiverIds = new HashSet<Long>();
			
			Veteran veteran;
			try {
				veteran = new Veteran ( PersnLocalServiceUtil.getByUser( PortalUtil.getUserId(request) ) );
				if ( !veteran.isPrimaryAvailable() ){
					caregiverIds.add( veteran.getPrimaryId() );
				}
				if ( !veteran.isSecondaryAvailable() ){
					caregiverIds.add( veteran.getSecondaryId() );
				}
				if ( !veteran.isSecondaryTwoAvailable() ){
					caregiverIds.add( veteran.getSecondaryTwoId() );
				}
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
			caregiverIds.add(cg3);
			caregiverIds.add(cg2);
			caregiverIds.add(cg1);
			if ( listSize > 0 ){
				if ( caregiverIds != null && !caregiverIds.isEmpty() && list.get(0).getPrimaryKey() > 0 ){
					if ( caregiverIds.contains( list.get(0).getPrimaryKey() ) ){
						size = 0;
						message = "taken";
					} else {
						size = listSize;
					}
				} else {
					size = listSize;
				}
			}
		}
		json.put("size", size );
		_log.info("user size vcgs.. " + size );
		
		if ( size == 0 ){
			vcg = JSONFactoryUtil.createJSONObject();
			vcg.put(CaretStrPool.PRIMARY_KEY, 0 );
			ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
			String noPersonsFound = LanguageUtil.get(themeDisplay.getLocale(), "no-caregiver-found", "No Caregiver found"  );
			vcg.put("fullName", noPersonsFound );
			vcgs.put(vcg);
		} else {
			for ( Persn p : list ){
				vcg = JSONFactoryUtil.createJSONObject();
				
				vcg.put("fullName", p.getFirstName() + " " + p.getMiddleName() + " " +  p.getLastName() );
				vcg.put(CaretStrPool.PRIMARY_KEY, p.getPrimaryKey() );
				// vcg.put("ssn", p.getSsn() );
				// vcg.put("birthDate", Toolbox.formatDate( p.getBirthDate() ) );
//					vcg.put("lastName", p.getLastName() );
//					vcg.put("firstName", p.getFirstName() );
//					vcg.put("middleName", p.getMiddleName() );
//					vcg.put("suffix", p.getSuffix() );
				vcg.put("phone", p.getPhone() );
				vcg.put("phone2", p.getPhone2() );
				vcg.put("email", p.getEmail() );
				vcg.put("address", p.getAddress() );
				vcg.put("city", p.getCity() );
				vcg.put("state", p.getState() );
				vcg.put("zip", p.getZip() );
				vcg.put("groupId", p.getGroupId() );
				vcg.put("gender", p.getGender() );
				vcg.put("Icn", p.getICN() );
				vcgs.put(vcg);
			}
		}
		json.put("vcgs", vcgs);
		json.put("msg", message);
		return writeJson ( response, json );
	}
	
	public String saveAttestationUrl ( ResourceRequest request, ResourceResponse response ){
		_log.info("saveAttestationUrl...");
		
		JSONObject json = JSONFactoryUtil.createJSONObject();
		
		String lastUrl = request.getParameter(CaretStrPool.RESOURCE_HANDLER);
		
		long confirmationId = 0;
		try {
			List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups("last-attestation-url", "last-attestation-url");
			if ( groups.isEmpty() ){
				BoxGp grp = new BoxGpImpl();
				grp.setBoxGroup("last-attestation-url");
				grp.setBoxSubGroup("last-attestation-url");
				grp.setLabel("last-attestation-url");
				grp.setViewSequence(1);
				try {
					groups = Collections.singletonList( BoxGpLocalServiceUtil.addBoxGp(grp) );
				} catch (SystemException e) {
					throw new ApplicationWorkFlowException(e);
				}
			}
			
			BgLae bgLae = BgLaeLocalServiceUtil.getBgLaeAssociation( PortalUtil.getUserId(request), groups.get(0).getBoxGpId() );
			
			if ( bgLae != null ){
				bgLae.setLargeText(lastUrl);
			} else {
				bgLae = new BgLaeImpl();
				bgLae.setLargeText( lastUrl );
				bgLae.setBoxGpId( groups.get(0).getBoxGpId() );
				bgLae.setOwnerId( PortalUtil.getUserId(request) );
			}
			BgLaeLocalServiceUtil.updateBgLae(bgLae);
			confirmationId = bgLae.getOwnerId();
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		} catch (SystemException e) {
			e.printStackTrace();
		}
		json.put(CaretStrPool.READ_CONFIRMATION, confirmationId );
		return writeJson ( response, json );
	}
	
	
	public String saveAnswer ( ResourceRequest request, ResourceResponse response ){
		 _log.info("saveAnswer...");
		 String subgroup = request.getParameter(CaretStrPool.SUBGROUP);
		 long boxGpId = ParamUtil.getLong(request, CaretStrPool.BOX_GROUP_ID);
		
		 JSONObject json = JSONFactoryUtil.createJSONObject();
		 try{
			 for ( BoxGp boxGp: BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.ONLINE_QUESTIONAIRE_YN, subgroup) ) {
				 BgAsn bgAsn = BoxGpLocalServiceUtil.getBoxGroupAssociation( CaretParam.getPersnId(request), boxGp.getBoxGpId() ) ;
				 if ( bgAsn != null ){
					 bgAsn.setSelected(boxGp.getBoxGpId() == boxGpId);
				 } else if ( boxGp.getBoxGpId() == boxGpId ){
					 bgAsn = new BgAsnImpl();
					 bgAsn.setSelected(true);
					 bgAsn.setBoxGpId(boxGpId);
					 bgAsn.setOwnerId( CaretParam.getPersnId(request) );
				 } else {
					 continue;
				 }
				 BgAsnLocalServiceUtil.updateBgAsn(bgAsn);
				 if ( Veteran.ENROLLED_VA_HEALTH.equals( subgroup ) && boxGp.getBoxGpId() == boxGpId ){
					 request.getPortletSession().setAttribute( Veteran.ENROLLED_VA_HEALTH, Toolbox.toBoolYesNo( boxGp.getLabel() ) );
				 }
			}
			json.put(CaretStrPool.FORM, StringPool.TRUE);
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		 
		 
		 json.put(CaretStrPool.FORM, StringPool.TRUE);
		return writeJson ( response, json );
	}
	
	public String clearAnswer ( ResourceRequest request, ResourceResponse response ){
		
		_log.info("clearAnswer...");
		JSONObject json = JSONFactoryUtil.createJSONObject();
		try {
			for ( BgAsn bgAsn: BoxGpLocalServiceUtil.getBoxGroupAssociations( CaretParam.getPersnId(request) ) ) {
				bgAsn.setSelected(false);
				BgAsnLocalServiceUtil.updateBgAsn(bgAsn);
			}
			json.put(CaretStrPool.FORM, StringPool.TRUE);
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		if ( request.getPortletSession().getAttribute(Veteran.ENROLLED_VA_HEALTH) != null ){
			request.getPortletSession().removeAttribute(Veteran.ENROLLED_VA_HEALTH);
		}
		return writeJson(response, json);
	}
	
	public String lockDocum( ResourceRequest request, ResourceResponse response ){
		_log.info("lockDocum...");
		JSONObject json = JSONFactoryUtil.createJSONObject();
		try {
			long userId = PortalUtil.getUserId(request);
			long vcgAnId = ParamUtil.getLong(request, "vcgAnId", 0);
			if ( vcgAnId > 0 ) {
				json.put( CaretStrPool.FORM, Monitor.lock(vcgAnId, userId) );
			}
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
			json.put(CaretStrPool.FORM, -1);
		}
		return writeJson ( response, json );
	}
	
	@ProcessAction (name="testMvi")
	public void testMvi ( ResourceRequest request, ResourceResponse response ) throws ApplicationWorkFlowException, PortalException, SystemException, COSVisitorException, IOException, URISyntaxException {
		_log.info("testMVI");
//		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
//		if ( ! CaretParam.isTracked( request, tracker, true ) ){
//			_log.warn("TRACKER BLOCKING action... ");
//			request.setAttribute(CaretStrPool.INVALID_REQUEST, true);
//			return;
//		}
		IamService.testMvi();
		_log.info("testMVI finished");
	}

	@ProcessAction (name="testEsig")
	public void testEsig ( ResourceRequest request, ResourceResponse response ) throws ApplicationWorkFlowException, PortalException, SystemException, COSVisitorException, IOException, URISyntaxException {
		
		if ( CaretUtil.isTrackerEnabled() ){
			String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
			if ( ! CaretParam.isTracked( request, tracker, true ) ){
				_log.warn("TRACKER BLOCKING action... ");
				request.setAttribute(CaretStrPool.INVALID_REQUEST, true);
				return;
			}
		}

		Veteran veteran = new Veteran( PersnLocalServiceUtil.getLatest( PortalUtil.getUserId( request ) ) );
		
		CaretParam.setOnlineServiceContext( request );
		VcgAn vcgAn = new VcgAnImpl();
		vcgAn.setLastTreatmentPlace("last-Treatment-Place-clinic");
		vcgAn.setMediEnrolled(true);
		vcgAn.setVaHealthEnrolled(true);
		
		vcgAn.setGroupId( OrganizationLocalServiceUtil.getOrganizationId(PortalUtil.getCompanyId(request), "VISN1"));
		veteran.setGroupId( vcgAn.getGroupId() );
		
		VaForm1010cgSection form = new VaForm1010cgSection(veteran, vcgAn, PDDocument.load( PdfHandler.getSeedUrl() ) );
		
		_log.info("reached testFunction.....");
		
		ByteArrayOutputStream outStream = new ByteArrayOutputStream();
		PdfHandler pdfHandler = new PdfHandler();
		pdfHandler.setFields(form);

		form.getPdfDoc().save( outStream );
		form.getPdfDoc().close();
		outStream.flush();
		pdfHandler.eSigForm( veteran, outStream );
		
		try{
			response.setContentType( "application/pdf");
			response.setProperty("Cache-Control", "no-cache");
			writeStream( response, outStream.toByteArray(), "eSigTest.pdf" );
		} catch (Exception e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	private static Log _log = LogFactoryUtil.getLog( OnlineResourceCommand.class );

	@Override
	public String getJspDir() {
		return CaretBaseViewController.ONLINE_VIEW;
	}
	
}
