package gov.va.caret.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.util.bridges.mvc.MVCPortlet;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.CaretBaseViewController;
import gov.va.caret.portlet.action.ActionCommand;
import gov.va.caret.portlet.resource.ResourceCommand;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.view.CaretParam;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.ProcessAction;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;


public class CaretBasePortlet extends MVCPortlet implements PortletCommander {
	

	protected void include( String path, RenderRequest renderRequest, RenderResponse renderResponse)
		throws IOException, PortletException {

		PortletRequestDispatcher portletRequestDispatcher = getPortletContext().getRequestDispatcher(path);

		if (portletRequestDispatcher == null) {
			_log.error(path + " is not a valid include");
		}
		else {
			renderRequest.setAttribute( CaretStrPool.BUILDVERSION, getViewController().getVersion() );
			portletRequestDispatcher.include(renderRequest, renderResponse);
		}
	}
	
	public void doView(RenderRequest renderRequest, RenderResponse renderResponse)
			throws IOException, PortletException {  
		//RENDER_PHASE
		_log.info("do View...");
		String mvcPath = ParamUtil.getString( renderRequest, CaretStrPool.MVC_PATH, StringPool.BLANK );
		
		if ( mvcPath.isEmpty() ){
			Object path = renderRequest.getAttribute(CaretStrPool.MVC_PATH);
			if ( path != null ){
				mvcPath = path.toString();
			}
		}
		
		if ( mvcPath.isEmpty() ){
			mvcPath = getViewController().loadDefaultView(renderRequest, renderResponse);
		}
		
		Object tracker = CaretParam.trackNdx( renderRequest );
		renderRequest.setAttribute( CaretStrPool.GENERIC_URL, renderResponse.createRenderURL() );
		renderRequest.setAttribute( CaretStrPool.TRACKER, tracker );
		_log.debug("tracker set..." + tracker);
		if ( mvcPath != null && !mvcPath.isEmpty() ){
			include(mvcPath, renderRequest, renderResponse);
		} else {
			include(viewJSP, renderRequest, renderResponse);
		}
		includeVersion(renderRequest, renderResponse);
	}
	

	private void includeVersion(RenderRequest renderRequest,
			RenderResponse renderResponse) {
		try {
			include(CaretBaseViewController.VERSION_VIEW, renderRequest, renderResponse);
		} catch (Exception e1) {
			_log.error("Could not load version...");
			ApplicationWorkFlowException.handleException(e1);
		}
	}

	@Override
	public void serveResource ( ResourceRequest request, ResourceResponse response ) throws PortletException, IOException {
		
		Object resourceObj = ResourceCommand.handle( request, response, resourceCommand );
		if ( resourceObj != null && !StringPool.BLANK.equals( resourceObj ) ){
			String resourceName = resourceCommand.getJspDir() + resourceObj + CaretBaseViewController.JSP_EXT;
			if ( _log.isDebugEnabled() ){
				_log.debug( "path is " + resourceName );
			}
			try{
				request.getPortletSession().getPortletContext().getRequestDispatcher(resourceName).include(request, response);
			} catch ( javax.portlet.PortletException e ){
				ApplicationWorkFlowException.handleException(e);
				request.getPortletSession().getPortletContext().getRequestDispatcher(CaretStrPool.PAGE_NOT_FOUND).include(request, response);
			}
		}
	}
	
	public void init() throws PortletException {
		viewJSP = getInitParameter("view-jsp");
		gov.va.caret.service.thread.Monitor.clear ();
	}

	@Override
	public ResourceCommand getResourceCommand() {
		return resourceCommand;
	}

	@Override
	public CaretBaseViewController getViewController() {
		return viewController;
	}
	
	@Override
	public ActionCommand getActionCommand() {
		return actionCommand;
	}
	
	@ProcessAction (name="doAction")
	public void doAction( ActionRequest request, ActionResponse response ) {
		ActionCommand.handle( request, response, actionCommand );
	}
	
	protected ResourceCommand resourceCommand;
	protected ActionCommand actionCommand;
	protected CaretBaseViewController viewController;
	protected String viewJSP;
	
	private static Log _log = LogFactoryUtil.getLog(CaretBasePortlet.class);
}
