package gov.va.caret.pm.portlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import gov.va.caret.model.Facil;
import gov.va.caret.model.PMDeletedMessage;
import gov.va.caret.model.PMMessage;
import gov.va.caret.model.impl.PMDeletedMessageImpl;
import gov.va.caret.pm.util.PMCategories;
import gov.va.caret.pm.util.PMConstants;
import gov.va.caret.pm.util.PMUtil;
import gov.va.caret.service.PMDeletedMessageLocalServiceUtil;
import gov.va.caret.service.PMMessageLocalServiceUtil;
import gov.va.caret.service.persistence.PMDeletedMessageUtil;
import gov.va.caret.service.persistence.PMMessageUtil;
import gov.va.caret.util.CaretStrPool;

import com.liferay.mail.service.MailServiceUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.util.PropsUtil;

/** 
 * 
 * @author akhojoyan
 *
 */
//@SuppressWarnings("unchecked")
public class PMPortlet {

	static Log log = LogFactoryUtil.getLog(PMPortlet.class);

	private static long userId = 0L;

	public static void render(ActionRequest actionRequest, ActionResponse actionResponse) {

		int countPerPage = 10;	//	TODO:	get from configuration

		try {
			String includeFile = "/view.jsp";
			String action = ParamUtil.getString(actionRequest, CaretStrPool.MESSAGE_ACTION, StringPool.BLANK );
			
			String startIndexStr = ParamUtil.getString(actionRequest, "startIndex");
			startIndexStr = startIndexStr.trim().equals("") ? "0" : startIndexStr;
			int startIndex = Integer.parseInt(startIndexStr);
			int endIndex = startIndex + countPerPage;
			actionRequest.setAttribute("start", startIndex);
			String pageStr = ParamUtil.getString(actionRequest, "page");
			if (!pageStr.trim().equals("")) {
				action = pageStr;
			}

			userId = PortalUtil.getUserId(actionRequest);
			
			if (action.equals(PMConstants.INBOX_ACTION)) {
				includeFile = "/view.jsp";
			} else if (action.equals(PMConstants.VIEW_MESSAGE_ACTION)) {
				includeFile = "/view_message.jsp";
			} else if (action.equals(PMConstants.OUTBOX_ACTION)) {
				includeFile = "/outbox.jsp";
			} else if (action.equals(PMConstants.TRASH_ACTION)) {
				includeFile = "/trash.jsp";
			} else if (action.equals(PMConstants.COMPOSE_ACTION)) {
				actionRequest.setAttribute("parentMessageId", "-1");
				includeFile = "/compose.jsp";
			} else if (action.equals(PMConstants.REPLY_ACTION)) {
				String pId = ParamUtil.getString(actionRequest, "parentMessageId");
				if (pId != null) {
					PMMessage parentMessage = PMMessageLocalServiceUtil.getPMMessage(Long.parseLong(pId));
					actionRequest.setAttribute("parentMessage", parentMessage);
					actionRequest.setAttribute("parentMessageId", pId);
					
				}
				includeFile = "/compose.jsp";
			} else if (action.equals(PMConstants.ADD_ACTION)) {
				try {
					createNewMessage(actionRequest);
					//includeFile = "/view.jsp";
				} catch (Exception e) {
					String parentMessageIdStr = ParamUtil.getString(actionRequest, "parentMessageId");
					actionRequest.setAttribute("parentMessageId", parentMessageIdStr);
					actionRequest.setAttribute(PMConstants.ERROR_MESSAGE, e.getMessage());
					includeFile = "/compose.jsp";
				}
			} else if (action.equals(PMConstants.DELETE_ACTION)) {
				try {
						deleteMessages(actionRequest);
						includeFile = "/view.jsp";
				} catch (Exception e) {
					actionRequest.setAttribute(PMConstants.ERROR_MESSAGE, e.getMessage());
					includeFile = "/view.jsp";
				}
			} else {
				includeFile = "/view.jsp";
			}

			if(includeFile.equals("/view.jsp")) {
				int unreadCount = 0;
				// save selected page of messages list
				List<PMMessage> messages = PMMessageLocalServiceUtil.getInboxMessages(userId);
				List<PMMessage> parentMessages = new ArrayList<PMMessage>();
				
				HashMap<Long, List<PMMessage>> messageMap = new HashMap<Long, List<PMMessage>> ();
				HashMap<Long, String> recipentMap = new HashMap<Long, String> ();
				for ( Iterator<PMMessage> iter = messages.iterator(); iter.hasNext(); ) {
					PMMessage message = iter.next();
					if (message.getParentMessageId() < 0) {
						// message is considered parent since it doesn't have a parentmessage
						messageMap.put(message.getMessageId(), PMMessageLocalServiceUtil.getChildMessages(message.getMessageId()));
						recipentMap.put(message.getMessageId(), PMUtil.getRecepientsAsString(message));
						parentMessages.add(message);
					}
				}
				int totalCount = parentMessages.size();
				List<PMMessage> filtered = new ArrayList<PMMessage>();
				if (endIndex > parentMessages.size()) {
					endIndex = parentMessages.size();
				}
				for (int i = startIndex; i < endIndex; i++) {
					filtered.add(parentMessages.get(i));
				}
				messages = filtered;

				actionRequest.setAttribute(PMConstants.MESSAGES_LIST, parentMessages);
				actionRequest.setAttribute(PMConstants.MESSAGES_MAP, messageMap);
				actionRequest.setAttribute(PMConstants.UNREAD_COUNT, getUnreadCount(userId));

				//	save total count of Inbox messages
				actionRequest.setAttribute(PMConstants.TOTAL_COUNT, totalCount);
				actionRequest.setAttribute("recipentMap", recipentMap);
				
			} else if (includeFile.equals("/view_message.jsp")) {
				

				long pId = ParamUtil.getLong(actionRequest, "parentMessageId");
				actionRequest.setAttribute("parentMessageId", pId);
				List<PMMessage> messages = new ArrayList<PMMessage> ();
				messages.add(PMMessageLocalServiceUtil.getPMMessage(pId));
				List<PMMessage> childMessages = PMMessageLocalServiceUtil.getChildMessages(pId);
				List<PMMessage> sortedChildMessages = new ArrayList<PMMessage>(childMessages); 
			    Collections.reverse(sortedChildMessages);
				messages.addAll(sortedChildMessages);
				int totalCount = messages.size();
				List<PMMessage> filtered = new ArrayList<PMMessage>();
				if (endIndex > messages.size()) {
					endIndex = messages.size();
				}
				for (int i = startIndex; i < endIndex; i++) {
					filtered.add(messages.get(i));
				}
				messages = filtered;
				actionRequest.setAttribute(PMConstants.MESSAGES_LIST, messages);

				//	save total count of Inbox messages
				actionRequest.setAttribute(PMConstants.TOTAL_COUNT, totalCount);
			} 
			actionRequest.setAttribute("targetPath", includeFile);
			actionRequest.setAttribute("userId", userId);
			//include(includeFile, actionRequest, actionResponse);
		} catch (Exception e) {
			actionRequest.setAttribute(PMConstants.ERROR_MESSAGE, "Wrong usage");
			//include("/error.jsp", actionRequest, actionResponse);
		}
	}

	/**
	 * Creates a new message
	 * 
	 * @param actionRequest
	 * @throws Exception
	 */
	private static void createNewMessage(ActionRequest actionRequest) throws Exception {
		String recepients = ParamUtil.getString(actionRequest, "recepients", StringPool.BLANK);
		
		if (recepients.trim().equals("")) {
			throw new Exception("Please select message recepients");
		}
		String subject = ParamUtil.getString(actionRequest, "subject");
		if (subject.trim().equals("")) {
			throw new Exception("Please enter message subject");
		}
		String body = ParamUtil.getString(actionRequest, "body");
		String embeddedUrl = ParamUtil.getString(actionRequest, "url");
		
		if (body.trim().equals("")) {
			throw new Exception("Please enter message body");
		}
		String parentMessageIdStr = ParamUtil.getString(actionRequest, "parentMessageId");
		String messageIdStr = ParamUtil.getString(actionRequest, "messageId");
		long parentMessageId = -1;
		if (!parentMessageIdStr.isEmpty() && !parentMessageIdStr.equals("-1")) {
			parentMessageId = Long.parseLong(parentMessageIdStr);
		} else if (!messageIdStr.isEmpty()) {
			parentMessageId = Long.parseLong(messageIdStr);
		} 
		
		if(parentMessageId > 0) {
			PMMessage message = PMMessageLocalServiceUtil.getPMMessage(parentMessageId);
			String readRecepients = message.getReadRecepients();
			String newReadRecipents = "";
			String[] readRecepientIds = readRecepients.split(",");
			for (int i = 0; i < readRecepientIds.length; i++) {
				if (!recepients.contains(readRecepientIds[i])) {
					newReadRecipents = newReadRecipents + "," + readRecepientIds[i];
				}
			}
			//Reset all read recipents
			message.setReadRecepients(newReadRecipents);
			PMMessageLocalServiceUtil.updatePMMessage(message);
		}
		//Mark parent as unread when ever a child message is added
		
		PMMessage pmMessage = PMMessageLocalServiceUtil.createPMMessage(0L);
		pmMessage.setOwnerId(userId);
		User user = UserLocalServiceUtil.getUserById(userId);
		pmMessage.setOwnerName(user.getFullName());
		pmMessage.setRecepients(recepients);
		pmMessage.setSubject(subject);
		pmMessage.setBody(body);
		pmMessage.setUrl(embeddedUrl);
		pmMessage.setParentMessageId(parentMessageId);
		pmMessage.setPostedDate(new Date());
		PMMessageLocalServiceUtil.updatePMMessage(pmMessage);
		updateDeletedMessage(parentMessageId, recepients);
		//sendNotificationEmail(pmMessage);

		actionRequest.setAttribute(PMConstants.INFO_MESSAGE, "Message successfully sent");
	}
	
	/**
	 * Update deleted message whenever a reply is sent to an already deleted message 
	 * @param recepients 
	 * 
	 * @param actionRequest
	 * @throws Exception
	 */
	private static void updateDeletedMessage(Long parentMessageId, String recepients) throws Exception {
		 DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( PMDeletedMessageImpl.class, PortletClassLoaderUtil.getClassLoader() );
		 dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.MESSAGE_ID).like(parentMessageId));
		 dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.OWNER_ID).in(PMUtil.getRecipentsForQuery(recepients)));
		 try {
			 List<PMDeletedMessage> deletedMessages = PMDeletedMessageLocalServiceUtil.dynamicQuery(dynamicQuery);
			 for (PMDeletedMessage deletedMessage: deletedMessages) {
				 PMDeletedMessageLocalServiceUtil.deletePMDeletedMessage(deletedMessage.getDeletedMessageId());
			 }
		 } catch(Exception e) {
			 log.error(e);
		 }
		 
	}

	/**
	 * Deletes selected messages
	 * 
	 * @param actionRequest
	 * @throws Exception
	 */
	private static void deleteMessages(ActionRequest actionRequest) throws Exception {
		
		String ids = actionRequest.getParameter("deleteIds");
		String[] messages = ids.split(",");
		for(String m : messages) {
			long messageId = Long.parseLong(m);	
			List<PMMessage> childMessages = PMMessageLocalServiceUtil.getChildMessages(messageId);
			for ( Iterator<PMMessage> iter = childMessages.iterator(); iter.hasNext(); ) {
				PMMessage message = iter.next();
				createDeletedMessage(message.getMessageId());
				//PMMessageLocalServiceUtil.deletePMMessage(message.getMessageId());
			}
			//For parent message
			createDeletedMessage(messageId);
			
		}
		actionRequest.setAttribute(PMConstants.INFO_MESSAGE, "Messages successfully removed");
	}
	
	//Incase if we decide to have a screen for deleted messages
	private static void createDeletedMessage(Long messageId) {
		PMDeletedMessage dm = PMDeletedMessageLocalServiceUtil.createPMDeletedMessage(0L);
		dm.setMessageId(messageId);
		dm.setDeletedDate(new Date());
		dm.setOwnerId(userId);
		try {
			PMDeletedMessageLocalServiceUtil.addPMDeletedMessage(dm);
			//PMMessageLocalServiceUtil.deletePMMessage(messageId);
		} catch (SystemException e) {
			log.error(e);
		}
	}

	/**
	 * Completele erases selected messages
	 * 
	 * @param actionRequest
	 * @throws Exception
	 */
	//Incase if we decide to have a screen for deleted messages
	/*
	private static void eraseMessages(ActionRequest actionRequest) throws Exception {
		String ids = actionRequest.getParameter("ids");
		String[] messages = ids.split(";");
		for(String m : messages) {
			long messageId = Long.parseLong(m);				
			PMDeletedMessage dMessage = PMDeletedMessageLocalServiceUtil.getPMDeletedMessage(messageId);
			PMDeletedMessageLocalServiceUtil.deletePMDeletedMessage(dMessage);
		}
		actionRequest.setAttribute(PMConstants.INFO_MESSAGE, "Messages successfully erased");
	}*/

	/**
	 * Undeletes selected messages
	 * @param userId 
	 * 
	 * @param actionRequest
	 * @throws Exception
	 */
	////Incase if we decide to have a screen for delete/undelete messages
	/*
	private static void undeleteMessages(ActionRequest actionRequest) throws Exception {
		String ids = actionRequest.getParameter("ids");
		String[] messages = ids.split(";");
		for(String m : messages) {
			long messageId = Long.parseLong(m);
			PMDeletedMessageLocalServiceUtil.deletePMDeletedMessage(messageId);
		}
		actionRequest.setAttribute(PMConstants.INFO_MESSAGE, "Messages successfully undeleted");
	}*/

	public static void updateMessageStatus(String messageId, Long userId) {
		try {
			PMMessage message = PMMessageLocalServiceUtil.getPMMessage(Long.parseLong(messageId));
			String readRecepients = message.getReadRecepients();
			String readUserId = Long.toString(userId);
			if (!readRecepients.contains(readUserId)) {
				if (readRecepients.isEmpty()) {
					readRecepients = readUserId;
				} else {
					readRecepients = readRecepients + "," + readUserId;
				}
			}
			message.setReadRecepients(readRecepients);
			PMMessageLocalServiceUtil.updatePMMessage(message);
		} catch (NumberFormatException e) {
			log.error(e);
		} catch (PortalException e) {
			log.error(e);
		} catch (SystemException e) {
			log.error(e);
		}
		
	}
	
	public static int getUnreadCount(Long userId) {
		List<PMMessage> messages;
		try {
			messages = PMMessageLocalServiceUtil.getInboxMessages(userId);
			int unreadCount = 0;
			for ( Iterator<PMMessage> iter = messages.iterator(); iter.hasNext(); ) {
				PMMessage message = iter.next();
					if (message.getParentMessageId() <0 && !PMUtil.isMessageReadForUser(message, userId)) {
						unreadCount++;
					}
			}
			return unreadCount;
		} catch (SystemException e) {
			log.error(e);
		}
		return 0;
	}

}