package gov.va.caret.model.support.occ;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;

import gov.va.caret.model.StiPt;
import gov.va.caret.model.WorIm;


public class TierChange extends CalculationWrapper implements CalculationChange {

	
	private StiPt oldConfig;
	private BigDecimal oldDailyRate = null;			//( ( [Tier Level Monthly Hours] * [Local Hourly Wage] ) * 12) / 365
	private BigDecimal totalStipend;  				//[Monthly Amount] + [Prorated Amount] + [Back Pay] OCC Super must review if > 35k
	private BigDecimal backPay = null;				//[Number of Retro Months] * [Monthly Amount]

	public TierChange(WorIm workItem, StiPt config, StiPt oldConfig, int month, int year ) {
		super(workItem, config, month, year);
		this.oldConfig = oldConfig;
	}
	
	
	
	
	//[New Monthly Amount] + [Prorated Amount] + [Back Pay] + [Recoupment Amount]
	public BigDecimal getTotalStipend(){
		if ( totalStipend == null ){
			//(Tier Change Effective Date prior to current Payment Month) 
			totalStipend =  (getMonthlyRate().subtract( getOldMonthlyRate() )).multiply( new BigDecimal ( getRetroactiveMonths() ) ).add( getProratedAmount()).add(  getMonthlyRate(  ) );
		}
		return totalStipend;
	}

	public BigDecimal getOldMonthlyRate (  ) {
		BigDecimal monthlyAmount = StipendConfig.getTierLevelMonthlyHours( oldConfig.getTier() ).multiply( new BigDecimal( oldConfig.getBlsRateHourly() ) );
		monthlyAmount = new BigDecimal( String.valueOf( monthlyAmount.doubleValue() ) ).setScale( 2, RoundingMode.HALF_UP );
		return monthlyAmount;
	}
	
	@Override
	public BigDecimal getOldHourlyRate() {
		return new BigDecimal( oldConfig.getBlsRateHourly() );
	}
	
	
//	//([Number of Days between the first day of the current Payment Month to the Tier Change Effective Date] * [Old Daily Rate]) + ([Number of Days from the Tier Change Effective Date to the last day of the current Payment Month] * [New Daily Rate])
//	private BigDecimal getPartialMonthlyStipend(  ) {
//		BigDecimal hourlyWage = getTierLevelMonthlyHours( config );
//		BigDecimal monthlyAmount = new BigDecimal( config.getTierLevelMonthlyHours() ).multiply( hourlyWage );
//		monthlyAmount = new BigDecimal( String.valueOf( monthlyAmount.doubleValue() ) ).setScale( 2, RoundingMode.HALF_UP );
//		return monthlyAmount;
//	}
	
	//(new BigDecimal( getTotalDays() ).multiply( getOldDailyRate().subtract( getDailyRate() ) ) )
	// .add( new BigDecimal( getRetroMonths() ).multiply( getOldPartialMonthlyAmount().subtract( getPartialMonthlyAmount() ) ) )
	
	public BigDecimal getPartialMonthlyAmount (  ) {
		Calendar effectiveDate = Calendar.getInstance();
		effectiveDate.setTime( config.getStipendStartDate() );
		int count = effectiveDate.getActualMaximum( Calendar.DAY_OF_MONTH ) - effectiveDate.get(Calendar.DAY_OF_MONTH) + 1;
		return new BigDecimal ( count ).multiply( getDailyRate() );
	}
	
	public BigDecimal getOldPartialMonthlyAmount( ){
		Calendar effectiveDate = Calendar.getInstance();
		effectiveDate.setTime( config.getStipendStartDate() );
		return new BigDecimal ( effectiveDate.get( Calendar.DAY_OF_MONTH )).multiply( getOldDailyRate() );
	}
	
	public BigDecimal getOldDailyRate(){
		if ( oldDailyRate == null ){
			oldDailyRate = getOldHourlyRate().multiply( StipendConfig.getTierLevelMonthlyHours( config.getTier() ) ).multiply( new BigDecimal(12) ).divide( new BigDecimal(365), 2, RoundingMode.HALF_UP );
		}
		return oldDailyRate;
	}
	
	public BigDecimal getPayChange(){
		return getDailyRate().subtract( getOldDailyRate() );
	}

//	public BigDecimal getBackPayAmount(){
//		if ( backPay == null ){
//			backPay = new BigDecimal( getRetroactiveMonths() ).multiply( getMonthlyRate() ).subtract( getOldMonthlyRate() );
//		}
//		return backPay;
//	}
	
	public BigDecimal getBackPayAmount(){
		BigDecimal dailyRateDiff = getDailyRateDiff();
		return dailyRateDiff.doubleValue() > 0 ?
		 (new BigDecimal( getTotalDays() ).multiply( dailyRateDiff ) )
				.add( new BigDecimal( getRetroactiveMonths() ).multiply( getPartialMonthlyAmount().subtract( getOldPartialMonthlyAmount() ) ) ): BigDecimal.ZERO;
	}
	
	public double getTotalDays(  ) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime( config.getStipendStartDate() );
		return calendar.getActualMaximum( Calendar.DAY_OF_MONTH ) - calendar.get(Calendar.DAY_OF_MONTH) + 1;
	}

	public BigDecimal getProratedAmount(){
		return new BigDecimal( getTotalDays() ).multiply( getPayChange() );
	}
	
	//[address change date] - [first of the month of the next or current payment month] * DailyRateDiff
	public BigDecimal getDailyRateDiff(){
		return getDailyRate().subtract( getOldDailyRate() ); 
	}
	
	//( [Total Days] * ([Old Daily Rate]  [New Daily Rate]) ) + ([Number of Retro Months * ([Old Monthly Amount]  [New Monthly Amount]))
	public BigDecimal getRecoupmentAmount(){
		BigDecimal dailyRateDiff = getDailyRateDiff();
		return dailyRateDiff.doubleValue() < 0 ?
		 (new BigDecimal( getTotalDays() ).multiply( dailyRateDiff.negate() ) )
				.add( new BigDecimal( getRetroactiveMonths() ).multiply( getOldPartialMonthlyAmount().subtract( getPartialMonthlyAmount() ) ) ): BigDecimal.ZERO;
	}
	
	public int getRetroactiveMonths( ){
		int totalMonths = 0;
		Calendar calendar = Calendar.getInstance();
		calendar.setTime( config.getStipendStartDate() );
		while ( calendar.getTime().before( getPaymentMonthDate(  ) ) ) {
			int days = calendar.getActualMaximum( Calendar.DAY_OF_MONTH ) - calendar.get(Calendar.DAY_OF_MONTH) + 1;
			if ( days == calendar.getActualMaximum( Calendar.DAY_OF_MONTH ) ){
				totalMonths++;
			}
			calendar.set( Calendar.DAY_OF_MONTH, 1);
			if ( calendar.get(Calendar.MONTH ) == Calendar.DECEMBER ){
				calendar.roll( Calendar.YEAR, true );
				calendar.roll( Calendar.MONTH, true );
			} else {
				calendar.roll( Calendar.MONTH, true );
			}
		}
		return totalMonths;
	}
	
	public boolean isCalculationChange(){
		return true;
	}
	

//	public static void main ( String[] args ) throws ParseException{
//		StipendConfig oldConfig = new StipendConfig( 2, 18.11, format.parse("10/05/2016") );
//		StipendConfig config = new StipendConfig( 3, 18.11, format.parse("11/16/2016") );
//		System.out.println( new TierChange( config, oldConfig, Calendar.FEBRUARY, 2017 ) );
//	}

	public String toString () {
		return  "Stipend Payment Date: " + formatDate( getPaymentDate() ) + 
				"\n         Effective Date: " + formatDate( config.getStipendStartDate() ) +
				"\n Current Monthly Amount: " + getOldMonthlyRate() +
				"\n     New Monthly Amount: " + getMonthlyRate(  ) +
				 
				"\n     Prorated Amount of: " + getProratedAmount() +  
				"\n        Retro Months of: " + getRetroactiveMonths() +
				"\n  Current Daily Rate of: " + getOldDailyRate() +
				"\n      New Daily Rate of: " + getDailyRate() +
				"\n          Pay Change of: " + getPayChange() + 
				"\n      Recoupment Amount: " + (getRecoupmentAmount().doubleValue() > 0 ? getRecoupmentAmount(): 0) +
				"\n      Total Payment Due: " + getTotalStipend(  )  +
				"\n------------------------------------------------" +
				"\n MonthlyRecurringAmount: " + getMonthlyRecurringAmount()+
				"\n          BackPayAmount: " + getBackPayAmount()+
				"\n            FinalAmount: " + getFinalAmount()+
				//getRecoupmentAmount();
				"\n         ProratedAmount: " + getProratedAmount()+
				"\n            MonthlyRate: " + getMonthlyRate()+
				"\n              DailyRate: " + getDailyRate()+
				"\n             HourlyRate: " + getHourlyRate()+
				"\n           ProratedDate: " + getProratedDate()+
				"\n      RetroactiveMonths: " + getRetroactiveMonths();
	}

	@Override
	public StiPt getOldStipendPaymentConfig() {
		return oldConfig;
	}

}

